

package gov.va.med.cds.util;



import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;

import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(SuiteAwareRunner.class)
public class StreamUtilTest
{
    private static final String FILE_NAME = "sample.txt";
    //private static final String FILE_PATH = "C:/data/perforce/hdr/cdsn/main/modules/redrock-common/src/test/java/gov/va/med/cds/util/";
    private static final String OUTPUT_STRING = "This is a sample StreamUtilTest";


    @Test
    @Suite( groups = "checkintest" )
    public void testFileUtilities( )
        throws Exception
    {
        File file = new File( FILE_NAME );
        if ( !file.exists() )
            assertTrue( file.createNewFile() );

        StreamUtil.putToFile( OUTPUT_STRING, FILE_NAME );

        FileReader fileReader = new FileReader( FILE_NAME );
        String result = StreamUtil.streamAsString( fileReader );
        assertEquals( result, OUTPUT_STRING );
        fileReader.close();

        FileInputStream fileInputStream = new FileInputStream( FILE_NAME );
        String result1 = StreamUtil.streamToString( fileInputStream );
        assertEquals( result1, OUTPUT_STRING );
        fileInputStream.close();

        //        ResourceLoader resourceLoader = new DefaultResourceLoader();
        //        Resource resource = resourceLoader.getResource( "classpath:" + "gov/va/med/cds/util/" + FILE_NAME );
        //        String result3 = StreamUtil.resourceToString( resource );
        //        Assert.assertEquals( result3, OUTPUT_STRING );

        if ( file.exists() )
            assertTrue( file.delete() );
    }
}
