

package gov.va.med.cds.monitor.util;


import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.monitor.StandardCdsMethodMetrics;

import org.junit.Test;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.assertFalse;


import org.junit.runner.RunWith;

@RunWith(SuiteAwareRunner.class)
public class StandardCdsMethodMetricsTest
{
    StandardCdsMethodMetrics standardCdsMethodMetrics;

    private long methodCount = 0;
    private long methodElapsedTime = 0;
    private long minElapsedTime = Long.MAX_VALUE;
    private long maxElapsedTime = Long.MIN_VALUE;
    private double averageElapsedTime = 0.0d;
    private double transactionsPerSecond = 0.0d;


    @Test
    @Suite( groups = "checkintest" )
    public void testEnableMetrics( )
    {
        standardCdsMethodMetrics = new StandardCdsMethodMetrics();
        standardCdsMethodMetrics.enableMetrics();

        assertTrue( standardCdsMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, standardCdsMethodMetrics.getCdsTransactions() );
        assertEquals( methodElapsedTime, standardCdsMethodMetrics.getCdsElapsedTime() );
        assertEquals( transactionsPerSecond, standardCdsMethodMetrics.getCdsTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, standardCdsMethodMetrics.getCdsAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, standardCdsMethodMetrics.getCdsMaxElapsedTime() );
        assertEquals( minElapsedTime, standardCdsMethodMetrics.getCdsMinElapsedTime() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testSetSingleMethodElapsedTime( )
    {
        long elapsedTime = 100L;
        long methodCount = 1;
        long methodElapsedTime = elapsedTime;
        long minElapsedTime = elapsedTime;
        long maxElapsedTime = elapsedTime;
        double averageElapsedTime = elapsedTime;
        double transactionsPerSecond = 10.0d;

        standardCdsMethodMetrics = new StandardCdsMethodMetrics();
        standardCdsMethodMetrics.enableMetrics();
        standardCdsMethodMetrics.setSingleMethodElapsedTime( elapsedTime );

        assertTrue( standardCdsMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, standardCdsMethodMetrics.getCdsTransactions() );
        assertEquals( methodElapsedTime, standardCdsMethodMetrics.getCdsElapsedTime() );
        assertEquals( transactionsPerSecond, standardCdsMethodMetrics.getCdsTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, standardCdsMethodMetrics.getCdsAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, standardCdsMethodMetrics.getCdsMaxElapsedTime() );
        assertEquals( minElapsedTime, standardCdsMethodMetrics.getCdsMinElapsedTime() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testDisableMetrics( )
    {
        standardCdsMethodMetrics = new StandardCdsMethodMetrics();
        standardCdsMethodMetrics.enableMetrics();

        assertTrue( standardCdsMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, standardCdsMethodMetrics.getCdsTransactions() );
        assertEquals( methodElapsedTime, standardCdsMethodMetrics.getCdsElapsedTime() );
        assertEquals( transactionsPerSecond, standardCdsMethodMetrics.getCdsTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, standardCdsMethodMetrics.getCdsAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, standardCdsMethodMetrics.getCdsMaxElapsedTime() );
        assertEquals( minElapsedTime, standardCdsMethodMetrics.getCdsMinElapsedTime() );

        standardCdsMethodMetrics.disableMetrics();
        assertFalse( standardCdsMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, standardCdsMethodMetrics.getCdsTransactions() );
        assertEquals( methodElapsedTime, standardCdsMethodMetrics.getCdsElapsedTime() );
        assertEquals( transactionsPerSecond, standardCdsMethodMetrics.getCdsTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, standardCdsMethodMetrics.getCdsAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, standardCdsMethodMetrics.getCdsMaxElapsedTime() );
        assertEquals( minElapsedTime, standardCdsMethodMetrics.getCdsMinElapsedTime() );
    }
}
