

package gov.va.med.cds.exception;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class RuntimeMDBOnMessageExceptionTest
{
    @Test( expected = RuntimeMDBOnMessageException.class )
    @Suite( groups = "checkintest" )
    public void testRuntimeMDBOnMessageException( )
    {
        throw new RuntimeMDBOnMessageException( ErrorCodeEnum.MDB_ON_MESSAGE_JMS_EXCEPTION );
    }


    @Test( expected = RuntimeMDBOnMessageException.class )
    @Suite( groups = "checkintest" )
    public void testRuntimeMDBOnMessageExceptionWithCustomMsg( )
    {
        throw new RuntimeMDBOnMessageException( ErrorCodeEnum.MDB_ON_MESSAGE_JMS_EXCEPTION, "Error in Message" );
    }


    @Test( expected = RuntimeMDBOnMessageException.class )
    @Suite( groups = "checkintest" )
    public void testRuntimeMDBOnMessageExceptionWithWrappingException( )
    {
        throw new RuntimeMDBOnMessageException( ErrorCodeEnum.MDB_ON_MESSAGE_JMS_EXCEPTION, new Exception() );
    }


    @Test( expected = RuntimeMDBOnMessageException.class )
    @Suite( groups = "checkintest" )
    public void testRuntimeMDBOnMessageExceptionWithWrappingExceptionAndCustomMsg( )
    {
        throw new RuntimeMDBOnMessageException( ErrorCodeEnum.MDB_ON_MESSAGE_JMS_EXCEPTION, new Exception(), "Error in Message" );
    }
}
