

package gov.va.med.cds.audit.persistence.hibernate;


import gov.va.med.cds.audit.persistence.CdsAuditClobStore;
import gov.va.med.cds.audit.persistence.CdsAuditClobStoreInterface;
import gov.va.med.cds.junit.runners.Suite;

import org.junit.Test;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;


//@RunWith( SuiteAwareRunner.class )
public class PersistAuditStoreTest
{
    //private PersistAuditStore cdsAuditClobStore;
    private CdsAuditClobStoreInterface cdsAuditClobStore;
    

    public PersistAuditStoreTest( )
    {
        // load up the application context and set the members because we can't
        // use the test harness Abstract test classes because of a circular
        // dependency issue
        @SuppressWarnings("resource")
		ConfigurableApplicationContext appCtxt = new ClassPathXmlApplicationContext(
                        new String[] { "classpath:gov/va/med/cds/audit/persistence/hibernate/hibernatePropertiesTestContext.xml", "classpath:gov/va/med/cds/audit/persistence/hibernate/persistAuditStoreTest-context.xml" } );
        appCtxt.getBeanFactory().autowireBeanProperties( this, AutowireCapableBeanFactory.AUTOWIRE_BY_NAME, true );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testPersistCdsAuditClob( )
    {
        String requestId = "requestId";
        String hl7Clob = "hl7Clob";
        String facilityId = "facilityId";
        String messageDateTime = "12/12/2008";
        String messageType = "bogusMessageType";
        String templateId = "templateId";
        String clientId = "clientId";
        String clientRequestInitiationTime = "2001-12-17T09:30:47.0Z";

        CdsAuditClobStore cdsAuditClob = new CdsAuditClobStore();
        cdsAuditClob.setRequestId( requestId );
        cdsAuditClob.setHl7Clob( hl7Clob );
        cdsAuditClob.setFacilityId( facilityId );
        cdsAuditClob.setMessageDateTime( messageDateTime );
        cdsAuditClob.setMessageType( messageType );
        cdsAuditClob.setTemplateId( templateId );
        cdsAuditClob.setClientIdentifier( clientId );
        cdsAuditClob.setClientRequestInitiationTime( clientRequestInitiationTime );

        cdsAuditClobStore.persistCdsAuditClob( cdsAuditClob );
    }
    
    
    /*@Test
    @Suite( groups = "checkintest" )
    public void testPersistHaAuditClob( )
    {
        String requestId = "requestId";
        String hl7Clob = "hl7Clob";
        String facilityId = "facilityId";
        String messageDateTime = "12/12/2008";
        String messageType = "bogusMessageType";
        String templateId = "templateId";
        String clientId = "clientId";
        String clientRequestInitiationTime = "2001-12-17T09:30:47.0Z";

        HaAuditClobStore haAuditClob = new HaAuditClobStore();
        haAuditClob.setRequestId( requestId );
        haAuditClob.setHl7Clob( hl7Clob );
        haAuditClob.setFacilityId( facilityId );
        haAuditClob.setMessageDateTime( messageDateTime );
        haAuditClob.setMessageType( messageType );
        haAuditClob.setTemplateId( templateId );
        haAuditClob.setClientIdentifier( clientId );
        haAuditClob.setClientRequestInitiationTime( clientRequestInitiationTime );

        cdsAuditClobStore.persistHaAuditClob( haAuditClob );
    }*/

    
    /*public void setCdsAuditClobStore( PersistAuditStore cdsAuditClobStore )
    {
        this.cdsAuditClobStore = cdsAuditClobStore;
    }*/
    
    public void setCdsAuditClobStore( CdsAuditClobStoreInterface cdsAuditClobStore )
    {
        this.cdsAuditClobStore = cdsAuditClobStore;
    }
}
