

package gov.va.med.cds.audit;


import static org.junit.Assert.assertEquals;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.util.StreamUtil;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import java.io.IOException;
import java.util.Date;


@RunWith( SuiteAwareRunner.class )
public class VhimReadRpcResponseAuditLogTest
{
    @Test
    @Suite( groups = "checkintest" )
    public void testVhimResponseSizeAndLength( )
        throws IOException
    {
        Resource resource = new ClassPathResource( "gov/va/med/cds/audit/vhimResponse.xml" );
        Resource filterResource = new ClassPathResource( "gov/va/med/cds/audit/examsFilter1.xml");
        String response = StreamUtil.resourceToString( resource );
        String filter = StreamUtil.resourceToString( filterResource );

        VhimReadPathwaysResponseAuditLog auditLog = new VhimReadPathwaysResponseAuditLog();
        auditLog.setEndTime( 12345L );
        auditLog.setLocalTime( new Date( 55555L ) );
        auditLog.setFacility( "FACILITY" );
        auditLog.setIsoLocalTime( "20081021125959.999-600" );
        auditLog.setFilterRequest( filter );
        auditLog.setRequestId( "REQUEST_ID" );
        auditLog.setResponse( response );
        auditLog.setSendingApplication( "SENDING_APPLICATION" );
        auditLog.setStartTime( 12335L );
        auditLog.setClientId( "CLIENT IDENTIFIER" );
        auditLog.setClientRequestInitiationTime( "2001-12-17T09:30:47.0Z" );

        StringBuilder sbDebugInfo = new StringBuilder();
        sbDebugInfo.append( "Server PATHWAYS 1.x ==> Audit detail: \n" );
        sbDebugInfo.append( "\tdomain => PATHWAYS 1.x\n" );
        sbDebugInfo.append( "\tstart_milliseconds => 12335\n" );
        sbDebugInfo.append( "\tmilliseconds => 10\n" );
        sbDebugInfo.append( "\tISO_localtime => " ).append( auditLog.getIsoLocalTime() ).append( "\n" );
        sbDebugInfo.append( "\tlog_information => \n" );
        sbDebugInfo.append( "\t\tstartTime -> 12335\n" );
        sbDebugInfo.append( "\t\tsendingApplication -> SENDING_APPLICATION\n" );
        sbDebugInfo.append( "\t\toriginalMessageControlId -> REQUEST_ID\n" );
        sbDebugInfo.append( "\t\trequesterString -> \n" );
        sbDebugInfo.append( "\t\trequestMsg -> " ).append(filter).append( "\n" );
        sbDebugInfo.append( "\t\treceivingApplication -> PATHWAYS 1.x\n" );
        sbDebugInfo.append( "\t\tcompletionTime -> " ).append( auditLog.getEndTime()).append( "\n" );
        sbDebugInfo.append( "\t\tsamlToken -> " ).append( auditLog.getSamlToken() );
        
        assertEquals( auditLog.getDebugInfo(), sbDebugInfo.toString() );

        resource = new ClassPathResource( "gov/va/med/cds/audit/TiuListReadResult.xml" );
        response = StreamUtil.resourceToString( resource );

        auditLog.setResponse( response );
        assertEquals( auditLog.getDebugInfo(), sbDebugInfo.toString() );
    }


//    @Test( expected = IllegalArgumentException.class )
//    @Suite( groups = "checkintest" )
//    public void testVhimResponseSizeAndLengthWithErrorResponse( )
//        throws IOException
//    {
//        VhimReadPathwaysResponseAuditLog auditLog = new VhimReadPathwaysResponseAuditLog();
//        auditLog.setEndTime( 12345L );
//        auditLog.setLocalTime( new Date( 55555L ) );
//        auditLog.setIsoLocalTime( "20081021125959.999-600" );
//        auditLog.setFilterRequest( "REQUEST" );
//        auditLog.setRequestId( "REQUEST_ID" );
//        auditLog.setResponse( "<InvalidResponse>" );
//        auditLog.setSendingApplication( "SENDING_APPLICATION" );
//        auditLog.setStartTime( 12335L );
//        auditLog.setClientId( "CLIENT IDENTIFIER" );
//        auditLog.setClientRequestInitiationTime( "2001-12-17T09:30:47.0Z" );
//
//        auditLog.getDebugInfo();
//        auditLog.getResponseLength();
//    }
}
