/**
 * 
 */


package gov.va.med.cds.xml.transform;


import org.dom4j.Document;

import java.util.Map;


/**
 * @author susarlan
 *
 */
public interface TransformerInterface
{
    /**
     * Utility method intended to reduced duplicated logic in clients needing to transfrom an xml file with an xslt
     * template - for ease this method returns a usable String value
     * 
     * @param source The XML data as a string.
     * @param transformerKey The key to look up the transformer by.
     * @return The transformed results.
     */
    public String transformMessageAsString( String source, String transformerKey );

    /**
     * Utility method intended to reduced duplicated logic in clients needing to transfrom an xml file with an xslt
     * template - for ease this method returns a usable String value and is used to transfrom xml to plain text
     * 
     * @param source The XML data as a string.
     * @param transformerKey The key to look up the transformer by.
     * @return The transformed results.
     */
    public String transformMessageAsPlainText( String source, String transformerKey );
    
    /**
     * Utility method intended to reduced duplicated logic in clients needing to transfrom an xml file with an xslt
     * template - for ease this method returns a usable String value and is used to transfrom xml to plain text
     * 
     * @param source The XML data as a string.
     * @param transformerKey The key to look up the transformer by.
     * @param parameters The parameters that will be passed to the Transformer.
     * @return The transformed results.
     */
    public String transformMessageAsPlainText( String source, String xsltKey, Map<String, Object> parameters);

    /**
     * Utility method intended to reduced duplicated logic in clients needing to transfrom an xml file with an xslt
     * template - for ease this method returns a usable String value
     * 
     * @param source The XML data as a string.
     * @param transformerKey The key to look up the transformer by.
     * @param parameters The parameters that will be passed to the Transformer.
     * @return The transformed results.
     */
    public String transformMessageAsString( String source, String transformerKey, Map<String, Object> parameters );


    /**
     * 
     * @param source The XML data as a string.
     * @param transformerKey The key to look up the transformer by.
     * @return The Document object into which to store the transformed results.
     */
    public Document transformMessage( String source, String transformerKey );


    /***
     * 
     * @param source The XML data as a string.
     * @param transformerKey The key to look up the transformer by.
     * @param parameters The parameters that will be passed to the Transformer.
     * @return The Document object into which to store the transformed results.
     * @throws NullPointerException if no transformer template exists for transform name.
     */
    public Document transformMessage( String source, String transformerKey, Map<String, Object> parameters );
}
