

package gov.va.med.cds.util;


import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.zip.GZIPOutputStream;


/**
 * Strips out new lines in a given string.
 * 
 * 
 */
public class StringUtil
{
    /**
     * Strips out new lines in a given string.
     * 
     * @param aSource
     *            String with new lines.
     * @return String with no new lines.
     */
    public static String stripNewlines( String aSource )
    {
        if ( aSource == null )
        {
            return null;
        }
        StringBuilder buff = new StringBuilder( aSource.length() );
        char c;
        for ( int i = 0; i < aSource.length(); i++ )
        {
            c = aSource.charAt( i );
            if ( c != '\n' )
            {
                buff.append( c );
            }
        }

        return buff.toString();
    }


    public static String[] concat( String[] aStringA, String[] aStringB )
    {
        if ( aStringA == null )
        {
            return aStringB;
        }
        else if ( aStringB == null )
        {
            return aStringA;
        }
        else
        {
            String[] result = new String[aStringA.length + aStringB.length];

            int i = 0;
            for ( String element : aStringA )
            {
                result[i++] = element;
            }

            for ( String element : aStringB )
            {
                result[i++] = element;
            }

            return result;
        }
    }


    /**
     * Returns the string after the last occurrence of the given search char
     * from the given string.
     * 
     * @param stringData
     * @param searchDelimiter
     * @return String
     * @see gov.va.med.cds.persistence.hibernate.HibernateConstraintViolationException(
     *      ConstraintViolationException cause)
     */
    public static String getLastStringAfterTheDelimiter( String aStringData, char aSearchDelimiter )
    {
        return aStringData.substring( aStringData.lastIndexOf( aSearchDelimiter ) + 1, aStringData.length() );
    }


    /**
     * Compare the two string while ignoring any whitespace found.
     * 
     * @param aSring1
     *            String 1 to compare.
     * @param aString2
     *            String 2 to compare.
     * @return True if the two string don't differ or differ by white space
     *         only; false otherwise.
     */
    public static boolean equalsIgnoreWhiteSpace( String aSring1, String aString2 )
    {
        boolean result = false;
        // first remove any ending white space if file/strings
        char[] c1 = aSring1.trim().toCharArray();
        char[] c2 = aString2.trim().toCharArray();
        int c1Length = c1.length;
        int c2Length = c2.length;

        for ( int c1i = 0, c2i = 0; c1i < c1Length && c2i < c2Length; c1i++, c2i++ )
        {
            while ( c1i < c1Length && Character.isWhitespace( c1[c1i] ) )
            {
                c1i++;
            }

            while ( c2i < c2Length && Character.isWhitespace( c2[c2i] ) )
            {
                c2i++;
            }

            if ( c1i == c1Length - 1 && c2i == c2Length - 1 )
            {
                result = true;
            }

            if ( c1[c1i] != c2[c2i] )
            {
                break;
            }
        }

        return result;
    }


    /**
     * Split and sort the split substrings and return a newly constructed
     * <String> from the sorted order of split substrings.
     * 
     * @param aStringToSort
     *            <String> needing sorted
     * @param splitterExp
     *            <RegExp> used to split the substrings into <Array>
     * @return <String> newly constructed from sorted substrings
     */
    public static String splitAndSortsubStrings( String aStringToSort, String aSplitterRegExp )
    {
        String list[] = aStringToSort.split( aSplitterRegExp );
        Arrays.sort( list );
        StringBuilder sbuff = new StringBuilder();
        for ( int i = 0; i < list.length; i++ )
        {
            if ( i > 0 )
            {
                sbuff.append( aSplitterRegExp );
            }
            sbuff.append( list[i] );
        }

        return sbuff.toString();

    }


    public static String splitAndSortsubStrings( String aStringToSort, String aSplitterExp, String aInnerSplitter )
    {
        String list[] = aStringToSort.split( aSplitterExp );
        Arrays.sort( list );
        StringBuilder sbuff = new StringBuilder();
        for ( int i = 0; i < list.length; i++ )
        {
            if ( i > 0 )
            {
                sbuff.append( aSplitterExp );
            }
            sbuff.append( splitAndSortsubStrings( list[i], aInnerSplitter ) );
        }

        return sbuff.toString();
    }


    public static String encodeStringInBase64( String aStringToEncode )
    {

        byte[] bytesEncoded = org.apache.commons.codec.binary.Base64.encodeBase64( aStringToEncode.getBytes() );
//        return new String( bytesEncoded, StandardCharsets.ISO_8859_1 );
        return new String( bytesEncoded );
    }


    public static String base64EncodeString( String aStringToEncode )
    {
//        byte[] bytesToEncode = aStringToEncode.getBytes( StandardCharsets.ISO_8859_1 );
        byte[] bytesToEncode = aStringToEncode.getBytes( );
        String encodedString = java.util.Base64.getEncoder().encodeToString( bytesToEncode );

        return encodedString;
    }


    public static String base64EncodeStream( ByteArrayOutputStream aByteArrayOutputStream )
    {
        byte[] bytesToEncode = aByteArrayOutputStream.toByteArray();
        String encodedString = java.util.Base64.getEncoder().encodeToString( bytesToEncode );

        return encodedString;
    }


    public static String base64DecodeString( String aStringToDecode )
    {
//        byte[] bytesToDecode = aStringToDecode.getBytes( StandardCharsets.ISO_8859_1 );
        byte[] bytesToDecode = aStringToDecode.getBytes( );
        byte[] decodedBytes = java.util.Base64.getDecoder().decode( bytesToDecode );
//        String decodedString = new String( decodedBytes, StandardCharsets.ISO_8859_1 );
        String decodedString = new String( decodedBytes );

        return decodedString;
    }


    public static String compressAndEncodeStringInBase64Old( String aStringToCompressAndEncode ) 
        throws IOException
    {
        ByteArrayOutputStream rstBao = new ByteArrayOutputStream();
        GZIPOutputStream zos = new GZIPOutputStream( rstBao );
        zos.write( aStringToCompressAndEncode.getBytes() );
        zos.close();

        byte[] bytes = rstBao.toByteArray();
        return org.apache.commons.codec.binary.Base64.encodeBase64String( bytes );
    }


    public static String compressAndEncodeStringInBase64( String aStringToCompressAndEncode ) 
        throws IOException
    {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzos = new GZIPOutputStream( baos );
        gzos.write( aStringToCompressAndEncode.getBytes() );
        gzos.close();

        return base64EncodeStream( baos );
    }

}
