

package gov.va.med.cds.properties;


import java.io.IOException;
import java.util.Properties;

import javax.crypto.spec.SecretKeySpec;


public class PropertiesUtil 
{
    public static final String PROPERTIES_KEYSTORE_FILE_PATH_PROPERTY = "cds.keystore.properties.path";
    private PropertiesManager propertiesManager = null;
    
    
    public PropertiesUtil( )
    {
        if ( getPropertiesManager() == null )
        {
            propertiesManager = new PropertiesManager();
        }
    }
    
    
    /*
     * Loads Properties from the properties file and, based on the encryption flag,
     * will encrypt the plain text passwords and override the existing file with encrypted passwords.
     * Encrypted passwords stored in properties file and will be decrypted before used by application.  
     */
    public void loadSystemRunProperties( )
        throws IOException
    {
        String propertiesFilePath = propertiesManager.getPropertiesFilePathFromSystemProperties();
        
        if ( propertiesFilePath != null )
        {
            //switch system property that indicates whether a property file must be encrypted or not
            String encrypt = propertiesManager.getEncryptSwitchFromSystemProperties();
            
            //password system property that protects KeyStore access
            String keyStorePassword = propertiesManager.getKeyStorePasswordFromSystemProperties();

            Properties fileProperties = propertiesManager.loadPropertiesFromPropertiesFile( propertiesFilePath );

            SecretKeySpec savedKey = null;
            //the KeyStore file path is expected  to be inside the property file when encryption is expected
            String keyStoreFileLocation = fileProperties.getProperty( PROPERTIES_KEYSTORE_FILE_PATH_PROPERTY );
            savedKey = propertiesManager.configureKeyStore( keyStoreFileLocation, keyStorePassword );

            //encrypt property file
            if ( ( encrypt != null ) && ( encrypt.equalsIgnoreCase( "true" ) ) )
            {
                encryptProperties( propertiesFilePath, fileProperties, savedKey );
            }

            //attempt to decrypt fileProps - this may not be necessary as fileProps may not be encrypted
            //so an error will thrown only if keystore information is missing 
            //and an encrypted property is discovered in fileProps
            fileProperties = propertiesManager.decryptProperties( savedKey, fileProperties );

            //now load all properties (some may have been decrypted) into system
            propertiesManager.updateSystemProperties( fileProperties );
        }
    }

        
    public void loadSystemRunProperties( byte[] anInitializationVector, boolean aAddPrefixFlag )
        throws Exception
    {
        String propertiesFilePath = propertiesManager.getPropertiesFilePathFromSystemProperties();
        
        if ( propertiesFilePath != null )
        {
            //switch system property that indicates whether a property file must be encrypted or not
            String encrypt = propertiesManager.getEncryptSwitchFromSystemProperties();
            
            //password system property that protects KeyStore access
            String keyStorePassword = propertiesManager.getKeyStorePasswordFromSystemProperties();

            Properties fileProperties = propertiesManager.loadPropertiesFromPropertiesFile( propertiesFilePath );

            SecretKeySpec savedKey = null;
            //the KeyStore file path is expected  to be inside the property file when encryption is expected
            String keyStoreFileLocation = fileProperties.getProperty( PROPERTIES_KEYSTORE_FILE_PATH_PROPERTY );
            savedKey = propertiesManager.configureKeyStore( keyStoreFileLocation, keyStorePassword );

            //encrypt property file
            if ( ( encrypt != null ) && ( encrypt.equalsIgnoreCase( "true" ) ) )
            {
                encryptProperties( propertiesFilePath, fileProperties, savedKey, anInitializationVector, aAddPrefixFlag );
            }

            //attempt to decrypt fileProps - this may not be necessary as fileProps may not be encrypted
            //so an error will thrown only if keystore information is missing 
            //and an encrypted property is discovered in fileProps
            fileProperties = propertiesManager.decryptProperties( savedKey, anInitializationVector, fileProperties );

            //now load all properties (some may have been decrypted) into system
            propertiesManager.updateSystemProperties( fileProperties );
        }
    }

        
    protected void encryptProperties( String aPropertiesFilePath, Properties aFileProps, SecretKeySpec aSavedKey )
        throws IOException
    {
        propertiesManager.encryptProperties( aSavedKey, aPropertiesFilePath, ( Properties )aFileProps.clone() );
    }

        
    protected void encryptProperties( String aPropertiesFilePath, Properties aFileProps, SecretKeySpec aSavedKey, byte[] anInitializationVector, boolean aAddPrefixFlag  )
        throws Exception
    {
        propertiesManager.encryptProperties( aPropertiesFilePath, ( Properties )aFileProps.clone(), aSavedKey, anInitializationVector, aAddPrefixFlag );
    }

        
    /**
     * Getters and setters
     */
    final PropertiesManager getPropertiesManager( )
    {
        return propertiesManager;
    }

    
    final void setPropertiesManager( PropertiesManager propertiesManager )
    {
        this.propertiesManager = propertiesManager;
    }
}
