

package gov.va.med.cds.properties;


import gov.va.med.cds.util.CipherUtilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

import javax.crypto.spec.SecretKeySpec;


public class PropertiesManager
{
    public static final String PROPERTIES_FILE_PATH_PROPERTY = "cds.run.properties.path";
    public static final String PROPERTIES_ENCRYPTION_SWITCH = "cds.encrypt.password.properties";
    public static final String PROPERTIES_KEYSTORE_PSWD = "cds.keystore.password";

    
    protected Properties loadPropertiesFromPropertiesFile( String aPropertiesFilePath )
        throws FileNotFoundException,
            IOException
    {
        InputStream propInputStream = null;
        Properties fileProps = new Properties();

        try
        {
            propInputStream = new FileInputStream( aPropertiesFilePath );           
            fileProps.load( propInputStream );
            propInputStream.close();
        }
        finally
        {
            if ( propInputStream != null )
            {
                propInputStream.close();
            }
        }
        
        return fileProps;
    }


    protected String getKeyStorePasswordFromSystemProperties( )
    {
        String keyStorePassword = System.getProperty( PROPERTIES_KEYSTORE_PSWD );
        
        return keyStorePassword;
    }


    protected String getEncryptSwitchFromSystemProperties( )
    {
        String encrypt = System.getProperty( PROPERTIES_ENCRYPTION_SWITCH );
        
        return encrypt;
    }


    protected String getPropertiesFilePathFromSystemProperties( )
    {
        String propertiesFilePath = System.getProperty( PROPERTIES_FILE_PATH_PROPERTY );
        
        return propertiesFilePath;
    }


    protected void updateSystemProperties( Properties fileProps )
    {
        Properties systemProps = System.getProperties();
        systemProps.putAll( fileProps );
        System.setProperties( systemProps );
    }


    protected void encryptProperties( SecretKeySpec aSavedKey, String aPropertiesFilePath, Properties aProperties )
        throws IOException
    {
        FileOutputStream fos = null;
        Properties propertiesToBeSaved = ( Properties )aProperties.clone();
        
        Enumeration<?> e = propertiesToBeSaved.propertyNames();
        while ( e.hasMoreElements() )
        {
            String propKey = ( String )e.nextElement();
            if ( propKey.endsWith( ".password" ) )
            {
                String propValue = propertiesToBeSaved.getProperty( propKey );
                //if property has been already encrypted, skip it
                if ( ! CipherUtilities.isEncrypted( propValue ) ) 
                {
                    String encryptedProperty = CipherUtilities.encrypt( propValue, aSavedKey  );
                    propertiesToBeSaved.setProperty( propKey, encryptedProperty );
                }
            }
        }

        fos = new java.io.FileOutputStream( new File( aPropertiesFilePath ) );
        try
        {
            propertiesToBeSaved.store( fos, "File encrypted" );
            fos.close();
        }
        finally
        {
            if ( fos != null )
            {
                fos.close();
            }
        }
    }


    protected void encryptProperties( String aPropertiesFilePath, Properties aProperties, SecretKeySpec aSavedKey, byte[] anInitializationVector, boolean aAddPrefixFlag  )
        throws Exception
    {
        FileOutputStream fos = null;
        Properties propertiesToBeSaved = ( Properties )aProperties.clone();
        
        Enumeration<?> e = propertiesToBeSaved.propertyNames();
        while ( e.hasMoreElements() )
        {
            String propKey = ( String )e.nextElement();
            if ( propKey.endsWith( ".password" ) )
            {
                String propValue = propertiesToBeSaved.getProperty( propKey );
                //if property has been already encrypted, skip it
                if ( ! CipherUtilities.isEncrypted( propValue ) ) 
                {
                    String encryptedProperty = CipherUtilities.encrypt( propValue, aSavedKey, anInitializationVector, aAddPrefixFlag );
                    propertiesToBeSaved.setProperty( propKey, encryptedProperty );
                }
            }
        }

        fos = new java.io.FileOutputStream( new File( aPropertiesFilePath ) );
        try
        {
            propertiesToBeSaved.store( fos, "File encrypted" );
            fos.close();
        }
        finally
        {
            if ( fos != null )
            {
                fos.close();
            }
        }
    }


    protected Properties decryptProperties( SecretKeySpec aSavedKey, Properties aProperties )
        throws IOException
    {
        Enumeration<?> e = aProperties.propertyNames();
        while ( e.hasMoreElements() )
        {
            String propKey = ( String )e.nextElement();
            if ( propKey.endsWith( ".password" ) )
            {
                String propValue = aProperties.getProperty( propKey );
                if ( propValue.startsWith( CipherUtilities.ENCRYPTED_PREFIX ) )
                {
                    //property is encrypted - make sure CipherUtilities is configured 
                    //if is has not already been configured and if anything is
                    //missing for configuration a runtime exception will be thrown
                    aProperties.setProperty( propKey, decrypt( aSavedKey, propValue ) );
                }
            }
        }
        
        return aProperties;
    }


    protected Properties decryptProperties( SecretKeySpec aSavedKey, byte[] anIntializationVector, Properties aProperties )
        throws IOException
    {
        Enumeration<?> e = aProperties.propertyNames();
        while ( e.hasMoreElements() )
        {
            String propKey = ( String )e.nextElement();
            if ( propKey.endsWith( ".password" ) )
            {
                String propValue = aProperties.getProperty( propKey );
                if ( propValue.startsWith( CipherUtilities.ENCRYPTED_PREFIX ) )
                {
                    //property is encrypted - make sure CipherUtilities is configured 
                    //if is has not already been configured and if anything is
                    //missing for configuration a runtime exception will be thrown
                    aProperties.setProperty( propKey, decrypt( aSavedKey, anIntializationVector, propValue ) );
                }
            }
        }
        
        return aProperties;
    }


    protected String decrypt( SecretKeySpec savedKey, String propValue )
    {
        return CipherUtilities.decrypt( propValue, savedKey  );
    }


    protected String decrypt( SecretKeySpec savedKey, byte[] anIntializationVector, String propValue )
    {
        return CipherUtilities.decrypt( propValue, savedKey, anIntializationVector  );
    }


    protected SecretKeySpec configureKeyStore( String keyStoreFileLocation, String keyStorePassword )
        throws IOException
    {
        return CipherUtilities.configureKeyStore( keyStoreFileLocation, keyStorePassword );
    }

}
