

package gov.va.med.cds.clinicaldata;



import org.xml.sax.SAXException;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.FilterCacheException;

import java.io.StringReader;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.xml.XMLConstants;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;


/**
 * This class implements the methods required for handling the Filter Cache Metadata. The Metadata consists
 * of: 
 * <li>FilterId
 * <li>Filter Schema (XSD)
 * <li>Validator
 * <li>VHIM Version
 * <li>Domain Entry Points
 * <br>
 * 
 */
public class TfsFilterMetaData
    implements
        TfsFilterMetaDataInterface
{
    private String filterId;
    private Set<EntryFilter> entryFilters;
    protected Set<String> vhimVersions;
    private Schema filterSchema;
    private String filterDescription;
    private boolean containsCorrelation;
    private Date dateAdded;
    private Date dateDeprecated;
    private Date dateActivated;
    private Date dateDeactivated;
    private Date dateUpdated;
    private String status;
    private String filterSchemaXml;


    /**
     * Get the filterId.
     * 
     * @return the filterId
     */
    public String getFilterId( )
    {
        return filterId;
    }


    /**
     * Set the filterId.
     * 
     * @param theFilterId the filterId to set
     */
    public void setFilterId( String aFilterId )
    {
        filterId = aFilterId;
    }


    public Set<String> getVhimVersions( )
    {
        return vhimVersions;
    }

    
    public void setVhimVersions( Set<String> aVhimVersions )
    {
        vhimVersions = aVhimVersions;
    }
    
    
    @SuppressWarnings("unused")
    private Set<VhimVersionWrapper> getVhimVersionWrappers( )
    {
        Set<VhimVersionWrapper> wrappers = new HashSet<VhimVersionWrapper>( vhimVersions.size() );
        VhimVersionWrapper vvw;
        for ( String vhimVersion : vhimVersions )
        {
            vvw = new VhimVersionWrapper();
            vvw.setVersion( vhimVersion );
            wrappers.add( vvw );
        }
        
        return wrappers;
    }

    
    @SuppressWarnings("unused")
    private void setVhimVersionWrappers( Set<VhimVersionWrapper> aVhimVersions )
    {
        vhimVersions = new HashSet<String>( aVhimVersions.size() );
        for ( VhimVersionWrapper vhimVersionWrapper : aVhimVersions )
        {
            vhimVersions.add( vhimVersionWrapper.getVersion() );
        }
    }



    /**
     * Get the Schema.
     * 
     * @return the schema associated with the filter
     */
    public Schema getFilterSchema( )
    {
        if ( filterSchema == null && filterSchemaXml != null )
        {
            try
            {
                setFilterSchema( filterSchemaXml );
            }
            catch ( Exception e )
            {
            }
        }
        
        return filterSchema;
    }

    
    public Date getDateAdded( )
    {
        return dateAdded;
    }


    public void setDateAdded( Date aDateAdded )
    {
        this.dateAdded = aDateAdded;
    }


    public Date getDateDeprecated( )
    {
        return dateDeprecated;
    }


    public void setDateDeprecated( Date aDateDeprecated )
    {
        this.dateDeprecated = aDateDeprecated;
    }


    public Date getDateActivated( )
    {
        return dateActivated;
    }


    public void setDateActivated( Date aDateActivated )
    {
        this.dateActivated = aDateActivated;
    }


    public Date getDateDeactivated( )
    {
        return dateDeactivated;
    }


    public void setDateDeactivated( Date aDateDeactivated )
    {
        this.dateDeactivated = aDateDeactivated;
    }


    public Date getDateUpdated( )
    {
        return dateUpdated;
    }


    public void setDateUpdated( Date aDateUpdated )
    {
        this.dateUpdated = dateUpdated;
    }


    public String getStatus( )
    {
        return status;
    }


    public void setStatus( String aStatus )
    {
        this.status = aStatus;
    }

    
    public void setFilterSchemaXml( String aFilterSchemaXml )
    {
        this.filterSchemaXml = aFilterSchemaXml;
    }


    public String getFilterSchemaXml( )
    {
        return filterSchemaXml;
    }


    /**
     * Set the Filter Schema using the passed in string schema.
     * 
     * @param filterStringSchema the string schema
     */
    public void setFilterSchema( String aFilterSchemaXml )
    {
        try
        {
            SchemaFactory schemaFactory = SchemaFactory.newInstance( /*XMLConstants.W3C_XML_SCHEMA_NS_URI*/ "http://www.w3.org/2001/XMLSchema" );
            this.filterSchema = schemaFactory.newSchema( new StreamSource( new StringReader( aFilterSchemaXml ) ) );
            setFilterSchemaXml( aFilterSchemaXml );
        }
        catch ( SAXException e )
        {
            throw new FilterCacheException( ErrorCodeEnum.ERROR_MARSHALLING_FILTER_XML, e, aFilterSchemaXml, "Provided Filter schema is invalid : " + filterId );
        }
    }


    public void setFilterDescription( String aFilterDescription )
    {
        this.filterDescription = aFilterDescription;
    }


    public String getFilterDescription( )
    {
        return filterDescription;
    }


    public void setContainsCorrelation( boolean aContainsCorrelation )
    {
        this.containsCorrelation = aContainsCorrelation;
    }


    public boolean isContainsCorrelation( )
    {
        return containsCorrelation;
    }


    public void setEntryFilters( Set<EntryFilter> aEntryFilters )
    {
        this.entryFilters = aEntryFilters;
    }


    public Set<EntryFilter> getEntryFilters( )
    {
        return entryFilters;
    }

    
    public String toString()
    {
        return "id: " + getFilterId() + ", desc: " + getFilterDescription() + ", dateAdded: " + dateAdded + ", status: " + status + ", vhims: " + getVhimVersions() + ", entryFilters: " + getEntryFilters() + "\nXML: " + getFilterSchemaXml();
    }
}
