

package gov.va.med.cds.client.proxy;


import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.SocketClientException;
import gov.va.med.cds.util.MllpUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;


public class MllpDnsSocketBasedHTHClientProxy
    extends
        AbstractMllpSocketBasedClientProxy

{
    private static Log logger = LogFactory.getLog( MllpDnsSocketBasedHTHClientProxy.class );


    public ByteBuffer sendMessage( ByteBuffer message, Properties properties )
    {
        String dnsName = properties.getProperty( NetworkClientProxyInterface.PROP_DNS_NAME );
        if ( dnsName == null || dnsName.length() == 0 )
        {
            throw new IllegalArgumentException( "DNS name is required by MllpDnsSocketBasedClientProxy." );
        }
        return sendMessage( message, dnsName );
    }


    public ByteBuffer sendMessage( ByteBuffer acknowledgement, String host )
    {
        ByteBuffer response = null;

        SocketChannel socketChannel = null;

        WritableByteChannel wrappedWritableByteChannel = null;

        ReadableByteChannel wrappedReadableByteChannel = null;

        Map<String, Object> dataInfo = null;

        try
        {
            socketChannel = blockingConnectionFactory.getConnection( host, port );

            wrappedWritableByteChannel = getReadWriteChannel.getWriteChannel( socketChannel );

            wrappedWritableByteChannel.write( MllpUtil.encode( acknowledgement, Charset.defaultCharset(), Charset.forName( "ISO-8859-1" ) ) );

            ByteBuffer buffer = ByteBuffer.allocate( 2048 ); // allocate a 2K buffer to store the CA in.

            wrappedReadableByteChannel = getReadWriteChannel.getReadChannel( socketChannel );
            boolean hasEOB = false;
            try
            {

                int i = -1;
                while ( ( i = wrappedReadableByteChannel.read( buffer ) ) != -1 )
                {
                    //handle different scenarios of HTH vendor server Cx transmission
                    if ( MllpUtil.isCxMessage( new ByteBuffer[] { buffer }, Charset.forName( "ISO-8859-1" ) ) )
                    {
                        dataInfo = MllpUtil.decodeHTH( new ByteBuffer[] { buffer }, true, Charset.forName( "ISO-8859-1" ), Charset.defaultCharset() );

                        response = ( ByteBuffer )dataInfo.get( "data" );
                        hasEOB = ( ( Boolean )dataInfo.get( "eob" ) ).booleanValue();
                        if ( hasEOB )
                        {
                            break;
                        }
                    }
                }
            }
            catch ( java.net.SocketTimeoutException ste )//rare scenario
            {
                if ( response == null )
                {
                    dataInfo = MllpUtil.decodeHTH( new ByteBuffer[] { buffer }, true, Charset.forName( "ISO-8859-1" ), Charset.defaultCharset() );
                    response = ( ByteBuffer )dataInfo.get( "data" );
                }

            }
            buffer.flip();
        }
        catch ( Exception e )
        {
            logger.error( "Socket timeout exception occurred when writing/reading message ", e );
            throw new SocketClientException( ErrorCodeEnum.SOCKET_CLIENT_TIMEOUT_EXCEPTION, e );
        }
        finally
        {
            try
            {
                socketChannel.socket().close();
                socketChannel.close();
            }
            catch ( Exception e )
            {
                logger.error( "Error closing connection.", e );
            }
        }

        return response;
    }

}
