

package gov.va.med.cds.audit.persistence.hibernate;


import gov.va.med.cds.audit.TemplateIdWrapper;
import gov.va.med.cds.audit.persistence.CdsAuditClobStore;
import gov.va.med.cds.audit.persistence.CdsAuditClobStoreInterface;
import gov.va.med.cds.audit.persistence.HaAuditClobStore;
import gov.va.med.cds.audit.persistence.PathwaysAuditClobStore;

import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.orm.hibernate5.HibernateOperations;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

import javax.annotation.Resource;


@EnableTransactionManagement
@EnableAspectJAutoProxy
public class PersistAuditStore
    implements
        CdsAuditClobStoreInterface
{

    private HibernateOperations hibernateOperations;


    @Transactional( value = "hdr2TransactionManager", propagation = Propagation.REQUIRES_NEW, isolation = Isolation.READ_COMMITTED, readOnly = false )
    public void persistCdsAuditClob( CdsAuditClobStore cdsAuditClob )
    {
        persistTemplateIdWrapper( cdsAuditClob );
        hibernateOperations.save( cdsAuditClob );
        hibernateOperations.flush();
    }


    public void persistHaAuditClob( HaAuditClobStore haAuditClob )
    {

        persistTemplateIdWrapper( haAuditClob );
        hibernateOperations.save( haAuditClob );
    }


    @Transactional( value = "hdr2TransactionManager", propagation = Propagation.REQUIRES_NEW, isolation = Isolation.READ_COMMITTED, readOnly = false )
    public void persistPathwaysAuditClob( PathwaysAuditClobStore pathwaysAuditClobStore )
    {
        persistTemplateIdWrapper( pathwaysAuditClobStore );
        hibernateOperations.save( pathwaysAuditClobStore );
        hibernateOperations.flush();
    }


    private void persistTemplateIdWrapper( PathwaysAuditClobStore pathwaysAuditClobStore )
    {
        List<TemplateIdWrapper> hibernateTemplateIds = hibernateOperations.findByExample( pathwaysAuditClobStore.getTemplateIdWrapper() );
        if ( hibernateTemplateIds.size() < 1 )
        {
            hibernateOperations.save( pathwaysAuditClobStore.getTemplateIdWrapper() );
        }
        else
        {
            pathwaysAuditClobStore.setTemplateIdWrapper( hibernateTemplateIds.get( 0 ) );
        }

    }


    @SuppressWarnings( "unchecked" )
    private void persistTemplateIdWrapper( CdsAuditClobStore cdsAuditClob )
    {
        List<TemplateIdWrapper> hibernateTemplateIds = hibernateOperations.findByExample( cdsAuditClob.getTemplateIdWrapper() );
        if ( hibernateTemplateIds.size() < 1 )
        {
            hibernateOperations.save( cdsAuditClob.getTemplateIdWrapper() );
        }
        else
        {
            cdsAuditClob.setTemplateIdWrapper( hibernateTemplateIds.get( 0 ) );
        }
    }


    @SuppressWarnings( "unchecked" )
    private void persistTemplateIdWrapper( HaAuditClobStore haAuditClob )
    {
        List<TemplateIdWrapper> hibernateTemplateIds = hibernateOperations.findByExample( haAuditClob.getTemplateIdWrapper() );
        if ( hibernateTemplateIds.size() < 1 )
        {
            hibernateOperations.save( haAuditClob.getTemplateIdWrapper() );
        }
        else
        {
            haAuditClob.setTemplateIdWrapper( hibernateTemplateIds.get( 0 ) );
        }
    }


    public void setHibernateTemplate( HibernateOperations hibernateOperations )
    {
        this.hibernateOperations = hibernateOperations;
    }
}
