

package gov.va.med.cds.audit.persistence;


import gov.va.med.cds.audit.TemplateIdWrapper;


public class PathwaysAuditClobStore
    implements
        java.io.Serializable
{
    protected static final String ADD_NEW_LINE = "\n";
    protected static final String ADD_TAB = "\t";
    protected static final String ADD_DOUBLE_TAB = "\t\t";

    private String requestId;
    private String facilityId;
    private String hl7Clob;
    private String messageDateTime;
    private String messageType;
    private String clientIdentifier;
    private TemplateIdWrapper templateIdWrapper = new TemplateIdWrapper();
    private String clientRequestInitiationTime;
    private String samlToken;


    public PathwaysAuditClobStore( String aRequestId, String aFacilityId, String aHl7Clob, String aMessageDateTime, String aMessageType,
            String aTemplateId, String aClientIdentifier, String aClientRequestTime )
    {
        this.requestId = aRequestId;
        this.facilityId = aFacilityId;
        this.hl7Clob = aHl7Clob;
        this.messageDateTime = aMessageDateTime;
        this.messageType = aMessageType;
        this.clientIdentifier = aClientIdentifier;
        this.clientRequestInitiationTime = aClientRequestTime;

        setTemplateId( aTemplateId );
    }


    public PathwaysAuditClobStore( String aRequestId, String aFacilityId, String aHl7Clob, String aMessageDateTime, String aMessageType,
            String aTemplateId, String aClientIdentifier, String aClientRequestTime, String aSamlToken )
    {
        this.requestId = aRequestId;
        this.facilityId = aFacilityId;
        this.hl7Clob = aHl7Clob;
        this.messageDateTime = aMessageDateTime;
        this.messageType = aMessageType;
        this.clientIdentifier = aClientIdentifier;
        this.clientRequestInitiationTime = aClientRequestTime;

        setTemplateId( aTemplateId );
        isSamlTokenPresent( samlToken );
    }


    private void isSamlTokenPresent( String aSamlToken )
    {
        if ( null != aSamlToken )
        {
            StringBuilder auditInfo = new StringBuilder();
            auditInfo.append( hl7Clob );
            auditInfo.append( ADD_NEW_LINE );
            auditInfo.append( ADD_DOUBLE_TAB );
            auditInfo.append( "samlToken -> " );
            auditInfo.append( aSamlToken );
            setHl7Clob( auditInfo.toString() );
        }
    }


    public final String getTemplateId( )
    {
        return templateIdWrapper.getTemplateId();
    }


    public final void setTemplateId( String aTemplateId )
    {
        this.templateIdWrapper.setTemplateId( aTemplateId );
    }


    public final TemplateIdWrapper getTemplateIdWrapper( )
    {
        return templateIdWrapper;
    }


    public final void setTemplateIdWrapper( TemplateIdWrapper aTemplateIdWrapper )
    {
        templateIdWrapper = aTemplateIdWrapper;
    }


    public final String getFacilityId( )
    {
        return this.facilityId;
    }


    public final void setFacilityId( String aFacilityId )
    {
        this.facilityId = aFacilityId;
    }


    public final String getRequestId( )
    {
        return this.requestId;
    }


    public final void setRequestId( String aRequestId )
    {
        this.requestId = aRequestId;
    }


    public final String getHl7Clob( )
    {
        return this.hl7Clob;
    }


    public final void setHl7Clob( String aHl7Clob )
    {
        this.hl7Clob = aHl7Clob;
    }


    public final String getMessageDateTime( )
    {
        return this.messageDateTime;
    }


    public final void setMessageDateTime( String aMessageDateTime )
    {
        this.messageDateTime = aMessageDateTime;
    }


    public final String getMessageType( )
    {
        return this.messageType;
    }


    public final void setMessageType( String aMessageType )
    {
        this.messageType = aMessageType;
    }


    public final String getClientIdentifier( )
    {
        return this.clientIdentifier;
    }


    public final void setClientIdentifier( String aClientIdentifier )
    {
        this.clientIdentifier = aClientIdentifier;
    }


    public final String getClientRequestInitiationTime( )
    {
        return this.clientRequestInitiationTime;
    }


    public final void setClientRequestInitiationTime( String aClientRequestTime )
    {
        this.clientRequestInitiationTime = aClientRequestTime;
    }


    public final void setSamlToken( String aSamlToken )
    {
        this.samlToken = aSamlToken;
    }


    public final String getSamlToken( )
    {
        return samlToken;
    }

}
