

package gov.va.med.cds.audit.persistence;


import gov.va.med.cds.audit.TemplateIdWrapper;


public class HaAuditClobStore
{
    private Long auditId;
    private String requestId;
    private String hl7Clob;
    private String facilityId;
    private String messageDateTime;
    private String messageType;
    private TemplateIdWrapper templateIdWrapper = new TemplateIdWrapper();
    private String clientIdentifier;
    private String clientRequestInitiationTime;


    public HaAuditClobStore()
    {
    }


    public HaAuditClobStore( String aRequestId, String aFacilityId, String aHl7Clob, String aMessageDateTime, String aMessageType,
            String aTemplateId )
    {
        this( aRequestId, aFacilityId, aHl7Clob, aMessageDateTime, aMessageType, aTemplateId, null );
    }


    public HaAuditClobStore( String aRequestId, String aFacilityId, String aHl7Clob, String aMessageDateTime, String aMessageType,
            String aTemplateId, String aClientId )
    {
        setRequestId( aRequestId );
        setFacilityId( aFacilityId );
        setHl7Clob( aHl7Clob );
        setMessageDateTime( aMessageDateTime );
        setMessageType( aMessageType );
        setTemplateId( aTemplateId );
        setClientIdentifier( aClientId );
    }


    public HaAuditClobStore( String aRequestId, String aFacilityId, String aHl7Clob, String aMessageDateTime, String aMessageType,
            String aTemplateId, String aClientId, String aClientRequestInitiationTime )
    {
        setRequestId( aRequestId );
        setFacilityId( aFacilityId );
        setHl7Clob( aHl7Clob );
        setMessageDateTime( aMessageDateTime );
        setMessageType( aMessageType );
        setTemplateId( aTemplateId );
        setClientIdentifier( aClientId );
        setClientRequestInitiationTime( aClientRequestInitiationTime );
    }


    public final String getRequestId( )
    {
        return requestId;
    }


    public final void setRequestId( String aRequestId )
    {
        this.requestId = aRequestId;
    }


    public final Long getAuditId( )
    {
        return auditId;
    }


    public final String getFacilityId( )
    {
        return facilityId;
    }


    public final void setFacilityId( String aFacilityId )
    {
        this.facilityId = aFacilityId;
    }


    public final void setHl7Clob( String aHl7Clob )
    {
        this.hl7Clob = aHl7Clob;
    }


    public final String getHl7Clob( )
    {
        return hl7Clob;
    }


    public final void setMessageDateTime( String aMessageDateTime )
    {
        this.messageDateTime = aMessageDateTime;
    }


    public final void setMessageType( String aMessageType )
    {
        this.messageType = aMessageType;
    }


    public final String getMessageDateTime( )
    {
        return messageDateTime;
    }


    public final String getMessageType( )
    {
        return messageType;
    }


    public final String getClientIdentifier( )
    {
        return clientIdentifier;
    }


    public final void setClientIdentifier( String aClientIdentifier )
    {
        this.clientIdentifier = aClientIdentifier;
    }


    public final String getTemplateId( )
    {
        return templateIdWrapper.getTemplateId();
    }


    public final void setTemplateId( String aTemplateId )
    {
        this.templateIdWrapper.setTemplateId( aTemplateId );
    }


    public final TemplateIdWrapper getTemplateIdWrapper( )
    {
        return templateIdWrapper;
    }


    public final void setTemplateIdWrapper( TemplateIdWrapper aTemplateIdWrapper )
    {
        templateIdWrapper = aTemplateIdWrapper;
    }


    public final String getClientRequestInitiationTime( )
    {
        return clientRequestInitiationTime;
    }


    public final void setClientRequestInitiationTime( String aClientRequestInitiationTime )
    {
        this.clientRequestInitiationTime = aClientRequestInitiationTime;
    }
}
