/**
 * 
 */


package gov.va.med.cds.audit.persistence;


import gov.va.med.cds.audit.TemplateIdWrapper;


/**
 * @author vhaislchittv
 * 
 */
public class CdsAuditClobStore
{
    private Long auditId;
    private String requestId;
    private String hl7Clob;
    private String facilityId;
    private String messageDateTime;
    private String messageType;
    private TemplateIdWrapper templateId = new TemplateIdWrapper();
    private String clientIdentifier;
    private String clientRequestInitiationTime;


    public CdsAuditClobStore( )
    {
    }


    public CdsAuditClobStore( String aRequestId, String aFacilityId, String aHl7Clob, String aMessageDateTime, String aMessageType, String aTemplateId )
    {
        this( aRequestId, aFacilityId, aHl7Clob, aMessageDateTime, aMessageType, aTemplateId, null );
    }


    public CdsAuditClobStore( String aRequestId, String aFacilityId, String aHl7Clob, String aMessageDateTime, String aMessageType, String aTemplateId,
                    String aClientId )
    {
        setRequestId( aRequestId );
        setFacilityId( aFacilityId );
        setHl7Clob( aHl7Clob );
        setMessageDateTime( aMessageDateTime );
        setMessageType( aMessageType );
        setTemplateId( aTemplateId );
        setClientIdentifier( aClientId );
    }


    public CdsAuditClobStore( String aRequestId, String aFacilityId, String aHl7Clob, String aMessageDateTime, String aMessageType, String aTemplateId,
                    String aClientId, String aClientRequestInitiationTime )
    {
        setRequestId( aRequestId );
        setFacilityId( aFacilityId );
        setHl7Clob( aHl7Clob );
        setMessageDateTime( aMessageDateTime );
        setMessageType( aMessageType );
        setTemplateId( aTemplateId );
        setClientIdentifier( aClientId );
        setClientRequestInitiationTime( aClientRequestInitiationTime );
    }


    public final String getRequestId( )
    {
        return requestId;
    }


    public final void setRequestId( String requestId )
    {
        this.requestId = requestId;
    }


    public final Long getAuditId( )
    {
        return auditId;
    }


    public final String getFacilityId( )
    {
        return facilityId;
    }


    public final void setFacilityId( String facilityId )
    {
        this.facilityId = facilityId;
    }


    public final void setHl7Clob( String hl7Clob )
    {
        this.hl7Clob = hl7Clob;
    }


    public final String getHl7Clob( )
    {
        return hl7Clob;
    }


    public final void setMessageDateTime( String messageDateTime )
    {
        this.messageDateTime = messageDateTime;
    }


    public final void setMessageType( String messageType )
    {
        this.messageType = messageType;
    }


    public final String getMessageDateTime( )
    {
        return messageDateTime;
    }


    public final String getMessageType( )
    {
        return messageType;
    }


    public final String getClientIdentifier( )
    {
        return clientIdentifier;
    }


    public final void setClientIdentifier( String clientIdentifier )
    {
        this.clientIdentifier = clientIdentifier;
    }


    public final String getTemplateId( )
    {
        return templateId.getTemplateId();
    }


    public final void setTemplateId( String templateId )
    {
        this.templateId.setTemplateId( templateId );
    }


    public final TemplateIdWrapper getTemplateIdWrapper( )
    {
        return templateId;
    }


    public final void setTemplateIdWrapper( TemplateIdWrapper aTemplateIdWrapper )
    {
        templateId = aTemplateIdWrapper;
    }


    public final String getClientRequestInitiationTime( )
    {
        return clientRequestInitiationTime;
    }


    public final void setClientRequestInitiationTime( String clientRequestInitiationTime )
    {
        this.clientRequestInitiationTime = clientRequestInitiationTime;
    }
}
