

package gov.va.med.cds.audit;


import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import gov.va.med.cds.util.DateTimeUtil;


public class VhimReadPathwaysResponseAuditLog
    extends
        AbstractAuditLog
{
    private static final Log logger = LogFactory.getLog( VhimReadPathwaysResponseAuditLog.class );
    private static final long serialVersionUID = 1L;

    protected static final String ADD_NEW_LINE = "\n";
    protected static final String ADD_TAB = "\t";
    protected static final String ADD_DOUBLE_TAB = "\t\t";
    private static final String PATHWAYS_DOMAIN_NAME = "PATHWAYS 1.x";
    private String pathwaysDomainName = PATHWAYS_DOMAIN_NAME;
    private Long auditLogId;
    private Date localTime;
//    protected String isoLocalTime = DateTimeUtil.getISOTimeOld( new Date().getTime(), null );
    protected String isoLocalTime = DateTimeUtil.getCurrentISOTime( );
    private ClientMappingPathways clientMappingPathways;
    protected String clientId;
    protected String clientRequestInitiationTime;
    private TemplateIdWrapper templateIdWrapper = new TemplateIdWrapper();
    private FilterIdWrapper filterIdWrapper = new FilterIdWrapper();
    protected String filterRequest;
    protected Long clientMappingId;
    private String facility;
    private String response;
    protected long startTime;
    protected long endTime;
    private long milliseconds;
    protected String requestId;
    protected String sendingApplication;
    protected String debugInfo;
    private int responseSize = -1;
    private int responseLength = -1;
    private String appName;
    
    


    public String getDebugInfo( )
    {
        StringBuilder auditInfo = new StringBuilder();

        // Build the audit log message
        auditInfo.append( "Server " + PATHWAYS_DOMAIN_NAME + " ==> Audit detail: " );
        auditInfo.append( ADD_NEW_LINE );
        auditInfo.append( ADD_TAB );
        auditInfo.append( "domain => " );
        auditInfo.append( PATHWAYS_DOMAIN_NAME );
        auditInfo.append( ADD_NEW_LINE );
        auditInfo.append( ADD_TAB );
        auditInfo.append( "start_milliseconds => " );
        auditInfo.append( startTime );
        auditInfo.append( ADD_NEW_LINE );
        auditInfo.append( ADD_TAB );
        auditInfo.append( "milliseconds => " );
        auditInfo.append( getMilliseconds() );
        auditInfo.append( ADD_NEW_LINE );
        auditInfo.append( ADD_TAB );
        auditInfo.append( "ISO_localtime => " );
        auditInfo.append( isoLocalTime );
        auditInfo.append( ADD_NEW_LINE );
        auditInfo.append( ADD_TAB );
        auditInfo.append( "log_information => " );
        auditInfo.append( ADD_NEW_LINE );
        auditInfo.append( ADD_DOUBLE_TAB );
        auditInfo.append( "startTime -> " );
        auditInfo.append( startTime );
        auditInfo.append( ADD_NEW_LINE );
        auditInfo.append( ADD_DOUBLE_TAB );
        auditInfo.append( "sendingApplication -> " );
        auditInfo.append( sendingApplication );
        auditInfo.append( ADD_NEW_LINE );
        auditInfo.append( ADD_DOUBLE_TAB );
        auditInfo.append( "originalMessageControlId -> " );
        auditInfo.append( requestId );
        auditInfo.append( ADD_NEW_LINE );
        auditInfo.append( ADD_DOUBLE_TAB );
        auditInfo.append( "requesterString -> " );
        auditInfo.append( ADD_NEW_LINE );
        auditInfo.append( ADD_DOUBLE_TAB );
        auditInfo.append( "requestMsg -> " );
        auditInfo.append( filterRequest );
        auditInfo.append( ADD_NEW_LINE );
        auditInfo.append( ADD_DOUBLE_TAB );
        auditInfo.append( "receivingApplication -> " );
        auditInfo.append( PATHWAYS_DOMAIN_NAME );
        auditInfo.append( ADD_NEW_LINE );
        auditInfo.append( ADD_DOUBLE_TAB );
        auditInfo.append( "completionTime -> " );
        auditInfo.append( Long.toString( endTime ) );
        auditInfo.append( ADD_NEW_LINE );
        auditInfo.append( ADD_DOUBLE_TAB );
        auditInfo.append( "samlToken -> " );
        auditInfo.append( getSamlToken() );

        this.debugInfo = auditInfo.toString();
        return debugInfo;
    }


    public void setDebugInfo( String aDebugInfo )
    {
        this.debugInfo = aDebugInfo;
        Map<String, String> debugInfoMap = parseDebugInfo( aDebugInfo );
        setStartTime( Long.parseLong( debugInfoMap.get( "start_milliseconds" ) ) );
        setMilliseconds( Long.parseLong( debugInfoMap.get( "milliseconds" ) ) );
        setIsoLocalTime( debugInfoMap.get( "ISO_localtime" ) );
        setSendingApplication( debugInfoMap.get( "sendingApplication" ) );
        setRequestId( debugInfoMap.get( "originalMessageControlId" ) );
        setFilterRequest( debugInfoMap.get( "requestMsg" ) );
        setEndTime( Long.parseLong( debugInfoMap.get( "completionTime" ) ) );
    }


    /* (non-Javadoc)
     * @see gov.va.med.cds.audit.AbstractAuditLog#getResponseLength(java.lang.String)
     */
    @SuppressWarnings( { "rawtypes" } )
    @Override
    protected int getResponseLength( String aResponse )
    {
        responseLength = 0;
        if ( aResponse != null )
        {
            try
            {
                Document document = DocumentHelper.parseText( aResponse );
                Element rootElement = document.getRootElement();

                if ( rootElement.element( "patients" ) != null )
                {
                    for ( Iterator patientIterator = rootElement.element( "patients" ).elementIterator( "patient" ); patientIterator
                            .hasNext(); )
                    {
                        Element patientElement = ( Element )patientIterator.next();

                        responseLength += patientElement.selectNodes( "//exams/exam" ).size();
                        responseLength += patientElement.selectNodes( "//examRequests/examRequest" ).size();
                        responseLength += patientElement.selectNodes( "//appointments/appointment" ).size();
                        responseLength += patientElement.selectNodes( "//releasesOfInformation/releaseOfInformation" ).size();
                        responseLength += patientElement.selectNodes( "//clinicalReminders/clinicalReminder" ).size();
                        responseLength += patientElement.selectNodes( "nonVeteranEmployees" ).size();
                    }
                }

            }
            catch ( DocumentException e )
            {
                throw new IllegalArgumentException( "Invalid document string passed in.", e );
            }
        }

        return responseLength;
    }


    @Override
    public int getResponseLength( )
    {
        if ( response != null )
        {
            return getResponseLength( response );
        }

        return responseLength;
    }


    @Override
    public int getResponseSize( )
    {
        responseSize = ( getResponse() != null ) ? getResponse().getBytes().length : 0;
        
        return responseSize;
    }


    public void setResponseLength( int aResponseLength )
    {
        this.responseLength = aResponseLength;
    }


    public void setResponseSize( int aResponseSize )
    {
        this.responseSize = aResponseSize;
    }


    public String getPathwaysDomainName( )
    {
        return pathwaysDomainName;
    }


    public void setPathwaysDomainName( String aPathwaysDomainName )
    {
        this.pathwaysDomainName = aPathwaysDomainName;
    }


    public Long getAuditLogId( )
    {
        return auditLogId;
    }


    @SuppressWarnings( "unused" )
    private void setAuditLogId( Long anAuditLogId )
    {
        this.auditLogId = anAuditLogId;
    }


    public long getMilliseconds( )
    {
    	this.milliseconds = this.endTime - this.startTime;
        return this.milliseconds;
    }


    public void setMilliseconds( long aMilliseconds )
    {
        this.milliseconds = aMilliseconds;
    }


    public String getDomainName( )
    {
        return PATHWAYS_DOMAIN_NAME;
    }


    public ClientMappingPathways getClientMappingPathways( )
    {
        return clientMappingPathways;
    }


    public void setClientMappingPathways( ClientMappingPathways aClientMappingPathways )
    {
        this.clientMappingPathways = aClientMappingPathways;
    }


    public String getFilterId( )
    {
        return filterIdWrapper.getFilterId();
    }


    public String getClientId( )
    {
        return clientId;
    }


    public void setClientId( String aClientId )
    {
        this.clientId = aClientId;
    }
    
    
    public Long getClientMappingId( )
    {
        return clientMappingPathways.getClientMappingId();
    }


    public void setClientMappingId( Long aClientMappingId )
    {
    	clientMappingPathways.setClientMappingId(aClientMappingId);
    }



    public String getTemplateId( )
    {
        return templateIdWrapper.getTemplateId();
    }


    public void setTemplateId( String aTemplateId )
    {
        templateIdWrapper.setTemplateId( aTemplateId );
        if ( clientMappingPathways == null )
        {
            clientMappingPathways = new ClientMappingPathways( null, aTemplateId );
        }
        else
        {
            clientMappingPathways.setTemplateId( aTemplateId );
        }
    }


    public void setFilterId( String aFilterId )
    {
        filterIdWrapper.setFilterId( aFilterId );
        if ( clientMappingPathways == null )
        {
            clientMappingPathways = new ClientMappingPathways( aFilterId, null );
        }
        else
        {
            clientMappingPathways.setFilterId( aFilterId );
        }
    }


    protected Map<String, String> parseDebugInfo( String aDebugInfo )
    {
        Map<String, String> data = new Hashtable<String, String>();
        String delim = "=>";
        aDebugInfo = aDebugInfo.substring( aDebugInfo.indexOf( "Audit detail: " ) + "Audit detail: ".length() );
        String[] infos = aDebugInfo.split( "\n" );

        for ( String info : infos )
        {
            info = info.trim();

            if ( info.startsWith( "Server" ) )
            {
                continue;
            }

            if ( info.startsWith( "log_information" ) )
            {
                delim = "->";
                continue;
            }

            String[] arr = info.split( delim );
            data.put( arr[0].trim(), ( arr.length == 2 ) ? arr[1].trim() : "" );
        }

        return data;
    }


    public Date getLocalTime( )
    {
        return localTime;
    }


    public void setLocalTime( Date aLocalTime )
    {
        this.localTime = aLocalTime;
    }


    public String getFacility( )
    {
        return facility;
    }


    public void setFacility( String aFacility )
    {
        this.facility = aFacility;
    }


    public String getResponse( )
    {
        return response;
    }


    public void setResponse( String aResponse )
    {
        this.response = aResponse;
    }


    public long getStartTime( )
    {
        return startTime;
    }


    public void setStartTime( long aStartTime )
    {
        this.startTime = aStartTime;
    }


    public long getEndTime( )
    {
        return endTime;
    }


    public void setEndTime( long aEndTime )
    {
        this.endTime = aEndTime;
    }


    public String getIsoLocalTime( )
    {
        return isoLocalTime;
    }


    public void setIsoLocalTime( String aIsoLocalTime )
    {
        this.isoLocalTime = aIsoLocalTime;
    }


    public String getRequestId( )
    {
        return requestId;
    }


    public void setRequestId( String aRequestId )
    {
        this.requestId = aRequestId;
    }


    public String getSendingApplication( )
    {
        return sendingApplication;
    }


    public void setSendingApplication( String aSendingApplication )
    {
        this.sendingApplication = aSendingApplication;
    }


    public String getFilterRequest( )
    {
        return filterRequest;
    }


    public void setFilterRequest( String aFilterRequest )
    {
        this.filterRequest = aFilterRequest;
        
        try
        {
            Document filterDocument = DocumentHelper.parseText( aFilterRequest );
            this.setClientId( filterDocument.getRootElement().elementTextTrim( "clientName" ) );
            this.setClientRequestInitiationTime( filterDocument.getRootElement().elementTextTrim( "clientRequestInitiationTime" ) );
        }
        catch ( DocumentException e )
        {
            throw new IllegalArgumentException("Filter request document is not valid XML.", e);
        }
        
    }


    public String getAppName( )
    {
        return appName;
    }


    public void setAppName( String anAppName )
    {
        this.appName = anAppName;
    }


    public TemplateIdWrapper getTemplateIdWrapper( )
    {
        return templateIdWrapper;
    }


    public void setTemplateIdWrapper( TemplateIdWrapper aTemplateIdWrapper )
    {
        this.templateIdWrapper = aTemplateIdWrapper;
    }


    public FilterIdWrapper getFilterIdWrapper( )
    {
        return filterIdWrapper;
    }


    public void setFilterIdWrapper( FilterIdWrapper aFilterIdWrapper )
    {
        this.filterIdWrapper = aFilterIdWrapper;
    }


    public String getClientRequestInitiationTime( )
    {
        return clientRequestInitiationTime;
    }


    public void setClientRequestInitiationTime( String aClientRequestInitiationTime )
    {
        this.clientRequestInitiationTime = aClientRequestInitiationTime;
    }

}
