package gov.va.med.cds.audit;

public interface ReadAuditFactoryInteface
{
    /**
     * Creates an instance of the an audit log appropriate to the client and template.
     * @param clientId The client identifier of the read client.
     * @param templateId The template identifier being requested by the read client.
     * @param filterRequest The filter request being made by the read client.
     * @param filterId The identifier of the filter being performed by the read client.
     * @param requestId The request identifier of the request being performed by the read client.
     * @param startTime The start time of the request being performed by the read client. This is used to calculate read response times.
     * @param response The response returned by the CDS framework to the read client.
     * @return The audit log instance that will by persisted by the CDS framework.
     */
    AbstractAuditLog createAuditLog( String aClientId, String aTemplateId, String aFilterRequest, String aFilterId, String aRequestId, long aStartTime, String aResponse, String aSamlToken );
}
