

package gov.va.med.cds.audit;


import java.util.HashMap;
import java.util.Map;


public class ReadAuditFactory
    implements
        ReadAuditFactoryInteface
{
    private Map<String, ReadAuditFactoryInteface> filterToReadAuditFactoryMap = new HashMap<String, ReadAuditFactoryInteface>();


    /*
     * (non-Javadoc)
     * 
     * @see
     * gov.va.med.cds.audit.ReadAuditFactoryInteface#createAuditLog(java.lang.
     * String, java.lang.String, java.lang.String, java.lang.String,
     * java.lang.String, long, java.lang.String)
     */
    @Override
    public AbstractAuditLog createAuditLog( String aClientId, String aTemplateId, String aFilterRequest, String aFilterId, String aRequestId,
            long aStartTime, String aResponse, String aSamlToken )
    {
        ReadAuditFactoryInteface readAuditFactory = this.filterToReadAuditFactoryMap.get( aFilterId );

        if ( readAuditFactory == null )
        {
            throw new IllegalArgumentException(
                    String.format( "Unexpected client and template combination: Client ID: %s, Template ID: %s", aClientId, aTemplateId ) );
        }

        return readAuditFactory.createAuditLog( aClientId, aTemplateId, aFilterRequest, aFilterId, aRequestId, aStartTime, aResponse, aSamlToken );
    }


    public void setFilterToReadAuditFactoryMap( Map<String, ReadAuditFactoryInteface> filterToReadAuditFactoryMap )
    {
        this.filterToReadAuditFactoryMap = filterToReadAuditFactoryMap;
    }

}
