/******************************************************************************
   NAME:       load_tiu_load4x_arms.sql
   PURPOSE:    This script will create tiu records that map to 
               VHIM version 4  
   ADDITIONAL INFORMATION:
    
   REVISIONS:
   Ver        Date        Author           Description
   ---------  ----------  ---------------  ------------------------------------
   1.1        12/02/2008  M. Jacobsen      - Initial Release for vhim 4.0
******************************************************************************/
set serveroutput on
DECLARE
   prev_num                     NUMBER          := 0;
   random_num                   NUMBER          := 0;
   random_num2                  NUMBER          := 0;
   random_num3                  NUMBER          := 0;
   random_num4                  NUMBER          := 0;
   random_num5                  NUMBER          := 0;
   random_num6                  NUMBER          := 0;
   random_num7                  NUMBER          := 0;
   random_num8                  NUMBER          := 0;
   upd_date                     VARCHAR2 (30);
   reference_date              VARCHAR2 (30);
   datap_date                VARCHAR2 (30);
   authp_date               VARCHAR2 (30);
   amend_date                   VARCHAR2 (30);
   dictate_date                 varchar2(30);
   pmvmnt_date                  varchar2(30);
   archive_date                 varchar2(30);
   proc_date                    varchar2(30);
   del_date                     varchar2(30);
   collection_date              VARCHAR2 (30);
   ord_date                     VARCHAR2 (30);
   value_date                   VARCHAR2 (30);
   clinical_document_seq_id_val      NUMBER;
   patient_seq_id_val           NUMBER;
   tiu_patient_visit_seq_id_val     NUMBER;
   hosploc_cd_d                 varchar2(100);
   hosploc_cd_v                 varchar2(100);
   v_vpid                       VARCHAR2 (30);
   r_vpid                       VARCHAR2 (30);
   starting_patient_vpid        NUMBER;
   fixed_date			        DATE;
   vr_tpp_id                    number;
   ve_tpp_id                    number;
   vd_tpp_id                    number;
   vi_tpp_id                    number;
   de_tpp_id                    number;
   au_tpp_id                    number;
   cs_tpp_id                    number;
   cc_tpp_id                    number;
   es_tpp_id                    number;
   sg_tpp_id                    number;
   ec_tpp_id                    number;
   cg_tpp_id                    number;
   ac_tpp_id                    number;
   am_tpp_id                    number;
   rt_tpp_id                    number;
   
BEGIN
   dbms_output.enable(null);
   DBMS_RANDOM.SEED(42); -- add seeding for same random numbers.
   DBMS_OUTPUT.put_line (   'TIU Start Time := '|| TO_CHAR (SYSDATE, 'MM/DD/YY hh:mi:ss'));

   fixed_date := TO_DATE('12-02-08 17:07:06','MM-DD-YY HH24:MI:SS');

-- Set starting_patient_vpid
   IF &3 <= 0 
   THEN
       starting_patient_vpid :=1;
   ELSE
       starting_patient_vpid := &3 - 1;
   END IF;

--loop thru x times
   FOR z IN 1 .. &1
   LOOP
       -- Loop thru how many patients to assign lab to
       FOR jj in 1 .. &2
	   LOOP
         
         random_num  := DBMS_RANDOM.VALUE (-10, -30);
         random_num2 := DBMS_RANDOM.VALUE (-1, -15);
         random_num3 := DBMS_RANDOM.VALUE (-3, -18);
         random_num4 := DBMS_RANDOM.VALUE (-4, -25);
         random_num5 := DBMS_RANDOM.VALUE (-1, -10);
         random_num6 := DBMS_RANDOM.VALUE (-2, -5);
         random_num7 := DBMS_RANDOM.VALUE (-3, -22);
         random_num8 := DBMS_RANDOM.VALUE (-3, -30);

         SELECT TO_CHAR (fixed_date + random_num2, 'yyyymmddhh24miss'),
                TO_CHAR (fixed_date + random_num3, 'yyyymmddhh24miss'),
                TO_CHAR (fixed_date + random_num4, 'yyyymmddhh24miss'),
                TO_CHAR (fixed_date + random_num5, 'yyyymmddhh24miss'),
                TO_CHAR (fixed_date + random_num6, 'yyyymmddhh24miss'),
                TO_CHAR (fixed_date + random_num7, 'yyyymmddhh24miss'),
                TO_CHAR (fixed_date + random_num8, 'yyyymmddhh24miss'),
                TO_CHAR (fixed_date + random_num, 'yyyymmddhh24miss'),
                TO_CHAR (fixed_date, 'yyyymmddhh24miss')
           INTO reference_date,
                datap_date,
                authp_date,
                amend_date,
                dictate_date,
                pmvmnt_date,
                archive_date,
                proc_date,
                upd_date
           FROM DUAL;

         SELECT clinical_document_seq_id.NEXTVAL
           INTO clinical_document_seq_id_val
           FROM DUAL;
                       
         -- Set hospital code
         random_num := round(DBMS_RANDOM.VALUE (1, 10));

         CASE random_num
            WHEN '1' THEN
               hosploc_cd_d := 'VA SALT LAKE CITY HEALTH CARE SYSTEM';
               hosploc_cd_v := '660';
            WHEN '2' THEN
               hosploc_cd_d := 'TUSCALOOSA VA MEDICAL CENTER';
               hosploc_cd_v := '679';
            WHEN '3' THEN
               hosploc_cd_d := 'CENTRAL TEXAS VETERANS HEALTH CARE SYSTEM';
               hosploc_cd_v := '674';
            WHEN '4' THEN
               hosploc_cd_d := 'PHILADELPHIA VA MEDICAL CENTER';
               hosploc_cd_v := '642';
            WHEN '5' THEN
               hosploc_cd_d := 'CINCINNATI VA MEDICAL CENTER';
               hosploc_cd_v := '539';
            WHEN '6' THEN
               hosploc_cd_d := 'JAMES J. PETERS VA MEDICAL CENTER';
               hosploc_cd_v := '526';
            WHEN '7' THEN
               hosploc_cd_d := 'VA GULF COAST VETERANS HEALTH CARE SYSTEM';
               hosploc_cd_v := '520';
            WHEN '8' THEN
               hosploc_cd_d := 'RICHARD L. ROUDEBUSH VA MEDICAL CENTER';
               hosploc_cd_v := '583';
            WHEN '9' THEN
               hosploc_cd_d := 'MIAMI VA HEALTHCARE SYSTEM';
               hosploc_cd_v := '546';
            ELSE
               hosploc_cd_d := 'JONATHAN M. WAINWRIGHT MEMORIAL VA MEDICAL CENTER';
               hosploc_cd_v := '687';
         END CASE;

         INSERT INTO tiu_patient_visit_v (
                            TIU_PATIENT_VISIT_ID
                          , PATIENT_CLASS
                          , ASSIGN_LOC_POINT_OF_CARE
                          , ASSIGN_LOC_ROOM
                          , ASSIGN_LOC_BED
                          , ASSIGN_LOC_FCLTY_NMSPCID
                          , ASSIGN_LOC_FCLTY_UNVSID
                          , ASSIGN_LOC_FCLTY_UNVSIDTYP
                          , ASSIGN_LOC_PERS_LOC_TYP
                          , ASSIGN_LOC_DESCRIPTION
                          , srvc_LOC_POINT_OF_CARE
                          , srvc_LOC_ROOM
                          , srvc_LOC_BED
                          , srvc_LOC_FCLTY_NMSPCID
                          , srvc_LOC_FCLTY_UNVSID
                          , srvc_LOC_FCLTY_UNVSIDTYP
                          , srvc_LOC_PERS_LOC_TYP
                          , srvc_LOC_DESCRIPTION
                          , atnd_PERSON_IDENTITY
                          , atnd_PERSON_ASGNING_FACILITY
                          , atnd_PERSON_ASGNING_AUTHORITY
                          , atnd_PRACTITIONER_ID_SRC_TBL
                          , atnd_NAME_PREFIX
                          , atnd_NAME_GIVEN
                          , atnd_NAME_FAMILY
                          , atnd_NAME_SUFFIX
                          , atnd_NAME_TITLE
                          , atnd_NAME_MIDDLE
                          , HOSPITAL_SERVICE
                          , visit_dt
                          , visit_dt_nbr
                          , SERVICE_FACILITY
                          , admit_dt
                          , admit_dt_nbr
                          , visit_identifier
                          , secondary_visit_dt
                          , secondary_visit_dt_nbr
                )
         VALUES (
                   tiu_patient_visit_seq_id.nextval                                             -- LAB_PATIENT_VISIT_ID
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- PATIENT_CLASS
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- ASSIGN_LOC_POINT_OF_CARE
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- ASSIGN_LOC_ROOM
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- ASSIGN_LOC_BED
                 , hosploc_cd_d                                                                 -- ASSIGN_LOC_FCLTY_NMSPCID
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- ASSIGN_LOC_FCLTY_UNVSID
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- ASSIGN_LOC_FCLTY_UNVSIDTYP
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- ASSIGN_LOC_PERS_LOC_TYP
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- ASSIGN_LOC_DESCRIPTION
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- PRIOR_LOC_POINT_OF_CARE
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- PRIOR_LOC_ROOM
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- PRIOR_LOC_BED
                 , hosploc_cd_d                                                                 -- PRIOR_LOC_FCLTY_NMSPCID
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- PRIOR_LOC_FCLTY_UNVSID
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- PRIOR_LOC_FCLTY_UNVSIDTYP
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- PRIOR_LOC_PERS_LOC_TYP
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- PRIOR_LOC_DESCRIPTION
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- AUTH_PERSON_IDENTITY
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- AUTH_PERSON_ASGNING_FACILITY
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- AUTH_PERSON_ASGNING_AUTHORITY
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- AUTH_PRACTITIONER_ID_SRC_TBL
                 , NULL                                                                         -- AUTH_NAME_PREFIX
                 , NULL                                                                         -- AUTH_NAME_GIVEN
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- AUTH_NAME_FAMILY
                 , NULL                                                                         -- AUTH_NAME_SUFFIX
                 , NULL                                                                         -- AUTH_NAME_TITLE
                 , NULL                                                                         -- AUTH_NAME_MIDDLE
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- HOSPITAL_SERVICE
                 , amend_date                                                                   -- visit_dt
                 , (to_number(amend_date,'99999999999999')-17000000000000)/1000000               -- visit_DT_NBR
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- SERVICE_FACILITY
                 , amend_date                                                                   -- admit_dt
                 , (to_number(amend_date,'99999999999999')-17000000000000)/1000000               -- admit_DT_NBR
                 , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                      -- visit_identifier
                 , archive_date                                                                 -- secondary_visit_dt
                 , (to_number(archive_date,'99999999999999')-17000000000000)/1000000             -- secondary_visit_dt_nbr
         );


         v_vpid := 'test_sourceid_' || to_char(jj + starting_patient_vpid);
         r_vpid := 'retract_sourceid_' || to_char(jj + starting_patient_vpid);

         de_tpp_id := NULL;
         au_tpp_id := NULL;
         cs_tpp_id := NULL;
         cc_tpp_id := NULL;
         es_tpp_id := NULL;
         sg_tpp_id := NULL;
         ec_tpp_id := NULL;
         cg_tpp_id := NULL;
         ac_tpp_id := NULL;
         am_tpp_id := NULL;
         rt_tpp_id := NULL;
         -- load 0 or 1 tiu_pract_part (dataEnterer)
         random_num := ROUND (DBMS_RANDOM.VALUE (1, 10));
         IF random_num > 2
         THEN
                -- set tiu_pract_part_id
                SELECT tiu_pract_part_seq_id.nextval
                INTO de_tpp_id
                FROM dual;
                -- Insert into tiu_pract_part_v
                INSERT INTO TIU_PRACT_PART_V (
                                                TIU_PRACT_PART_ID
--                                              , CLINICAL_DOCUMENT_ID
--                                              , DISCRIMINATOR
                                              , PERSON_IDENTITY
                                              , PERSON_ASSIGNING_FACILITY
                                              , PERSON_ASSIGNING_AUTHORITY
                                              , PRACTITIONER_ID_SRC_TBL
                                              , NAME_PREFIX
                                              , NAME_GIVEN
                                              , NAME_FAMILY
                                              , NAME_SUFFIX
                                              , NAME_TITLE
                                              , NAME_MIDDLE
                                             )
                                      VALUES (
                                                de_tpp_id                                                     -- TIU_PRACT_PART_ID	
--                                              , clinical_document_seq_id_val                                     -- CLINICAL_DOCUMENT_ID	
--                                              , 'DTR'                                                         -- DISCRIMINATOR	
                                              , 'dataEnterer_id_' || to_char(round(dbms_random.value(1,1000)))-- PERSON_IDENTITY
                                              , 'visn ' || to_char(round(dbms_random.value(1,21)))            -- PERSON_ASSIGNING_FACILITY
                                              , null                                                          -- PERSON_ASSIGNING_AUTHORITY
                                              , null                                                          -- PRACTITIONER_ID_SRC_TBL	
                                              , NULL                                                          -- NAME_PREFIX	
                                              , NULL                                                          -- NAME_GIVEN	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,40)))       -- NAME_FAMILY	
                                              , NULL                                                          -- NAME_SUFFIX	
                                              , NULL                                                          -- NAME_TITLE	
                                              , NULL                                                          -- NAME_MIDDLE	
                                             );         
         END IF;

         -- load 0 or 1 tiu_pract_part (author)
         random_num := ROUND (DBMS_RANDOM.VALUE (1, 10));
         IF random_num > 2
         THEN
                -- set tiu_pract_part_id
                SELECT tiu_pract_part_seq_id.nextval
                INTO au_tpp_id
                FROM dual;
                -- Insert into tiu_pract_part_v
                INSERT INTO TIU_PRACT_PART_V (
                                                TIU_PRACT_PART_ID
--                                              , CLINICAL_DOCUMENT_ID
--                                              , DISCRIMINATOR
                                              , PERSON_IDENTITY
                                              , PERSON_ASSIGNING_FACILITY
                                              , PERSON_ASSIGNING_AUTHORITY
                                              , PRACTITIONER_ID_SRC_TBL
                                              , NAME_PREFIX
                                              , NAME_GIVEN
                                              , NAME_FAMILY
                                              , NAME_SUFFIX
                                              , NAME_TITLE
                                              , NAME_MIDDLE
                                             )
                                      VALUES (
                                                au_tpp_id                                                     -- TIU_PRACT_PART_ID	
--                                              , clinical_document_seq_id_val                                     -- CLINICAL_DOCUMENT_ID	
--                                              , 'ATH'                                                         -- DISCRIMINATOR	
                                              , 'author_id_' || to_char(round(dbms_random.value(1,1000)))-- PERSON_IDENTITY
                                              , 'visn ' || to_char(round(dbms_random.value(1,21)))            -- PERSON_ASSIGNING_FACILITY
                                              , null                                                          -- PERSON_ASSIGNING_AUTHORITY
                                              , null                                                          -- PRACTITIONER_ID_SRC_TBL	
                                              , NULL                                                          -- NAME_PREFIX	
                                              , NULL                                                          -- NAME_GIVEN	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,40)))       -- NAME_FAMILY	
                                              , NULL                                                          -- NAME_SUFFIX	
                                              , NULL                                                          -- NAME_TITLE	
                                              , NULL                                                          -- NAME_MIDDLE	
                                             );         
         END IF;

         -- load 0 or 1 tiu_pract_part (chartMarkedSigned)
         random_num := ROUND (DBMS_RANDOM.VALUE (1, 10));
         IF random_num > 6
         THEN
                -- set tiu_pract_part_id
                SELECT tiu_pract_part_seq_id.nextval
                INTO cs_tpp_id
                FROM dual;
                -- Insert into tiu_pract_part_v
                INSERT INTO TIU_PRACT_PART_V (
                                                TIU_PRACT_PART_ID
--                                              , CLINICAL_DOCUMENT_ID
--                                              , DISCRIMINATOR
                                              , PERSON_IDENTITY
                                              , PERSON_ASSIGNING_FACILITY
                                              , PERSON_ASSIGNING_AUTHORITY
                                              , PRACTITIONER_ID_SRC_TBL
                                              , NAME_PREFIX
                                              , NAME_GIVEN
                                              , NAME_FAMILY
                                              , NAME_SUFFIX
                                              , NAME_TITLE
                                              , NAME_MIDDLE
                                             )
                                      VALUES (
                                                cs_tpp_id                                                     -- TIU_PRACT_PART_ID	
--                                              , clinical_document_seq_id_val                                     -- CLINICAL_DOCUMENT_ID	
--                                              , 'CMS'                                                         -- DISCRIMINATOR	
                                              , 'chartMarkedSigned_id_' || to_char(round(dbms_random.value(1,1000)))-- PERSON_IDENTITY
                                              , 'visn ' || to_char(round(dbms_random.value(1,21)))            -- PERSON_ASSIGNING_FACILITY
                                              , null                                                          -- PERSON_ASSIGNING_AUTHORITY
                                              , null                                                          -- PRACTITIONER_ID_SRC_TBL	
                                              , NULL                                                          -- NAME_PREFIX	
                                              , NULL                                                          -- NAME_GIVEN	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,40)))       -- NAME_FAMILY	
                                              , NULL                                                          -- NAME_SUFFIX	
                                              , NULL                                                          -- NAME_TITLE	
                                              , NULL                                                          -- NAME_MIDDLE	
                                             );         
         END IF;

         -- load 0 or 1 tiu_pract_part (chartMarkedCosigned)
         random_num := ROUND (DBMS_RANDOM.VALUE (1, 10));
         IF random_num > 8
         THEN
                -- set tiu_pract_part_id
                SELECT tiu_pract_part_seq_id.nextval
                INTO cc_tpp_id
                FROM dual;
                -- Insert into tiu_pract_part_v
                INSERT INTO TIU_PRACT_PART_V (
                                                TIU_PRACT_PART_ID
--                                              , CLINICAL_DOCUMENT_ID
--                                              , DISCRIMINATOR
                                              , PERSON_IDENTITY
                                              , PERSON_ASSIGNING_FACILITY
                                              , PERSON_ASSIGNING_AUTHORITY
                                              , PRACTITIONER_ID_SRC_TBL
                                              , NAME_PREFIX
                                              , NAME_GIVEN
                                              , NAME_FAMILY
                                              , NAME_SUFFIX
                                              , NAME_TITLE
                                              , NAME_MIDDLE
                                             )
                                      VALUES (
                                                cc_tpp_id                                                     -- TIU_PRACT_PART_ID	
--                                              , clinical_document_seq_id_val                                     -- CLINICAL_DOCUMENT_ID	
--                                              , 'CMC'                                                         -- DISCRIMINATOR	
                                              , 'chartMarkedCosigned_id_' || to_char(round(dbms_random.value(1,1000)))-- PERSON_IDENTITY
                                              , 'visn ' || to_char(round(dbms_random.value(1,21)))            -- PERSON_ASSIGNING_FACILITY
                                              , null                                                          -- PERSON_ASSIGNING_AUTHORITY
                                              , null                                                          -- PRACTITIONER_ID_SRC_TBL	
                                              , NULL                                                          -- NAME_PREFIX	
                                              , NULL                                                          -- NAME_GIVEN	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,40)))       -- NAME_FAMILY	
                                              , NULL                                                          -- NAME_SUFFIX	
                                              , NULL                                                          -- NAME_TITLE	
                                              , NULL                                                          -- NAME_MIDDLE	
                                             );         
         END IF;

         -- load 0 or 1 tiu_pract_part (expectedSigner)
         random_num := ROUND (DBMS_RANDOM.VALUE (1, 10));
         IF random_num > 8
         THEN
                -- set tiu_pract_part_id
                SELECT tiu_pract_part_seq_id.nextval
                INTO es_tpp_id
                FROM dual;
                -- Insert into tiu_pract_part_v
                INSERT INTO TIU_PRACT_PART_V (
                                                TIU_PRACT_PART_ID
--                                              , CLINICAL_DOCUMENT_ID
--                                              , DISCRIMINATOR
                                              , PERSON_IDENTITY
                                              , PERSON_ASSIGNING_FACILITY
                                              , PERSON_ASSIGNING_AUTHORITY
                                              , PRACTITIONER_ID_SRC_TBL
                                              , NAME_PREFIX
                                              , NAME_GIVEN
                                              , NAME_FAMILY
                                              , NAME_SUFFIX
                                              , NAME_TITLE
                                              , NAME_MIDDLE
                                             )
                                      VALUES (
                                                es_tpp_id                                                     -- TIU_PRACT_PART_ID	
--                                              , clinical_document_seq_id_val                                     -- CLINICAL_DOCUMENT_ID	
--                                              , 'ESR'                                                         -- DISCRIMINATOR	
                                              , 'expectedSigner_id_' || to_char(round(dbms_random.value(1,1000)))-- PERSON_IDENTITY
                                              , 'visn ' || to_char(round(dbms_random.value(1,21)))            -- PERSON_ASSIGNING_FACILITY
                                              , null                                                          -- PERSON_ASSIGNING_AUTHORITY
                                              , null                                                          -- PRACTITIONER_ID_SRC_TBL	
                                              , NULL                                                          -- NAME_PREFIX	
                                              , NULL                                                          -- NAME_GIVEN	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,40)))       -- NAME_FAMILY	
                                              , NULL                                                          -- NAME_SUFFIX	
                                              , NULL                                                          -- NAME_TITLE	
                                              , NULL                                                          -- NAME_MIDDLE	
                                             );         
         END IF;

         -- load 0 or 1 tiu_pract_part (signer)
         random_num := ROUND (DBMS_RANDOM.VALUE (1, 10));
         IF random_num > 3
         THEN
                -- set tiu_pract_part_id
                SELECT tiu_pract_part_seq_id.nextval
                INTO sg_tpp_id
                FROM dual;
                -- Insert into tiu_pract_part_v
                INSERT INTO TIU_PRACT_PART_V (
                                                TIU_PRACT_PART_ID
--                                              , CLINICAL_DOCUMENT_ID
--                                              , DISCRIMINATOR
                                              , PERSON_IDENTITY
                                              , PERSON_ASSIGNING_FACILITY
                                              , PERSON_ASSIGNING_AUTHORITY
                                              , PRACTITIONER_ID_SRC_TBL
                                              , NAME_PREFIX
                                              , NAME_GIVEN
                                              , NAME_FAMILY
                                              , NAME_SUFFIX
                                              , NAME_TITLE
                                              , NAME_MIDDLE
                                              , PARTICIPATION_TYPE
                                              , PARTICIPATION_DT
                                              , PARTICIPATION_DT_NBR
                                              , SIGNATURE_BLOCK_NM
                                              , SIGNATURE_BLOCK_TITLE
                                              , SIGNATURE_MODE_CODE
                                              , SIGNATURE_MODE_DSPLYTXT
                                              , SIGNATURE_MODE_CODSYS
                                             )
                                      VALUES (
                                                sg_tpp_id                                                     -- TIU_PRACT_PART_ID	
--                                              , clinical_document_seq_id_val                                     -- CLINICAL_DOCUMENT_ID	
--                                              , 'SGR'                                                         -- DISCRIMINATOR	
                                              , 'Signer_id_' || to_char(round(dbms_random.value(1,1000)))     -- PERSON_IDENTITY
                                              , 'visn ' || to_char(round(dbms_random.value(1,21)))            -- PERSON_ASSIGNING_FACILITY
                                              , null                                                          -- PERSON_ASSIGNING_AUTHORITY
                                              , null                                                          -- PRACTITIONER_ID_SRC_TBL	
                                              , NULL                                                          -- NAME_PREFIX	
                                              , NULL                                                          -- NAME_GIVEN	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,40)))       -- NAME_FAMILY	
                                              , NULL                                                          -- NAME_SUFFIX	
                                              , NULL                                                          -- NAME_TITLE	
                                              , NULL                                                          -- NAME_MIDDLE	
                                              , DBMS_RANDOM.STRING('U',TRUNC(DBMS_RANDOM.VALUE(3,5)))         -- PARTICIPATION_TYPE
                                              , archive_date                                                  -- PARTICIPATION_DT	
                                              , (TO_NUMBER(archive_date,'99999999999999')-17000000000000)/1000000                      -- PARTICIPATION_DT_NBR	
                                              , 'Michael'                                                     -- SIGNATURE_BLOCK_NM	
                                              , 'Sir'                                                         -- SIGNATURE_BLOCK_TITLE	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,100)))      -- SIGNATURE_MODE_CODE	
                                              , ROUND(DBMS_RANDOM.VALUE (1,99999999))                         -- SIGNATURE_MODE_DSPLYTXT	
                                              , NULL                                                          -- SIGNATURE_MODE_CODSYS	
                                             );         
         END IF;

         -- load 0 or 1 tiu_pract_part (expectedCosigner)
         random_num := ROUND (DBMS_RANDOM.VALUE (1, 10));
         IF random_num > 8
         THEN
                -- set tiu_pract_part_id
                SELECT tiu_pract_part_seq_id.nextval
                INTO ec_tpp_id
                FROM dual;
                -- Insert into tiu_pract_part_v
                INSERT INTO TIU_PRACT_PART_V (
                                                TIU_PRACT_PART_ID
--                                              , CLINICAL_DOCUMENT_ID
--                                              , DISCRIMINATOR
                                              , PERSON_IDENTITY
                                              , PERSON_ASSIGNING_FACILITY
                                              , PERSON_ASSIGNING_AUTHORITY
                                              , PRACTITIONER_ID_SRC_TBL
                                              , NAME_PREFIX
                                              , NAME_GIVEN
                                              , NAME_FAMILY
                                              , NAME_SUFFIX
                                              , NAME_TITLE
                                              , NAME_MIDDLE
                                             )
                                      VALUES (
                                                ec_tpp_id                                                     -- TIU_PRACT_PART_ID	
--                                              , clinical_document_seq_id_val                                     -- CLINICAL_DOCUMENT_ID	
--                                              , 'ECR'                                                         -- DISCRIMINATOR	
                                              , 'expectedCosigner_id_' || to_char(round(dbms_random.value(1,1000)))-- PERSON_IDENTITY
                                              , 'visn ' || to_char(round(dbms_random.value(1,21)))            -- PERSON_ASSIGNING_FACILITY
                                              , null                                                          -- PERSON_ASSIGNING_AUTHORITY
                                              , null                                                          -- PRACTITIONER_ID_SRC_TBL	
                                              , NULL                                                          -- NAME_PREFIX	
                                              , NULL                                                          -- NAME_GIVEN	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,40)))       -- NAME_FAMILY	
                                              , NULL                                                          -- NAME_SUFFIX	
                                              , NULL                                                          -- NAME_TITLE	
                                              , NULL                                                          -- NAME_MIDDLE	
                                             );         
         END IF;

         -- load 0 or 1 tiu_pract_part (cosigner)
         random_num := ROUND (DBMS_RANDOM.VALUE (1, 10));
         IF random_num > 5
         THEN
                -- set tiu_pract_part_id
                SELECT tiu_pract_part_seq_id.nextval
                INTO cg_tpp_id
                FROM dual;
                -- Insert into tiu_pract_part_v
                INSERT INTO TIU_PRACT_PART_V (
                                                TIU_PRACT_PART_ID
--                                              , CLINICAL_DOCUMENT_ID
--                                              , DISCRIMINATOR
                                              , PERSON_IDENTITY
                                              , PERSON_ASSIGNING_FACILITY
                                              , PERSON_ASSIGNING_AUTHORITY
                                              , PRACTITIONER_ID_SRC_TBL
                                              , NAME_PREFIX
                                              , NAME_GIVEN
                                              , NAME_FAMILY
                                              , NAME_SUFFIX
                                              , NAME_TITLE
                                              , NAME_MIDDLE
                                              , PARTICIPATION_TYPE
                                              , PARTICIPATION_DT
                                              , PARTICIPATION_DT_NBR
                                              , SIGNATURE_BLOCK_NM
                                              , SIGNATURE_BLOCK_TITLE
                                              , SIGNATURE_MODE_CODE
                                              , SIGNATURE_MODE_DSPLYTXT
                                              , SIGNATURE_MODE_CODSYS
                                             )
                                      VALUES (
                                                cg_tpp_id                                                     -- TIU_PRACT_PART_ID	
--                                              , clinical_document_seq_id_val                                     -- CLINICAL_DOCUMENT_ID	
--                                              , 'CSR'                                                         -- DISCRIMINATOR	
                                              , 'cosigner_id_' || to_char(round(dbms_random.value(1,1000)))-- PERSON_IDENTITY
                                              , 'visn ' || to_char(round(dbms_random.value(1,21)))            -- PERSON_ASSIGNING_FACILITY
                                              , null                                                          -- PERSON_ASSIGNING_AUTHORITY
                                              , null                                                          -- PRACTITIONER_ID_SRC_TBL	
                                              , NULL                                                          -- NAME_PREFIX	
                                              , NULL                                                          -- NAME_GIVEN	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,40)))       -- NAME_FAMILY	
                                              , NULL                                                          -- NAME_SUFFIX	
                                              , NULL                                                          -- NAME_TITLE	
                                              , NULL                                                          -- NAME_MIDDLE	
                                              , DBMS_RANDOM.STRING('U',TRUNC(DBMS_RANDOM.VALUE(3,5)))         -- PARTICIPATION_TYPE
                                              , value_date                                                  -- PARTICIPATION_DT	
                                              , (TO_NUMBER(value_date,'99999999999999')-17000000000000)/1000000                      -- PARTICIPATION_DT_NBR	
                                              , 'Laury'                                                     -- SIGNATURE_BLOCK_NM	
                                              , 'Sir'                                                         -- SIGNATURE_BLOCK_TITLE	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,100)))      -- SIGNATURE_MODE_CODE	
                                              , ROUND(DBMS_RANDOM.VALUE (1,99999999))                         -- SIGNATURE_MODE_DSPLYTXT	
                                              , NULL                                                          -- SIGNATURE_MODE_CODSYS	
                                             );         
         END IF;

         -- load 0 or 1 tiu_pract_part (adminCloser)
         random_num := ROUND (DBMS_RANDOM.VALUE (1, 10));
         IF random_num > 8
         THEN
                -- set tiu_pract_part_id
                SELECT tiu_pract_part_seq_id.nextval
                INTO ac_tpp_id
                FROM dual;
                -- Insert into tiu_pract_part_v
                INSERT INTO TIU_PRACT_PART_V (
                                                TIU_PRACT_PART_ID
--                                              , CLINICAL_DOCUMENT_ID
--                                              , DISCRIMINATOR
                                              , PERSON_IDENTITY
                                              , PERSON_ASSIGNING_FACILITY
                                              , PERSON_ASSIGNING_AUTHORITY
                                              , PRACTITIONER_ID_SRC_TBL
                                              , NAME_PREFIX
                                              , NAME_GIVEN
                                              , NAME_FAMILY
                                              , NAME_SUFFIX
                                              , NAME_TITLE
                                              , NAME_MIDDLE
                                              , PARTICIPATION_TYPE
                                              , PARTICIPATION_DT
                                              , PARTICIPATION_DT_NBR
                                              , SIGNATURE_BLOCK_NM
                                              , SIGNATURE_BLOCK_TITLE
                                              , SIGNATURE_MODE_CODE
                                              , SIGNATURE_MODE_DSPLYTXT
                                              , SIGNATURE_MODE_CODSYS
                                             )
                                      VALUES (
                                                ac_tpp_id                                                     -- TIU_PRACT_PART_ID	
--                                              , clinical_document_seq_id_val                                     -- CLINICAL_DOCUMENT_ID	
--                                              , 'ACR'                                                         -- DISCRIMINATOR	
                                              , 'adminCloser_id_' || to_char(round(dbms_random.value(1,1000)))-- PERSON_IDENTITY
                                              , 'visn ' || to_char(round(dbms_random.value(1,21)))            -- PERSON_ASSIGNING_FACILITY
                                              , null                                                          -- PERSON_ASSIGNING_AUTHORITY
                                              , null                                                          -- PRACTITIONER_ID_SRC_TBL	
                                              , NULL                                                          -- NAME_PREFIX	
                                              , NULL                                                          -- NAME_GIVEN	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,40)))       -- NAME_FAMILY	
                                              , NULL                                                          -- NAME_SUFFIX	
                                              , NULL                                                          -- NAME_TITLE	
                                              , NULL                                                          -- NAME_MIDDLE	
                                              , DBMS_RANDOM.STRING('U',TRUNC(DBMS_RANDOM.VALUE(3,5)))         -- PARTICIPATION_TYPE
                                              , proc_date                                                  -- PARTICIPATION_DT	
                                              , (TO_NUMBER(proc_date,'99999999999999')-17000000000000)/1000000                      -- PARTICIPATION_DT_NBR	
                                              , 'Steve'                                                     -- SIGNATURE_BLOCK_NM	
                                              , 'Sir'                                                         -- SIGNATURE_BLOCK_TITLE	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,100)))      -- SIGNATURE_MODE_CODE	
                                              , ROUND(DBMS_RANDOM.VALUE (1,99999999))                         -- SIGNATURE_MODE_DSPLYTXT	
                                              , NULL                                                          -- SIGNATURE_MODE_CODSYS	
                                             );         
         END IF;

         -- load 0 or 1 tiu_pract_part (amender)
         random_num := ROUND (DBMS_RANDOM.VALUE (1, 10));
         IF random_num > 8
         THEN
                -- set tiu_pract_part_id
                SELECT tiu_pract_part_seq_id.nextval
                INTO am_tpp_id
                FROM dual;
                -- Insert into tiu_pract_part_v
                INSERT INTO TIU_PRACT_PART_V (
                                                TIU_PRACT_PART_ID
--                                              , CLINICAL_DOCUMENT_ID
--                                              , DISCRIMINATOR
                                              , PERSON_IDENTITY
                                              , PERSON_ASSIGNING_FACILITY
                                              , PERSON_ASSIGNING_AUTHORITY
                                              , PRACTITIONER_ID_SRC_TBL
                                              , NAME_PREFIX
                                              , NAME_GIVEN
                                              , NAME_FAMILY
                                              , NAME_SUFFIX
                                              , NAME_TITLE
                                              , NAME_MIDDLE
                                              , PARTICIPATION_TYPE
                                              , PARTICIPATION_DT
                                              , PARTICIPATION_DT_NBR
                                              , SIGNATURE_BLOCK_NM
                                              , SIGNATURE_BLOCK_TITLE
                                              , SIGNATURE_MODE_CODE
                                              , SIGNATURE_MODE_DSPLYTXT
                                              , SIGNATURE_MODE_CODSYS
                                             )
                                      VALUES (
                                                am_tpp_id                                                     -- TIU_PRACT_PART_ID	
--                                              , clinical_document_seq_id_val                                     -- CLINICAL_DOCUMENT_ID	
--                                              , 'AMD'                                                         -- DISCRIMINATOR	
                                              , 'amender_id_' || to_char(round(dbms_random.value(1,1000)))-- PERSON_IDENTITY
                                              , 'visn ' || to_char(round(dbms_random.value(1,21)))            -- PERSON_ASSIGNING_FACILITY
                                              , null                                                          -- PERSON_ASSIGNING_AUTHORITY
                                              , null                                                          -- PRACTITIONER_ID_SRC_TBL	
                                              , NULL                                                          -- NAME_PREFIX	
                                              , NULL                                                          -- NAME_GIVEN	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,40)))       -- NAME_FAMILY	
                                              , NULL                                                          -- NAME_SUFFIX	
                                              , NULL                                                          -- NAME_TITLE	
                                              , NULL                                                          -- NAME_MIDDLE	
                                              , DBMS_RANDOM.STRING('U',TRUNC(DBMS_RANDOM.VALUE(3,5)))         -- PARTICIPATION_TYPE
                                              , del_date                                                  -- PARTICIPATION_DT	
                                              , (TO_NUMBER(del_date,'99999999999999')-17000000000000)/1000000                      -- PARTICIPATION_DT_NBR	
                                              , 'Joey'                                                     -- SIGNATURE_BLOCK_NM	
                                              , 'Sir'                                                         -- SIGNATURE_BLOCK_TITLE	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,100)))      -- SIGNATURE_MODE_CODE	
                                              , ROUND(DBMS_RANDOM.VALUE (1,99999999))                         -- SIGNATURE_MODE_DSPLYTXT	
                                              , NULL                                                          -- SIGNATURE_MODE_CODSYS	
                                             );         
         END IF;

         -- load 0 or 1 tiu_pract_part (retractor)
         random_num := ROUND (DBMS_RANDOM.VALUE (1, 10));
         IF random_num > 8
         THEN
                -- set tiu_pract_part_id
                SELECT tiu_pract_part_seq_id.nextval
                INTO rt_tpp_id
                FROM dual;
                -- Insert into tiu_pract_part_v
                INSERT INTO TIU_PRACT_PART_V (
                                                TIU_PRACT_PART_ID
--                                              , CLINICAL_DOCUMENT_ID
--                                              , DISCRIMINATOR
                                              , PERSON_IDENTITY
                                              , PERSON_ASSIGNING_FACILITY
                                              , PERSON_ASSIGNING_AUTHORITY
                                              , PRACTITIONER_ID_SRC_TBL
                                              , NAME_PREFIX
                                              , NAME_GIVEN
                                              , NAME_FAMILY
                                              , NAME_SUFFIX
                                              , NAME_TITLE
                                              , NAME_MIDDLE
                                             )
                                      VALUES (
                                                rt_tpp_id                                                     -- TIU_PRACT_PART_ID	
--                                              , clinical_document_seq_id_val                                  -- CLINICAL_DOCUMENT_ID	
--                                              , 'RTR'                                                         -- DISCRIMINATOR	
                                              , 'retractor_id_' || to_char(round(dbms_random.value(1,1000)))  -- PERSON_IDENTITY
                                              , 'visn ' || to_char(round(dbms_random.value(1,21)))            -- PERSON_ASSIGNING_FACILITY
                                              , null                                                          -- PERSON_ASSIGNING_AUTHORITY
                                              , null                                                          -- PRACTITIONER_ID_SRC_TBL	
                                              , NULL                                                          -- NAME_PREFIX	
                                              , NULL                                                          -- NAME_GIVEN	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,40)))       -- NAME_FAMILY	
                                              , NULL                                                          -- NAME_SUFFIX	
                                              , NULL                                                          -- NAME_TITLE	
                                              , NULL                                                          -- NAME_MIDDLE	
                                             );         
         END IF;

         -- load clinical document        
         INSERT INTO CLINICAL_DOCUMENT_V
                     (    
                       CLINICAL_DOCUMENT_ID
                     , TIU_PATIENT_VISIT_ID
                     , REQUEST_ID
                     , RECORDIDENTIFIER_IDENTITY
                     , RECORDIDENTIFIER_NAMESPACEID
                     , RECORDIDENTIFIER_UNIVERSALID
                     , RECORDIDENTIFIER_UNIVERSTYP
                     , PATIENT_IDENTITY
                     , PATIENT_ASSIGNING_FACILITY
                     , PATIENT_ASSIGNING_AUTHORITY
                     , DATAENTERER_TPP_ID
                     , AUTHOR_TPP_ID     
                     , CHARTMARKEDSIGNED_TPP_ID 
                     , CHARTMARKEDCOSIGNED_TPP_ID
                     , EXPECTEDSIGNER_TPP_ID    
                     , SIGNER_TPP_ID           
                     , EXPECTEDCOSIGNER_TPP_ID 
                     , COSIGNER_TPP_ID         
                     , ADMINCLOSER_TPP_ID      
                     , AMENDER_TPP_ID          
                     , RETRACTOR_TPP_ID        
                     , PATIENT_NAME_PREFIX
                     , PATIENT_NAME_GIVEN
                     , PATIENT_NAME_FAMILY
                     , PATIENT_NAME_SUFFIX
                     , PATIENT_NAME_TITLE
                     , PATIENT_NAME_MIDDLE
                     , REFERENCE_DT
                     , REFERENCE_DT_NBR
                     , PARENTIDENTIFIER_IDENTITY
                     , PARENTIDENTIFIER_NAMESPACEID
                     , PARENTIDENTIFIER_UNIVERSALID
                     , PARENTIDENTIFIER_UNIVERSTYP
                     , STANDARD_DOC_TITLE_CODE
                     , STANDARD_DOC_TITLE_DSPLYTXT
                     , STANDARD_DOC_TITLE_CODSYS
                     , DOCUMENT_TITLE
                     , DOCUMENT_SUBJECT
                     , DOCUMENT_CONTENT
                     , STATUS_CODE
                     , STATUS_DSPLYTXT
                     , STATUS_CODSYS
                     , ENTERED_DT
                     , ENTERED_DT_NBR
                     , AMENDMENT_DT
                     , AMENDMENT_DT_NBR
                     , DICTATION_DT
                     , DICTATION_DT_NBR
                     , PATIENT_MVMNT_DT
                     , PATIENT_MVMNT_DT_NBR
                     , ARCHIVE_DT
                     , ARCHIVE_DT_NBR
                     , PROCEDURE_DT
                     , PROCEDURE_DT_NBR
                     , PROCEDURE_SUMMARY_CODE
                     , PROCEDURE_SUMMARY_DSPLYTXT
                     , PROCEDURE_SUMMARY_CODSYS
                     , TREATING_SPCLTY_CODE
                     , TREATING_SPCLTY_DSPLYTXT
                     , TREATING_SPCLTY_CODSYS
                     , SERVICE_CODE
                     , SERVICE_DSPLYTXT
                     , SERVICE_CODSYS
                     , COSIGN_NEEDED_CODE
                     , COSIGN_NEEDED_DSPLYTXT
                     , COSIGN_NEEDED_CODSYS
                     , TRMNT_EPISODE_BEGIN_DT
                     , TRMNT_EPISODE_BEGIN_DT_NBR
                     , TRMNT_EPISODE_END_DT
                     , TRMNT_EPISODE_END_DT_NBR
                     , RETRACTION_REASON_CODE
                     , RETRACTION_REASON_DSPLYTXT
                     , RETRACTION_REASON_CODSYS
                     , RETRACTION_DT
                     , RETRACTION_DT_NBR
                     , RTCRORGIDENTIFIER_IDENTITY
                     , RTCRORGIDENTIFIER_NAMESPACEID
                     , RTCRORGIDENTIFIER_UNIVERSALID
                     , RTCRORGIDENTIFIER_UNIVERSTYP
                     , RECORD_VERSION
                     , RECORD_UPDATE_TM
                     , RECORD_UPDATE_TM_NBR
                     )
              VALUES (  
                        clinical_document_seq_id_val                                                -- CLINICAL_DOCUMENT_ID
                      , tiu_patient_visit_seq_id.CURRVAL                                            -- TIU_PATIENT_VISIT_ID
                      , NULL                                                                        -- REQUEST_ID
                      , 'VISN'||ROUND(DBMS_RANDOM.VALUE(1, 21))||'_'||ROUND(DBMS_RANDOM.VALUE(1,99999999))||'.'||clinical_document_seq_id_val -- RECORDIDENTIFIER_IDENTITY	
                      , 'VISN'||ROUND(DBMS_RANDOM.VALUE(1, 21))||'_'||ROUND(DBMS_RANDOM.VALUE(1,99999999))||'.'||clinical_document_seq_id_val -- RECORDIDENTIFIER_NAMESPACEID	
                      , 'VISN'||ROUND(DBMS_RANDOM.VALUE(1, 21))||'_'||ROUND(DBMS_RANDOM.VALUE(1,99999999))||'.'||clinical_document_seq_id_val -- RECORDIDENTIFIER_UNIVERSALID	
                      , 'VISN'||ROUND(DBMS_RANDOM.VALUE(1, 21))||'_'||ROUND(DBMS_RANDOM.VALUE(1,99999999))||'.'||clinical_document_seq_id_val -- RECORDIDENTIFIER_UNIVERSTYP	
                      , v_vpid                                                                      -- PATIENT_IDENTITY
                      , 'VA.GOV-605'                                                                -- PATIENT_ASSIGNING_FACILITY
                      , 'USVHA'                                                                     -- PATIENT_ASSIGNING_AUTHORITY
                      , de_tpp_id
                      , au_tpp_id
                      , cs_tpp_id
                      , cc_tpp_id
                      , es_tpp_id
                      , sg_tpp_id
                      , ec_tpp_id
                      , cg_tpp_id
                      , ac_tpp_id
                      , am_tpp_id
                      , rt_tpp_id
                      , NULL                                                        -- PREFIX_NM	
                      , NULL                                                        -- GIVEN_NM	
                      , dbms_random.string ('U',trunc(dbms_random.value(8,30)))     -- FAMILY_NM	
                      , NULL                                                        -- SUFFIX_NM	
                      , NULL                                                        -- TITLE_NM	
                      , NULL                                                        -- MIDDLE_NM	
                      , reference_date                                             -- REFERENCE_DT	
                      , (to_number(reference_date,'99999999999999')-17000000000000)/1000000                 -- REFERENCE_DT_NBR	
                      , 'VISN'||ROUND(DBMS_RANDOM.VALUE(1, 21))||'_'||ROUND(DBMS_RANDOM.VALUE(1,99999999))||'.'||clinical_document_seq_id_val -- PARENTIDENTIFIER_IDENTITY	
                      , 'VISN'||ROUND(DBMS_RANDOM.VALUE(1, 21))||'_'||ROUND(DBMS_RANDOM.VALUE(1,99999999))||'.'||clinical_document_seq_id_val -- PARENTIDENTIFIER_NAMESPACEID	
                      , 'VISN'||ROUND(DBMS_RANDOM.VALUE(1, 21))||'_'||ROUND(DBMS_RANDOM.VALUE(1,99999999))||'.'||clinical_document_seq_id_val -- PARENTIDENTIFIER_UNIVERSALID	
                      , 'VISN'||ROUND(DBMS_RANDOM.VALUE(1, 21))||'_'||ROUND(DBMS_RANDOM.VALUE(1,99999999))||'.'||clinical_document_seq_id_val -- PARENTIDENTIFIER_UNIVERSTYP	
                      , ROUND(DBMS_RANDOM.VALUE (1598,6548))                        -- STANDARD_DOC_TITLE_CODE
                      , dbms_random.string ('U',trunc(dbms_random.value(1,100)))    -- STANDARD_DOC_TITLE_DSPLYTXT
                      , NULL                                                        -- STANDARD_DOC_TITLE_CODSYS
                      , dbms_random.string ('U',trunc(dbms_random.value(1,100)))    -- DOCUMENT_TITLE
                      , dbms_random.string ('U',trunc(dbms_random.value(1,100)))    -- DOCUMENT_SUBJECT
                      , dbms_random.string ('U',trunc(dbms_random.value(1,100)))    -- DOCUMENT_CONTENT
                      , ROUND(DBMS_RANDOM.VALUE (1598,6548))                        -- STATUS_CODE
                      , dbms_random.string ('U',trunc(dbms_random.value(1,50)))     -- STATUS_DSPLYTXT
                      , NULL                                                        -- STATUS_CODSYS
                      , datap_date                                                  -- entered_dt
                      , (to_number(datap_date,'99999999999999')-17000000000000)/1000000                      -- ENTERED_DT_NBR
                      , amend_date                                                  -- AMENDMENT_DT	
                      , (to_number(authp_date,'99999999999999')-17000000000000)/1000000                      -- AMENDMENT_DT_NBR	
                      , dictate_date                                                -- DICTATION_DT	
                      , (to_number(dictate_date,'99999999999999')-17000000000000)/1000000                    -- DICTATION_DT_NBR	
                      , pmvmnt_date                                                 -- PATIENT_MVMNT_DT	
                      , (to_number(pmvmnt_date,'99999999999999')-17000000000000)/1000000                     -- PATIENT_MVMNT_DT_NBR	
                      , archive_date                                                -- ARCHIVE_DT	
                      , (to_number(archive_date,'99999999999999')-17000000000000)/1000000                    -- ARCHIVE_DT_NBR	
                      , proc_date                                                   -- PROCEDURE_DT	
                      , (to_number(proc_date,'99999999999999')-17000000000000)/1000000                       -- PROCEDURE_DT_NBR	
                      , ROUND(DBMS_RANDOM.VALUE (59874,98422))                      -- PROCEDURE_SUMMARY_CODE
                      , dbms_random.string ('U',trunc(dbms_random.value(1,50)))     -- PROCEDURE_SUMMARY_DSPLYTXT
                      , null                                                        -- PROCEDURE_SUMMARY_CODSYS
                      , ROUND(DBMS_RANDOM.VALUE (63122,78877))                      -- TREATING_SPCLTY_CODE
                      , dbms_random.string ('U',trunc(dbms_random.value(1,50)))     -- TREATING_SPCLTY_DSPLYTXT
                      , null                                                        -- TREATING_SPCLTY_CODSYS
                      , ROUND(DBMS_RANDOM.VALUE (1235,6548))                        -- SERVICE_CODE
                      , dbms_random.string ('U',trunc(dbms_random.value(1,50)))     -- SERVICE_DSPLYTXT
                      , null                                                        -- SERVICE_CODSYS
                      , ROUND(DBMS_RANDOM.VALUE (589,1234))                         -- COSIGN_NEEDED_CODE
                      , dbms_random.string ('U',trunc(dbms_random.value(1,50)))     -- COSIGN_NEEDED_DSPLYTXT
                      , null                                                        -- COSIGN_NEEDED_CODSYS
                      , amend_date                                                  -- TRMNT_EPISODE_BEGIN_DT                
                      , (to_number(authp_date,'99999999999999')-17000000000000)/1000000                      -- TRMNT_EPISODE_BEGIN_DT_NBR            
                      , dictate_date                                                -- TRMNT_EPISODE_END_DT                  
                      , (to_number(dictate_date,'99999999999999')-17000000000000)/1000000                    -- TRMNT_EPISODE_END_DT_NBR              
                      , ROUND(DBMS_RANDOM.VALUE (589,1234))                         -- RETRACTION_REASON_CODE                     
                      , dbms_random.string ('U',trunc(dbms_random.value(1,50)))     -- RETRACTION_REASON_DSPLYTXT                 
                      , NULL                                                        -- RETRACTION_REASON_CODSYS                   
                      , proc_date                                                   -- RETRACTION_DT                   
                      , (to_number(proc_date,'99999999999999')-17000000000000)/1000000                       -- RETRACTION_DT_NBR               
                      , 'RTCR'||ROUND(DBMS_RANDOM.VALUE(1, 21))||'_'||ROUND(DBMS_RANDOM.VALUE(1,99999999))||'.'||clinical_document_seq_id_val -- RTCRORGIDENTIFIER_IDENTITY      
                      , 'RTCR'||ROUND(DBMS_RANDOM.VALUE(1, 21))||'_'||ROUND(DBMS_RANDOM.VALUE(1,99999999))||'.'||clinical_document_seq_id_val -- RTCRORGIDENTIFIER_NAMESPACEID   
                      , 'RTCR'||ROUND(DBMS_RANDOM.VALUE(1, 21))||'_'||ROUND(DBMS_RANDOM.VALUE(1,99999999))||'.'||clinical_document_seq_id_val -- RTCRORGIDENTIFIER_UNIVERSALID   
                      , 'RTCR'||ROUND(DBMS_RANDOM.VALUE(1, 21))||'_'||ROUND(DBMS_RANDOM.VALUE(1,99999999))||'.'||clinical_document_seq_id_val -- RTCRORGIDENTIFIER_UNIVERSTYP    
                      , 1                                                           -- RECORD_VERSION	
                      , upd_date                                                    -- RECORD_UPDATE_TM	
                      , (to_number(upd_date,'99999999999999')-17000000000000)/1000000                        -- RECORD_UPDATE_TM_NBR
                     );
 
         -- load 1 or many text entries
         FOR txt IN 1 .. ROUND (DBMS_RANDOM.VALUE (1, 4))
         LOOP

            INSERT INTO TIU_TEXT_V (
                                          CLINICAL_DOCUMENT_ID
                                        , LINE_NBR
                                        , DOCUMENT_TXT
                                       )
                               VALUES (
                                          clinical_document_seq_id_val                              -- CLINICAL_DOCUMENT_ID
                                        , txt                                                       -- line_nbr
                                        , dbms_random.string ('U',trunc(dbms_random.value(25,400))) -- DOCUMENT_TXT
                                      );	
         END LOOP;          

         -- load 0 to many IMAGE
         random_num := ROUND (dbms_random.value(1,3));
         IF random_num > 1
         THEN
           FOR image IN 1 .. ROUND (dbms_random.value (1,2))
           LOOP
            
             INSERT INTO TIU_IMAGE_V (
                                       TIU_IMAGE_ID
                                     , CLINICAL_DOCUMENT_ID
                                     , IMAGE_LINK_CODE
                                     , IMAGE_LINK_DSPLYTXT
                                     , IMAGE_LINK_CODSYS
                                    )
                             VALUES (
                                       TIU_IMAGE_SEQ_ID.NEXTVAL                                 -- TIU_IMAGE_ID
                                     , clinical_document_seq_id_val                             -- CLINICAL_DOCUMENT_ID
                                     , ROUND(DBMS_RANDOM.VALUE (354,894))                       -- IMAGE_LINK_CODE
                                     , dbms_random.string ('U',trunc(dbms_random.value(8,30)))  -- IMAGE_LINK_DSPLYTXT
                                     , NULL                                                     -- IMAGE_LINK_CODSYS
                                    );

           END Loop;
         END If;

         IF random_num > 1
         THEN
              FOR chg IN 1 .. ROUND (DBMS_RANDOM.VALUE (1, 2))
              LOOP
        

                 random_num  := DBMS_RANDOM.VALUE (-2, -20);
                 random_num2 := DBMS_RANDOM.VALUE (-5, -15);
                 random_num3 := DBMS_RANDOM.VALUE (-10, -30);
                 random_num4 := DBMS_RANDOM.VALUE (-14, -60);
                 random_num5 := DBMS_RANDOM.VALUE (-1, -5);
                 random_num6 := DBMS_RANDOM.VALUE (-1, -3);

                 SELECT TO_CHAR (fixed_date + random_num, 'yyyymmddhh24miss'),
                        TO_CHAR (fixed_date + random_num2, 'yyyymmddhh24miss'),
                        TO_CHAR (fixed_date + random_num3, 'yyyymmddhh24miss'),
                        TO_CHAR (fixed_date + random_num4, 'yyyymmddhh24miss'),
                        TO_CHAR (fixed_date + random_num5, 'yyyymmddhh24miss'),
                        TO_CHAR (fixed_date + random_num6, 'yyyymmddhh24miss')
                   INTO value_date,
                        ord_date,
                        proc_date,
                        archive_date,
                        dictate_date,
                        del_date
                   FROM DUAL;
    
                 vr_tpp_id := NULL;
                 ve_tpp_id := NULL;
                 vd_tpp_id := NULL;

                 -- load tiu_pract_part
                 random_num := ROUND (DBMS_RANDOM.VALUE (1, 3));
                 IF random_num = 1
                 THEN
                        -- set tiu_pract_part_id
                        SELECT tiu_pract_part_seq_id.nextval
                        INTO vr_tpp_id
                        FROM dual;
                        -- Insert into tiu_pract_part_v
                        INSERT INTO TIU_PRACT_PART_V (
                                                        TIU_PRACT_PART_ID
--                                                      , DOCUMENT_CHANGE_ID
--                                                      , DISCRIMINATOR
                                                      , PERSON_IDENTITY
                                                      , PERSON_ASSIGNING_FACILITY
                                                      , PERSON_ASSIGNING_AUTHORITY
                                                      , PRACTITIONER_ID_SRC_TBL
                                                      , NAME_PREFIX
                                                      , NAME_GIVEN
                                                      , NAME_FAMILY
                                                      , NAME_SUFFIX
                                                      , NAME_TITLE
                                                      , NAME_MIDDLE
                                                     )
                                              VALUES (
                                                        vr_tpp_id                                                     -- TIU_PRACT_PART_ID	
--                                                      , document_change_seq_id.currval                                     -- document_change_id	
--                                                      , 'RSR'                                                         -- DISCRIMINATOR	
                                                      , 'reassigner_id_' || to_char(round(dbms_random.value(1,1000))) -- PERSON_IDENTITY
                                                      , 'visn ' || to_char(round(dbms_random.value(1,21)))            -- PERSON_ASSIGNING_FACILITY
                                                      , null                                                          -- PERSON_ASSIGNING_AUTHORITY
                                                      , null                                                          -- PRACTITIONER_ID_SRC_TBL	
                                                      , NULL                                                          -- NAME_PREFIX	
                                                      , NULL                                                          -- NAME_GIVEN	
                                                      , dbms_random.string ('U',trunc(dbms_random.value(1,40)))       -- NAME_FAMILY	
                                                      , NULL                                                          -- NAME_SUFFIX	
                                                      , NULL                                                          -- NAME_TITLE	
                                                      , NULL                                                          -- NAME_MIDDLE	
                                                     );         
                 ELSIF random_num = 2
                 THEN
                        -- set tiu_pract_part_id
                        SELECT tiu_pract_part_seq_id.nextval
                        INTO ve_tpp_id
                        FROM dual;
                        -- Insert into tiu_pract_part_v
                        INSERT INTO TIU_PRACT_PART_V (
                                                        TIU_PRACT_PART_ID
--                                                      , DOCUMENT_CHANGE_ID
--                                                      , DISCRIMINATOR
                                                      , PERSON_IDENTITY
                                                      , PERSON_ASSIGNING_FACILITY
                                                      , PERSON_ASSIGNING_AUTHORITY
                                                      , PRACTITIONER_ID_SRC_TBL
                                                      , NAME_PREFIX
                                                      , NAME_GIVEN
                                                      , NAME_FAMILY
                                                      , NAME_SUFFIX
                                                      , NAME_TITLE
                                                      , NAME_MIDDLE
                                                     )
                                              VALUES (
                                                        ve_tpp_id                                                     -- TIU_PRACT_PART_ID	
--                                                      , document_change_seq_id.currval                                     -- document_change_id	
--                                                      , 'EDT'                                                         -- DISCRIMINATOR	
                                                      , 'editor_id_' || to_char(round(dbms_random.value(1,1000)))     -- PERSON_IDENTITY
                                                      , 'visn ' || to_char(round(dbms_random.value(1,21)))            -- PERSON_ASSIGNING_FACILITY
                                                      , null                                                          -- PERSON_ASSIGNING_AUTHORITY
                                                      , null                                                          -- PRACTITIONER_ID_SRC_TBL	
                                                      , NULL                                                          -- NAME_PREFIX	
                                                      , NULL                                                          -- NAME_GIVEN	
                                                      , dbms_random.string ('U',trunc(dbms_random.value(1,40)))       -- NAME_FAMILY	
                                                      , NULL                                                          -- NAME_SUFFIX	
                                                      , NULL                                                          -- NAME_TITLE	
                                                      , NULL                                                          -- NAME_MIDDLE	
                                                     );         
                 ELSE
                        -- set tiu_pract_part_id
                        SELECT tiu_pract_part_seq_id.nextval
                        INTO vd_tpp_id
                        FROM dual;
                        -- Insert into tiu_pract_part_v
                        INSERT INTO TIU_PRACT_PART_V (
                                                        TIU_PRACT_PART_ID
--                                                      , DOCUMENT_CHANGE_ID
--                                                      , DISCRIMINATOR
                                                      , PERSON_IDENTITY
                                                      , PERSON_ASSIGNING_FACILITY
                                                      , PERSON_ASSIGNING_AUTHORITY
                                                      , PRACTITIONER_ID_SRC_TBL
                                                      , NAME_PREFIX
                                                      , NAME_GIVEN
                                                      , NAME_FAMILY
                                                      , NAME_SUFFIX
                                                      , NAME_TITLE
                                                      , NAME_MIDDLE
                                                     )
                                              VALUES (
                                                        vd_tpp_id                                                     -- TIU_PRACT_PART_ID	
--                                                      , document_change_seq_id.currval                                     -- document_change_id	
--                                                      , 'DEL'                                                         -- DISCRIMINATOR	
                                                      , 'deleter_id_' || to_char(round(dbms_random.value(1,1000)))    -- PERSON_IDENTITY
                                                      , 'visn ' || to_char(round(dbms_random.value(1,21)))            -- PERSON_ASSIGNING_FACILITY
                                                      , null                                                          -- PERSON_ASSIGNING_AUTHORITY
                                                      , null                                                          -- PRACTITIONER_ID_SRC_TBL	
                                                      , NULL                                                          -- NAME_PREFIX	
                                                      , NULL                                                          -- NAME_GIVEN	
                                                      , dbms_random.string ('U',trunc(dbms_random.value(1,40)))       -- NAME_FAMILY	
                                                      , NULL                                                          -- NAME_SUFFIX	
                                                      , NULL                                                          -- NAME_TITLE	
                                                      , NULL                                                          -- NAME_MIDDLE	
                                                     );         
                 END IF;

                 -- load 0 or 1 tiu_pract_part (interdisciplinaryNoteMarker)
                 vi_tpp_id := NULL;

                 random_num := ROUND (DBMS_RANDOM.VALUE (1, 10));
                 IF random_num > 7
                 THEN
    
                        -- set tiu_pract_part_id
                        SELECT tiu_pract_part_seq_id.nextval
                        INTO vi_tpp_id
                        FROM dual;

                        -- Insert into tiu_pract_part_v
                        INSERT INTO TIU_PRACT_PART_V (
                                                        TIU_PRACT_PART_ID
--                                                      , DOCUMENT_CHANGE_ID
--                                                      , DISCRIMINATOR
                                                      , PERSON_IDENTITY
                                                      , PERSON_ASSIGNING_FACILITY
                                                      , PERSON_ASSIGNING_AUTHORITY
                                                      , PRACTITIONER_ID_SRC_TBL
                                                      , NAME_PREFIX
                                                      , NAME_GIVEN
                                                      , NAME_FAMILY
                                                      , NAME_SUFFIX
                                                      , NAME_TITLE
                                                      , NAME_MIDDLE
                                                     )
                                              VALUES (
                                                        vi_tpp_id                                                     -- TIU_PRACT_PART_ID	
--                                                      , document_change_seq_id.currval                                     -- document_change_id	
--                                                      , 'INM'                                                         -- DISCRIMINATOR	
                                                      , 'interdisciplinaryNoteMarker_id_' || to_char(round(dbms_random.value(1,1000)))-- PERSON_IDENTITY
                                                      , 'visn ' || to_char(round(dbms_random.value(1,21)))            -- PERSON_ASSIGNING_FACILITY
                                                      , null                                                          -- PERSON_ASSIGNING_AUTHORITY
                                                      , null                                                          -- PRACTITIONER_ID_SRC_TBL	
                                                      , NULL                                                          -- NAME_PREFIX	
                                                      , NULL                                                          -- NAME_GIVEN	
                                                      , dbms_random.string ('U',trunc(dbms_random.value(1,40)))       -- NAME_FAMILY	
                                                      , NULL                                                          -- NAME_SUFFIX	
                                                      , NULL                                                          -- NAME_TITLE	
                                                      , NULL                                                          -- NAME_MIDDLE	
                                                     );         
                 END IF;

                 -- insert into document_change
                 INSERT INTO DOCUMENT_CHANGE_V
                             (   
                                DOCUMENT_CHANGE_ID
                              , CLINICAL_DOCUMENT_ID
                              , REASSIGNER_TPP_ID             
                              , EDITOR_TPP_ID                    
                              , DELETER_TPP_ID
                              , INTERDISC_NOTE_MARKER_TPP_ID      
                              , INITIAL_PAT_NAME_PREFIX
                              , INITIAL_PAT_NAME_GIVEN
                              , INITIAL_PAT_NAME_FAMILY
                              , INITIAL_PAT_NAME_SUFFIX
                              , INITIAL_PAT_NAME_TITLE
                              , INITIAL_PAT_NAME_MIDDLE
                              , FINAL_PAT_NAME_PREFIX
                              , FINAL_PAT_NAME_GIVEN
                              , FINAL_PAT_NAME_FAMILY
                              , FINAL_PAT_NAME_SUFFIX
                              , FINAL_PAT_NAME_TITLE
                              , FINAL_PAT_NAME_MIDDLE
                              , INITIAL_VISIT_DT
                              , INITIAL_VISIT_DT_NBR
                              , FINAL_VISIT_DT
                              , FINAL_VISIT_DT_NBR
                              , INITVST_LOC_POINT_OF_CARE
                              , INITVST_LOC_ROOM
                              , INITVST_LOC_BED
                              , INITVST_LOC_FCLTY_NMSPCID
                              , INITVST_LOC_FCLTY_UNVSID
                              , INITVST_LOC_FCLTY_UNVSIDTYP
                              , INITVST_LOC_PERS_LOC_TYP
                              , INITVST_LOC_DESCRIPTION
                              , FINALVST_LOC_POINT_OF_CARE
                              , FINALVST_LOC_ROOM
                              , FINALVST_LOC_BED
                              , FINALVST_LOC_FCLTY_NMSPCID
                              , FINALVST_LOC_FCLTY_UNVSID
                              , FINALVST_LOC_FCLTY_UNVSIDTYP
                              , FINALVST_LOC_PERS_LOC_TYP
                              , FINALVST_LOC_DESCRIPTION
                              , INITIAL_VISIT_TYPE_CODE
                              , INITIAL_VISIT_TYPE_DSPLYTXT
                              , INITIAL_VISIT_TYPE_CODSYS
                              , FINAL_VISIT_TYPE_CODE
                              , FINAL_VISIT_TYPE_DSPLYTXT
                              , FINAL_VISIT_TYPE_CODSYS
                              , INITIAL_VISIT_RECORD
                              , FINAL_VISIT_RECORD
                              , REASSIGNMENT_DT
                              , REASSIGNMENT_DT_NBR
                              , EDIT_DT
                              , EDIT_DT_NBR
                              , INTERDISC_NOTE_PARENT
                              , INTERDISC_NOTE_ACT_CODE
                              , INTERDISC_NOTE_ACT_DSPLYTXT
                              , INTERDISC_NOTE_ACT_CODSYS
                              , INTERDISC_NOTE_ACT_DT
                              , INTERDISC_NOTE_ACT_DT_NBR
                              , INTERDISC_NOTE_ENTRY_STATUS
                              , DELETION_DT                         
                              , DELETION_DT_NBR 
                              , DELETION_REASON_CODE                
                              , DELETION_REASON_DSPLYTXT            
                              , DELETION_REASON_CODSYS              
                             )
                      VALUES ( 
                                document_change_seq_id.nextval                                                        -- DOCUMENT_CHANGE_ID	
                              , clinical_document_seq_id_val                                                          -- CLINICAL_DOCUMENT_ID	
                              , vr_tpp_id	
                              , ve_tpp_id	
                              , vd_tpp_id
                              , vi_tpp_id
                              , NULL                                                                                  -- initial_pat_NAME_PREFIX
                              , DBMS_RANDOM.STRING ('U',TRUNC(DBMS_RANDOM.VALUE(20,30)))                              -- initial_pat_NAME_GIVEN
                              , NULL                                                                                  -- initial_pat_NAME_FAMILY
                              , NULL                                                                                  -- initial_pat_NAME_SUFFIX
                              , NULL                                                                                  -- initial_pat_NAME_TITLE
                              , NULL                                                                                  -- initial_pat_NAME_MIDDLE
                              , NULL                                                                                  -- final_pat_NAME_PREFIX
                              , DBMS_RANDOM.STRING ('U',TRUNC(DBMS_RANDOM.VALUE(20,30)))                              -- final_pat_NAME_GIVEN
                              , NULL                                                                                  -- final_pat_NAME_FAMILY
                              , NULL                                                                                  -- final_pat_NAME_SUFFIX
                              , NULL                                                                                  -- final_pat_NAME_TITLE
                              , NULL                                                                                  -- final_pat_NAME_MIDDLE
                              , value_date                                                                            -- INITIAL_VISIT_DT	
                              , (TO_NUMBER(value_date,'99999999999999')-17000000000000)/1000000                                                -- INITIAL_VISIT_DT_NBR	
                              , ord_date                                                                              -- FINAL_VISIT_DT	
                              , (TO_NUMBER(ord_date,'99999999999999')-17000000000000)/1000000                                                  -- FINAL_VISIT_DT_NBR	
                              , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                               -- inivst_LOC_POINT_OF_CARE
                              , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                               -- inivst_LOC_ROOM
                              , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                               -- inivst_LOC_BED
                              , hosploc_cd_d                                                                          -- inivst_LOC_FCLTY_NMSPCID
                              , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                               -- inivst_LOC_FCLTY_UNVSID
                              , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                               -- inivst_LOC_FCLTY_UNVSIDTYP
                              , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                               -- inivst_LOC_PERS_LOC_TYP
                              , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                               -- inivst_LOC_DESCRIPTION
                              , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                               -- finalvst_LOC_POINT_OF_CARE
                              , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                               -- finalvst_LOC_ROOM
                              , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                               -- finalvst_LOC_BED
                              , hosploc_cd_d                                                                          -- finalvst_LOC_FCLTY_NMSPCID
                              , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                               -- finalvst_LOC_FCLTY_UNVSID
                              , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                               -- finalvst_LOC_FCLTY_UNVSIDTYP
                              , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                               -- finalvst_LOC_PERS_LOC_TYP
                              , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                               -- finalvst_LOC_DESCRIPTION
                              , ROUND(DBMS_RANDOM.VALUE (34812,84975))                                                -- initial_visit_type_code
                              , dbms_random.string ('U',trunc(dbms_random.value(5,10)))                               -- initial_visit_type_dsplytxt
                              , null                                                                                  -- initial_visit_type_codsys
                              , ROUND(DBMS_RANDOM.VALUE (84976,125987))                                               -- final_visit_type_code
                              , dbms_random.string ('U',trunc(dbms_random.value(5,10)))                               -- final_visit_type_dsplytxt
                              , null                                                                                  -- final_visit_type_codsys
                              , dbms_random.string ('U',trunc(dbms_random.value(10,100)))                             -- initial_visit_record
                              , dbms_random.string ('U',trunc(dbms_random.value(10,100)))                             -- final_visit_record
                              , proc_date                                                                             -- REASSIGNMENT_DT	
                              , (TO_NUMBER(proc_date,'99999999999999')-17000000000000)/1000000                                                 -- REASSIGNMENT_DT_NBR
                              , archive_date                                                                          -- EDIT_DT	
                              , (TO_NUMBER(archive_date,'99999999999999')-17000000000000)/1000000                                              -- EDIT_DT_NBR
                              , null                                                                                  -- INTERDISC_NOTE_PARENT
                              , ROUND(DBMS_RANDOM.VALUE (87954,213547))                                               -- INTERDISC_NOTE_ACT_CODE
                              , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                               -- INTERDISC_NOTE_ACT_DSPLYTXT
                              , null                                                                                  -- INTERDISC_NOTE_ACT_CODSYS
                              , dictate_date                                                                          -- INTERDISC_NOTE_ACT_DT
                              , (TO_NUMBER(dictate_date,'99999999999999')-17000000000000)/1000000                                              -- INTERDISC_NOTE_ACT_DT_NBR
                              , null                                                                                  -- INTERDISC_NOTE_ENTRY_STATUS
                              , del_date                                                                              -- DELETION_DT                         
                              , (TO_NUMBER(del_date,'99999999999999')-17000000000000)/1000000                                                  -- DELETION_DT_NBR 
                              , ROUND(DBMS_RANDOM.VALUE (87954,213547))                                               -- DELETION_REASON_CODE                
                              , dbms_random.string ('U',trunc(dbms_random.value(8,30)))                               -- DELETION_REASON_DSPLYTXT            
                              , NULL                                                                                  -- DELETION_REASON_CODSYS              
                             );


              END LOOP;          
         END IF;

         -- load 0 or 1 tiu_pract_part (otherExpectedCosigners)
         random_num := ROUND (DBMS_RANDOM.VALUE (1, 10));
         IF random_num > 8
         THEN
            FOR oec IN 1 .. ROUND (DBMS_RANDOM.VALUE(1, 3))
            LOOP
                -- Insert into tiu_pract_part_v
                INSERT INTO TIU_PRACT_PART_V (
                                                TIU_PRACT_PART_ID
                                              , CLINICAL_DOCUMENT_ID
                                              , DISCRIMINATOR
                                              , PERSON_IDENTITY
                                              , PERSON_ASSIGNING_FACILITY
                                              , PERSON_ASSIGNING_AUTHORITY
                                              , PRACTITIONER_ID_SRC_TBL
                                              , NAME_PREFIX
                                              , NAME_GIVEN
                                              , NAME_FAMILY
                                              , NAME_SUFFIX
                                              , NAME_TITLE
                                              , NAME_MIDDLE
                                              , PARTICIPATION_TYPE
                                              , PARTICIPATION_DT
                                              , PARTICIPATION_DT_NBR
                                              , SIGNATURE_BLOCK_NM
                                              , SIGNATURE_BLOCK_TITLE
                                              , SIGNATURE_MODE_CODE
                                              , SIGNATURE_MODE_DSPLYTXT
                                              , SIGNATURE_MODE_CODSYS
                                             )
                                      VALUES (
                                                tiu_pract_part_seq_id.nextval                                 -- TIU_PRACT_PART_ID	
                                              , clinical_document_seq_id_val                                     -- CLINICAL_DOCUMENT_ID	
                                              , 'OEC'                                                         -- DISCRIMINATOR	
                                              , 'otherExpCos_id_' || to_char(round(dbms_random.value(1,1000)))-- PERSON_IDENTITY
                                              , 'visn ' || to_char(round(dbms_random.value(1,21)))            -- PERSON_ASSIGNING_FACILITY
                                              , null                                                          -- PERSON_ASSIGNING_AUTHORITY
                                              , null                                                          -- PRACTITIONER_ID_SRC_TBL	
                                              , NULL                                                          -- NAME_PREFIX	
                                              , NULL                                                          -- NAME_GIVEN	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,40)))       -- NAME_FAMILY	
                                              , NULL                                                          -- NAME_SUFFIX	
                                              , NULL                                                          -- NAME_TITLE	
                                              , NULL                                                          -- NAME_MIDDLE	
                                              , DBMS_RANDOM.STRING('U',TRUNC(DBMS_RANDOM.VALUE(3,5)))         -- PARTICIPATION_TYPE
                                              , archive_date                                                  -- PARTICIPATION_DT	
                                              , (TO_NUMBER(archive_date,'99999999999999')-17000000000000)/1000000                      -- PARTICIPATION_DT_NBR	
                                              , 'Ed'                                                     -- SIGNATURE_BLOCK_NM	
                                              , 'Sir'                                                         -- SIGNATURE_BLOCK_TITLE	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,100)))      -- SIGNATURE_MODE_CODE	
                                              , ROUND(DBMS_RANDOM.VALUE (1,99999999))                         -- SIGNATURE_MODE_DSPLYTXT	
                                              , NULL                                                          -- SIGNATURE_MODE_CODSYS	
                                             );         
            END LOOP;
         END IF;

         -- load 0 or 1 tiu_pract_part (otherCosigners)
         random_num := ROUND (DBMS_RANDOM.VALUE (1, 10));
         IF random_num > 6
         THEN
            FOR oec IN 1 .. ROUND (DBMS_RANDOM.VALUE(1, 3))
            LOOP
                -- Insert into tiu_pract_part_v
                INSERT INTO TIU_PRACT_PART_V (
                                                TIU_PRACT_PART_ID
                                              , CLINICAL_DOCUMENT_ID
                                              , DISCRIMINATOR
                                              , PERSON_IDENTITY
                                              , PERSON_ASSIGNING_FACILITY
                                              , PERSON_ASSIGNING_AUTHORITY
                                              , PRACTITIONER_ID_SRC_TBL
                                              , NAME_PREFIX
                                              , NAME_GIVEN
                                              , NAME_FAMILY
                                              , NAME_SUFFIX
                                              , NAME_TITLE
                                              , NAME_MIDDLE
                                              , PARTICIPATION_TYPE
                                              , PARTICIPATION_DT
                                              , PARTICIPATION_DT_NBR
                                              , SIGNATURE_BLOCK_NM
                                              , SIGNATURE_BLOCK_TITLE
                                              , SIGNATURE_MODE_CODE
                                              , SIGNATURE_MODE_DSPLYTXT
                                              , SIGNATURE_MODE_CODSYS
                                             )
                                      VALUES (
                                                tiu_pract_part_seq_id.nextval                                 -- TIU_PRACT_PART_ID	
                                              , clinical_document_seq_id_val                                     -- CLINICAL_DOCUMENT_ID	
                                              , 'OCS'                                                          -- DISCRIMINATOR	
                                              , 'otherCos_id_' || to_char(round(dbms_random.value(1,1000)))   -- PERSON_IDENTITY
                                              , 'visn ' || to_char(round(dbms_random.value(1,21)))            -- PERSON_ASSIGNING_FACILITY
                                              , null                                                          -- PERSON_ASSIGNING_AUTHORITY
                                              , null                                                          -- PRACTITIONER_ID_SRC_TBL	
                                              , NULL                                                          -- NAME_PREFIX	
                                              , NULL                                                          -- NAME_GIVEN	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,40)))       -- NAME_FAMILY	
                                              , NULL                                                          -- NAME_SUFFIX	
                                              , NULL                                                          -- NAME_TITLE	
                                              , NULL                                                          -- NAME_MIDDLE	
                                              , DBMS_RANDOM.STRING('U',TRUNC(DBMS_RANDOM.VALUE(3,5)))         -- PARTICIPATION_TYPE
                                              , dictate_date                                                  -- PARTICIPATION_DT	
                                              , (TO_NUMBER(dictate_date,'99999999999999')-17000000000000)/1000000                      -- PARTICIPATION_DT_NBR	
                                              , 'Barry'                                                       -- SIGNATURE_BLOCK_NM	
                                              , 'Sir'                                                         -- SIGNATURE_BLOCK_TITLE	
                                              , dbms_random.string ('U',trunc(dbms_random.value(1,100)))      -- SIGNATURE_MODE_CODE	
                                              , ROUND(DBMS_RANDOM.VALUE (1,99999999))                         -- SIGNATURE_MODE_DSPLYTXT	
                                              , NULL                                                          -- SIGNATURE_MODE_CODSYS	
                                             );         
            END LOOP;
         END IF;


       END LOOP;
       
       COMMIT;
   END LOOP;

   DBMS_OUTPUT.put_line (' ');
   DBMS_OUTPUT.put_line (   'Lab End Time := ' || TO_CHAR (SYSDATE, 'MM/DD/YY hh:mi:ss') );
END;
/