/******************************************************************************
   NAME:       load_survey_v2.sql
   PURPOSE:    This script will create Survey static data from SQA1 so that test won't fail
   ADDITIONAL INFORMATION:

   REVISIONS:
   Ver        Date        Author           Description
   ---------  ----------  ---------------  ------------------------------------
   1.0        10/31/2017  Ajay/Craig      Initial release

******************************************************************************/

/******************************************************************************
	Delete Survey Data
******************************************************************************/

DELETE FROM Dmp_Question_Answer;
DELETE FROM Dmp_Response;
DELETE FROM Survey_Question_Answer;
DELETE FROM Survey_Response;
DELETE FROM Survey_Choice;
DELETE FROM Survey_Question;
DELETE FROM Survey_Patient;
DELETE FROM Survey WHERE nvl(Type,' ') not in 'CENSUS';
DELETE FROM Vendor;
DELETE FROM Care_Coordinator;



COMMIT;

/******************************************************************************
	Add Vendors
******************************************************************************/

SET DEFINE OFF;
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (59, '200TX', 'String', TO_TIMESTAMP('3/4/2013 12:49:55.568671 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (62, '200T1', 'AMD', TO_TIMESTAMP('3/6/2013 2:45:24.159180 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (85, '200T6', 'Viterion', TO_TIMESTAMP('5/24/2013 1:17:47.789590 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (86, '200T7', 'ViTel Net', TO_TIMESTAMP('5/24/2013 1:48:31.081241 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (87, '200T3', 'Viterion', TO_TIMESTAMP('5/24/2013 2:48:40.452468 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (88, '200T7', 'Viterion', TO_TIMESTAMP('5/24/2013 3:09:06.136481 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (146, '200T6', 'String', TO_TIMESTAMP('7/9/2013 2:49:29.609851 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (289, '200T3', 'NEW NAME', TO_TIMESTAMP('4/22/2014 12:15:38.943175 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (331, '200T3', 'NEW VENDOR', TO_TIMESTAMP('8/13/2014 1:59:31.525811 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (1, '200T5', 'Viterion', TO_TIMESTAMP('2/23/2012 11:27:01.377479 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (2, '200T2', 'AMD', TO_TIMESTAMP('2/23/2012 11:27:01.477598 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (3, '200T3', 'Carematix', TO_TIMESTAMP('2/23/2012 11:27:01.574706 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (4, '200T1', 'Health Hero', TO_TIMESTAMP('2/23/2012 11:27:01.674680 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (5, '200T4', 'ViTel Net', TO_TIMESTAMP('2/23/2012 11:27:01.771315 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (6, '200T6', 'ATI', TO_TIMESTAMP('2/23/2012 11:27:01.890883 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (7, '200T7', 'Cardiocom', TO_TIMESTAMP('2/23/2012 11:27:01.989793 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (8, '200T8', 'Authentidate', TO_TIMESTAMP('2/23/2012 11:27:02.090472 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (9, '200TX', 'Home Telehealth emulator', TO_TIMESTAMP('2/23/2012 11:27:02.196710 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (40, '200T1', 'Viterion', TO_TIMESTAMP('2/28/2013 4:26:10.989192 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (57, '200T2', 'ViTel Net', TO_TIMESTAMP('3/4/2013 11:42:56.060523 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (65, '200T1', 'ViTel Net', TO_TIMESTAMP('4/1/2013 9:56:12.149406 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (105, '200T3', 'AMD', TO_TIMESTAMP('5/28/2013 8:21:57.737195 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (226, '200T3', 'String', TO_TIMESTAMP('10/30/2013 4:23:58.322990 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (247, '200TX', 'NEW VENDOR', TO_TIMESTAMP('1/22/2014 10:19:21.633055 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (352, '200T4', 'NEW NAME', TO_TIMESTAMP('1/16/2015 8:49:53.992815 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (472, '200T1', 'Telehealth Authentidate', TO_TIMESTAMP('6/2/2016 7:19:03.389519 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (16, '200T5', 'String', TO_TIMESTAMP('2/20/2013 12:34:31.190335 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (44, '200T1', 'String', TO_TIMESTAMP('3/7/2013 12:18:59.601574 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (268, '200T2', 'NEW NAME', TO_TIMESTAMP('2/5/2014 1:21:58.436696 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (269, '200T1', 'NEW NAME', TO_TIMESTAMP('3/6/2014 1:22:46.683734 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (372, '200T6', 'ViTel Net', TO_TIMESTAMP('2/19/2015 4:12:28.513711 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (392, '200T8', 'String', TO_TIMESTAMP('2/25/2015 1:25:32.952472 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (412, '200T5', 'Telehealth Viterion', TO_TIMESTAMP('8/6/2015 7:30:59.644241 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (432, '200T5', 'NEW VENDOR', TO_TIMESTAMP('8/11/2015 1:35:15.491419 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (58, '200T3', 'ViTel Net', TO_TIMESTAMP('3/4/2013 11:45:03.128939 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (60, '200T4', 'String', TO_TIMESTAMP('3/4/2013 1:43:36.706413 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (61, '200T2', 'String', TO_TIMESTAMP('3/5/2013 9:44:24.717685 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (107, 'XYZ', TO_TIMESTAMP('7/3/2013 8:56:31.375280 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (126, '200T8', 'NEW NAME', TO_TIMESTAMP('7/8/2013 9:01:28.056489 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (206, '200T4', 'Viterion', TO_TIMESTAMP('10/30/2013 2:22:00.192200 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (248, '200T3', 'Authentidate', TO_TIMESTAMP('2/4/2014 9:56:44.313303 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (271, '200T6', 'NEW NAME', TO_TIMESTAMP('3/6/2014 4:45:53.190626 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (351, '200T8', 'ViTel Net', TO_TIMESTAMP('10/28/2014 3:43:27.434381 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (452, '200T8', 'Telehealth Viterion', TO_TIMESTAMP('11/5/2015 7:11:47.803033 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (492, '200T7', 'Telehealth Cardiocom', TO_TIMESTAMP('11/16/2016 7:43:11.010374 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (35, '200T5', 'ViTel Net', TO_TIMESTAMP('2/28/2013 12:25:20.834118 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (38, '200TX', 'ViTel Net', TO_TIMESTAMP('2/28/2013 1:10:14.577098 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (55, '200TX', 'Viterion', TO_TIMESTAMP('2/28/2013 4:07:45.098810 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (56, '200T2', 'Viterion', TO_TIMESTAMP('2/28/2013 4:08:59.458605 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (41, '200T5', 'AMD', TO_TIMESTAMP('3/4/2013 12:03:03.326053 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (42, '200TX', 'AMD', TO_TIMESTAMP('3/4/2013 12:11:18.304020 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (64, '200T4', 'AMD', TO_TIMESTAMP('3/6/2013 2:51:27.547944 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (89, '200T8', 'Viterion', TO_TIMESTAMP('5/24/2013 3:14:19.935369 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (166, '200TX', 'NEW NAME', TO_TIMESTAMP('7/12/2013 3:50:03.488734 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (186, '200T8', 'NEW VENDOR', TO_TIMESTAMP('8/13/2013 8:41:56.981573 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (270, '200T5', 'NEW NAME', TO_TIMESTAMP('3/6/2014 4:41:59.094593 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (309, '200T7', 'NEW NAME', TO_TIMESTAMP('7/8/2014 1:57:28.971871 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into VENDOR
   (VENDOR_ID, VENDOR_FACILITY, VENDOR_NAME, MESSAGE_INSERTION_TIME)
 Values
   (310, '200T7', 'String', TO_TIMESTAMP('7/8/2014 3:20:40.030661 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
COMMIT;



/******************************************************************************
	Add Surveys
******************************************************************************/


SET DEFINE OFF;
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (1, 'VR-12 ADL', '1.0', TO_TIMESTAMP('2/23/2012 11:27:02.455532 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'SURVEY');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (2, 'Patient Satisfaction', '1.0', TO_TIMESTAMP('2/23/2012 11:27:02.555698 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'SURVEY');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (3, 'VA Home Telehealth Patient Satisfaction Survey', '2.0', TO_TIMESTAMP('2/12/2013 2:02:51.136703 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'SURVEY');

Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME)
 Values
   (24, 'DMP', '1.0', TO_TIMESTAMP('2/20/2013 12:34:31.191193 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME)
 Values
   (43, 'OTHER DMP', '1.0', TO_TIMESTAMP('3/4/2013 11:27:49.097743 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME)
 Values
   (44, 'DMP title', '1.0', TO_TIMESTAMP('3/4/2013 12:43:20.868724 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (45, 'VHA DMP', '1.0', TO_TIMESTAMP('6/19/2013 1:45:07.754264 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (65, 'VHA.DMP', '1.0', TO_TIMESTAMP('6/25/2013 3:42:35.606691 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (85, 'VHA DMP TITLE TESTING LONG TITLE', '1.0', TO_TIMESTAMP('7/8/2013 9:01:28.069682 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (105, 'VHA TT DMP TITLE new', '1.0', TO_TIMESTAMP('8/8/2013 3:08:04.303737 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (125, 'VHA DMP GENERAL', '1.0', TO_TIMESTAMP('8/13/2013 8:41:57.008756 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (145, 'VHA DMP', '5.0', TO_TIMESTAMP('8/27/2013 10:42:01.573778 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (185, 'VHA TESTING TITLE DMP 3.6.0.8', '1.0', TO_TIMESTAMP('4/9/2014 1:45:39.247603 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (205, 'VHA 3.6.2.3 TT TITLE 1', '1.0', TO_TIMESTAMP('7/8/2014 8:59:19.349349 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (207, 'VHA DMP HIDU PUSH TESTING TT', '1.0', TO_TIMESTAMP('9/2/2014 7:25:24.204684 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (208, 'VHA DMP TT TESTING TITLE', '1.0', TO_TIMESTAMP('9/23/2014 8:08:04.992936 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (226, 'VHA TT DMP NON ACCEPTED', '1.0', TO_TIMESTAMP('8/13/2014 1:59:31.750477 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (246, 'VHA TT TITLE - NEW TITLE', '1.0', TO_TIMESTAMP('10/27/2014 11:18:18.852302 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (266, 'VHA DMP 3.7.2.0 SQA1 TT', '1.0', TO_TIMESTAMP('12/18/2014 10:27:17.890365 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (286, 'VHA TESTING HDR DOMAIN ONLY 3.7.2.0', '1.0', TO_TIMESTAMP('1/9/2015 10:28:10.946853 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (306, 'VHA HDR DOMAIN ONLY 3.7.2.1 TT', '1.0', TO_TIMESTAMP('1/12/2015 6:57:29.024730 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (326, 'VHA DMP GENERAL TT 3.8.0.2 SQA1', '1.0', TO_TIMESTAMP('2/19/2015 2:32:58.718727 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (346, 'VHA.DMPJP', '1.0', TO_TIMESTAMP('3/26/2015 3:44:12.901212 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (366, 'VHA.DMP TITLE', '1.0', TO_TIMESTAMP('6/24/2015 11:32:58.378468 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (386, 'VHA DMP NON ACCEPT STATUS TT 3.10.0.3 SQA1', '1.0', TO_TIMESTAMP('8/6/2015 7:30:59.739369 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (406, 'VHA NON ACCEPT STATUS TT 3.10.1.6 SQA1', '1.0', TO_TIMESTAMP('11/5/2015 7:11:47.918490 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (426, 'VHA DMP NON ACCEPT STATUS TT 3.11.0.1 SQA1', '1.0', TO_TIMESTAMP('12/7/2015 2:15:12.584979 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (446, 'VHA DMP NON ACCEPT STATUS TT 3.12.0.2 SQA1', '1.0', TO_TIMESTAMP('1/25/2016 7:36:24.376435 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (447, 'VHA DMP NON ACCEPT STATUS:COMPLETE TT 3.12.0.5', '1.0', TO_TIMESTAMP('2/16/2016 12:38:46.955604 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (448, 'VHA DMP TESTING', '1.0', TO_TIMESTAMP('7/29/2016 1:38:14.402872 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (468, 'VHA DMP NON ACCEPT STATUS:COMPLETE TT 3.14.0.12', '1.0', TO_TIMESTAMP('8/5/2016 12:59:58.325192 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (469, 'VHA DMP IJ TESTING', '1.0', TO_TIMESTAMP('8/8/2016 1:03:19.894011 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (488, 'VHA.DMP IJ TESTING', '1.0', TO_TIMESTAMP('8/15/2016 2:06:12.193811 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (508, 'VHA DMP GENERAL TT 3.12.0.13 SQA1', '1.0', TO_TIMESTAMP('8/16/2016 6:56:29.773515 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (509, 'VHA DMP NON ACCEPT STATUS:COMPLETE TT 3.14.0.13', '1.0', TO_TIMESTAMP('8/16/2016 8:12:36.875164 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (528, 'VHA DMP NON ACCEPT STATUS:COMPLETE TT 3.15.1.0', '1.0', TO_TIMESTAMP('2/10/2017 10:02:49.671523 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (548, 'VHA 3.16.0.0  TT sqa2', '1.0', TO_TIMESTAMP('3/3/2017 1:24:00.743049 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (549, 'VHA DMP NON ACCEPT STATUS: TT 3.16.0.1', '1.0', TO_TIMESTAMP('3/7/2017 8:49:04.977958 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (568, 'VHA DMP SQA Testing', '1.0', TO_TIMESTAMP('5/15/2017 2:19:56.556883 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (588, 'VHA DMP DELAYED STATUS: TT 3.18.0.3', '1.0', TO_TIMESTAMP('8/29/2017 9:12:05.171766 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
Insert into SURVEY
   (SURVEY_ID, TITLE, VERSION, MESSAGE_INSERTION_TIME, TYPE)
 Values
   (608, 'VHA 3.14.0.11 TT', '1.0', TO_TIMESTAMP('8/30/2017 10:44:39.517575 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'), 'DMP');
COMMIT;
COMMIT;


/******************************************************************************
	Add Survey Patients
******************************************************************************/

SET DEFINE OFF;
Insert into SURVEY_PATIENT
   (SURVEY_PATIENT_ID, ICN, FAMILY_NAME, MIDDLE_NAME, GIVEN_NAME,
    BIRTH_DATE_DT, SSN, MESSAGE_INSERTION_TIME)
 Values
   (25711, '6000000000V666666', 'IJPATIENT', 'P', 'TRINITYPT',
    TO_DATE('11/21/1942 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '999990000', TO_TIMESTAMP('4/17/2015 11:50:27.598199 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_PATIENT
   (SURVEY_PATIENT_ID, ICN, FAMILY_NAME, MIDDLE_NAME, GIVEN_NAME,
    BIRTH_DATE_DT, SSN, MESSAGE_INSERTION_TIME)
 Values
   (33198, '1234567890V123456', 'fam111', 'middle11', 'given11',
    TO_DATE('08/13/1961 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '100000011', TO_TIMESTAMP('11/15/2016 4:02:10.235948 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_PATIENT
   (SURVEY_PATIENT_ID, ICN, FAMILY_NAME, MIDDLE_NAME, GIVEN_NAME,
    BIRTH_DATE_DT, SSN, MESSAGE_INSERTION_TIME)
 Values
   (33709, '1012136799V636901', 'HDRMARCY', 'mh', 'One',
    TO_DATE('12/31/1960 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '899509001', TO_TIMESTAMP('11/16/2016 7:39:55.720702 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
COMMIT;


/******************************************************************************
	Add Care Coordinator
******************************************************************************/

SET DEFINE OFF;
Insert into CARE_COORDINATOR
   (CARE_COORDINATOR_ID, CC_IDENTIFIER, CC_FAMILY_NAME, CC_MIDDLE_NAME, CC_GIVEN_NAME,
    MESSAGE_INSERTION_TIME)
 Values
   (2, '123456', 'Coordinator', '1', 'Care',
    TO_TIMESTAMP('4/13/2012 10:51:17.417274 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into CARE_COORDINATOR
   (CARE_COORDINATOR_ID, CC_IDENTIFIER, CC_FAMILY_NAME, CC_MIDDLE_NAME, CC_GIVEN_NAME,
    MESSAGE_INSERTION_TIME)
 Values
   (22722, 'ccString', 'fString', 'mString', 'gString',
    TO_TIMESTAMP('11/15/2016 4:02:10.277291 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into CARE_COORDINATOR
   (CARE_COORDINATOR_ID, CC_IDENTIFIER, CC_FAMILY_NAME, CC_MIDDLE_NAME, CC_GIVEN_NAME,
    MESSAGE_INSERTION_TIME)
 Values
   (23234, '88888', 'HDRMHFAMcareCoO', 'Care', 'HDRMHcareCoO',
    TO_TIMESTAMP('11/16/2016 7:39:55.760959 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
COMMIT;


/******************************************************************************
	Add Survey Question
******************************************************************************/

SET DEFINE OFF;
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (1, 1, 1, 'In general, would you say your health is: Excellent  (1) Very Good (2) Good (3) Fair (4) Poor (5) ', TO_TIMESTAMP('2/23/2012 11:27:02.804912 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (2, 1, 2, 'Moderate activities, such as moving a table, pushing a vacuum cleaner, bowling, or playing golf: Yes, Limited A Lot (1) Yes, Limited A Little (2) No, Not Limited At All (3)', TO_TIMESTAMP('2/23/2012 11:27:02.909718 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (3, 1, 3, 'Climbing several flights of stairs? Yes, Limited A Lot (1) Yes, Limited A Little (2) No, Not Limited At All (3)', TO_TIMESTAMP('2/23/2012 11:27:03.014442 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (4, 1, 4, 'Accomplished less than you would like: No, none of the time (5) Yes, a little of the time (4) Yes, some of the time (3) Yes, most of the time (2) Yes, all of the time (1)', TO_TIMESTAMP('2/23/2012 11:27:03.120515 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (5, 1, 5, 'Were limited in the kind of work or other activities: No, none of the time (5) Yes, a little of the time (4) Yes, some of the time (3) Yes, most of the time (2) Yes, all of the time (1)  ', TO_TIMESTAMP('2/23/2012 11:27:03.227536 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (6, 1, 6, 'Accomplished less than you would like: No, none of the time (5) Yes, a little of the time (4) Yes, some of the time (3) Yes, most of the time (2) Yes, all of the time (1)', TO_TIMESTAMP('2/23/2012 11:27:03.330013 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (7, 1, 7, 'Didn''t do work or other activities as carefully as usual: No, none of the time (5) Yes, a little of the time (4) Yes, some of the time (3) Yes, most of the time (2) Yes, all of the time (1)  ', TO_TIMESTAMP('2/23/2012 11:27:03.434631 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (8, 1, 8, 'During the past 4 weeks, how much did pain interfere with your normal work (including both work outside the home and housework)? Not at all (1) A little bit (2) Moderately (3) Quite a bit (4) Extremely (5)', TO_TIMESTAMP('2/23/2012 11:27:03.535970 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (9, 1, 9, 'Have you felt calm and peaceful? All of the time (6) A good bit of the time (5) A little of the time (4) Most of the time (3) Some of the time (2) None of the time (1)', TO_TIMESTAMP('2/23/2012 11:27:03.636876 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (10, 1, 10, 'Did you have a lot of energy? All of the time (6) A good bit of the time (5) A little of the time (4) Most of the time (3) Some of the time (2) None of the time (1)', TO_TIMESTAMP('2/23/2012 11:27:03.738341 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (11, 1, 11, 'How much of the time during the past 4 weeks: have you felt downhearted and blue? All of the time (6) Most of the time (5) A good bit of the time (4) Some of the time (3) A little of the time (2) None of the time (1)', TO_TIMESTAMP('2/23/2012 11:27:03.843537 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (12, 1, 12, 'During the past 4 weeks, how much of the time has your physical health or emotional problems interfered with your social activities (like visiting with friends, relatives, etc.) All of the time (1) Most of the time (2) Some of the time (3) A little of the time (4) None of the time (5)', TO_TIMESTAMP('2/23/2012 11:27:03.947273 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (13, 2, 1, 'The following statement is related to your feelings about the Care Coordination staff. The staff is helpful: Strongly agree (1) Agree (2) No opinion (3) Disagree (4) Strongly disagree (5)  No Experience (6)', TO_TIMESTAMP('2/23/2012 11:27:04.215314 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (14, 2, 2, 'The following statement refers to the health care you receive from the Care Coordination program. Information given to me about my health is clear and adequate: Strongly agree (1) Agree (2) No opinion (3) Disagree (4) Strongly disagree (5)  No Experience (6)  ', TO_TIMESTAMP('2/23/2012 11:27:04.315991 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (15, 2, 3, 'Your Care Coordinator has a thorough understanding of the things that are wrong with you: Strongly agree (1) Agree (2) No opinion (3) Disagree (4) Strongly disagree (5)  No Experience (6)  ', TO_TIMESTAMP('2/23/2012 11:27:04.417728 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (16, 2, 4, 'Please rate the following aspects of the health care you received from Care Coordinators in the past 12 months. Advice the Care Coordinator gives you about ways to avoid illness and stay healthy: Excellent (1) Very Good (2) Good (3)  Fair(4)  Poor(5) Not Applicable (6)   ', TO_TIMESTAMP('2/23/2012 11:27:04.519656 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (17, 2, 5, 'How much do you agree or disagree with the following statement about the Care Coordination care you have received in the past 12 months? I would recommend this type of care to my family or friends who have chronic diseases: Strongly agree (1) Agree (2) No opinion (3) Disagree (4) Strongly disagree (5)  No Experience (6)  ', TO_TIMESTAMP('2/23/2012 11:27:04.632146 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (18, 2, 6, 'Think about the care you receive your Care Coordinator. You often have health problems that should be discussed but are not: Strongly agree (1) Agree (2) No opinion (3) Disagree (4) Strongly disagree (5)  No Experience (6)   ', TO_TIMESTAMP('2/23/2012 11:27:04.734813 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (19, 2, 7, 'The following statement refers to your Care Coordinator. It is easy to understand what the Care Coordinator is talking about: Strongly agree (1) Agree (2) No opinion (3) Disagree (4) Strongly disagree (5)  No Experience (6)  ', TO_TIMESTAMP('2/23/2012 11:27:04.839278 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (20, 2, 8, 'The information given by the Care Coordinator about my medical problems helps me to adjust to my condition: Strongly agree (1) Agree (2) No opinion (3) Disagree (4) Strongly disagree (5)  No Experience (6)  ', TO_TIMESTAMP('2/23/2012 11:27:04.939659 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (21, 3, 1, 'My care coordinator explains things in a way that is easy to understand. Always (1) Usually (2) Sometimes (3) Never (4) No Experience (5) ', TO_TIMESTAMP('2/12/2013 2:02:51.330775 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (22, 3, 2, 'The information provided by my care coordinator has helped me manage my health problem(s). Strongly Agree (1) Agree (2) Disagree (3) Strongly Disagree (4) No Experience (5) ', TO_TIMESTAMP('2/12/2013 2:02:51.444645 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (23, 3, 3, 'Over the past 3 months, my home telehealth equipment works: Always (1) Usually (2) Sometimes (3) Never (4) No Experience (5) ', TO_TIMESTAMP('2/12/2013 2:02:51.500485 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (24, 3, 4, 'My home telehealth equipment is easy to use. Strongly Agree (1) Agree (2) Disagree (3) Strongly Disagree (4) No Experience (5) ', TO_TIMESTAMP('2/12/2013 2:02:51.555858 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (25, 3, 5, 'I have made changes in the way I take care of myself as a result of the VA home telehealth program. Strongly Agree (1) Agree (2) Disagree (3) Strongly Disagree (4) No Experience (5) ', TO_TIMESTAMP('2/12/2013 2:02:51.611003 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (26, 3, 6, 'When I have questions, I am able to contact my care coordinator during business hours. Always (1) Usually (2) Sometimes (3) Never (4) No Experience (5) ', TO_TIMESTAMP('2/12/2013 2:02:51.665253 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (27, 3, 7, 'Using the VA home telehealth program has made a positive difference in my health. Strongly Agree (1) Agree (2) Disagree (3) Strongly Disagree (4) No Experience (5) ', TO_TIMESTAMP('2/12/2013 2:02:51.721856 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION
   (SURVEY_QUESTION_ID, SURVEY_ID, QUESTION_NUMBER, QUESTION_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (28, 3, 8, 'I would recommend a home telehealth program to others. Strongly Agree (1) Agree (2) Disagree (3) Strongly Disagree (4) No Experience (5) ', TO_TIMESTAMP('2/12/2013 2:02:51.781359 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
COMMIT;



/******************************************************************************
	Add Survey Choice
******************************************************************************/

SET DEFINE OFF;
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (5, 1, 5, 'Poor', TO_TIMESTAMP('2/23/2012 11:27:05.713367 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (4, 1, 4, 'Fair', TO_TIMESTAMP('2/23/2012 11:27:05.611703 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (3, 1, 3, 'Good', TO_TIMESTAMP('2/23/2012 11:27:05.448677 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (2, 1, 2, 'Very Good', TO_TIMESTAMP('2/23/2012 11:27:05.342686 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (1, 1, 1, 'Excellent', TO_TIMESTAMP('2/23/2012 11:27:05.232680 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (8, 2, 3, 'No, Not Limited At All', TO_TIMESTAMP('2/23/2012 11:27:06.022778 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (7, 2, 2, 'Yes, Limited A Little', TO_TIMESTAMP('2/23/2012 11:27:05.923218 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (6, 2, 1, 'Yes, Limited A Lot', TO_TIMESTAMP('2/23/2012 11:27:05.818725 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (11, 3, 3, 'No, Not Limited At All', TO_TIMESTAMP('2/23/2012 11:27:06.333258 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (10, 3, 2, 'Yes, Limited A Little', TO_TIMESTAMP('2/23/2012 11:27:06.230271 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (9, 3, 1, 'Yes, Limited A Lot', TO_TIMESTAMP('2/23/2012 11:27:06.130290 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (16, 4, 5, 'Yes, all of the time', TO_TIMESTAMP('2/23/2012 11:27:06.859757 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (15, 4, 4, 'Yes, most of the time', TO_TIMESTAMP('2/23/2012 11:27:06.752803 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (14, 4, 3, 'Yes, some of the time', TO_TIMESTAMP('2/23/2012 11:27:06.646758 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (13, 4, 2, 'Yes, a little of the time', TO_TIMESTAMP('2/23/2012 11:27:06.546280 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (12, 4, 1, 'No, none of the time', TO_TIMESTAMP('2/23/2012 11:27:06.437571 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (21, 5, 5, 'Yes, all of the time', TO_TIMESTAMP('2/23/2012 11:27:07.377327 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (20, 5, 4, 'Yes, most of the time', TO_TIMESTAMP('2/23/2012 11:27:07.274584 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (19, 5, 3, 'Yes, some of the time', TO_TIMESTAMP('2/23/2012 11:27:07.169550 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (18, 5, 2, 'Yes, a little of the time', TO_TIMESTAMP('2/23/2012 11:27:07.066490 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (17, 5, 1, 'No, none of the time', TO_TIMESTAMP('2/23/2012 11:27:06.962185 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (26, 6, 5, 'No, none of the time', TO_TIMESTAMP('2/23/2012 11:27:07.884739 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (25, 6, 4, 'Yes, a little of the time', TO_TIMESTAMP('2/23/2012 11:27:07.782385 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (24, 6, 3, 'Yes, some of the time', TO_TIMESTAMP('2/23/2012 11:27:07.679885 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (23, 6, 2, 'Yes, most of the time', TO_TIMESTAMP('2/23/2012 11:27:07.578568 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (22, 6, 1, 'Yes, all of the time', TO_TIMESTAMP('2/23/2012 11:27:07.479666 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (31, 7, 5, 'No, none of the time', TO_TIMESTAMP('2/23/2012 11:27:08.397385 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (30, 7, 4, 'Yes, a little of the time', TO_TIMESTAMP('2/23/2012 11:27:08.295410 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (29, 7, 3, 'Yes, some of the time', TO_TIMESTAMP('2/23/2012 11:27:08.191488 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (28, 7, 2, 'Yes, most of the time', TO_TIMESTAMP('2/23/2012 11:27:08.088649 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (27, 7, 1, 'Yes, all of the time', TO_TIMESTAMP('2/23/2012 11:27:07.986967 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (36, 8, 5, 'Extremely', TO_TIMESTAMP('2/23/2012 11:27:08.908490 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (35, 8, 4, 'Quite a bit', TO_TIMESTAMP('2/23/2012 11:27:08.806657 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (34, 8, 3, 'Moderately', TO_TIMESTAMP('2/23/2012 11:27:08.705334 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (33, 8, 2, 'A little bit', TO_TIMESTAMP('2/23/2012 11:27:08.604676 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (32, 8, 1, 'Not at all', TO_TIMESTAMP('2/23/2012 11:27:08.504382 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (42, 9, 6, 'All of the time', TO_TIMESTAMP('2/23/2012 11:27:09.557084 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (41, 9, 5, 'A good bit of the time', TO_TIMESTAMP('2/23/2012 11:27:09.453130 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (40, 9, 4, 'A little of the time', TO_TIMESTAMP('2/23/2012 11:27:09.351660 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (39, 9, 3, 'Most of the time', TO_TIMESTAMP('2/23/2012 11:27:09.214702 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (38, 9, 2, 'Some of the time', TO_TIMESTAMP('2/23/2012 11:27:09.108036 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (37, 9, 1, 'None of the time', TO_TIMESTAMP('2/23/2012 11:27:09.008704 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (48, 10, 6, 'None of the time', TO_TIMESTAMP('2/23/2012 11:27:10.178801 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (47, 10, 5, 'Some of the time', TO_TIMESTAMP('2/23/2012 11:27:10.076813 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (46, 10, 4, 'Most of the time', TO_TIMESTAMP('2/23/2012 11:27:09.971853 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (45, 10, 3, 'A little of the time', TO_TIMESTAMP('2/23/2012 11:27:09.869238 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (44, 10, 2, 'A good bit of the time', TO_TIMESTAMP('2/23/2012 11:27:09.760661 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (43, 10, 1, 'All of the time', TO_TIMESTAMP('2/23/2012 11:27:09.659259 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (54, 11, 6, 'All of the time', TO_TIMESTAMP('2/23/2012 11:27:10.805827 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (53, 11, 5, 'Most of the time', TO_TIMESTAMP('2/23/2012 11:27:10.699568 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (52, 11, 4, 'A good bit of the time', TO_TIMESTAMP('2/23/2012 11:27:10.596446 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (51, 11, 3, 'Some of the time', TO_TIMESTAMP('2/23/2012 11:27:10.491568 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (50, 11, 2, 'A little of the time', TO_TIMESTAMP('2/23/2012 11:27:10.384565 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (49, 11, 1, 'None of the time', TO_TIMESTAMP('2/23/2012 11:27:10.282660 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (59, 12, 5, 'None of the time', TO_TIMESTAMP('2/23/2012 11:27:11.311068 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (58, 12, 4, 'A little of the time', TO_TIMESTAMP('2/23/2012 11:27:11.210672 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (57, 12, 3, 'Some of the time', TO_TIMESTAMP('2/23/2012 11:27:11.109038 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (56, 12, 2, 'Most of the time', TO_TIMESTAMP('2/23/2012 11:27:11.006202 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME)
 Values
   (55, 12, 1, 'All of the time', TO_TIMESTAMP('2/23/2012 11:27:10.907543 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (65, 13, 6, 'No Experience', TO_TIMESTAMP('2/23/2012 11:27:13.146378 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    6);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (64, 13, 5, 'Strongly disagree', TO_TIMESTAMP('2/23/2012 11:27:13.045314 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    1);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (63, 13, 4, 'Disagree', TO_TIMESTAMP('2/23/2012 11:27:11.957009 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    2);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (62, 13, 3, 'No opinion', TO_TIMESTAMP('2/23/2012 11:27:11.855232 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    3);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (61, 13, 2, 'Agree', TO_TIMESTAMP('2/23/2012 11:27:11.747400 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    4);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (60, 13, 1, 'Strongly agree', TO_TIMESTAMP('2/23/2012 11:27:11.634305 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    5);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (71, 14, 6, 'No Experience', TO_TIMESTAMP('2/23/2012 11:27:15.497810 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    6);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (70, 14, 5, 'Strongly disagree', TO_TIMESTAMP('2/23/2012 11:27:15.395397 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    1);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (69, 14, 4, 'Disagree', TO_TIMESTAMP('2/23/2012 11:27:15.286242 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    2);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (68, 14, 3, 'No opinion', TO_TIMESTAMP('2/23/2012 11:27:15.181264 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    3);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (67, 14, 2, 'Agree', TO_TIMESTAMP('2/23/2012 11:27:14.523813 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    4);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (66, 14, 1, 'Strongly agree', TO_TIMESTAMP('2/23/2012 11:27:13.800771 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    5);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (77, 15, 6, 'No Experience', TO_TIMESTAMP('2/23/2012 11:27:16.125437 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    6);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (76, 15, 5, 'Strongly disagree', TO_TIMESTAMP('2/23/2012 11:27:16.020958 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    1);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (75, 15, 4, 'Disagree', TO_TIMESTAMP('2/23/2012 11:27:15.918506 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    2);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (74, 15, 3, 'No opinion', TO_TIMESTAMP('2/23/2012 11:27:15.816068 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    3);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (73, 15, 2, 'Agree', TO_TIMESTAMP('2/23/2012 11:27:15.706541 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    4);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (72, 15, 1, 'Strongly agree', TO_TIMESTAMP('2/23/2012 11:27:15.601747 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    5);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (83, 16, 6, 'Not Applicable', TO_TIMESTAMP('2/23/2012 11:27:16.738564 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    6);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (82, 16, 5, 'Poor', TO_TIMESTAMP('2/23/2012 11:27:16.634257 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    1);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (81, 16, 4, 'Fair', TO_TIMESTAMP('2/23/2012 11:27:16.532620 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    2);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (80, 16, 3, 'Good', TO_TIMESTAMP('2/23/2012 11:27:16.429574 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    3);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (79, 16, 2, 'Very Good', TO_TIMESTAMP('2/23/2012 11:27:16.328828 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    4);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (78, 16, 1, 'Excellent', TO_TIMESTAMP('2/23/2012 11:27:16.225931 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    5);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (89, 17, 6, 'No Experience', TO_TIMESTAMP('2/23/2012 11:27:17.360130 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    6);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (88, 17, 5, 'Strongly disagree', TO_TIMESTAMP('2/23/2012 11:27:17.258201 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    1);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (87, 17, 4, 'Disagree', TO_TIMESTAMP('2/23/2012 11:27:17.154176 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    2);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (86, 17, 3, 'No opinion', TO_TIMESTAMP('2/23/2012 11:27:17.049334 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    3);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (85, 17, 2, 'Agree', TO_TIMESTAMP('2/23/2012 11:27:16.941620 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    4);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (84, 17, 1, 'Strongly agree', TO_TIMESTAMP('2/23/2012 11:27:16.840328 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    5);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (95, 18, 6, 'No experience', TO_TIMESTAMP('2/23/2012 11:27:18.069441 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    6);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (94, 18, 5, 'Strongly disagree', TO_TIMESTAMP('2/23/2012 11:27:17.961824 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    1);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (93, 18, 4, 'Disagree', TO_TIMESTAMP('2/23/2012 11:27:17.862417 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    2);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (92, 18, 3, 'No opinion', TO_TIMESTAMP('2/23/2012 11:27:17.709549 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    3);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (91, 18, 2, 'Agree', TO_TIMESTAMP('2/23/2012 11:27:17.609952 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    4);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (90, 18, 1, 'Strongly agree', TO_TIMESTAMP('2/23/2012 11:27:17.469177 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    5);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (101, 19, 6, 'No experience', TO_TIMESTAMP('2/23/2012 11:27:18.687666 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    6);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (100, 19, 5, 'Strongly disagree', TO_TIMESTAMP('2/23/2012 11:27:18.586499 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    1);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (99, 19, 4, 'Disagree', TO_TIMESTAMP('2/23/2012 11:27:18.477607 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    2);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (98, 19, 3, 'No opinion', TO_TIMESTAMP('2/23/2012 11:27:18.375029 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    3);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (97, 19, 2, 'Agree', TO_TIMESTAMP('2/23/2012 11:27:18.273901 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    4);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (96, 19, 1, 'Strongly agree', TO_TIMESTAMP('2/23/2012 11:27:18.173778 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    5);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (107, 20, 6, 'No Experience', TO_TIMESTAMP('2/23/2012 11:27:19.302488 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    6);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (106, 20, 5, 'Strongly disagree', TO_TIMESTAMP('2/23/2012 11:27:19.201194 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    1);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (105, 20, 4, 'Disagree', TO_TIMESTAMP('2/23/2012 11:27:19.098266 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    2);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (104, 20, 3, 'No opinion', TO_TIMESTAMP('2/23/2012 11:27:18.997117 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    3);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (103, 20, 2, 'Agree', TO_TIMESTAMP('2/23/2012 11:27:18.894884 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    4);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (102, 20, 1, 'Strongly agree', TO_TIMESTAMP('2/23/2012 11:27:18.792408 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    5);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (112, 21, 5, 'No Experience', TO_TIMESTAMP('2/12/2013 2:02:52.239739 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    5);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (111, 21, 4, 'Never', TO_TIMESTAMP('2/12/2013 2:02:52.175260 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    4);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (110, 21, 3, 'Sometimes', TO_TIMESTAMP('2/12/2013 2:02:52.111802 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    3);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (109, 21, 2, 'Usually', TO_TIMESTAMP('2/12/2013 2:02:52.050625 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    2);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (108, 21, 1, 'Always', TO_TIMESTAMP('2/12/2013 2:02:51.909209 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    1);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (117, 22, 5, 'No Experience', TO_TIMESTAMP('2/12/2013 2:02:52.567707 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    5);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (116, 22, 4, 'Strongly Disagree', TO_TIMESTAMP('2/12/2013 2:02:52.502347 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    4);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (115, 22, 3, 'Disagree', TO_TIMESTAMP('2/12/2013 2:02:52.436488 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    3);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (114, 22, 2, 'Agree', TO_TIMESTAMP('2/12/2013 2:02:52.372181 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    2);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (113, 22, 1, 'Strongly Agree', TO_TIMESTAMP('2/12/2013 2:02:52.305973 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    1);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (122, 23, 5, 'No Experience', TO_TIMESTAMP('2/12/2013 2:02:52.890985 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    5);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (121, 23, 4, 'Never', TO_TIMESTAMP('2/12/2013 2:02:52.824804 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    4);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (120, 23, 3, 'Sometimes', TO_TIMESTAMP('2/12/2013 2:02:52.760733 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    3);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (119, 23, 2, 'Usually', TO_TIMESTAMP('2/12/2013 2:02:52.696250 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    2);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (118, 23, 1, 'Always', TO_TIMESTAMP('2/12/2013 2:02:52.632856 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    1);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (127, 24, 5, 'No Experience', TO_TIMESTAMP('2/12/2013 2:02:53.204118 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    5);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (126, 24, 4, 'Strongly Disagree', TO_TIMESTAMP('2/12/2013 2:02:53.147262 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    4);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (125, 24, 3, 'Disagree', TO_TIMESTAMP('2/12/2013 2:02:53.082733 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    3);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (124, 24, 2, 'Agree', TO_TIMESTAMP('2/12/2013 2:02:53.017952 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    2);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (123, 24, 1, 'Strongly Agree', TO_TIMESTAMP('2/12/2013 2:02:52.957338 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    1);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (132, 25, 5, 'No Experience', TO_TIMESTAMP('2/12/2013 2:02:53.524127 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    5);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (131, 25, 4, 'Strongly Disagree', TO_TIMESTAMP('2/12/2013 2:02:53.467424 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    4);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (130, 25, 3, 'Disagree', TO_TIMESTAMP('2/12/2013 2:02:53.399281 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    3);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (129, 25, 2, 'Agree', TO_TIMESTAMP('2/12/2013 2:02:53.334057 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    2);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (128, 25, 1, 'Strongly Agree', TO_TIMESTAMP('2/12/2013 2:02:53.267756 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    1);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (137, 26, 5, 'No Experience', TO_TIMESTAMP('2/12/2013 2:02:53.867595 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    5);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (136, 26, 4, 'Never', TO_TIMESTAMP('2/12/2013 2:02:53.802146 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    4);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (135, 26, 3, 'Sometimes', TO_TIMESTAMP('2/12/2013 2:02:53.735495 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    3);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (134, 26, 2, 'Usually', TO_TIMESTAMP('2/12/2013 2:02:53.670111 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    2);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (133, 26, 1, 'Always', TO_TIMESTAMP('2/12/2013 2:02:53.591818 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    1);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (142, 27, 5, 'No Experience', TO_TIMESTAMP('2/12/2013 2:02:54.192352 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    5);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (141, 27, 4, 'Strongly Disagree', TO_TIMESTAMP('2/12/2013 2:02:54.125375 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    4);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (140, 27, 3, 'Disagree', TO_TIMESTAMP('2/12/2013 2:02:54.059826 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    3);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (139, 27, 2, 'Agree', TO_TIMESTAMP('2/12/2013 2:02:53.994922 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    2);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (138, 27, 1, 'Strongly Agree', TO_TIMESTAMP('2/12/2013 2:02:53.933395 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    1);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (147, 28, 5, 'No Experience', TO_TIMESTAMP('2/12/2013 2:02:54.503153 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    5);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (146, 28, 4, 'Strongly Disagree', TO_TIMESTAMP('2/12/2013 2:02:54.444133 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    4);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (145, 28, 3, 'Disagree', TO_TIMESTAMP('2/12/2013 2:02:54.379664 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    3);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (144, 28, 2, 'Agree', TO_TIMESTAMP('2/12/2013 2:02:54.322775 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    2);
Insert into SURVEY_CHOICE
   (SURVEY_CHOICE_ID, SURVEY_QUESTION_ID, CHOICE_NUMBER, CHOICE_TEXT, MESSAGE_INSERTION_TIME,
    NORMALIZED_VALUE)
 Values
   (143, 28, 1, 'Strongly Agree', TO_TIMESTAMP('2/12/2013 2:02:54.257652 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'),
    1);
COMMIT;


/******************************************************************************
	Add Survey Response
******************************************************************************/

SET DEFINE OFF;
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (977033, 1, 1, 5, 25711,
    2, 'ADL20170418ds2', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('4/18/2017 11:22:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20170418-0100', 3170418, TO_TIMESTAMP('4/18/2017 9:01:50.332638 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976652, 1, 35, 5, 25711,
    2, 'ADL20161020IJ', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Ira', 'Joshi',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('10/20/2016 11:22:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20130618-0500', 3130618, TO_TIMESTAMP('10/20/2016 1:45:40.691177 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (977129, 1, 1, 5, 25711,
    2, 'ADL20170721dsA', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('7/21/2017 11:22:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20170721-0500', 3170721, TO_TIMESTAMP('7/21/2017 8:54:50.080307 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976820, 1, 1, 5, 25711,
    2, 'ADL20170203dsA', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('2/3/2017 10:22:46.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20170203-0400', 3170203, TO_TIMESTAMP('2/3/2017 2:57:02.425320 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976835, 1, 1, 5, 25711,
    2, 'ADL20170213ds', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('2/13/2017 10:22:46.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20170213-0900', 3170213, TO_TIMESTAMP('2/13/2017 12:58:37.600271 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976727, 1, 1, 5, 25711,
    2, 'ADL20161118dsQ1', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('11/18/2016 10:22:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20161118-0300', 3161118, TO_TIMESTAMP('11/18/2016 10:20:18.450546 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976819, 1, 1, 5, 25711,
    2, 'ADL20170202ds', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('2/2/2017 10:22:46.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20170202-0200', 3170202, TO_TIMESTAMP('2/2/2017 8:32:20.895972 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976601, 1, 1, 5, 25711,
    2, 'ADL20160815ds', '200T4', 'LOCALHOST', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('8/15/2016 11:22:46.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20130618-0500', 3130618, TO_TIMESTAMP('8/15/2016 11:48:22.030729 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (977149, 1, 1, 5, 25711,
    2, 'ADL20170721ds', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('7/21/2017 11:22:46.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20170721-0400', 3170721, TO_TIMESTAMP('7/21/2017 8:54:24.915297 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976677, 1, 1, 5, 25711,
    2, 'ADL20161020dsz', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('10/20/2016 11:22:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20161020-0400', 3161020, TO_TIMESTAMP('10/20/2016 3:28:01.132676 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976678, 1, 1, 5, 25711,
    2, 'ADL20161020ds', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('10/20/2016 11:22:46.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20130618-0500', 3130618, TO_TIMESTAMP('10/20/2016 3:47:41.444993 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976692, 1, 1, 5, 25711,
    2, 'ADL20161118ds', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('11/18/2016 10:22:46.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20130618-0800', 3130618, TO_TIMESTAMP('11/18/2016 12:11:34.935978 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976748, 1, 1, 5, 25711,
    2, 'ADL20170103dsQ1', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('1/3/2017 10:22:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20170103-0200', 3170103, TO_TIMESTAMP('1/3/2017 9:41:49.069292 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976749, 1, 1, 5, 25711,
    2, 'ADL20170103ds', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('1/3/2017 10:22:46.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20170103-0200', 3170103, TO_TIMESTAMP('1/3/2017 2:15:50.026093 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976840, 1, 1, 5, 25711,
    2, 'ADL20170206ds', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('2/6/2017 10:22:46.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20170206-0300', 3170206, TO_TIMESTAMP('2/6/2017 1:26:51.488847 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976880, 1, 1, 5, 25711,
    2, 'ADL20170214ds', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('2/14/2017 10:22:46.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20170214-0100', 3170214, TO_TIMESTAMP('2/14/2017 9:22:15.843524 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976919, 1, 1, 5, 25711,
    2, 'ADL20170215ds', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('2/15/2017 10:22:46.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20170215-0200', 3170215, TO_TIMESTAMP('2/15/2017 7:51:38.896657 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976920, 1, 1, 5, 25711,
    2, 'ADL20170216ds', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('2/16/2017 10:22:46.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20170216-0400', 3170216, TO_TIMESTAMP('2/16/2017 1:37:03.262674 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (977041, 1, 1, 5, 25711,
    2, 'ADL20170418ds', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('4/18/2017 11:22:46.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20170418-0100', 3170418, TO_TIMESTAMP('4/18/2017 9:02:46.631035 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976545, 1, 1, 5, 25711,
    2, 'ADL20160811ds', '200T4', 'LOCALHOST', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('8/11/2016 11:22:46.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20130618-0500', 3130618, TO_TIMESTAMP('8/11/2016 1:54:32.503565 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (977065, 1, 1, 5, 25711,
    2, 'ADL20170510ds', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('5/10/2017 11:22:46.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20170510-0600', 3170510, TO_TIMESTAMP('5/10/2017 9:26:15.808045 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976724, 1, 1, 5, 25711,
    2, 'ADL20161117ds', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('11/17/2016 10:22:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20161117-0100', 3161117, TO_TIMESTAMP('11/17/2016 12:53:53.961453 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (977206, 1, 1, 5, 25711,
    2, 'ADL20170901ds', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('9/1/2017 12:22:46.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20170901-0400', 3170901, TO_TIMESTAMP('9/1/2017 2:50:24.724362 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (977031, 1, 1, 5, 25711,
    2, 'ADL20170417IJ', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Ira', 'Joshi',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('4/17/2017 11:22:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20130618-0500', 3130618, TO_TIMESTAMP('4/17/2017 2:01:02.714390 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976995, 1, 35, 5, 25711,
    2, 'ADL20170309IJ', '200T4', 'DNS         .DNS           ', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Ira', 'Joshi',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('3/9/2017 10:22:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20130618-0500', 3130618, TO_TIMESTAMP('3/9/2017 2:27:06.434702 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY,
    PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME,
    PROGRAM_NAME, DEVICE_NAME, SURVEY_ACCEPTED_STATUS, MENTAL_SCORE, PHYSICAL_SCORE,
    ACTIVATION_DT, ENROLLMENT_DT, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976544, 1, 1, 5, 25711,
    2, 'ADL20160809ds', '200T4', 'LOCALHOST', 'DNS',
    '6000000000V666666', '613', 'USVHA', 'Debbie', 'Shaffer',
    'N', 'String', TO_DATE('08/13/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('7/1/2016 11:22:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String',
    'String', 'String', 'ACCEPTED', 0.452, 0.567,
    TO_DATE('08/13/2011 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/12/2010 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), '20160809-0500', 3160809, TO_TIMESTAMP('8/9/2016 3:39:26.408144 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN,
    PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN,
    SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME, PROGRAM_NAME, DEVICE_NAME,
    SURVEY_ACCEPTED_STATUS, DISENRMENT_DT, INACTIVATION_DT, ACTIVATION_DT, ENROLLMENT_DT,
    RECORD_CREATION_TM, MESSAGE_INSERTION_TIME)
 Values
   (976685, 2, 23, 1, 33198,
    22722, 'local-test-20161028171500-v1-1', '200T5', 'DNS         .DNS           ', 'DNS',
    '1234567890V123456', '540', 'USVHA', 'Dr', 'Veterans',
    'Patient', 'Jr', 'MD', 'Administration', 'ViterionMRN',
    TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('1/9/2013 5:36:10.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'cString', 'pString', 'dString',
    'ACCEPTED', TO_DATE('08/13/1969 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/13/1969 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/13/1969 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'),
    '20040621104503 05 00', TO_TIMESTAMP('11/15/2016 4:02:10.341039 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN,
    PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN,
    SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME, PROGRAM_NAME, DEVICE_NAME,
    SURVEY_ACCEPTED_STATUS, DISENRMENT_DT, INACTIVATION_DT, ACTIVATION_DT, ENROLLMENT_DT,
    RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976687, 2, 1, 4, 33709,
    23234, '20161116000000mh_PS1.0', '200T1', 'DNS         .DNS           ', 'DNS',
    '1012136799V636901', '402', 'USVHA', 'Dr', 'HDRMH01',
    'PatientMH01', 'Jr1', 'MD', 'MHAdmin01', 'MMH001',
    TO_DATE('07/13/2015 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('11/15/2016 5:00:00.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'hello', 'It''s me', 'checking',
    'ACCEPTED', TO_DATE('09/15/2015 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/13/2015 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/13/1990 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/16/1990 00:00:00', 'MM/DD/YYYY HH24:MI:SS'),
    '20161116000000', 3161116, TO_TIMESTAMP('11/16/2016 7:39:55.804490 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN,
    PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN,
    SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME, PROGRAM_NAME, DEVICE_NAME,
    SURVEY_ACCEPTED_STATUS, DISENRMENT_DT, INACTIVATION_DT, ACTIVATION_DT, ENROLLMENT_DT,
    RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (976739, 2, 1, 4, 33709,
    23234, '20161207000000mh_PS1.0', '200T1', 'DNS         .DNS           ', 'DNS',
    '1012136799V636901', '402', 'USVHA', 'Dr', 'HDRMH01',
    'PatientMH01', 'Jr1', 'MD', 'MHAdmin01', 'MMH001',
    TO_DATE('07/13/2015 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('12/6/2016 5:00:00.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'hello', 'It''s me', 'checking',
    'ACCEPTED', TO_DATE('09/15/2015 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/13/2015 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/13/1990 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/16/1990 00:00:00', 'MM/DD/YYYY HH24:MI:SS'),
    '20161207000000', 3161207, TO_TIMESTAMP('12/20/2016 10:16:08.668956 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_RESPONSE
   (SURVEY_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, SURVEY_PATIENT_ID,
    CARE_COORDINATOR_ID, REQUEST_ID, RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP,
    PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN,
    PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN,
    SCHEDULED_DT, COMPLETED_DT, CURRENT_DIALOG_NAME, PROGRAM_NAME, DEVICE_NAME,
    SURVEY_ACCEPTED_STATUS, DISENRMENT_DT, INACTIVATION_DT, ACTIVATION_DT, ENROLLMENT_DT,
    RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, MESSAGE_INSERTION_TIME)
 Values
   (977003, 2, 1, 4, 33709,
    23234, '20170311000000mh_PS1.0invtitle', '200T1', 'DNS         .DNS           ', 'DNS',
    '1012136799V636901', '402', 'USVHA', 'Dr', 'HDRMH01',
    'PatientMH01', 'Jr1', 'MD', 'MHAdmin01', 'MMH001',
    TO_DATE('07/13/2015 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('3/10/2017 5:00:00.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'hello', 'It''s me', 'checking',
    'ACCEPTED', TO_DATE('09/15/2015 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/13/2015 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/13/1990 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('08/16/1990 00:00:00', 'MM/DD/YYYY HH24:MI:SS'),
    '20170311000000', 3170311, TO_TIMESTAMP('3/11/2017 9:17:31.850799 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
COMMIT;


/******************************************************************************
	Add Survey Question Answer
******************************************************************************/

SET DEFINE OFF;
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12221, 977065, 1, 0, TO_TIMESTAMP('5/10/2017 9:26:15.904721 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12113, 977041, 1, 0, TO_TIMESTAMP('4/18/2017 9:02:46.689222 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12601, 977129, 1, 0, TO_TIMESTAMP('7/21/2017 8:54:50.144253 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11757, 976995, 1, 0, TO_TIMESTAMP('3/9/2017 2:27:06.496586 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11417, 976920, 1, 0, TO_TIMESTAMP('2/16/2017 1:37:03.494096 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11321, 976880, 1, 0, TO_TIMESTAMP('2/14/2017 9:22:16.026295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11041, 976820, 1, 0, TO_TIMESTAMP('2/3/2017 2:57:02.614015 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12917, 977206, 1, 0, TO_TIMESTAMP('9/1/2017 2:50:24.863294 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11297, 976835, 1, 0, TO_TIMESTAMP('2/13/2017 12:58:37.780352 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12617, 977149, 1, 0, TO_TIMESTAMP('7/21/2017 8:54:25.011563 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11065, 976840, 1, 0, TO_TIMESTAMP('2/6/2017 1:26:51.659766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10641, 976724, 1, 0, TO_TIMESTAMP('11/17/2016 12:53:54.063718 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10937, 976748, 1, 0, TO_TIMESTAMP('1/3/2017 9:41:49.206700 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12093, 977033, 1, 0, TO_TIMESTAMP('4/18/2017 9:01:50.402402 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12049, 977031, 1, 0, TO_TIMESTAMP('4/17/2017 2:01:02.793333 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11405, 976919, 1, 0, TO_TIMESTAMP('2/15/2017 7:51:39.042295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11029, 976819, 1, 0, TO_TIMESTAMP('2/2/2017 8:32:21.051792 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10969, 976749, 1, 0, TO_TIMESTAMP('1/3/2017 2:15:50.073403 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10465, 976677, 1, 0, TO_TIMESTAMP('10/20/2016 3:28:01.217393 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10013, 976601, 1, 0, TO_TIMESTAMP('8/15/2016 11:48:22.090278 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9841, 976545, 1, 0, TO_TIMESTAMP('8/11/2016 1:54:32.736999 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10593, 976692, 1, 0, TO_TIMESTAMP('11/18/2016 12:11:34.999378 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10673, 976727, 1, 0, TO_TIMESTAMP('11/18/2016 10:20:18.635765 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10477, 976678, 1, 0, TO_TIMESTAMP('10/20/2016 3:47:41.491274 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10421, 976652, 1, 0, TO_TIMESTAMP('10/20/2016 1:45:40.747618 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9829, 976544, 1, 0, TO_TIMESTAMP('8/9/2016 3:39:26.491622 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12222, 977065, 6, 1, TO_TIMESTAMP('5/10/2017 9:26:15.904721 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12114, 977041, 6, 1, TO_TIMESTAMP('4/18/2017 9:02:46.689222 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12602, 977129, 6, 1, TO_TIMESTAMP('7/21/2017 8:54:50.144253 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11758, 976995, 6, 1, TO_TIMESTAMP('3/9/2017 2:27:06.496586 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11418, 976920, 6, 1, TO_TIMESTAMP('2/16/2017 1:37:03.494096 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11322, 976880, 6, 1, TO_TIMESTAMP('2/14/2017 9:22:16.026295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11042, 976820, 6, 1, TO_TIMESTAMP('2/3/2017 2:57:02.614015 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12918, 977206, 6, 1, TO_TIMESTAMP('9/1/2017 2:50:24.863294 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11298, 976835, 6, 1, TO_TIMESTAMP('2/13/2017 12:58:37.780352 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12618, 977149, 6, 1, TO_TIMESTAMP('7/21/2017 8:54:25.011563 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11066, 976840, 6, 1, TO_TIMESTAMP('2/6/2017 1:26:51.659766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10642, 976724, 6, 1, TO_TIMESTAMP('11/17/2016 12:53:54.063718 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10938, 976748, 6, 1, TO_TIMESTAMP('1/3/2017 9:41:49.206700 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12094, 977033, 6, 1, TO_TIMESTAMP('4/18/2017 9:01:50.402402 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12050, 977031, 6, 1, TO_TIMESTAMP('4/17/2017 2:01:02.793333 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11406, 976919, 6, 1, TO_TIMESTAMP('2/15/2017 7:51:39.042295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11030, 976819, 6, 1, TO_TIMESTAMP('2/2/2017 8:32:21.051792 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10970, 976749, 6, 1, TO_TIMESTAMP('1/3/2017 2:15:50.073403 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10466, 976677, 6, 1, TO_TIMESTAMP('10/20/2016 3:28:01.217393 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10014, 976601, 6, 1, TO_TIMESTAMP('8/15/2016 11:48:22.090278 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9842, 976545, 6, 1, TO_TIMESTAMP('8/11/2016 1:54:32.736999 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10594, 976692, 6, 1, TO_TIMESTAMP('11/18/2016 12:11:34.999378 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10674, 976727, 6, 1, TO_TIMESTAMP('11/18/2016 10:20:18.635765 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10478, 976678, 6, 1, TO_TIMESTAMP('10/20/2016 3:47:41.491274 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10422, 976652, 6, 1, TO_TIMESTAMP('10/20/2016 1:45:40.747618 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9830, 976544, 6, 1, TO_TIMESTAMP('8/9/2016 3:39:26.491622 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12223, 977065, 9, 2, TO_TIMESTAMP('5/10/2017 9:26:15.904721 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12115, 977041, 9, 2, TO_TIMESTAMP('4/18/2017 9:02:46.689222 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12603, 977129, 9, 2, TO_TIMESTAMP('7/21/2017 8:54:50.144253 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11759, 976995, 9, 2, TO_TIMESTAMP('3/9/2017 2:27:06.496586 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11419, 976920, 9, 2, TO_TIMESTAMP('2/16/2017 1:37:03.494096 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11323, 976880, 9, 2, TO_TIMESTAMP('2/14/2017 9:22:16.026295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11043, 976820, 9, 2, TO_TIMESTAMP('2/3/2017 2:57:02.614015 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12919, 977206, 9, 2, TO_TIMESTAMP('9/1/2017 2:50:24.863294 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11299, 976835, 9, 2, TO_TIMESTAMP('2/13/2017 12:58:37.780352 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12619, 977149, 9, 2, TO_TIMESTAMP('7/21/2017 8:54:25.011563 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11067, 976840, 9, 2, TO_TIMESTAMP('2/6/2017 1:26:51.659766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10643, 976724, 9, 2, TO_TIMESTAMP('11/17/2016 12:53:54.063718 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10939, 976748, 9, 2, TO_TIMESTAMP('1/3/2017 9:41:49.206700 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12095, 977033, 9, 2, TO_TIMESTAMP('4/18/2017 9:01:50.402402 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12051, 977031, 9, 2, TO_TIMESTAMP('4/17/2017 2:01:02.793333 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11407, 976919, 9, 2, TO_TIMESTAMP('2/15/2017 7:51:39.042295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11031, 976819, 9, 2, TO_TIMESTAMP('2/2/2017 8:32:21.051792 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10971, 976749, 9, 2, TO_TIMESTAMP('1/3/2017 2:15:50.073403 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10467, 976677, 9, 2, TO_TIMESTAMP('10/20/2016 3:28:01.217393 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10015, 976601, 9, 2, TO_TIMESTAMP('8/15/2016 11:48:22.090278 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9843, 976545, 9, 2, TO_TIMESTAMP('8/11/2016 1:54:32.736999 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10595, 976692, 9, 2, TO_TIMESTAMP('11/18/2016 12:11:34.999378 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10675, 976727, 9, 2, TO_TIMESTAMP('11/18/2016 10:20:18.635765 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10479, 976678, 9, 2, TO_TIMESTAMP('10/20/2016 3:47:41.491274 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10423, 976652, 9, 2, TO_TIMESTAMP('10/20/2016 1:45:40.747618 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9831, 976544, 9, 2, TO_TIMESTAMP('8/9/2016 3:39:26.491622 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12224, 977065, 12, 3, TO_TIMESTAMP('5/10/2017 9:26:15.904721 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12116, 977041, 12, 3, TO_TIMESTAMP('4/18/2017 9:02:46.689222 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12604, 977129, 12, 3, TO_TIMESTAMP('7/21/2017 8:54:50.144253 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11760, 976995, 12, 3, TO_TIMESTAMP('3/9/2017 2:27:06.496586 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11420, 976920, 12, 3, TO_TIMESTAMP('2/16/2017 1:37:03.494096 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11324, 976880, 12, 3, TO_TIMESTAMP('2/14/2017 9:22:16.026295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11044, 976820, 12, 3, TO_TIMESTAMP('2/3/2017 2:57:02.614015 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12920, 977206, 12, 3, TO_TIMESTAMP('9/1/2017 2:50:24.863294 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11300, 976835, 12, 3, TO_TIMESTAMP('2/13/2017 12:58:37.780352 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12620, 977149, 12, 3, TO_TIMESTAMP('7/21/2017 8:54:25.011563 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11068, 976840, 12, 3, TO_TIMESTAMP('2/6/2017 1:26:51.659766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10644, 976724, 12, 3, TO_TIMESTAMP('11/17/2016 12:53:54.063718 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10940, 976748, 12, 3, TO_TIMESTAMP('1/3/2017 9:41:49.206700 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9832, 976544, 12, 3, TO_TIMESTAMP('8/9/2016 3:39:26.491622 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12096, 977033, 12, 3, TO_TIMESTAMP('4/18/2017 9:01:50.402402 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12052, 977031, 12, 3, TO_TIMESTAMP('4/17/2017 2:01:02.793333 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11408, 976919, 12, 3, TO_TIMESTAMP('2/15/2017 7:51:39.042295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11032, 976819, 12, 3, TO_TIMESTAMP('2/2/2017 8:32:21.051792 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10972, 976749, 12, 3, TO_TIMESTAMP('1/3/2017 2:15:50.073403 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10468, 976677, 12, 3, TO_TIMESTAMP('10/20/2016 3:28:01.217393 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10016, 976601, 12, 3, TO_TIMESTAMP('8/15/2016 11:48:22.090278 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9844, 976545, 12, 3, TO_TIMESTAMP('8/11/2016 1:54:32.736999 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10596, 976692, 12, 3, TO_TIMESTAMP('11/18/2016 12:11:34.999378 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10676, 976727, 12, 3, TO_TIMESTAMP('11/18/2016 10:20:18.635765 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10480, 976678, 12, 3, TO_TIMESTAMP('10/20/2016 3:47:41.491274 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10424, 976652, 12, 3, TO_TIMESTAMP('10/20/2016 1:45:40.747618 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12225, 977065, 17, 4, TO_TIMESTAMP('5/10/2017 9:26:15.904721 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12137, 977041, 17, 4, TO_TIMESTAMP('4/18/2017 9:02:46.689222 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12605, 977129, 17, 4, TO_TIMESTAMP('7/21/2017 8:54:50.144253 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11761, 976995, 17, 4, TO_TIMESTAMP('3/9/2017 2:27:06.496586 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11421, 976920, 17, 4, TO_TIMESTAMP('2/16/2017 1:37:03.494096 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11345, 976880, 17, 4, TO_TIMESTAMP('2/14/2017 9:22:16.026295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11045, 976820, 17, 4, TO_TIMESTAMP('2/3/2017 2:57:02.614015 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12921, 977206, 17, 4, TO_TIMESTAMP('9/1/2017 2:50:24.863294 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11301, 976835, 17, 4, TO_TIMESTAMP('2/13/2017 12:58:37.780352 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12621, 977149, 17, 4, TO_TIMESTAMP('7/21/2017 8:54:25.011563 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11069, 976840, 17, 4, TO_TIMESTAMP('2/6/2017 1:26:51.659766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10645, 976724, 17, 4, TO_TIMESTAMP('11/17/2016 12:53:54.063718 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10941, 976748, 17, 4, TO_TIMESTAMP('1/3/2017 9:41:49.206700 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9833, 976544, 17, 4, TO_TIMESTAMP('8/9/2016 3:39:26.491622 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12117, 977033, 17, 4, TO_TIMESTAMP('4/18/2017 9:01:50.402402 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12053, 977031, 17, 4, TO_TIMESTAMP('4/17/2017 2:01:02.793333 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11409, 976919, 17, 4, TO_TIMESTAMP('2/15/2017 7:51:39.042295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11033, 976819, 17, 4, TO_TIMESTAMP('2/2/2017 8:32:21.051792 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10973, 976749, 17, 4, TO_TIMESTAMP('1/3/2017 2:15:50.073403 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10469, 976677, 17, 4, TO_TIMESTAMP('10/20/2016 3:28:01.217393 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10017, 976601, 17, 4, TO_TIMESTAMP('8/15/2016 11:48:22.090278 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9845, 976545, 17, 4, TO_TIMESTAMP('8/11/2016 1:54:32.736999 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10597, 976692, 17, 4, TO_TIMESTAMP('11/18/2016 12:11:34.999378 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10677, 976727, 17, 4, TO_TIMESTAMP('11/18/2016 10:20:18.635765 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10481, 976678, 17, 4, TO_TIMESTAMP('10/20/2016 3:47:41.491274 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10425, 976652, 17, 4, TO_TIMESTAMP('10/20/2016 1:45:40.747618 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12226, 977065, 22, 5, TO_TIMESTAMP('5/10/2017 9:26:15.904721 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12138, 977041, 22, 5, TO_TIMESTAMP('4/18/2017 9:02:46.689222 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12606, 977129, 22, 5, TO_TIMESTAMP('7/21/2017 8:54:50.144253 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11762, 976995, 22, 5, TO_TIMESTAMP('3/9/2017 2:27:06.496586 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11422, 976920, 22, 5, TO_TIMESTAMP('2/16/2017 1:37:03.494096 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11346, 976880, 22, 5, TO_TIMESTAMP('2/14/2017 9:22:16.026295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11046, 976820, 22, 5, TO_TIMESTAMP('2/3/2017 2:57:02.614015 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12922, 977206, 22, 5, TO_TIMESTAMP('9/1/2017 2:50:24.863294 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11302, 976835, 22, 5, TO_TIMESTAMP('2/13/2017 12:58:37.780352 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12622, 977149, 22, 5, TO_TIMESTAMP('7/21/2017 8:54:25.011563 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11070, 976840, 22, 5, TO_TIMESTAMP('2/6/2017 1:26:51.659766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10646, 976724, 22, 5, TO_TIMESTAMP('11/17/2016 12:53:54.063718 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10942, 976748, 22, 5, TO_TIMESTAMP('1/3/2017 9:41:49.206700 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9834, 976544, 22, 5, TO_TIMESTAMP('8/9/2016 3:39:26.491622 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12118, 977033, 22, 5, TO_TIMESTAMP('4/18/2017 9:01:50.402402 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12054, 977031, 22, 5, TO_TIMESTAMP('4/17/2017 2:01:02.793333 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11410, 976919, 22, 5, TO_TIMESTAMP('2/15/2017 7:51:39.042295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11034, 976819, 22, 5, TO_TIMESTAMP('2/2/2017 8:32:21.051792 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10974, 976749, 22, 5, TO_TIMESTAMP('1/3/2017 2:15:50.073403 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10470, 976677, 22, 5, TO_TIMESTAMP('10/20/2016 3:28:01.217393 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10018, 976601, 22, 5, TO_TIMESTAMP('8/15/2016 11:48:22.090278 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9846, 976545, 22, 5, TO_TIMESTAMP('8/11/2016 1:54:32.736999 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10598, 976692, 22, 5, TO_TIMESTAMP('11/18/2016 12:11:34.999378 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10678, 976727, 22, 5, TO_TIMESTAMP('11/18/2016 10:20:18.635765 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10482, 976678, 22, 5, TO_TIMESTAMP('10/20/2016 3:47:41.491274 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10426, 976652, 22, 5, TO_TIMESTAMP('10/20/2016 1:45:40.747618 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12227, 977065, 27, 6, TO_TIMESTAMP('5/10/2017 9:26:15.904721 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12139, 977041, 27, 6, TO_TIMESTAMP('4/18/2017 9:02:46.689222 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12607, 977129, 27, 6, TO_TIMESTAMP('7/21/2017 8:54:50.144253 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11763, 976995, 27, 6, TO_TIMESTAMP('3/9/2017 2:27:06.496586 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11423, 976920, 27, 6, TO_TIMESTAMP('2/16/2017 1:37:03.494096 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11347, 976880, 27, 6, TO_TIMESTAMP('2/14/2017 9:22:16.026295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11047, 976820, 27, 6, TO_TIMESTAMP('2/3/2017 2:57:02.614015 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12923, 977206, 27, 6, TO_TIMESTAMP('9/1/2017 2:50:24.863294 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11303, 976835, 27, 6, TO_TIMESTAMP('2/13/2017 12:58:37.780352 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12623, 977149, 27, 6, TO_TIMESTAMP('7/21/2017 8:54:25.011563 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11071, 976840, 27, 6, TO_TIMESTAMP('2/6/2017 1:26:51.659766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10647, 976724, 27, 6, TO_TIMESTAMP('11/17/2016 12:53:54.063718 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10943, 976748, 27, 6, TO_TIMESTAMP('1/3/2017 9:41:49.206700 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9835, 976544, 27, 6, TO_TIMESTAMP('8/9/2016 3:39:26.491622 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12119, 977033, 27, 6, TO_TIMESTAMP('4/18/2017 9:01:50.402402 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12055, 977031, 27, 6, TO_TIMESTAMP('4/17/2017 2:01:02.793333 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11411, 976919, 27, 6, TO_TIMESTAMP('2/15/2017 7:51:39.042295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11035, 976819, 27, 6, TO_TIMESTAMP('2/2/2017 8:32:21.051792 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10975, 976749, 27, 6, TO_TIMESTAMP('1/3/2017 2:15:50.073403 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10471, 976677, 27, 6, TO_TIMESTAMP('10/20/2016 3:28:01.217393 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10019, 976601, 27, 6, TO_TIMESTAMP('8/15/2016 11:48:22.090278 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9847, 976545, 27, 6, TO_TIMESTAMP('8/11/2016 1:54:32.736999 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10599, 976692, 27, 6, TO_TIMESTAMP('11/18/2016 12:11:34.999378 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10679, 976727, 27, 6, TO_TIMESTAMP('11/18/2016 10:20:18.635765 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10483, 976678, 27, 6, TO_TIMESTAMP('10/20/2016 3:47:41.491274 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10427, 976652, 27, 6, TO_TIMESTAMP('10/20/2016 1:45:40.747618 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12228, 977065, 32, 7, TO_TIMESTAMP('5/10/2017 9:26:15.904721 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12140, 977041, 32, 7, TO_TIMESTAMP('4/18/2017 9:02:46.689222 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12608, 977129, 32, 7, TO_TIMESTAMP('7/21/2017 8:54:50.144253 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11764, 976995, 32, 7, TO_TIMESTAMP('3/9/2017 2:27:06.496586 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11424, 976920, 32, 7, TO_TIMESTAMP('2/16/2017 1:37:03.494096 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11348, 976880, 32, 7, TO_TIMESTAMP('2/14/2017 9:22:16.026295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11048, 976820, 32, 7, TO_TIMESTAMP('2/3/2017 2:57:02.614015 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12924, 977206, 32, 7, TO_TIMESTAMP('9/1/2017 2:50:24.863294 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11304, 976835, 32, 7, TO_TIMESTAMP('2/13/2017 12:58:37.780352 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12624, 977149, 32, 7, TO_TIMESTAMP('7/21/2017 8:54:25.011563 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11072, 976840, 32, 7, TO_TIMESTAMP('2/6/2017 1:26:51.659766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10648, 976724, 32, 7, TO_TIMESTAMP('11/17/2016 12:53:54.063718 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10944, 976748, 32, 7, TO_TIMESTAMP('1/3/2017 9:41:49.206700 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9836, 976544, 32, 7, TO_TIMESTAMP('8/9/2016 3:39:26.491622 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12120, 977033, 32, 7, TO_TIMESTAMP('4/18/2017 9:01:50.402402 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12056, 977031, 32, 7, TO_TIMESTAMP('4/17/2017 2:01:02.793333 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11412, 976919, 32, 7, TO_TIMESTAMP('2/15/2017 7:51:39.042295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11036, 976819, 32, 7, TO_TIMESTAMP('2/2/2017 8:32:21.051792 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10976, 976749, 32, 7, TO_TIMESTAMP('1/3/2017 2:15:50.073403 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10472, 976677, 32, 7, TO_TIMESTAMP('10/20/2016 3:28:01.217393 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10020, 976601, 32, 7, TO_TIMESTAMP('8/15/2016 11:48:22.090278 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9848, 976545, 32, 7, TO_TIMESTAMP('8/11/2016 1:54:32.736999 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10600, 976692, 32, 7, TO_TIMESTAMP('11/18/2016 12:11:34.999378 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10680, 976727, 32, 7, TO_TIMESTAMP('11/18/2016 10:20:18.635765 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10484, 976678, 32, 7, TO_TIMESTAMP('10/20/2016 3:47:41.491274 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10428, 976652, 32, 7, TO_TIMESTAMP('10/20/2016 1:45:40.747618 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12229, 977065, 37, 8, TO_TIMESTAMP('5/10/2017 9:26:15.904721 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12141, 977041, 37, 8, TO_TIMESTAMP('4/18/2017 9:02:46.689222 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12609, 977129, 37, 8, TO_TIMESTAMP('7/21/2017 8:54:50.144253 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11765, 976995, 37, 8, TO_TIMESTAMP('3/9/2017 2:27:06.496586 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11425, 976920, 37, 8, TO_TIMESTAMP('2/16/2017 1:37:03.494096 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11349, 976880, 37, 8, TO_TIMESTAMP('2/14/2017 9:22:16.026295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11049, 976820, 37, 8, TO_TIMESTAMP('2/3/2017 2:57:02.614015 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12925, 977206, 37, 8, TO_TIMESTAMP('9/1/2017 2:50:24.863294 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11325, 976835, 37, 8, TO_TIMESTAMP('2/13/2017 12:58:37.780352 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12625, 977149, 37, 8, TO_TIMESTAMP('7/21/2017 8:54:25.011563 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11073, 976840, 37, 8, TO_TIMESTAMP('2/6/2017 1:26:51.659766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10649, 976724, 37, 8, TO_TIMESTAMP('11/17/2016 12:53:54.063718 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10965, 976748, 37, 8, TO_TIMESTAMP('1/3/2017 9:41:49.206700 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9837, 976544, 37, 8, TO_TIMESTAMP('8/9/2016 3:39:26.491622 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12121, 977033, 37, 8, TO_TIMESTAMP('4/18/2017 9:01:50.402402 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12077, 977031, 37, 8, TO_TIMESTAMP('4/17/2017 2:01:02.793333 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11413, 976919, 37, 8, TO_TIMESTAMP('2/15/2017 7:51:39.042295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11037, 976819, 37, 8, TO_TIMESTAMP('2/2/2017 8:32:21.051792 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10977, 976749, 37, 8, TO_TIMESTAMP('1/3/2017 2:15:50.073403 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10473, 976677, 37, 8, TO_TIMESTAMP('10/20/2016 3:28:01.217393 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10021, 976601, 37, 8, TO_TIMESTAMP('8/15/2016 11:48:22.090278 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9849, 976545, 37, 8, TO_TIMESTAMP('8/11/2016 1:54:32.736999 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10701, 976692, 37, 8, TO_TIMESTAMP('11/18/2016 12:11:34.999378 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10681, 976727, 37, 8, TO_TIMESTAMP('11/18/2016 10:20:18.635765 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10485, 976678, 37, 8, TO_TIMESTAMP('10/20/2016 3:47:41.491274 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10429, 976652, 37, 8, TO_TIMESTAMP('10/20/2016 1:45:40.747618 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12230, 977065, 43, 9, TO_TIMESTAMP('5/10/2017 9:26:15.904721 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12142, 977041, 43, 9, TO_TIMESTAMP('4/18/2017 9:02:46.689222 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12610, 977129, 43, 9, TO_TIMESTAMP('7/21/2017 8:54:50.144253 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11766, 976995, 43, 9, TO_TIMESTAMP('3/9/2017 2:27:06.496586 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11426, 976920, 43, 9, TO_TIMESTAMP('2/16/2017 1:37:03.494096 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11350, 976880, 43, 9, TO_TIMESTAMP('2/14/2017 9:22:16.026295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11050, 976820, 43, 9, TO_TIMESTAMP('2/3/2017 2:57:02.614015 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12926, 977206, 43, 9, TO_TIMESTAMP('9/1/2017 2:50:24.863294 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11326, 976835, 43, 9, TO_TIMESTAMP('2/13/2017 12:58:37.780352 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12626, 977149, 43, 9, TO_TIMESTAMP('7/21/2017 8:54:25.011563 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11074, 976840, 43, 9, TO_TIMESTAMP('2/6/2017 1:26:51.659766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10650, 976724, 43, 9, TO_TIMESTAMP('11/17/2016 12:53:54.063718 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10966, 976748, 43, 9, TO_TIMESTAMP('1/3/2017 9:41:49.206700 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9838, 976544, 43, 9, TO_TIMESTAMP('8/9/2016 3:39:26.491622 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12122, 977033, 43, 9, TO_TIMESTAMP('4/18/2017 9:01:50.402402 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12078, 977031, 43, 9, TO_TIMESTAMP('4/17/2017 2:01:02.793333 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11414, 976919, 43, 9, TO_TIMESTAMP('2/15/2017 7:51:39.042295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11038, 976819, 43, 9, TO_TIMESTAMP('2/2/2017 8:32:21.051792 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10978, 976749, 43, 9, TO_TIMESTAMP('1/3/2017 2:15:50.073403 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10474, 976677, 43, 9, TO_TIMESTAMP('10/20/2016 3:28:01.217393 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10022, 976601, 43, 9, TO_TIMESTAMP('8/15/2016 11:48:22.090278 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9850, 976545, 43, 9, TO_TIMESTAMP('8/11/2016 1:54:32.736999 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10702, 976692, 43, 9, TO_TIMESTAMP('11/18/2016 12:11:34.999378 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10682, 976727, 43, 9, TO_TIMESTAMP('11/18/2016 10:20:18.635765 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10486, 976678, 43, 9, TO_TIMESTAMP('10/20/2016 3:47:41.491274 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10430, 976652, 43, 9, TO_TIMESTAMP('10/20/2016 1:45:40.747618 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12231, 977065, 49, 10, TO_TIMESTAMP('5/10/2017 9:26:15.904721 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12143, 977041, 49, 10, TO_TIMESTAMP('4/18/2017 9:02:46.689222 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12611, 977129, 49, 10, TO_TIMESTAMP('7/21/2017 8:54:50.144253 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11767, 976995, 49, 10, TO_TIMESTAMP('3/9/2017 2:27:06.496586 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11427, 976920, 49, 10, TO_TIMESTAMP('2/16/2017 1:37:03.494096 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11351, 976880, 49, 10, TO_TIMESTAMP('2/14/2017 9:22:16.026295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11051, 976820, 49, 10, TO_TIMESTAMP('2/3/2017 2:57:02.614015 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12927, 977206, 49, 10, TO_TIMESTAMP('9/1/2017 2:50:24.863294 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11327, 976835, 49, 10, TO_TIMESTAMP('2/13/2017 12:58:37.780352 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12627, 977149, 49, 10, TO_TIMESTAMP('7/21/2017 8:54:25.011563 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11075, 976840, 49, 10, TO_TIMESTAMP('2/6/2017 1:26:51.659766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10651, 976724, 49, 10, TO_TIMESTAMP('11/17/2016 12:53:54.063718 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10967, 976748, 49, 10, TO_TIMESTAMP('1/3/2017 9:41:49.206700 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9839, 976544, 49, 10, TO_TIMESTAMP('8/9/2016 3:39:26.491622 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12123, 977033, 49, 10, TO_TIMESTAMP('4/18/2017 9:01:50.402402 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12079, 977031, 49, 10, TO_TIMESTAMP('4/17/2017 2:01:02.793333 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11415, 976919, 49, 10, TO_TIMESTAMP('2/15/2017 7:51:39.042295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11039, 976819, 49, 10, TO_TIMESTAMP('2/2/2017 8:32:21.051792 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10979, 976749, 49, 10, TO_TIMESTAMP('1/3/2017 2:15:50.073403 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10475, 976677, 49, 10, TO_TIMESTAMP('10/20/2016 3:28:01.217393 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10023, 976601, 49, 10, TO_TIMESTAMP('8/15/2016 11:48:22.090278 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9851, 976545, 49, 10, TO_TIMESTAMP('8/11/2016 1:54:32.736999 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10703, 976692, 49, 10, TO_TIMESTAMP('11/18/2016 12:11:34.999378 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10683, 976727, 49, 10, TO_TIMESTAMP('11/18/2016 10:20:18.635765 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10487, 976678, 49, 10, TO_TIMESTAMP('10/20/2016 3:47:41.491274 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10431, 976652, 49, 10, TO_TIMESTAMP('10/20/2016 1:45:40.747618 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12232, 977065, 55, 11, TO_TIMESTAMP('5/10/2017 9:26:15.904721 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12144, 977041, 55, 11, TO_TIMESTAMP('4/18/2017 9:02:46.689222 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12612, 977129, 55, 11, TO_TIMESTAMP('7/21/2017 8:54:50.144253 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11768, 976995, 55, 11, TO_TIMESTAMP('3/9/2017 2:27:06.496586 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11428, 976920, 55, 11, TO_TIMESTAMP('2/16/2017 1:37:03.494096 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11352, 976880, 55, 11, TO_TIMESTAMP('2/14/2017 9:22:16.026295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11052, 976820, 55, 11, TO_TIMESTAMP('2/3/2017 2:57:02.614015 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12928, 977206, 55, 11, TO_TIMESTAMP('9/1/2017 2:50:24.863294 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11328, 976835, 55, 11, TO_TIMESTAMP('2/13/2017 12:58:37.780352 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12628, 977149, 55, 11, TO_TIMESTAMP('7/21/2017 8:54:25.011563 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11076, 976840, 55, 11, TO_TIMESTAMP('2/6/2017 1:26:51.659766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10652, 976724, 55, 11, TO_TIMESTAMP('11/17/2016 12:53:54.063718 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10968, 976748, 55, 11, TO_TIMESTAMP('1/3/2017 9:41:49.206700 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9840, 976544, 55, 11, TO_TIMESTAMP('8/9/2016 3:39:26.491622 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12124, 977033, 55, 11, TO_TIMESTAMP('4/18/2017 9:01:50.402402 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (12080, 977031, 55, 11, TO_TIMESTAMP('4/17/2017 2:01:02.793333 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11416, 976919, 55, 11, TO_TIMESTAMP('2/15/2017 7:51:39.042295 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11040, 976819, 55, 11, TO_TIMESTAMP('2/2/2017 8:32:21.051792 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10980, 976749, 55, 11, TO_TIMESTAMP('1/3/2017 2:15:50.073403 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10476, 976677, 55, 11, TO_TIMESTAMP('10/20/2016 3:28:01.217393 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10024, 976601, 55, 11, TO_TIMESTAMP('8/15/2016 11:48:22.090278 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (9852, 976545, 55, 11, TO_TIMESTAMP('8/11/2016 1:54:32.736999 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10704, 976692, 55, 11, TO_TIMESTAMP('11/18/2016 12:11:34.999378 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10684, 976727, 55, 11, TO_TIMESTAMP('11/18/2016 10:20:18.635765 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10488, 976678, 55, 11, TO_TIMESTAMP('10/20/2016 3:47:41.491274 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10432, 976652, 55, 11, TO_TIMESTAMP('10/20/2016 1:45:40.747618 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10845, 976739, 64, 0, TO_TIMESTAMP('12/20/2016 10:16:08.884901 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11813, 977003, 64, 0, TO_TIMESTAMP('3/11/2017 9:17:31.963356 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10549, 976687, 64, 0, TO_TIMESTAMP('11/16/2016 7:39:55.855902 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10509, 976685, 60, 0, TO_TIMESTAMP('11/15/2016 4:02:10.456576 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10846, 976739, 66, 1, TO_TIMESTAMP('12/20/2016 10:16:08.884901 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11814, 977003, 66, 1, TO_TIMESTAMP('3/11/2017 9:17:31.963356 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10550, 976687, 66, 1, TO_TIMESTAMP('11/16/2016 7:39:55.855902 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10510, 976685, 66, 1, TO_TIMESTAMP('11/15/2016 4:02:10.456576 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10847, 976739, 73, 2, TO_TIMESTAMP('12/20/2016 10:16:08.884901 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11815, 977003, 73, 2, TO_TIMESTAMP('3/11/2017 9:17:31.963356 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10551, 976687, 73, 2, TO_TIMESTAMP('11/16/2016 7:39:55.855902 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10511, 976685, 72, 2, TO_TIMESTAMP('11/15/2016 4:02:10.456576 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10848, 976739, 83, 3, TO_TIMESTAMP('12/20/2016 10:16:08.884901 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11816, 977003, 83, 3, TO_TIMESTAMP('3/11/2017 9:17:31.963356 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10552, 976687, 83, 3, TO_TIMESTAMP('11/16/2016 7:39:55.855902 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10512, 976685, 78, 3, TO_TIMESTAMP('11/15/2016 4:02:10.456576 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10849, 976739, 85, 4, TO_TIMESTAMP('12/20/2016 10:16:08.884901 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11817, 977003, 85, 4, TO_TIMESTAMP('3/11/2017 9:17:31.963356 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10553, 976687, 85, 4, TO_TIMESTAMP('11/16/2016 7:39:55.855902 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10513, 976685, 84, 4, TO_TIMESTAMP('11/15/2016 4:02:10.456576 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10850, 976739, 93, 5, TO_TIMESTAMP('12/20/2016 10:16:08.884901 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11818, 977003, 93, 5, TO_TIMESTAMP('3/11/2017 9:17:31.963356 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10554, 976687, 93, 5, TO_TIMESTAMP('11/16/2016 7:39:55.855902 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10514, 976685, 90, 5, TO_TIMESTAMP('11/15/2016 4:02:10.456576 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10851, 976739, 97, 6, TO_TIMESTAMP('12/20/2016 10:16:08.884901 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11819, 977003, 97, 6, TO_TIMESTAMP('3/11/2017 9:17:31.963356 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10555, 976687, 97, 6, TO_TIMESTAMP('11/16/2016 7:39:55.855902 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10515, 976685, 96, 6, TO_TIMESTAMP('11/15/2016 4:02:10.456576 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10852, 976739, 107, 7, TO_TIMESTAMP('12/20/2016 10:16:08.884901 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (11820, 977003, 107, 7, TO_TIMESTAMP('3/11/2017 9:17:31.963356 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10556, 976687, 107, 7, TO_TIMESTAMP('11/16/2016 7:39:55.855902 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into SURVEY_QUESTION_ANSWER
   (SURVEY_QUESTION_ANSWER_ID, SURVEY_RESPONSE_ID, SURVEY_CHOICE_ID, LINE_NBR, MESSAGE_INSERTION_TIME)
 Values
   (10516, 976685, 102, 7, TO_TIMESTAMP('11/15/2016 4:02:10.456576 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
COMMIT;


/******************************************************************************
	Add DMP Responses
******************************************************************************/
SET DEFINE OFF;
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (205, 24, 1, 59, '590161700', 
    '200TX', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2014 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/4/2013 12:49:55.574202 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (206, 44, 1, 16, '690161399', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2013 12:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/4/2013 1:06:37.400432 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, XML_VERSION, 
    RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (105, 44, 1, 16, '790161399', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2013 12:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', 'String', 
    'Accepted', TO_TIMESTAMP('3/4/2013 1:10:55.626803 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2824, 45, 1, 16, 'Aug278981000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2023 2:33:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/27/2013 8:01:31.512189 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2825, 45, 1, 16, 'Aug278961000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2023 2:35:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/27/2013 8:07:32.441809 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2826, 45, 1, 16, 'Aug278951000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2023 2:36:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/27/2013 8:09:15.720822 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2830, 45, 1, 16, 'aug273031000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2023 2:43:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/27/2013 8:17:35.207233 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2832, 125, 107, 186, '20130827102600', 
    '200T8', 'LOCALHOST', 'DNS', '00003333', '657', 
    'USVHA', 'DUCK', 'DONALD', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/27/2013 4:49:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '1111155555V009900', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('8/27/2013 8:46:14.987947 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2835, 145, 1, 16, 'aug273391000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/27/2013 8:46:48.000000 AM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/27/2013 10:42:01.601999 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3624, 65, 1, 61, '500167371A', 
    '200T2', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/22/2014 4:30:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567880V123457', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/22/2014 9:19:58.874729 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3835, 45, 1, 16, 'AUDITCLOBdec187091000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/9/2013 2:35:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/12/2014 12:25:43.340274 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3836, 45, 1, 16, 'audit2dec187091000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/12/2015 2:35:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/12/2014 12:27:54.690246 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3837, 45, 1, 226, '201308131042D', 
    '200T3', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/17/2014 5:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('4/17/2014 9:30:28.246089 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4133, 45, 1, 61, 'A201308131042', 
    '200T2', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('5/22/2014 5:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('6/5/2014 1:06:07.539289 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (6137, 326, 35, 247, '20150414115022TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/14/2015 6:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('4/14/2015 1:17:56.543649 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (6639, 326, 35, 247, '20150623115023TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/23/2015 8:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('6/23/2015 12:13:29.573026 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7638, 45, 1, 16, '11092015000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/9/2015 7:35:01.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/9/2015 9:55:57.676678 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7640, 326, 35, 432, '20151202115022TT', 
    '200T5', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/2/2015 11:50:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '9111155555V009905', 'String', 'ACCEPTED', TO_TIMESTAMP('12/2/2015 1:25:35.066574 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7643, 65, 35, 392, 'DMP20151207IJ', 
    '200T8', 'LOCALHOST', 'DNS', '000000026827', '613', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/7/2015 12:41:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503', 3040621.104503, 
    '1234567891V123456', 'String', 'ACCEPTED', TO_TIMESTAMP('12/7/2015 2:47:19.085844 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8039, 448, 1, 59, 'DMP20160727IJ', 
    '200TX', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('7/27/2016 11:41:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('7/29/2016 1:38:14.496982 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8352, 65, 1, 60, 'DMP20160922ds', 
    '200T4', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'Ms', 'Debbie', 'Shaffer', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('9/22/2016 11:41:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('9/22/2016 8:52:46.040791 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9567, 65, 35, 16, 'DMP20170309000000MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('3/9/2017 12:00:00.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '201703090000', 3170309, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/8/2017 4:05:58.778456 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4, 24, 1, 16, '500167401', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/19/2001 4:30:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567890V123456', 
    'String', 'Not submitted', TO_TIMESTAMP('2/21/2013 10:01:30.799661 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (203, 43, 1, 16, '290161399', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2013 12:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/4/2013 11:27:49.147630 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (204, 44, 1, 16, '590161399', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2013 12:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/4/2013 12:43:20.871127 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (208, 24, 1, 16, '990161399', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2019 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '12345V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/4/2013 1:58:41.180186 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2525, 65, 1, 61, '500167372', 
    '200T2', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/13/2013 4:30:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567880V123457', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/13/2013 4:19:49.679081 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2834, 45, 1, 16, 'aug273181000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/27/2013 8:46:48.000000 AM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/27/2013 10:38:05.577868 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3324, 125, 107, 186, '20131211154417', 
    '200T8', 'LOCALHOST', 'DNS', '00003333', '657', 
    'USVHA', 'DUCK', 'DONALD', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/11/2013 10:44:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '1111155555V009900', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('12/11/2013 2:44:43.625645 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3325, 125, 107, 186, '20131211154418', 
    '200T8', 'LOCALHOST', 'DNS', '00003333', '657', 
    'USVHA', 'DUCK', 'DONALD', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/11/2013 10:44:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '1111155555V009900', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('12/11/2013 2:46:47.243941 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3829, 45, 1, 44, '201308131042C', 
    '200T1', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/4/2014 5:41:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/6/2014 5:00:45.765102 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3830, 45, 1, 61, '201308131042E', 
    '200T2', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/7/2014 5:41:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/6/2014 5:12:56.515313 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4533, 65, 1, 61, 'A2013081310421BZ', 
    '200T2', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/29/2014 5:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/29/2014 12:32:42.266523 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5242, 45, 1, 16, 'TSY12222014000000002', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/22/2014 2:35:01.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/22/2014 10:57:24.451652 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5253, 65, 1, 61, 'DMP20150116IJ', 
    '200T2', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/16/2015 5:41:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/16/2015 9:58:51.336625 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5540, 326, 35, 247, '20150220115030TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/20/2015 6:52:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009999', 
    'String', 'DISENROLLED', TO_TIMESTAMP('2/20/2015 12:33:10.725507 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5544, 45, 1, 16, '02272015000000001tsy', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/27/2015 2:35:01.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/27/2015 11:38:36.990573 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7641, 45, 1, 16, '12072015000000002', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/7/2015 7:35:02.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'DELAYED', TO_TIMESTAMP('12/7/2015 7:00:58.665787 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8041, 45, 1, 16, '08052016000000001tsy', 
    '200T5', 'SERVER.      .URL       ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/5/2016 8:35:01.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/5/2016 7:11:22.820217 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9560, 65, 35, 16, 'DMP20170303000000MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('3/3/2017 12:00:00.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '201703030000', 3170303, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/3/2017 1:01:41.853180 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9566, 45, 1, 16, '03082017000000006tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/8/2017 6:35:06.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/8/2017 3:40:58.508055 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9568, 226, 35, 432, '20170308215022TT3', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr5', 'testhdr5', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/8/2017 2:02:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '2111155512V129092', 'String', 'ACCEPTED', TO_TIMESTAMP('3/9/2017 9:59:04.318847 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9569, 65, 35, 16, 'DMP20170309133500MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('3/9/2017 1:35:00.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '201703091335', 3170309.1335, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/9/2017 12:27:10.091514 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10058, 65, 35, 16, 'DMP20170517133000MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('5/17/2017 2:30:00.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20170517133000', 3170517.133, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('5/17/2017 1:21:32.835310 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2, 24, 1, 16, '500167399', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/17/2001 4:30:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567890V123456', 
    'String', 'Not submitted', TO_TIMESTAMP('2/20/2013 12:34:31.271977 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3, 24, 1, 16, '500167400', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/18/2001 4:30:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567890V123456', 
    'String', 'Not submitted', TO_TIMESTAMP('2/20/2013 12:48:07.595736 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (104, 24, 107, 16, '519167390', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/2012 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/17/2013 4:30:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130228104503 05 00', '2234567890V123456', 
    'String', 'Not submitted', TO_TIMESTAMP('2/28/2013 1:54:48.377507 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (107, 24, 1, 16, '190111399', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('9/6/2015 11:31:47.000000 AM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/7/2013 8:31:32.381590 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, XML_VERSION, 
    RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (108, 24, 1, 16, '190011399', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('9/6/2015 11:31:47.000000 AM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', 'String', 
    'Accepted', TO_TIMESTAMP('3/7/2013 8:33:42.876104 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (109, 24, 1, 59, '590145703', 
    '200TX', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/6/2012 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/7/2013 10:19:49.103571 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (110, 24, 1, 60, '590169906', 
    '200T4', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/6/2014 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/7/2013 11:45:21.328062 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (423, 45, 107, 59, '1100000007', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/6/2011 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130620084403 05 00', '3333333333V333333', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('6/20/2013 7:44:22.171745 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (425, 45, 107, 59, '1100000009', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/1/2011 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130620084903 05 00', '3333333333V333333', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('6/20/2013 11:06:02.478255 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (722, 45, 107, 59, '1100000011', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/2/2011 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130620154903 05 00', '3333333333V333333', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('6/20/2013 2:49:37.253823 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2222, 45, 1, 16, 'july168051000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2016 2:32:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('7/16/2013 7:30:36.241631 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3326, 45, 1, 16, 'DEMOdec187001000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/8/2013 2:35:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/18/2013 11:17:45.829584 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4132, 45, 1, 16, 'DEMOjun100187091000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/18/2014 2:35:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('6/5/2014 10:47:59.749746 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4542, 65, 1, 226, 'DMP2013081310', 
    '200T3', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/28/2014 5:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('10/28/2014 4:19:20.813138 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4835, 45, 1, 16, 'TSY00000000011111', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/12/2014 2:35:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/12/2014 10:48:53.102635 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4937, 65, 1, 61, '20141114A', 
    '200T2', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/14/2014 5:41:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/14/2014 8:17:07.229801 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5037, 45, 1, 16, 'TSY11242014000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/24/2014 2:35:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/24/2014 11:17:13.281685 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5038, 45, 1, 16, 'TSY11252014000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/25/2014 2:35:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/25/2014 11:13:26.190693 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5040, 45, 1, 16, 'TSY11252014000000002', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/25/2014 2:35:22.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222223V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/25/2014 11:21:59.744101 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5041, 125, 35, 247, '20141125115022TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/25/2014 6:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('11/25/2014 11:54:50.938045 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5239, 45, 1, 16, 'TSY12192014000000002', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/19/2014 2:35:01.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/19/2014 7:53:14.109446 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5547, 45, 1, 16, '02042015004tsy', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/20/2015 2:02:04.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/4/2015 2:49:03.475404 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (6337, 326, 35, 247, '20150513115022TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('5/13/2015 5:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('5/13/2015 2:08:37.458815 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7339, 326, 35, 432, '20150811115022TT', 
    '200T5', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/11/2015 6:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/11/2015 1:35:15.566197 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7652, 45, 1, 16, '02122016000000002', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/4/2016 7:35:02.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'DELAYED', TO_TIMESTAMP('2/12/2016 1:36:15.052203 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8249, 448, 1, 16, 'DMP20160824ds', 
    '200T4', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ms', 'Debbie', 'Shaffer', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('8/24/2016 12:41:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/24/2016 12:12:49.016398 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9252, 125, 35, 60, 'DMP20161228IJ', 
    '200T4', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('12/28/2016 10:41:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/28/2016 1:59:37.560674 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9572, 448, 1, 16, 'DMP20170309dsErT5', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'Ms', 'Debbie', 'Shaffer', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/15/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('3/9/2017 10:46:43.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/9/2017 2:01:12.230097 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10359, 448, 1, 392, 'DMPValid20170718IJ', 
    '200T8', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/18/2017 11:41:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('7/20/2017 2:20:16.001756 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5, 24, 1, 16, '500167402', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/20/2001 4:30:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567890V123456', 
    'String', 'Not submitted', TO_TIMESTAMP('2/21/2013 12:11:51.723844 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (207, 24, 1, 60, '590161501', 
    '200T4', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/6/2016 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/4/2013 1:43:36.708760 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (209, 24, 1, 61, '590161309', 
    '200T2', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2013 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Refused Time out', TO_TIMESTAMP('3/5/2013 9:44:24.727186 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, XML_VERSION, 
    RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (106, 24, 1, 16, '100161399', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2023 11:31:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', 'String', 
    'Accepted', TO_TIMESTAMP('3/6/2013 2:03:26.712815 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (210, 24, 1, 16, '190061399', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2013 11:31:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '12345V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/6/2013 2:03:09.409616 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (111, 24, 1, 44, 't90161399', 
    '200T1', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/6/2020 2:31:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/7/2013 12:18:59.651042 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2322, 65, 1, 44, '50016737F', 
    '200T1', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/6/2013 4:30:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567880V123457', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/6/2013 3:44:20.441772 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2836, 45, 1, 16, 'aug273211000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/27/2013 8:49:48.000000 AM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/27/2013 11:26:51.208917 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3827, 45, 1, 44, '201308131042A', 
    '200T1', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/4/2014 5:41:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/4/2014 9:07:23.127828 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5240, 45, 1, 16, 'TSY12192014000000003', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/19/2014 2:35:02.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('12/19/2014 7:54:45.792083 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5245, 65, 1, 61, '20150106DTDMPCE', 
    '200T2', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/6/2015 5:41:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/6/2015 1:11:27.502671 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5248, 306, 1, 16, '201401121330tt', 
    '200T5', 'LOCALHOST', 'DNS', '000000026837', '402', 
    'USVHA', 'ABCTT', 'HI', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/12/2014 10:33:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '2234567844V123456', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('1/12/2015 6:57:29.086625 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7642, 45, 1, 16, '12072015000000003', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/7/2015 7:35:03.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/7/2015 7:03:39.161354 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7654, 447, 1, 452, '20160216115030TT', 
    '200T8', 'LOCALHOST', 'DNS', '00001111', '402', 
    'USVHA', 'TRhdr2', 'PThdr2TT', 'TTVENDOR5', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/16/2016 11:52:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'TT NAME', 'TT DEVICE', '20130813093703', 3130813.093703, 
    '1015155333V119933', '1.0', 'COMPLETE', TO_TIMESTAMP('2/16/2016 12:38:47.060810 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7656, 326, 35, 432, '20160217115022TT', 
    '200T5', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/17/2016 11:50:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '9111155555V009905', 'String', 'ACCEPTED', TO_TIMESTAMP('2/17/2016 12:54:18.679372 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7939, 105, 35, 472, '20160601115026TT1', 
    '200T1', 'DNS .HL7.HEALTHHERO.CCURL        ', 'DNS', '00003334', '613', 
    'USVHA', 'TESTTRIN', 'hdrPT', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/1/2016 8:48:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201604270937030500', 3160427.09370305, 
    '8221155556V009877', 'String', 'ACCEPTED', TO_TIMESTAMP('6/2/2016 7:19:03.482159 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8239, 45, 1, 16, '08112016000000001tsy', 
    '200T5', 'SERVER.      .URL       ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/11/2016 8:35:01.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/11/2016 2:20:20.991021 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9558, 226, 35, 432, '20170303215022TT3', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr5', 'testhdr5', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/3/2017 2:02:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '2111155512V129092', 'String', 'ACCEPTED', TO_TIMESTAMP('3/3/2017 6:54:40.269449 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9559, 448, 1, 16, 'DMP20170303dsErT1', 
    '200T1', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'Ms', 'Debbie', 'Shaffer', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/15/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('3/3/2017 10:46:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/3/2017 1:00:17.800279 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9860, 226, 35, 432, '20170510215022TT5', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr5', 'testhdr5', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('5/10/2017 1:02:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '2111155512V129092', 'String', 'ACCEPTED', TO_TIMESTAMP('5/10/2017 1:05:01.509006 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (102, 24, 1, 16, '129167390', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Tiff', 'Lee', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/28/2013 8:30:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130228124503 05 00', '2934517890V123456', 
    'String', 'Not submitted', TO_TIMESTAMP('2/28/2013 12:23:18.242854 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (103, 24, 1, 16, '519167390', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/17/2013 4:30:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130621104503 05 00', '2234567890V123456', 
    'String', 'Not submitted', TO_TIMESTAMP('2/28/2013 1:22:44.723490 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (201, 24, 1, 16, '190161399', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2013 4:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/4/2013 9:28:51.552005 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (212, 24, 1, 16, '191111399', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('5/6/2014 3:31:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Delayed', TO_TIMESTAMP('3/6/2013 2:42:01.671967 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (213, 24, 1, 60, '590161506', 
    '200T4', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/6/2014 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/7/2013 6:45:27.343150 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (218, 24, 1, 60, '590198601', 
    '200T4', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/6/2016 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/13/2013 3:42:57.116876 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (220, 24, 1, 60, '590193271', 
    '200T4', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/6/2016 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/13/2013 3:49:52.574369 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (113, 24, 1, 60, '590712501', 
    '200T4', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/6/2017 2:31:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/13/2013 3:55:08.052000 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (223, 24, 1, 16, '590161399l', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/6/2023 12:31:45.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/20/2013 7:55:00.400786 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1123, 45, 107, 59, '1100000111', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/24/2013 10:08:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130624151103 05 00', '3333333333V333333', 
    'String', 'DISENROLLED', TO_TIMESTAMP('6/24/2013 2:11:20.936616 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1222, 45, 107, 59, '110001111112', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/24/2013 10:17:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130624151703 05 00', '3333333333V333333', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('6/24/2013 2:17:55.832424 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1223, 45, 1, 59, 'june251000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2023 2:35:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('6/24/2013 2:26:04.096259 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1523, 65, 1, 59, '625A177399B', 
    '200T3', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/17/2010 5:30:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567890V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('7/2/2013 5:33:56.648238 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1624, 45, 107, 62, '11000000000126', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/3/2013 6:31:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130702085703 05 00', '3333333333V333333', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('7/3/2013 9:06:35.816850 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1531, 45, 107, 62, '11000000000128', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/3/2013 6:31:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130702085703 05 00', '3333333333V333333', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('7/3/2013 9:09:20.219932 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2422, 65, 1, 61, '50016737G', 
    '200T2', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/8/2013 4:30:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567880V123457', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/8/2013 3:04:52.318758 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2423, 105, 35, 16, '20130808153900', 
    '200T5', 'LOCALHOST', 'DNS', '000000055555', '613', 
    'USVHA', 'World', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/8/2013 10:39:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130808155703 05 00', '3333555555V333355', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('8/8/2013 3:08:04.351845 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2722, 45, 1, 16, '1000000001AUG22801', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2013 2:32:48.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/20/2013 11:45:33.778582 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2924, 45, 1, 16, 'oct31201390011000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/31/2013 2:31:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('10/31/2013 8:04:57.085897 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2925, 45, 1, 16, 'oct312501390011000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/31/2013 2:32:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('10/31/2013 8:11:02.354254 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3024, 125, 107, 186, '20131103114113', 
    '200T8', 'LOCALHOST', 'DNS', '00003333', '657', 
    'USVHA', 'DUCK', 'DONALD', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/4/2013 6:56:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '1111155555V009900', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('11/4/2013 10:58:15.435010 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3625, 125, 35, 247, '20140122111515', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPT', 'testABC', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/14/2014 6:17:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009901', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('1/22/2014 10:19:21.639025 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3826, 45, 1, 16, '201402031336', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/3/2014 10:36:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('2/3/2014 2:38:44.419530 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4532, 125, 35, 247, '20140814115022TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/14/2014 6:50:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/14/2014 10:52:41.072125 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4534, 207, 35, 247, '20140901115022TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('9/1/2014 6:50:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'COMPLETE', TO_TIMESTAMP('9/2/2014 7:25:24.210961 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4540, 65, 1, 146, 'A2013081310421V', 
    '200T6', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('9/24/2014 5:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('9/24/2014 12:47:03.006615 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4543, 45, 1, 16, 'TSY201410280000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/29/2014 2:35:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('10/29/2014 1:41:56.297259 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5543, 45, 1, 16, '02232015000000003tsy', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/23/2015 2:35:03.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/23/2015 9:34:06.693204 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7645, 326, 35, 432, '20160120115022TT', 
    '200T5', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/20/2016 11:50:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '9111155555V009905', 'String', 'ACCEPTED', TO_TIMESTAMP('1/20/2016 3:03:09.031900 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8042, 468, 1, 452, '20160805115030TT', 
    '200T8', 'LOCALHOST', 'DNS', '00001111', '402', 
    'USVHA', 'TRhdr2', 'PThdr2TT', 'TTVENDOR5', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/5/2016 12:52:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'TT NAME', 'TT DEVICE', '20130813093703', 3130813.093703, 
    '1015155333V119933', '1.0', 'COMPLETE', TO_TIMESTAMP('8/5/2016 12:59:58.389300 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8240, 448, 1, 16, 'DMP20160815ds', 
    '200T4', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ms', 'Debbie', 'Shaffer', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('8/2/2016 12:41:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/15/2016 12:51:49.780193 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (112, 24, 1, 44, 't40161399', 
    '200T1', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/6/2020 2:31:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Incomplete', TO_TIMESTAMP('3/7/2013 12:29:10.297691 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (224, 24, 1, 59, '595161802', 
    '200TX', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2008 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('4/2/2013 11:58:55.327473 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (225, 24, 1, 16, '59016139i', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2013 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('4/2/2013 12:56:15.530702 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (823, 45, 107, 59, '1200000007', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/6/2011 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130620085703 05 00', '3333333333V333333', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('6/24/2013 8:48:10.512161 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1529, 45, 107, 59, '11000000000119', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'Eric', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/3/2013 6:56:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130702085703 05 00', '3333333333V333333', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('7/3/2013 8:41:59.520765 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1530, 45, 107, 107, '11000000000121', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/3/2013 6:39:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'ABC', 'String', '20130702085703 05 00', '3333333333V333333', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('7/3/2013 8:56:31.377547 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1823, 85, 107, 126, '11000000000127', 
    '200T8', 'LOCALHOST', 'DNS', '6789', '657', 
    'USVHA', 'FGHIK', 'ABCDE', 'String', TO_DATE('01/13/2013 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/8/2013 4:00:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130702085703 05 00', '3333355555V888888', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('7/8/2013 9:01:28.100515 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2122, 45, 1, 16, 'july129101000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2023 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('7/12/2013 12:08:25.355479 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3327, 45, 1, 16, 'DEMOdec187091000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('5/8/2013 2:35:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/19/2013 1:25:06.754669 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3524, 45, 1, 16, 'jan45t1241000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2023 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/13/2014 8:28:55.946342 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3525, 45, 1, 16, 'jan225091000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/22/2014 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/22/2014 7:55:04.813206 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3527, 45, 1, 16, 'jan228091000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'dum2', 'dum1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/6/2014 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/22/2014 12:32:14.309797 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3828, 45, 1, 16, '201402041336', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/4/2014 8:45:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('2/4/2014 12:39:21.114260 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3929, 125, 35, 247, '20140307120221T', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPT', 'testABC', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/7/2014 7:16:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009901', 
    'String', 'DELAYED', TO_TIMESTAMP('3/7/2014 7:38:31.822274 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3931, 45, 1, 16, 'DEMOmar505187091000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/7/2014 2:35:50.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'DISENROLLED', TO_TIMESTAMP('3/7/2014 10:36:40.462555 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5042, 65, 1, 16, '20141125IJE', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/25/2014 5:41:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/25/2014 1:26:29.436969 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5244, 45, 1, 16, 'TSY01062015000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/7/2015 2:35:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/6/2015 12:06:54.549583 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (6638, 45, 1, 16, '06232015000000002', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/23/2015 2:35:02.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('6/23/2015 12:04:55.860573 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7646, 366, 35, 60, 'DMP20160122IJ', 
    '200T4', 'LOCALHOST', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('1/22/2016 10:41:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/22/2016 1:22:44.757404 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7648, 45, 1, 16, '01262016000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/26/2016 7:35:01.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/26/2016 8:38:02.757827 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8242, 65, 35, 16, 'DMP20160816000000MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('8/16/2016 1:00:00.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20160816000000', 3160816, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/16/2016 7:26:26.805367 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9570, 488, 35, 226, 'DMP20170309dsValidT5', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('3/9/2017 10:41:42.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/9/2017 1:55:07.861093 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9859, 45, 1, 16, '05092017000000001tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/3/2017 6:35:01.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('5/9/2017 2:08:16.857681 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10458, 226, 35, 432, '20170828215022TT_dmp', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr5', 'testhdr5', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/28/2017 2:02:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '2111155512V129092', 'String', 'ACCEPTED', TO_TIMESTAMP('8/28/2017 6:54:53.822925 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, XML_VERSION, 
    RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (211, 24, 1, 16, '190061099', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2013 11:31:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', 'String', 
    'Accepted', TO_TIMESTAMP('3/6/2013 2:08:06.927759 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (422, 45, 1, 59, '1100000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/6/2021 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130619144503 05 00', '2222222222V123400', 
    'String', 'COMPLETE', TO_TIMESTAMP('6/19/2013 1:45:07.806478 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1822, 45, 107, 2, '11001110000128', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/4/2013 7:31:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130702085703 05 00', '3333333333V333333', 
    'String', 'ACCEPTED', TO_TIMESTAMP('7/5/2013 1:27:52.747708 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2822, 45, 1, 16, 'Aug278991000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2023 2:32:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/27/2013 7:57:29.999219 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2833, 45, 1, 16, 'aug273151000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/27/2013 8:45:48.000000 AM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/27/2013 8:54:12.927388 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3224, 125, 107, 186, '20131211114117', 
    '200T8', 'LOCALHOST', 'DNS', '00003333', '657', 
    'USVHA', 'DUCK', 'DONALD', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/5/2013 7:56:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '1111155555V009900', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('12/11/2013 1:29:05.017179 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3225, 45, 1, 16, '1dec232000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/7/2023 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '89830614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/12/2013 9:40:29.351095 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3227, 45, 1, 16, '1dec268000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/9/2023 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '89830614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/12/2013 10:28:55.047472 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3626, 125, 35, 247, '20140129111516', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPT', 'testABC', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/15/2014 6:17:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009901', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('1/28/2014 10:48:31.786913 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4129, 125, 35, 247, '20140602110719', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPT', 'testABC', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/2/2014 6:07:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009901', 
    'String', 'COMPLETE', TO_TIMESTAMP('6/2/2014 7:17:58.313419 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5252, 65, 1, 44, '20150112IJDMP', 
    '200T1', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/12/2015 5:41:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/12/2015 3:18:20.472475 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (6738, 45, 1, 16, '06252015000000007', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/25/2015 2:35:07.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('6/25/2015 12:28:37.375775 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7651, 45, 1, 16, '02122016000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/4/2016 7:35:01.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/12/2016 1:34:37.498947 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7653, 45, 1, 16, '02162016000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/16/2016 7:35:01.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/16/2016 12:35:24.561949 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9253, 45, 1, 16, '12282016000000001tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/28/2016 6:35:01.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/28/2016 2:17:25.271732 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9457, 65, 35, 16, 'DMP20170215142000MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('2/15/2017 2:20:00.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '201702151420', 3170215.142, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/15/2017 1:42:34.643497 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (214, 24, 1, 16, '500167405', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/27/2001 4:30:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567890V123456', 
    'String', 'Not submitted', TO_TIMESTAMP('3/7/2013 8:32:14.291094 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, XML_VERSION, 
    RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (215, 24, 1, 16, '500167406', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/29/2001 4:30:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104504 05 00', 'String', 
    'Not submitted', TO_TIMESTAMP('3/7/2013 9:19:13.004441 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2022, 65, 1, 146, '50016737C', 
    '200T6', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/9/2013 4:30:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567880V123457', 
    'String', 'ACCEPTED', TO_TIMESTAMP('7/9/2013 2:49:29.638649 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2823, 45, 1, 16, 'Aug278971000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2023 2:34:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/27/2013 8:00:37.624795 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3424, 45, 1, 16, 'DEMOdec187101000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/19/2013 2:35:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/19/2013 2:08:24.781180 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4430, 65, 1, 310, 'A2013081310421IJ', 
    '200T7', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/20/2014 5:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'DISENROLLED', TO_TIMESTAMP('7/8/2014 3:20:40.058934 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5557, 65, 1, 61, 'DMP20150310IJ', 
    '200T2', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/10/2015 5:41:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/10/2015 9:44:34.770613 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7340, 65, 1, 392, 'DMP20150811DTCE', 
    '200T8', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/11/2015 5:41:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/11/2015 2:07:13.074560 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7637, 366, 1, 392, 'DMP20151106IJ', 
    '200T8', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/6/2015 10:41:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/6/2015 1:43:02.924506 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8243, 226, 35, 432, '20160816115022TT1', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr4', 'testhdr4', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/16/2016 10:50:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '9111155512V129098', 'String', 'ACCEPTED', TO_TIMESTAMP('8/16/2016 7:58:54.990524 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8244, 226, 35, 432, '20160816115022TT2', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr4', 'testhdr4', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/16/2016 10:01:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '9111155512V129099', 'String', 'ACCEPTED', TO_TIMESTAMP('8/16/2016 7:59:45.309961 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8557, 509, 1, 452, '20161020115030TT', 
    '200T8', 'DNS         .DNS           ', 'DNS', '00001111', '402', 
    'USVHA', '2TRhdr2', '2PThdr2TT', 'TTVENDOR5', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/20/2016 10:52:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'TT NAME', 'TT DEVICE', '20161020093703', 3161020.093703, 
    '1015155333V119938', '1.0', 'INCOMPLETE', TO_TIMESTAMP('10/20/2016 11:42:38.454925 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8952, 488, 35, 226, 'DMP20161122dsValidT1', 
    '200T1', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('11/22/2016 10:41:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/22/2016 2:42:16.575547 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9573, 366, 1, 59, 'DMPNAS20170310IJ', 
    '200TX', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('3/10/2017 10:41:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('3/10/2017 10:32:59.326114 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9575, 226, 35, 432, '20170414215022TT3', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr5', 'testhdr5', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/14/2017 3:02:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '2111155512V129092', 'String', 'ACCEPTED', TO_TIMESTAMP('4/14/2017 10:46:52.162991 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9958, 568, 1, 61, 'DMPValid20170515IJ', 
    '200T2', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('5/15/2017 11:41:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('5/15/2017 2:19:56.630218 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (221, 24, 1, 60, '720161501', 
    '200T4', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/6/2016 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/14/2013 7:17:16.243287 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1322, 45, 107, 59, '11000000000t', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/24/2013 10:29:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130624152803 05 00', '3333333333V333333', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('6/24/2013 2:30:51.668276 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2622, 45, 1, 16, '201308131042', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/13/2013 5:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/13/2013 9:42:30.992438 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2623, 65, 1, 61, '500167373', 
    '200T2', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/13/2013 4:30:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567880V123457', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/13/2013 4:21:43.045940 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3726, 45, 1, 16, '201402031335', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/3/2014 10:35:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/3/2014 2:36:22.436374 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3930, 45, 1, 16, 'DEMOmar502187091000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/7/2014 2:35:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/7/2014 10:01:57.615744 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4131, 125, 35, 247, '20140604110723', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPT', 'testABC', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/4/2014 6:07:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009901', 
    'String', 'DISENROLLED', TO_TIMESTAMP('6/4/2014 1:10:36.718122 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4535, 65, 1, 226, 'A201308BZ', 
    '200T3', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('9/12/2014 5:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('9/12/2014 1:49:35.750882 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4544, 45, 1, 16, 'TSY201410280000004', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/29/2014 2:35:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('10/29/2014 2:21:36.380297 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5237, 125, 35, 247, '20141217115022TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/16/2014 6:50:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/17/2014 1:29:19.187473 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5247, 45, 1, 16, 'TSY0109201522222221', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/9/2015 2:35:00.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/9/2015 7:49:15.549005 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5538, 326, 35, 247, '20150219115022TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/19/2015 6:50:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/19/2015 2:32:58.817866 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7338, 45, 1, 16, '08102015000000002', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/11/2015 2:35:02.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'DELAYED', TO_TIMESTAMP('8/10/2015 8:43:53.777576 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7644, 366, 35, 61, 'DMP20151207IJ1', 
    '200T2', 'LOCALHOST', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('12/7/2015 10:41:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/7/2015 2:54:47.151818 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8241, 488, 35, 226, 'DMP20160815IJ', 
    '200T3', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('8/15/2016 11:41:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/15/2016 2:06:12.288941 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8248, 366, 35, 61, 'DMP20160817DTCE', 
    '200T2', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/17/2016 11:41:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/17/2016 2:27:14.226880 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8556, 488, 35, 226, 'DMP20161018dsV1', 
    '200T4', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('10/18/2016 11:41:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('10/18/2016 1:24:11.993846 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9152, 488, 35, 226, 'DMP20161222dsValidT1', 
    '200T1', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('12/22/2016 10:41:48.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/22/2016 9:49:26.030327 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9456, 528, 1, 452, '20170210115030TT', 
    '200T8', 'DNS         .DNS           ', 'DNS', '00001111', '402', 
    'USVHA', '2TRhdr21', '2PThdr2TT1', 'TTVENDOR5', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/8/2017 9:52:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'TT NAME', 'TT DEVICE', '20161020093703', 3161020.093703, 
    '1015155339V119939', '1.0', 'INCOMPLETE', TO_TIMESTAMP('2/10/2017 10:02:49.738760 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9561, 366, 1, 310, 'DMP20170306IJ', 
    '200T7', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('3/6/2017 10:41:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/6/2017 2:08:09.991436 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9862, 226, 35, 432, '20170511215022TT5', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr5', 'testhdr5', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('5/11/2017 1:02:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '2111155512V129092', 'String', 'ACCEPTED', TO_TIMESTAMP('5/11/2017 8:59:54.081394 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10658, 608, 35, 226, 'DMPValid20170830IJ', 
    '200T3', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/30/2017 12:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/30/2017 10:44:39.531138 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (217, 24, 1, 16, '110161399', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/23/2013 5:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20050621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/13/2013 1:35:13.657537 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (922, 45, 1, 59, 'JUNE24600000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2023 2:32:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('6/24/2013 9:01:49.482821 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2831, 45, 1, 16, 'aug273041000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2023 2:43:48.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/27/2013 8:21:35.990417 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2922, 45, 1, 16, 'oct305081000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/29/2013 2:32:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('10/29/2013 2:02:53.112187 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2923, 65, 1, 16, '500167371', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/30/2013 4:30:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567880V123457', 
    'String', 'ACCEPTED', TO_TIMESTAMP('10/30/2013 3:09:21.034311 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3022, 65, 1, 226, '500167372A', 
    '200T3', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/30/2013 4:30:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567880V123457', 
    'String', 'ACCEPTED', TO_TIMESTAMP('10/30/2013 4:23:58.333087 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3526, 125, 35, 247, '20140122111516', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPT', 'testABC', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/14/2014 6:17:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009901', 
    'String', 'DELAYED', TO_TIMESTAMP('1/22/2014 10:27:18.146765 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4541, 246, 35, 247, '20141027115023TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/27/2014 6:50:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('10/27/2014 11:18:18.904565 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4834, 125, 35, 247, '20141112115026TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/12/2014 6:55:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'DELAYED', TO_TIMESTAMP('11/12/2014 9:50:04.699316 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5243, 65, 1, 59, '20141223IJ', 
    '200TX', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/23/2014 5:41:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/23/2014 6:04:08.779191 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5539, 286, 1, 16, '201502201330tt', 
    '200T5', 'LOCALHOST', 'DNS', '000000026837', '402', 
    'USVHA', 'elmo', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/20/2015 10:33:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567844V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/20/2015 7:31:30.189507 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5549, 326, 35, 247, '20150306115023TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2015 6:51:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('3/6/2015 10:03:14.434147 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5556, 326, 35, 247, '20150306115030TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2015 6:51:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/6/2015 12:33:14.953998 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5558, 45, 1, 16, '03112015000001tsyDMP', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/11/2015 2:35:01.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/11/2015 11:55:41.321055 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7137, 45, 1, 16, '07292015000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/29/2015 2:35:01.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('7/29/2015 12:04:05.400349 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7138, 326, 35, 247, '20150729115022TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/29/2015 6:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('7/29/2015 1:25:37.259553 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7139, 45, 1, 16, '07312015000000007', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/31/2015 2:35:07.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('7/31/2015 2:57:51.343022 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8043, 45, 1, 16, '08082016000000001tsy', 
    '200T5', 'SERVER.      .URL       ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/20/2016 8:35:01.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/8/2016 8:11:14.177960 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8044, 65, 35, 16, 'DMP20160808000000MH', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('8/8/2016 1:00:00.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20160808000000', 3160808, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/8/2016 12:44:14.941662 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8045, 469, 1, 61, 'DMP20160808IJ', 
    '200T2', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('8/8/2016 11:41:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/8/2016 1:03:19.962377 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9571, 366, 1, 392, 'DMP20170309IJ', 
    '200T8', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('3/9/2017 10:41:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/9/2017 2:00:57.618322 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9574, 366, 1, 16, 'DMP20170310DTCE', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/10/2017 10:41:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/10/2017 2:20:12.186457 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9576, 45, 1, 16, '04142017000000003tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/14/2017 7:35:03.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('4/14/2017 12:46:06.232020 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9577, 65, 35, 16, 'DMP20170414154500MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('4/14/2017 4:45:00.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '201704141545', 3170414.1545, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('4/14/2017 2:48:01.331202 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9863, 65, 35, 16, 'DMP20170511161000MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('5/11/2017 5:10:00.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20170511161000', 3170511.161, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('5/11/2017 3:17:10.137846 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10358, 226, 35, 432, '20170719215022TT_dmp', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr5', 'testhdr5', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/19/2017 1:02:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '2111155512V129092', 'String', 'ACCEPTED', TO_TIMESTAMP('7/19/2017 1:29:35.336764 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (222, 24, 1, 60, '894168401', 
    '200T4', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/9/2016 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'Accepted', TO_TIMESTAMP('3/19/2013 3:53:35.635891 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1124, 45, 107, 59, '110001111111', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/24/2013 10:14:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130624151403 05 00', '3333333333V333333', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('6/24/2013 2:14:54.262827 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1527, 45, 107, 59, '11000000000115', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/3/2013 6:31:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130702085703 05 00', '3333333333V333333', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('7/3/2013 7:39:01.596275 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1825, 85, 107, 126, '110000000001011', 
    '200T8', 'LOCALHOST', 'DNS', '6789', '657', 
    'USVHA', 'FGHIK', 'ABCDE', 'String', TO_DATE('01/13/2013 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/8/2013 5:12:07.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130702085703 05 00', '3333355555V888888', 
    'String', 'ACCEPTED', TO_TIMESTAMP('7/8/2013 9:14:15.411766 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2522, 125, 107, 186, '20130813093800', 
    '200T8', 'LOCALHOST', 'DNS', '00003333', '657', 
    'USVHA', 'DUCK', 'DONALD', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/13/2013 4:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '1111155555V009900', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('8/13/2013 8:41:57.058185 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3124, 45, 1, 16, 'dec0910021000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/7/2023 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/7/2013 8:30:34.096937 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5537, 45, 1, 16, 'TSY0128201522222221', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/27/2015 2:35:01.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/27/2015 9:10:12.339879 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5550, 326, 35, 247, '20150306115026TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2015 6:51:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('3/6/2015 10:10:59.870540 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (6138, 45, 1, 16, '04202015000000022', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/20/2015 2:35:22.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('4/16/2015 7:30:43.401260 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8040, 326, 35, 432, '20160805115022TT', 
    '200T5', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/5/2016 12:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '9111155555V009905', 'String', 'ACCEPTED', TO_TIMESTAMP('8/5/2016 6:57:04.061319 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8554, 65, 35, 16, 'DMP201601017102000MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('10/17/2016 11:20:00.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20161017102000', 3161017.102, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('10/17/2016 9:20:11.274290 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8555, 45, 1, 16, '10182016000000001tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/18/2016 7:35:01.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('10/18/2016 8:10:43.699961 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8558, 366, 35, 310, 'DMP20161020IJ', 
    '200T7', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('10/20/2016 11:41:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('10/20/2016 1:28:50.804133 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9454, 65, 35, 16, 'DMP20170209000000MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('2/9/2017 12:00:00.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20170209000000', 3170209, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/9/2017 9:00:23.469292 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9458, 488, 35, 226, 'DMP20170217dsValidT1', 
    '200T1', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('2/17/2017 10:41:41.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/17/2017 11:56:58.687839 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9578, 185, 35, 392, 'DMPValid20170417IJ', 
    '200T8', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/17/2017 11:41:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('4/17/2017 9:22:04.873667 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (424, 45, 107, 59, '1100000008', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/1/2011 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130620084903 05 00', '3333333333V333333', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('6/20/2013 7:56:22.464486 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1522, 45, 107, 59, '11000000000112', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/2/2013 6:31:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130702085703 05 00', '3333333333V333333', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('7/2/2013 10:08:52.005912 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1622, 45, 107, 59, '11000000000113', 
    '200T5', 'LOCALHOST', 'DNS', '000000026952', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/3/2013 6:31:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130702085703 05 00', '3333333333V333333', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('7/2/2013 11:07:27.133950 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1623, 45, 107, 59, '11000000000245A', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/2/2013 6:40:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130702085703 05 00', '3333333333V333333', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('7/2/2013 11:58:41.014355 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5250, 45, 1, 16, 'TSY011220152323233', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/12/2015 9:20:03.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/12/2015 9:29:26.964541 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5251, 45, 1, 16, 'TSY011220152323235', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/12/2015 9:20:05.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/12/2015 9:39:18.910613 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5545, 45, 1, 16, '03032015000000001tsy', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/3/2015 2:36:01.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/3/2015 10:38:04.287591 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (6637, 45, 1, 16, '06232015000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/23/2015 2:35:01.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('6/23/2015 8:14:11.092247 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (6737, 45, 1, 16, '06252015000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/25/2015 2:35:01.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'DELAYED', TO_TIMESTAMP('6/25/2015 8:44:49.521519 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7647, 446, 1, 452, '20160125115030TT', 
    '200T8', 'LOCALHOST', 'DNS', '00001111', '402', 
    'USVHA', 'TRhdr2', 'PThdr2TT', 'TTVENDOR5', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/25/2016 11:52:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'TT NAME', 'TT DEVICE', '20130813093703', 3130813.093703, 
    '1015155333V119933', '1.0', 'NOT SUBMITTED', TO_TIMESTAMP('1/25/2016 7:36:24.463968 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7649, 45, 1, 16, '02102016000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/10/2016 7:35:01.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/10/2016 7:16:59.116048 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9453, 65, 35, 16, 'DMP20170208000000MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('2/8/2017 12:00:00.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20170208000000', 3170208, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/8/2017 9:07:53.262488 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9858, 488, 35, 226, 'DMP20170509dsValidT1', 
    '200T1', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('5/9/2017 11:41:42.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20170509104503', 3170509.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('5/9/2017 1:50:41.895654 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (323, 24, 1, 16, '500167499', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/27/2001 4:30:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567890V123456', 
    'String', 'Not submitted', TO_TIMESTAMP('3/26/2013 3:42:14.521314 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (622, 45, 107, 59, '1100000005', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '657', 
    'USVHA', 'hello1', 'HELLO1', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/6/2011 2:31:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130620075703 05 00', '3333333333V333333', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('6/20/2013 7:39:53.489955 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (1422, 65, 1, 59, '625A177399W', 
    '200T3', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/17/2010 5:30:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567890V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('6/25/2013 3:42:35.659116 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2524, 65, 1, 61, '500167370', 
    '200T2', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/13/2013 4:30:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567880V123457', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/13/2013 3:04:25.816723 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2827, 45, 1, 16, 'aug273001000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2023 2:41:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/27/2013 8:12:34.645892 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2828, 45, 1, 16, 'Aug278941000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2023 2:37:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/27/2013 8:13:16.160048 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (2829, 45, 1, 16, 'aug273011000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2023 2:42:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/27/2013 8:14:34.990656 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3228, 65, 1, 44, '500167370A', 
    '200T1', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/12/2013 4:30:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567880V123457', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/12/2013 3:39:52.210615 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3832, 45, 1, 16, '5001dec187091000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/10/2014 2:35:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/10/2014 3:19:42.582136 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4531, 45, 1, 16, 'DEMOAug187091000000102', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/17/2014 2:35:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'REFUSED', TO_TIMESTAMP('8/13/2014 10:21:05.602714 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4536, 208, 67, 247, '20140923115024TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '614', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('9/23/2014 6:50:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'REFUSED', TO_TIMESTAMP('9/23/2014 8:08:05.057416 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4538, 45, 1, 16, 'DEMOsep777333', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('5/23/2023 2:23:23.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('9/24/2014 9:06:43.021573 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4539, 45, 1, 16, 'DEMOsep777338', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/21/2020 2:21:21.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V777777', 
    'String', 'ACCEPTED', TO_TIMESTAMP('9/24/2014 9:28:22.692413 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5246, 45, 1, 16, 'TSY01072015000000002', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/7/2015 2:35:02.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('1/7/2015 12:46:21.163451 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5548, 65, 1, 44, 'DMP20150306IJ', 
    '200T1', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2015 5:41:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/6/2015 9:38:55.058104 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5553, 326, 35, 247, '20150306115028TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2015 6:51:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('3/6/2015 10:43:56.943822 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7639, 45, 1, 16, '11092015000000002', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/9/2015 7:35:02.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'DELAYED', TO_TIMESTAMP('11/9/2015 10:01:59.957541 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7650, 366, 35, 146, 'DMP20160211IJ', 
    '200T6', 'LOCALHOST', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('2/11/2016 10:41:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/11/2016 2:58:50.510773 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8552, 226, 35, 432, '20161013115022TT3', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr5', 'testhdr5', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/13/2016 3:02:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '2111155512V129092', 'String', 'ACCEPTED', TO_TIMESTAMP('10/13/2016 1:32:24.494504 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3935, 45, 1, 226, 'E201308131042', 
    '200T3', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/10/2014 9:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('3/10/2014 4:23:55.976983 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4029, 185, 1, 16, '201404091339tt', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/10/2014 10:33:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'NOT SUBMITTED', TO_TIMESTAMP('4/9/2014 1:45:39.254835 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4033, 125, 35, 247, '20140423101219', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPT', 'testABC', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/23/2014 5:07:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009901', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('4/23/2014 9:13:19.727362 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4231, 45, 1, 44, 'A201308131042A', 
    '200T1', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/10/2014 5:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('6/10/2014 12:34:58.758105 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4431, 45, 1, 16, 'DEMOdec187091000000001AR201', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/12/2014 2:35:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/12/2014 12:55:59.207747 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4432, 45, 1, 16, 'DEMOAug187091000000100', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/13/2014 2:35:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/13/2014 9:48:40.261553 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4435, 65, 1, 44, 'A2013081310421B', 
    '200T1', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/13/2014 5:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/13/2014 4:23:07.079256 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4633, 45, 1, 16, 'DEMOsep777799', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('5/5/2022 12:55:55.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('9/24/2014 8:43:40.618818 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4733, 45, 1, 16, 'TSY201410280000005', 
    '200T5', 'LOCALHOST', 'DNS', '00000000', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/29/2014 2:35:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('10/29/2014 2:25:43.450617 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4734, 125, 35, 247, '20141112115022TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/12/2014 6:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/12/2014 9:21:56.806843 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4735, 45, 1, 16, 'TSY187091000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('5/8/2013 2:35:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '1010101010V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/12/2014 9:45:12.785047 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4737, 45, 1, 16, 'TSY187091000000002', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('5/8/2013 2:35:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '1010101011V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/12/2014 9:50:18.002786 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4739, 45, 1, 16, 'TSY187091000000005', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/12/2014 2:33:33.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/12/2014 10:41:41.041638 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4837, 45, 1, 16, 'TSY20141113104104', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('5/8/2013 2:35:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20141113104104 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/13/2014 12:51:33.273917 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5438, 45, 1, 16, 'TSY01062015000000006', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/7/2015 2:35:06.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/6/2015 1:11:31.578480 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5642, 45, 1, 16, '02232015000000001tsy', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/23/2015 2:35:01.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/23/2015 9:24:32.913995 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5644, 45, 1, 16, '02232015000000002tsy', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/23/2015 2:35:02.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('2/23/2015 9:31:05.602757 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5648, 65, 1, 59, 'DMP20150303IJ', 
    '200TX', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/3/2015 5:41:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/3/2015 9:23:57.425454 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5657, 45, 1, 16, 'DMP0306201500001tsy', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2015 2:35:01.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/6/2015 9:28:48.165215 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5662, 326, 35, 247, '20150306115029TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2015 6:51:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('3/6/2015 12:31:21.694243 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5737, 45, 1, 16, '0316201500222', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/16/2015 2:35:22.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/16/2015 7:41:19.903952 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5837, 346, 1, 226, '625A177389x', 
    '200T3', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/17/2010 5:30:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567890V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/26/2015 3:44:13.006845 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (6240, 65, 1, 310, 'DMP20150416IJ', 
    '200T7', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/16/2015 7:41:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('4/16/2015 1:52:05.027121 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (6437, 45, 1, 16, '05132015000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('5/13/2015 2:35:01.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('5/13/2015 2:14:29.614586 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (6838, 45, 1, 16, '06252015000000002', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/25/2015 2:35:02.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('6/25/2015 8:49:26.665349 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7237, 326, 35, 247, '20150805115022TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/5/2015 6:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/5/2015 6:48:54.334162 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7242, 45, 1, 16, '08102015000000003', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/11/2015 2:35:03.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/10/2015 8:49:57.568941 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7243, 45, 1, 16, '08112015000000004', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/11/2015 2:35:04.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/11/2015 2:03:22.757206 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7439, 326, 35, 432, '20150917115022TT', 
    '200T5', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('9/17/2015 6:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('9/17/2015 7:02:43.971545 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7445, 326, 35, 432, '20150923115024TT', 
    '200T5', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/5/2015 6:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('9/23/2015 9:07:00.137330 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7538, 326, 35, 432, '20151104115022TT', 
    '200T5', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/4/2015 11:50:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/4/2015 1:27:19.540831 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7738, 426, 1, 452, '20151207115030TT', 
    '200T8', 'LOCALHOST', 'DNS', '00001111', '402', 
    'USVHA', 'TRhdr1', 'PThdr1TT', 'TTVENDOR5', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/6/2015 12:52:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'TT NAME', 'TT DEVICE', '20130813093703', 3130813.093703, 
    '9225155221V009912', '1.0', 'NOT SUBMITTED', TO_TIMESTAMP('12/7/2015 2:15:12.755292 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7837, 45, 1, 16, '01202016000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/20/2016 7:35:01.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/20/2016 3:08:52.398012 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7838, 45, 1, 16, '01222016000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/22/2016 7:35:01.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/22/2016 2:20:56.274212 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7839, 45, 1, 16, '01222016000000002', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/22/2016 7:35:02.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'DELAYED', TO_TIMESTAMP('1/22/2016 2:22:16.447059 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7841, 326, 35, 432, '20160210115022TT', 
    '200T5', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/10/2016 11:50:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '9111155555V009905', 'String', 'ACCEPTED', TO_TIMESTAMP('2/10/2016 7:26:12.343437 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7937, 45, 1, 16, '04142016000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/14/2016 8:35:01.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('4/14/2016 10:18:47.423486 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7938, 326, 35, 432, '20160414115022TT', 
    '200T5', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/14/2016 12:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '9111155555V009905', 'String', 'ACCEPTED', TO_TIMESTAMP('4/14/2016 10:19:47.871098 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8141, 326, 35, 432, '20160815115022TT', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/15/2016 12:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '9111155555V009905', 'String', 'ACCEPTED', TO_TIMESTAMP('8/15/2016 1:43:42.804305 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8142, 65, 35, 16, 'DMP20160815170000MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('8/15/2016 6:00:00.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20160815170000', 3160815.17, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/15/2016 3:51:53.583364 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8143, 65, 35, 16, 'DMP20160815000000MH', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('8/15/2016 1:00:00.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20160815000000', 3160815, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/15/2016 3:56:20.545663 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8148, 448, 1, 16, 'DMP20160823ds', 
    '200T4', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'Ms', 'Debbie', 'Shaffer', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('8/24/2016 12:41:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/24/2016 12:24:42.855737 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8453, 226, 35, 432, '20161013115022TT2', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr4', 'testhdr4', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/13/2016 10:02:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '9111155512V129099', 'String', 'ACCEPTED', TO_TIMESTAMP('10/13/2016 11:39:12.192245 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8652, 45, 1, 16, '11162016000000001tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/16/2016 6:35:01.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/16/2016 7:28:07.373075 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8654, 488, 35, 226, 'DMP20161116dsValidT1', 
    '200T1', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('11/16/2016 10:41:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/16/2016 8:44:56.847359 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8852, 488, 35, 226, 'DMP20161122dsValidT3', 
    '200T3', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('11/22/2016 10:41:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/22/2016 2:22:32.103112 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9053, 226, 35, 432, '2016122215022TT3', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr5', 'testhdr5', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/22/2016 2:02:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '2111155512V129092', 'String', 'ACCEPTED', TO_TIMESTAMP('12/22/2016 9:35:08.698257 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9659, 45, 1, 16, '03032017000000001tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/3/2017 6:35:01.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/3/2017 7:36:42.522512 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9660, 488, 35, 226, 'DMP20170303dsValidT5', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('3/3/2017 10:41:41.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/3/2017 8:23:17.347496 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9662, 448, 1, 16, 'DMP20170303dsErT5', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'Ms', 'Debbie', 'Shaffer', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/15/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('3/3/2017 10:46:43.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/3/2017 1:02:27.562843 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9665, 448, 1, 16, 'DMP20170306dsErT1', 
    '200T1', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'Ms', 'Debbie', 'Shaffer', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/15/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('3/6/2017 10:46:43.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/6/2017 10:38:39.208577 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9675, 226, 35, 432, '20170412215022TT3', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr5', 'testhdr5', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/12/2017 3:02:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '2111155512V129092', 'String', 'ACCEPTED', TO_TIMESTAMP('4/12/2017 7:49:25.393789 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9682, 226, 35, 432, '20170414215022TT5', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr5', 'testhdr5', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/14/2017 1:02:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '2111155512V129092', 'String', 'ACCEPTED', TO_TIMESTAMP('4/14/2017 12:27:45.896710 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9686, 549, 1, 452, '20170418115030TT', 
    '200T8', 'DNS         .DNS           ', 'DNS', '00001111', '402', 
    'USVHA', '2TRhdr21', '2PThdr2TT1', 'TTVENDOR5', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/18/2017 10:52:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'TT NAME', 'TT DEVICE', '20161020093703', 3161020.093703, 
    '1015155339V119939', '1.0', 'INCOMPLETE', TO_TIMESTAMP('4/18/2017 9:45:49.758008 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9760, 549, 1, 452, '20170511115030TT', 
    '200T8', 'DNS         .DNS           ', 'DNS', '00001111', '402', 
    'USVHA', '2TRhdr21', '2PThdr2TT1', 'TTVENDOR5', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('5/11/2017 10:52:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'TT NAME', 'TT DEVICE', '20161020093703', 3161020.093703, 
    '1015155339V119939', '1.0', 'REFUSED', TO_TIMESTAMP('5/11/2017 7:09:16.567552 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10264, 488, 35, 226, 'DMP20170821dsBValidT5', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('8/21/2017 12:42:42.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20170821104504', 3170821.104504, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/21/2017 3:23:56.285718 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10562, 65, 35, 16, 'DMP20170830133000MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('8/30/2017 3:30:00.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20170830133000', 3170830.133, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/30/2017 1:40:52.898028 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4032, 45, 1, 44, '201308131042DE', 
    '200T1', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/22/2014 5:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('4/22/2014 12:25:54.734952 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4232, 45, 1, 16, 'A201308131042D', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/11/2014 9:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('6/10/2014 1:24:54.470535 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4329, 205, 35, 247, '20140708115022t', 
    '200TX', 'LOCALHOST', 'DNS', '00002333', '613', 
    'USVHA', 'TESTPThdrII', 'testhdrII', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/8/2014 6:50:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155444V000066', 
    'String', 'NOT SUBMITTED', TO_TIMESTAMP('7/8/2014 8:59:19.385252 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4434, 226, 107, 331, '20140813115027TT', 
    '200T3', 'LOCALHOST', 'DNS', '00003333', '657', 
    'USVHA', 'TESTPThd1r', 'testhdr1', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/13/2014 6:50:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155512V129098', 
    'String', 'DELAYED', TO_TIMESTAMP('8/13/2014 1:59:31.819620 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4632, 208, 35, 247, '20140923115027TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('9/23/2014 6:50:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'REFUSED', TO_TIMESTAMP('9/23/2014 8:10:58.225535 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4740, 45, 1, 16, 'TSYnov122014000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/12/2014 2:31:11.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/12/2014 12:09:07.482491 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4741, 45, 1, 16, 'TSYnov122014000002', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/12/2014 2:31:12.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('11/12/2014 12:14:19.115193 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5138, 185, 1, 16, '201412021330tt', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/2/2014 10:33:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'DELAYED', TO_TIMESTAMP('12/2/2014 1:18:40.008565 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5437, 45, 1, 16, 'TSY01062015000000002', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/7/2015 2:35:02.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/6/2015 12:10:44.461866 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5639, 45, 1, 16, '02202015000000001tsy', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/20/2015 2:35:01.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/20/2015 10:26:41.009587 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5649, 45, 1, 16, '03032015000000002tsy', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/3/2015 2:36:02.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/3/2015 10:42:46.210735 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5651, 45, 1, 16, '02042015002tsy', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/20/2015 2:02:02.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/4/2015 2:44:31.986014 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5652, 45, 1, 16, '02042015003tsy', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/20/2015 2:02:03.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/4/2015 2:47:46.896442 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5656, 45, 1, 16, '03062015000000001tsy', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2015 2:35:01.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/6/2015 7:57:50.393228 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5661, 326, 35, 247, '20150306115027TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2015 6:51:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('3/6/2015 10:29:03.334417 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5663, 45, 1, 16, '03112015000002tsyDMP', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/11/2015 2:35:02.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/11/2015 2:55:31.407237 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5665, 45, 1, 16, '0313201500222', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/13/2015 2:35:22.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/13/2015 11:23:48.372554 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5738, 45, 1, 16, '0316201500228', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/16/2015 2:35:28.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'DELAYED', TO_TIMESTAMP('3/16/2015 9:53:52.674012 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (6037, 45, 1, 16, '041420150000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/14/2015 2:35:01.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('4/14/2015 1:05:18.997833 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (6237, 326, 35, 247, '20150416115022TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/16/2015 6:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('4/16/2015 7:14:15.095797 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (6238, 326, 35, 247, '20150416115024TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/16/2015 8:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'COMPLETE', TO_TIMESTAMP('4/16/2015 12:07:33.796983 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (6538, 366, 35, 226, 'DMP20150624IJ', 
    '200T3', 'LOCALHOST', 'DNS', '000000026827', '613', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/24/2015 5:41:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('6/24/2015 11:32:58.499205 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (6937, 326, 35, 247, '20150626115022TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/26/2015 6:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'DISENROLLED', TO_TIMESTAMP('6/26/2015 7:15:16.114296 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7238, 45, 1, 16, '08052015000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/5/2015 2:35:01.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/5/2015 7:42:30.449240 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7437, 45, 1, 16, '09142015000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('9/14/2015 2:35:01.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('9/14/2015 1:36:36.590753 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7443, 326, 35, 432, '20150923115023TT', 
    '200T5', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/5/2015 6:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('9/23/2015 7:15:01.471521 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7539, 406, 10, 452, '20151105115030TT', 
    '200T8', 'LOCALHOST', 'DNS', '00001111', '528A5', 
    'USVHA', 'TRANhdr2', 'PThdr2', 'TTVENDOR5', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/5/2015 11:52:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'TT NAME', 'TT DEVICE', '20130813093703 05 00', '9221555222V009922', 
    '1.0', 'NOT SUBMITTED', TO_TIMESTAMP('11/5/2015 7:11:47.999403 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7737, 45, 1, 16, '12022015000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/2/2015 7:35:01.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/2/2015 1:27:45.329988 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8144, 508, 35, 432, '20160816115022TT', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/16/2016 12:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '9111155555V000056', 'String', 'ACCEPTED', TO_TIMESTAMP('8/16/2016 6:56:29.823784 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8145, 45, 1, 16, '08162016000000001tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/16/2016 8:35:01.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/16/2016 7:54:06.658137 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8147, 45, 1, 16, '08172016000000002tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/17/2016 8:35:02.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/17/2016 12:25:16.592866 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8252, 226, 35, 432, '20160921115022TT2', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr4', 'testhdr4', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('9/21/2016 10:02:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '9111155512V129099', 'String', 'ACCEPTED', TO_TIMESTAMP('9/21/2016 3:05:53.546712 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8455, 448, 1, 146, 'DMP20161018dz', 
    '200T6', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ms', 'Debbie', 'Shaffer', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('10/18/2016 12:47:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('10/18/2016 12:10:11.787262 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8656, 326, 35, 247, '20161116115022TT', 
    '200TX', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/16/2016 11:50:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'DISENROLLED', TO_TIMESTAMP('11/16/2016 11:17:12.176075 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8657, 65, 35, 16, 'DMP20161116140000MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('11/16/2016 2:00:00.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20161116140000', 3161116.14, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/16/2016 2:50:32.217126 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9052, 45, 1, 16, '12222016000000001tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/22/2016 6:35:01.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/22/2016 9:20:18.275667 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9352, 45, 1, 16, '02082017000000001tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/8/2017 6:35:01.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/8/2017 8:06:09.165545 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9353, 226, 35, 432, '20170208215022TT3', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr5', 'testhdr5', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/8/2017 2:02:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '2111155512V129092', 'String', 'ACCEPTED', TO_TIMESTAMP('2/8/2017 8:27:33.301340 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9355, 488, 35, 226, 'DMP20170208dsValidT7', 
    '200T7', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('2/8/2017 10:41:49.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/8/2017 8:38:04.855359 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9661, 488, 35, 226, 'DMP20170303dsValidT1', 
    '200T1', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('3/3/2017 10:41:42.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/3/2017 8:39:06.024515 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9663, 548, 35, 3, '20170222115026TT_dmp7', 
    '200T3', 'DNS         .DNS           ', 'DNS', '00003334', '613', 
    'USVHA', 'TESTTRIN2', 'hdrPT2', 'Stmr12', TO_DATE('08/22/1990 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/22/2017 10:39:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'Steee1', 'St1234', '201610260937030500', 3161026.09370305, 
    '1121155556V009809', 'v1.0', 'ACCEPTED', TO_TIMESTAMP('3/3/2017 1:24:00.870607 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9668, 65, 35, 16, 'DMP20170308000000MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('3/8/2017 12:00:00.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '201703080000', 3170308, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/8/2017 7:48:01.789891 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9673, 65, 35, 16, 'DMP20170310140000MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('3/10/2017 2:00:00.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '201703101400', 3170310.14, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/10/2017 2:19:04.963748 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9676, 45, 1, 16, '04122017000000001tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/12/2017 7:35:01.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('4/12/2017 8:01:07.659918 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9678, 45, 1, 16, '04142017000000002tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/14/2017 7:35:02.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('4/14/2017 10:50:12.363134 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9684, 65, 35, 16, 'DMP20170417000000MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('4/17/2017 1:00:00.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '201704170000', 3170417, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('4/17/2017 2:57:08.036412 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10158, 45, 1, 16, '05242017000000001tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('5/24/2017 7:35:01.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('5/24/2017 3:12:20.304933 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10160, 488, 35, 226, 'DMP20170524dsValidT5', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('5/24/2017 11:41:44.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20170524104503', 3170524.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('5/24/2017 3:17:27.099346 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10258, 45, 1, 16, '07192017000000002tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/19/2017 7:35:02.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('7/19/2017 1:23:36.597258 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10262, 326, 35, 247, '20170720115022TT', 
    '200TX', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/20/2017 12:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'DISENROLLED', TO_TIMESTAMP('7/20/2017 9:18:59.663205 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10558, 45, 1, 16, '08282017000000002tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/28/2017 8:35:02.000000 AM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/28/2017 7:47:01.521690 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10559, 488, 35, 226, 'DMP20170828dsValidT5', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('8/28/2017 12:41:42.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20170828104503', 3170828.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/28/2017 8:19:19.851300 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10561, 588, 1, 452, '201708291115030TT', 
    '200T8', 'DNS         .DNS           ', 'DNS', '00001111', '402', 
    'USVHA', '2TRhdr21', '2PThdr2TT1', 'TTVENDOR5', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/29/2017 11:52:47.000000 AM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'TT NAME', 'TT DEVICE', '20161020093703', 3161020.093703, 
    '1015155339V119939', '1.0', 'DELAYED', TO_TIMESTAMP('8/29/2017 9:12:05.199336 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3934, 45, 1, 16, '90090907091000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/12/2014 2:35:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/10/2014 3:31:46.200582 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (3939, 45, 1, 44, '201403141042C', 
    '200T1', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/4/2014 5:41:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20140313104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/13/2014 8:51:07.046310 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4030, 125, 35, 247, '20140418110719', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPT', 'testABC', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/17/2014 6:07:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009901', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('4/18/2014 11:29:02.846677 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4031, 185, 1, 16, '201404211330tt', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'KITTY', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/21/2014 10:33:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'DELAYED', TO_TIMESTAMP('4/21/2014 12:53:09.198779 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4229, 125, 35, 247, '20140602110720T', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPT', 'testABC', 'String', TO_DATE('08/22/1980 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/2/2014 6:07:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('6/2/2014 7:26:06.479847 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4330, 65, 1, 60, 'A2013081310421', 
    '200T4', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/8/2014 5:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('7/8/2014 2:29:21.403483 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4331, 65, 1, 226, 'A2013081310421A', 
    '200T3', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/4/2014 5:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'COMPLETE', TO_TIMESTAMP('7/8/2014 3:07:07.060451 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4631, 65, 1, 16, 'A123456789BZ', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('9/16/2014 5:41:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('9/16/2014 11:57:05.777724 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (4738, 45, 1, 16, 'TSY187091000000004', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/12/2014 2:35:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/12/2014 10:21:45.764915 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5137, 45, 1, 16, 'TSY120214000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 05:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/2/2014 2:35:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('12/2/2014 1:03:22.932348 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5337, 266, 35, 247, '20141218115022TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('12/18/2014 6:50:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'DELAYED', TO_TIMESTAMP('12/18/2014 10:27:17.990746 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5439, 45, 1, 16, 'TSY01072015000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/7/2015 2:35:01.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/7/2015 12:44:54.042637 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5440, 45, 1, 16, 'TSY01072015000000003', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/7/2015 2:35:03.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/7/2015 12:51:29.050359 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5442, 45, 1, 16, 'TSY01082015222221', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/8/2015 2:55:05.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('1/8/2015 8:02:31.591033 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5443, 286, 1, 16, '201401091330tt', 
    '200T5', 'LOCALHOST', 'DNS', '000000026837', '402', 
    'USVHA', 'elmo', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/9/2014 10:33:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567844V123456', 
    'String', 'DELAYED', TO_TIMESTAMP('1/9/2015 10:28:11.101490 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5444, 45, 1, 16, 'TSY011220152323234', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('1/12/2015 9:20:04.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'INCOMPLETE', TO_TIMESTAMP('1/12/2015 9:35:32.990880 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5637, 45, 1, 16, 'TSY02192015000000022', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/19/2015 2:35:22.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/19/2015 1:31:05.850092 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5638, 65, 1, 226, 'DMP20150219IJ', 
    '200T3', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/19/2015 5:41:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/19/2015 4:21:59.921950 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5640, 326, 35, 247, '20150220115023TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/20/2015 6:50:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/20/2015 11:36:16.550478 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5645, 65, 1, 392, 'DMP20150225DTCE', 
    '200T8', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/25/2015 5:41:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/25/2015 1:25:33.029977 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5646, 326, 35, 247, '20150330115030TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/30/2015 6:52:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009999', 
    'String', 'DISENROLLED', TO_TIMESTAMP('3/3/2015 8:44:31.270201 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5653, 45, 1, 16, '02042015006tsy', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/20/2015 2:02:06.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/4/2015 2:52:17.104561 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5655, 326, 35, 247, '20150306115022TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2015 6:50:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/6/2015 5:58:36.213816 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5658, 326, 35, 247, '20150306115025TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/6/2015 6:51:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'REFUSED-TIME-OUT', TO_TIMESTAMP('3/6/2015 10:12:54.607039 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5664, 125, 1, 16, 'DMP20150313IJ', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/13/2015 5:41:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/13/2015 11:18:38.893780 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5739, 45, 1, 16, '0316201500229', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/16/2015 2:35:29.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/16/2015 9:55:27.914672 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (5938, 346, 1, 226, '625A170001x', 
    '200T3', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'TIM', 'HUMBUG', 'String', TO_DATE('08/13/1967 06:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/17/2010 5:30:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567890V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('3/27/2015 8:11:46.446417 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (6537, 326, 35, 247, '20150623115022TT', 
    '200TX', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('6/23/2015 6:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('6/23/2015 6:49:23.605726 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7037, 45, 1, 16, '07072015000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/7/2015 2:35:01.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('7/7/2015 10:11:26.323215 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7239, 386, 10, 412, '20150806115030TT', 
    '200T5', 'LOCALHOST', 'DNS', '00001111', '528A5', 
    'USVHA', 'TRANhdr1', 'PATIENThdr1', 'TTVENDOR5', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/6/2015 6:52:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'TT NAME', 'TT DEVICE', '20130813093703 05 00', '9221555221V009921', 
    '1.0', 'NOT SUBMITTED', TO_TIMESTAMP('8/6/2015 7:30:59.802272 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7240, 65, 35, 146, 'DMP20150806IJ', 
    '200T6', 'LOCALHOST', 'DNS', '000000026827', '613', 
    'USVHA', 'Ira', 'Joshi', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/6/2015 7:41:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20040621104503 05 00', '1234567891V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/6/2015 1:21:39.897731 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7438, 45, 1, 16, '09142015000000002', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('9/14/2015 2:35:02.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'DELAYED', TO_TIMESTAMP('9/14/2015 2:17:57.723380 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7440, 326, 35, 432, '20150917115023TT', 
    '200T5', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('9/17/2015 6:51:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130813093703 05 00', '9111155555V009905', 
    'String', 'ACCEPTED', TO_TIMESTAMP('9/17/2015 7:04:06.756528 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7441, 45, 1, 16, '09172015000000045', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('9/17/2015 2:35:45.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('9/17/2015 11:43:06.087432 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7442, 45, 1, 16, '09172015000000046', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('9/17/2015 2:35:46.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('9/17/2015 11:51:33.269196 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7537, 45, 1, 16, '11042015000000001', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/4/2015 7:35:01.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/4/2015 1:15:32.716794 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (7842, 45, 1, 16, '02172016000000004', 
    '200T5', 'LOCALHOST', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('2/17/2016 7:35:04.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/17/2016 12:54:13.028732 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8140, 326, 35, 432, '20160811115022TT', 
    '200T5', 'LOCALHOST', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr', 'testhdr', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/11/2016 12:50:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '9111155555V009905', 'String', 'ACCEPTED', TO_TIMESTAMP('8/11/2016 2:41:10.320815 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8146, 509, 1, 452, '20160816115030TT', 
    '200T8', 'DNS         .DNS           ', 'DNS', '00001111', '402', 
    'USVHA', '2TRhdr2', '2PThdr2TT', 'TTVENDOR5', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('8/16/2016 10:52:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'TT NAME', 'TT DEVICE', '20130813093703', 3130813.093703, 
    '1015155333V119938', '1.0', 'COMPLETE', TO_TIMESTAMP('8/16/2016 8:12:36.924371 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8253, 45, 1, 16, '09212016000000001tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('9/21/2016 8:35:01.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('9/21/2016 3:27:36.159054 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8452, 45, 1, 16, '10132016000000001tsy', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '402', 
    'USVHA', 'hello', 'HELLO', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('10/13/2016 8:35:01.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '20130614104503 05 00', '2222222222V123400', 
    'String', 'ACCEPTED', TO_TIMESTAMP('10/13/2016 11:07:40.172282 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8454, 488, 35, 226, 'DMP20161013dsV2', 
    '200T4', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('10/13/2016 11:41:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('10/13/2016 12:20:13.089773 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8456, 65, 35, 16, 'DMP201601018133000MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('10/18/2016 2:30:00.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20161018133000', 3161018.133, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('10/18/2016 1:12:24.063374 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8653, 226, 35, 432, '2016111615022TT3', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr5', 'testhdr5', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('11/16/2016 2:02:47.000000 PM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '2111155512V129092', 'String', 'ACCEPTED', TO_TIMESTAMP('11/16/2016 8:06:35.518384 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8655, 65, 35, 16, 'DMP20161116110000MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('11/16/2016 11:00:00.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20161116110000', 3161116.11, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/16/2016 10:12:21.184395 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (8658, 125, 35, 61, 'DMP20161118IJ', 
    '200T2', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('11/18/2016 10:41:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('11/18/2016 1:47:11.241005 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9354, 488, 35, 226, 'DMP20170208dsValidT1', 
    '200T1', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('2/8/2017 10:41:48.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20040621104503', 3040621.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('2/8/2017 8:30:42.870353 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9667, 549, 1, 452, '20170307115030TT', 
    '200T8', 'DNS         .DNS           ', 'DNS', '00001111', '402', 
    'USVHA', '2TRhdr21', '2PThdr2TT1', 'TTVENDOR5', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('3/7/2017 9:52:47.000000 AM -07:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'TT NAME', 'TT DEVICE', '20161020093703', 3161020.093703, 
    '1015155339V119939', '1.0', 'INCOMPLETE', TO_TIMESTAMP('3/7/2017 8:49:05.045901 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9674, 548, 35, 3, '20170412115026TT_dmp7', 
    '200T3', 'DNS         .DNS           ', 'DNS', '00003334', '613', 
    'USVHA', 'TESTTRIN2', 'hdrPT2', 'Stmr12', TO_DATE('08/22/1990 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('4/12/2017 11:39:47.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'Steee1', 'St1234', '201610260937030500', 3161026.09370305, 
    '1121155556V009809', 'v1.0', 'ACCEPTED', TO_TIMESTAMP('4/12/2017 7:18:54.155489 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, ICN, XML_VERSION, 
    RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9677, 488, 35, 226, 'DMP20170412dsValidT1', 
    '200T1', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('4/12/2017 11:41:43.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20170412z04503', '1234567821V123456', 'String', 
    'ACCEPTED', TO_TIMESTAMP('4/12/2017 8:45:30.034261 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (9758, 226, 35, 432, '20170509215022TT5', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr5', 'testhdr5', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('5/9/2017 1:02:47.000000 PM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '2111155512V129092', 'String', 'ACCEPTED', TO_TIMESTAMP('5/9/2017 1:34:14.936525 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10259, 488, 35, 226, 'DMP20170719dsValidT5', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Ira', 'Joshi', 'Test', 
    'Nurse', 'N', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('7/19/2017 11:41:42.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20170719104503', 3170719.104503, '1234567821V123456', 
    'String', 'ACCEPTED', TO_TIMESTAMP('7/19/2017 1:30:33.774055 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10260, 65, 35, 16, 'DMP20170720081600MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('7/20/2017 9:16:00.000000 AM -06:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20170720081600', 3170720.0816, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('7/20/2017 7:18:02.940863 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, VENDOR_MRN, SCHEDULED_DT, 
    COMPLETED_DT, PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, 
    ICN, XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10263, 226, 35, 432, '20170727215022TT_dmp', 
    '200T5', 'DNS         .DNS           ', 'DNS', '00003333', '613', 
    'USVHA', 'TESTPThdr5', 'testhdr5', 'String', TO_DATE('08/22/1980 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), 
    TO_TIMESTAMP_TZ('7/27/2017 2:02:47.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 'String', 'String', '201308130937030500', 3130813.09370305, 
    '2111155512V129092', 'String', 'ACCEPTED', TO_TIMESTAMP('7/27/2017 2:13:06.050716 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_RESPONSE
   (DMP_RESPONSE_ID, SURVEY_ID, FACILITY_ID, VENDOR_ID, REQUEST_ID, 
    RECORDSOURCE_NAMESPACEID, RECORDSOURCE_UNIVERSALID, RECORDSOURCE_UNIVERSTYP, PATIENT_IDENTITY, PATIENT_ASSIGNING_FACILITY, 
    PATIENT_ASSIGNING_AUTHORITY, PATIENT_NAME_PREFIX, PATIENT_NAME_GIVEN, PATIENT_NAME_FAMILY, PATIENT_NAME_SUFFIX, 
    PATIENT_NAME_TITLE, PATIENT_NAME_MIDDLE, VENDOR_MRN, SCHEDULED_DT, COMPLETED_DT, 
    PROGRAM_NAME, DEVICE_NAME, RECORD_CREATION_TM, RECORD_CREATION_TM_NBR, ICN, 
    XML_VERSION, RESPONSE_STATUS, MESSAGE_INSERTION_TIME)
 Values
   (10560, 65, 35, 16, 'DMP20170828162300MH', 
    '200T5', 'DNS         .DNS           ', 'DNS', '000000026827', '613', 
    'USVHA', 'Ms', 'Marcy', 'Hulsey', 'Test', 
    'Nurse', 'M', 'String', TO_DATE('08/13/1967 00:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_TIMESTAMP_TZ('8/28/2017 6:23:00.000000 PM -05:00','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM TZH:TZM'), 
    'String', 'String', '20170828162300', 3170828.1623, '1012136799V636901', 
    'String', 'ACCEPTED', TO_TIMESTAMP('8/28/2017 3:27:37.380764 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
COMMIT;


/******************************************************************************
	Add DMP Question Answer
******************************************************************************/


SET DEFINE OFF;
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (13, 205, 1, 0, 0, 
    TO_TIMESTAMP('3/4/2013 12:49:55.575347 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (14, 205, 2, 0, 1, 
    TO_TIMESTAMP('3/4/2013 12:49:55.575347 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (15, 205, 3, 0, 2, 
    TO_TIMESTAMP('3/4/2013 12:49:55.575347 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (16, 206, 1, 0, 0, 
    TO_TIMESTAMP('3/4/2013 1:06:37.401654 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (17, 206, 2, 0, 1, 
    TO_TIMESTAMP('3/4/2013 1:06:37.401654 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (18, 206, 3, 0, 2, 
    TO_TIMESTAMP('3/4/2013 1:06:37.401654 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (101, 105, 1, 0, 0, 
    TO_TIMESTAMP('3/4/2013 1:10:55.637879 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (102, 105, 2, 0, 1, 
    TO_TIMESTAMP('3/4/2013 1:10:55.637879 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (103, 105, 3, 0, 2, 
    TO_TIMESTAMP('3/4/2013 1:10:55.637879 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2131, 3225, 1, 0, 0, 
    TO_TIMESTAMP('12/12/2013 9:40:29.449451 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2132, 3225, 2, 0, 1, 
    TO_TIMESTAMP('12/12/2013 9:40:29.449451 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2133, 3225, 3, 0, 2, 
    TO_TIMESTAMP('12/12/2013 9:40:29.449451 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2137, 3227, 1, 0, 0, 
    TO_TIMESTAMP('12/12/2013 10:28:55.112403 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2138, 3227, 2, 0, 1, 
    TO_TIMESTAMP('12/12/2013 10:28:55.112403 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2139, 3227, 3, 0, 2, 
    TO_TIMESTAMP('12/12/2013 10:28:55.112403 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3046, 4231, 1, 0, 0, 
    TO_TIMESTAMP('6/10/2014 12:34:58.857183 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3047, 4231, 2, 0, 1, 
    TO_TIMESTAMP('6/10/2014 12:34:58.857183 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3048, 4231, 3, 0, 2, 
    TO_TIMESTAMP('6/10/2014 12:34:58.857183 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3243, 4431, 1, 0, 0, 
    TO_TIMESTAMP('8/12/2014 12:55:59.249379 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3244, 4431, 2, 0, 1, 
    TO_TIMESTAMP('8/12/2014 12:55:59.249379 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3245, 4431, 3, 0, 2, 
    TO_TIMESTAMP('8/12/2014 12:55:59.249379 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3246, 4432, 1, 0, 0, 
    TO_TIMESTAMP('8/13/2014 9:48:40.332534 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3247, 4432, 2, 0, 1, 
    TO_TIMESTAMP('8/13/2014 9:48:40.332534 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3248, 4432, 3, 0, 2, 
    TO_TIMESTAMP('8/13/2014 9:48:40.332534 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3552, 4735, 1, 0, 0, 
    TO_TIMESTAMP('11/12/2014 9:45:12.787617 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3553, 4735, 2, 0, 1, 
    TO_TIMESTAMP('11/12/2014 9:45:12.787617 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3554, 4735, 3, 0, 2, 
    TO_TIMESTAMP('11/12/2014 9:45:12.787617 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4058, 5239, 1, 0, 0, 
    TO_TIMESTAMP('12/19/2014 7:53:14.206092 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4059, 5239, 2, 0, 1, 
    TO_TIMESTAMP('12/19/2014 7:53:14.206092 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4060, 5239, 3, 0, 2, 
    TO_TIMESTAMP('12/19/2014 7:53:14.206092 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4358, 5638, 1, 0, 0, 
    TO_TIMESTAMP('2/19/2015 4:22:00.048567 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4359, 5638, 2, 0, 1, 
    TO_TIMESTAMP('2/19/2015 4:22:00.048567 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4360, 5638, 3, 0, 2, 
    TO_TIMESTAMP('2/19/2015 4:22:00.048567 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4955, 6137, 1, 2, 0, 
    TO_TIMESTAMP('4/14/2015 1:17:56.624307 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4956, 6137, 2, 2, 1, 
    TO_TIMESTAMP('4/14/2015 1:17:56.624307 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4957, 6137, 3, 3, 2, 
    TO_TIMESTAMP('4/14/2015 1:17:56.624307 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5361, 6639, 1, 2, 0, 
    TO_TIMESTAMP('6/23/2015 12:13:29.700939 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5362, 6639, 2, 2, 1, 
    TO_TIMESTAMP('6/23/2015 12:13:29.700939 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5363, 6639, 3, 3, 2, 
    TO_TIMESTAMP('6/23/2015 12:13:29.700939 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6258, 7638, 1, 0, 0, 
    TO_TIMESTAMP('11/9/2015 9:55:57.904492 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6259, 7638, 2, 0, 1, 
    TO_TIMESTAMP('11/9/2015 9:55:57.904492 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6260, 7638, 3, 0, 2, 
    TO_TIMESTAMP('11/9/2015 9:55:57.904492 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6261, 7640, 1, 2, 0, 
    TO_TIMESTAMP('12/2/2015 1:25:35.289655 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6262, 7640, 2, 2, 1, 
    TO_TIMESTAMP('12/2/2015 1:25:35.289655 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6263, 7640, 3, 3, 2, 
    TO_TIMESTAMP('12/2/2015 1:25:35.289655 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6267, 7643, 1, 0, 0, 
    TO_TIMESTAMP('12/7/2015 2:47:19.257008 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6268, 7643, 2, 0, 1, 
    TO_TIMESTAMP('12/7/2015 2:47:19.257008 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6269, 7643, 3, 0, 2, 
    TO_TIMESTAMP('12/7/2015 2:47:19.257008 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6467, 7842, 1, 0, 0, 
    TO_TIMESTAMP('2/17/2016 12:54:13.100089 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6468, 7842, 2, 0, 1, 
    TO_TIMESTAMP('2/17/2016 12:54:13.100089 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6469, 7842, 3, 0, 2, 
    TO_TIMESTAMP('2/17/2016 12:54:13.100089 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6558, 7938, 1, 2, 0, 
    TO_TIMESTAMP('4/14/2016 10:19:47.914568 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6559, 7938, 2, 2, 1, 
    TO_TIMESTAMP('4/14/2016 10:19:47.914568 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6560, 7938, 3, 3, 2, 
    TO_TIMESTAMP('4/14/2016 10:19:47.914568 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6897, 8252, 1, 2, 0, 
    TO_TIMESTAMP('9/21/2016 3:05:53.621370 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6898, 8252, 2, 2, 1, 
    TO_TIMESTAMP('9/21/2016 3:05:53.621370 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6899, 8252, 3, 3, 2, 
    TO_TIMESTAMP('9/21/2016 3:05:53.621370 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8333, 9665, 1, 0, 0, 
    TO_TIMESTAMP('3/6/2017 10:38:39.286616 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8334, 9665, 2, 0, 1, 
    TO_TIMESTAMP('3/6/2017 10:38:39.286616 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8335, 9665, 3, 0, 2, 
    TO_TIMESTAMP('3/6/2017 10:38:39.286616 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8360, 9675, 1, 2, 0, 
    TO_TIMESTAMP('4/12/2017 7:49:25.435403 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8361, 9675, 2, 2, 1, 
    TO_TIMESTAMP('4/12/2017 7:49:25.435403 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8362, 9675, 3, 3, 2, 
    TO_TIMESTAMP('4/12/2017 7:49:25.435403 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9215, 10559, 1, 0, 0, 
    TO_TIMESTAMP('8/28/2017 8:19:19.853373 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9216, 10559, 2, 0, 1, 
    TO_TIMESTAMP('8/28/2017 8:19:19.853373 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9217, 10559, 3, 0, 2, 
    TO_TIMESTAMP('8/28/2017 8:19:19.853373 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7, 203, 1, 0, 0, 
    TO_TIMESTAMP('3/4/2013 11:27:49.150364 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8, 203, 2, 0, 1, 
    TO_TIMESTAMP('3/4/2013 11:27:49.150364 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9, 203, 3, 0, 2, 
    TO_TIMESTAMP('3/4/2013 11:27:49.150364 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (10, 204, 1, 0, 0, 
    TO_TIMESTAMP('3/4/2013 12:43:20.873792 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (11, 204, 2, 0, 1, 
    TO_TIMESTAMP('3/4/2013 12:43:20.873792 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (12, 204, 3, 0, 2, 
    TO_TIMESTAMP('3/4/2013 12:43:20.873792 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (22, 208, 1, 0, 0, 
    TO_TIMESTAMP('3/4/2013 1:58:41.181378 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (23, 208, 2, 0, 1, 
    TO_TIMESTAMP('3/4/2013 1:58:41.181378 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (24, 208, 3, 0, 2, 
    TO_TIMESTAMP('3/4/2013 1:58:41.181378 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (134, 225, 1, 0, 0, 
    TO_TIMESTAMP('4/2/2013 12:56:15.531991 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (135, 225, 2, 0, 1, 
    TO_TIMESTAMP('4/2/2013 12:56:15.531991 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (136, 225, 3, 0, 2, 
    TO_TIMESTAMP('4/2/2013 12:56:15.531991 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (425, 1223, 1, 0, 0, 
    TO_TIMESTAMP('6/24/2013 2:26:04.101655 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (426, 1223, 2, 0, 1, 
    TO_TIMESTAMP('6/24/2013 2:26:04.101655 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (427, 1223, 3, 0, 2, 
    TO_TIMESTAMP('6/24/2013 2:26:04.101655 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (525, 1422, 1, 0, 0, 
    TO_TIMESTAMP('6/25/2013 3:42:35.752747 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (526, 1422, 2, 0, 1, 
    TO_TIMESTAMP('6/25/2013 3:42:35.752747 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (527, 1422, 3, 0, 2, 
    TO_TIMESTAMP('6/25/2013 3:42:35.752747 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (625, 1523, 1, 0, 0, 
    TO_TIMESTAMP('7/2/2013 5:33:56.658855 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (626, 1523, 2, 0, 1, 
    TO_TIMESTAMP('7/2/2013 5:33:56.658855 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (627, 1523, 3, 0, 2, 
    TO_TIMESTAMP('7/2/2013 5:33:56.658855 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1828, 2823, 1, 0, 0, 
    TO_TIMESTAMP('8/27/2013 8:00:37.626494 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1829, 2823, 2, 0, 1, 
    TO_TIMESTAMP('8/27/2013 8:00:37.626494 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1830, 2823, 3, 0, 2, 
    TO_TIMESTAMP('8/27/2013 8:00:37.626494 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1840, 2827, 1, 0, 0, 
    TO_TIMESTAMP('8/27/2013 8:12:34.647270 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1841, 2827, 2, 0, 1, 
    TO_TIMESTAMP('8/27/2013 8:12:34.647270 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1842, 2827, 3, 0, 2, 
    TO_TIMESTAMP('8/27/2013 8:12:34.647270 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1843, 2828, 1, 0, 0, 
    TO_TIMESTAMP('8/27/2013 8:13:16.160804 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1844, 2828, 2, 0, 1, 
    TO_TIMESTAMP('8/27/2013 8:13:16.160804 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1845, 2828, 3, 0, 2, 
    TO_TIMESTAMP('8/27/2013 8:13:16.160804 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1846, 2829, 1, 0, 0, 
    TO_TIMESTAMP('8/27/2013 8:14:34.991378 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1847, 2829, 2, 0, 1, 
    TO_TIMESTAMP('8/27/2013 8:14:34.991378 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1848, 2829, 3, 0, 2, 
    TO_TIMESTAMP('8/27/2013 8:14:34.991378 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2140, 3228, 1, 0, 0, 
    TO_TIMESTAMP('12/12/2013 3:39:52.262155 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2141, 3228, 2, 0, 1, 
    TO_TIMESTAMP('12/12/2013 3:39:52.262155 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2142, 3228, 3, 0, 2, 
    TO_TIMESTAMP('12/12/2013 3:39:52.262155 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2649, 3832, 1, 0, 0, 
    TO_TIMESTAMP('3/10/2014 3:19:42.634688 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2650, 3832, 2, 0, 1, 
    TO_TIMESTAMP('3/10/2014 3:19:42.634688 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2651, 3832, 3, 0, 2, 
    TO_TIMESTAMP('3/10/2014 3:19:42.634688 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3567, 4740, 1, 0, 0, 
    TO_TIMESTAMP('11/12/2014 12:09:07.488881 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3568, 4740, 2, 0, 1, 
    TO_TIMESTAMP('11/12/2014 12:09:07.488881 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3569, 4740, 3, 0, 2, 
    TO_TIMESTAMP('11/12/2014 12:09:07.488881 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4155, 5437, 1, 0, 0, 
    TO_TIMESTAMP('1/6/2015 12:10:44.535415 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4156, 5437, 2, 0, 1, 
    TO_TIMESTAMP('1/6/2015 12:10:44.535415 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4157, 5437, 3, 0, 2, 
    TO_TIMESTAMP('1/6/2015 12:10:44.535415 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4088, 5253, 1, 0, 0, 
    TO_TIMESTAMP('1/16/2015 9:58:51.490877 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4089, 5253, 2, 0, 1, 
    TO_TIMESTAMP('1/16/2015 9:58:51.490877 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4090, 5253, 3, 0, 2, 
    TO_TIMESTAMP('1/16/2015 9:58:51.490877 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4373, 5645, 1, 0, 0, 
    TO_TIMESTAMP('2/25/2015 1:25:33.171041 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4374, 5645, 2, 0, 1, 
    TO_TIMESTAMP('2/25/2015 1:25:33.171041 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4375, 5645, 3, 0, 2, 
    TO_TIMESTAMP('2/25/2015 1:25:33.171041 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4470, 5544, 1, 0, 0, 
    TO_TIMESTAMP('2/27/2015 11:38:37.139515 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4471, 5544, 2, 0, 1, 
    TO_TIMESTAMP('2/27/2015 11:38:37.139515 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4472, 5544, 3, 0, 2, 
    TO_TIMESTAMP('2/27/2015 11:38:37.139515 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4558, 5739, 1, 0, 0, 
    TO_TIMESTAMP('3/16/2015 9:55:27.961425 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4559, 5739, 2, 0, 1, 
    TO_TIMESTAMP('3/16/2015 9:55:27.961425 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4560, 5739, 3, 0, 2, 
    TO_TIMESTAMP('3/16/2015 9:55:27.961425 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6155, 7537, 1, 0, 0, 
    TO_TIMESTAMP('11/4/2015 1:15:32.951526 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6156, 7537, 2, 0, 1, 
    TO_TIMESTAMP('11/4/2015 1:15:32.951526 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6157, 7537, 3, 0, 2, 
    TO_TIMESTAMP('11/4/2015 1:15:32.951526 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7300, 8653, 1, 2, 0, 
    TO_TIMESTAMP('11/16/2016 8:06:35.560433 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7301, 8653, 2, 2, 1, 
    TO_TIMESTAMP('11/16/2016 8:06:35.560433 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7302, 8653, 3, 3, 2, 
    TO_TIMESTAMP('11/16/2016 8:06:35.560433 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7700, 9053, 1, 2, 0, 
    TO_TIMESTAMP('12/22/2016 9:35:08.742539 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7701, 9053, 2, 2, 1, 
    TO_TIMESTAMP('12/22/2016 9:35:08.742539 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7702, 9053, 3, 3, 2, 
    TO_TIMESTAMP('12/22/2016 9:35:08.742539 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8924, 10263, 1, 2, 0, 
    TO_TIMESTAMP('7/27/2017 2:13:06.080502 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8925, 10263, 2, 2, 1, 
    TO_TIMESTAMP('7/27/2017 2:13:06.080502 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8926, 10263, 3, 3, 2, 
    TO_TIMESTAMP('7/27/2017 2:13:06.080502 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (107, 107, 1, 0, 0, 
    TO_TIMESTAMP('3/7/2013 8:31:32.387014 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (108, 107, 2, 0, 1, 
    TO_TIMESTAMP('3/7/2013 8:31:32.387014 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (109, 107, 3, 0, 2, 
    TO_TIMESTAMP('3/7/2013 8:31:32.387014 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (110, 108, 1, 0, 0, 
    TO_TIMESTAMP('3/7/2013 8:33:42.877333 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (111, 108, 2, 0, 1, 
    TO_TIMESTAMP('3/7/2013 8:33:42.877333 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (112, 108, 3, 0, 2, 
    TO_TIMESTAMP('3/7/2013 8:33:42.877333 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (113, 109, 1, 0, 0, 
    TO_TIMESTAMP('3/7/2013 10:19:49.109058 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (114, 109, 2, 0, 1, 
    TO_TIMESTAMP('3/7/2013 10:19:49.109058 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (115, 109, 3, 0, 2, 
    TO_TIMESTAMP('3/7/2013 10:19:49.109058 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (116, 110, 1, 0, 0, 
    TO_TIMESTAMP('3/7/2013 11:45:21.330201 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (117, 110, 2, 0, 1, 
    TO_TIMESTAMP('3/7/2013 11:45:21.330201 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (118, 110, 3, 0, 2, 
    TO_TIMESTAMP('3/7/2013 11:45:21.330201 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (122, 113, 1, 0, 0, 
    TO_TIMESTAMP('3/13/2013 3:55:08.070616 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (123, 113, 2, 0, 1, 
    TO_TIMESTAMP('3/13/2013 3:55:08.070616 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (124, 113, 3, 0, 2, 
    TO_TIMESTAMP('3/13/2013 3:55:08.070616 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (49, 221, 1, 0, 0, 
    TO_TIMESTAMP('3/14/2013 7:17:16.374088 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (50, 221, 2, 0, 1, 
    TO_TIMESTAMP('3/14/2013 7:17:16.374088 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (51, 221, 3, 0, 2, 
    TO_TIMESTAMP('3/14/2013 7:17:16.374088 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (125, 222, 1, 0, 0, 
    TO_TIMESTAMP('3/19/2013 3:53:35.746195 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (126, 222, 2, 0, 1, 
    TO_TIMESTAMP('3/19/2013 3:53:35.746195 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (127, 222, 3, 0, 2, 
    TO_TIMESTAMP('3/19/2013 3:53:35.746195 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1325, 2322, 1, 0, 0, 
    TO_TIMESTAMP('8/6/2013 3:44:20.533082 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1326, 2322, 2, 0, 1, 
    TO_TIMESTAMP('8/6/2013 3:44:20.533082 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1327, 2322, 3, 0, 2, 
    TO_TIMESTAMP('8/6/2013 3:44:20.533082 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1425, 2422, 1, 0, 0, 
    TO_TIMESTAMP('8/8/2013 3:04:52.448926 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1426, 2422, 2, 0, 1, 
    TO_TIMESTAMP('8/8/2013 3:04:52.448926 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1427, 2422, 3, 0, 2, 
    TO_TIMESTAMP('8/8/2013 3:04:52.448926 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1525, 2622, 1, 0, 0, 
    TO_TIMESTAMP('8/13/2013 9:42:31.001346 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1526, 2622, 2, 0, 1, 
    TO_TIMESTAMP('8/13/2013 9:42:31.001346 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1527, 2622, 3, 0, 2, 
    TO_TIMESTAMP('8/13/2013 9:42:31.001346 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1528, 2623, 1, 0, 0, 
    TO_TIMESTAMP('8/13/2013 4:21:43.075286 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1529, 2623, 2, 0, 1, 
    TO_TIMESTAMP('8/13/2013 4:21:43.075286 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1530, 2623, 3, 0, 2, 
    TO_TIMESTAMP('8/13/2013 4:21:43.075286 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1725, 2722, 1, 0, 0, 
    TO_TIMESTAMP('8/20/2013 11:45:33.945464 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1726, 2722, 2, 0, 1, 
    TO_TIMESTAMP('8/20/2013 11:45:33.945464 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1727, 2722, 3, 0, 2, 
    TO_TIMESTAMP('8/20/2013 11:45:33.945464 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1861, 2835, 1, 0, 0, 
    TO_TIMESTAMP('8/27/2013 10:42:01.602930 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1862, 2835, 2, 0, 1, 
    TO_TIMESTAMP('8/27/2013 10:42:01.602930 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1863, 2835, 3, 0, 2, 
    TO_TIMESTAMP('8/27/2013 10:42:01.602930 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2434, 3625, 1, 1, 0, 
    TO_TIMESTAMP('1/22/2014 10:19:21.709201 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2435, 3625, 2, 2, 1, 
    TO_TIMESTAMP('1/22/2014 10:19:21.709201 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2436, 3625, 3, 3, 2, 
    TO_TIMESTAMP('1/22/2014 10:19:21.709201 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3040, 4229, 1, 2, 0, 
    TO_TIMESTAMP('6/2/2014 7:26:06.526639 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3041, 4229, 2, 2, 1, 
    TO_TIMESTAMP('6/2/2014 7:26:06.526639 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3042, 4229, 3, 3, 2, 
    TO_TIMESTAMP('6/2/2014 7:26:06.526639 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3349, 4535, 1, 0, 0, 
    TO_TIMESTAMP('9/12/2014 1:49:35.886932 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3350, 4535, 2, 0, 1, 
    TO_TIMESTAMP('9/12/2014 1:49:35.886932 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3351, 4535, 3, 0, 2, 
    TO_TIMESTAMP('9/12/2014 1:49:35.886932 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4364, 5640, 1, 2, 0, 
    TO_TIMESTAMP('2/20/2015 11:36:16.597070 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4365, 5640, 2, 2, 1, 
    TO_TIMESTAMP('2/20/2015 11:36:16.597070 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4366, 5640, 3, 3, 2, 
    TO_TIMESTAMP('2/20/2015 11:36:16.597070 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4479, 5547, 1, 0, 0, 
    TO_TIMESTAMP('3/4/2015 2:49:03.704068 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4480, 5547, 2, 3, 1, 
    TO_TIMESTAMP('3/4/2015 2:49:03.704068 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4481, 5547, 3, 2, 2, 
    TO_TIMESTAMP('3/4/2015 2:49:03.704068 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5955, 7339, 1, 2, 0, 
    TO_TIMESTAMP('8/11/2015 1:35:15.634035 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5956, 7339, 2, 2, 1, 
    TO_TIMESTAMP('8/11/2015 1:35:15.634035 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5957, 7339, 3, 3, 2, 
    TO_TIMESTAMP('8/11/2015 1:35:15.634035 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6055, 7437, 1, 0, 0, 
    TO_TIMESTAMP('9/14/2015 1:36:36.773581 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6056, 7437, 2, 0, 1, 
    TO_TIMESTAMP('9/14/2015 1:36:36.773581 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6057, 7437, 3, 0, 2, 
    TO_TIMESTAMP('9/14/2015 1:36:36.773581 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6061, 7440, 1, 2, 0, 
    TO_TIMESTAMP('9/17/2015 7:04:06.805334 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6062, 7440, 2, 2, 1, 
    TO_TIMESTAMP('9/17/2015 7:04:06.805334 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6063, 7440, 3, 3, 2, 
    TO_TIMESTAMP('9/17/2015 7:04:06.805334 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6064, 7441, 1, 0, 0, 
    TO_TIMESTAMP('9/17/2015 11:43:06.214975 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6065, 7441, 2, 0, 1, 
    TO_TIMESTAMP('9/17/2015 11:43:06.214975 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6066, 7441, 3, 0, 2, 
    TO_TIMESTAMP('9/17/2015 11:43:06.214975 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6458, 7838, 1, 0, 0, 
    TO_TIMESTAMP('1/22/2016 2:20:56.332002 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6459, 7838, 2, 0, 1, 
    TO_TIMESTAMP('1/22/2016 2:20:56.332002 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6460, 7838, 3, 0, 2, 
    TO_TIMESTAMP('1/22/2016 2:20:56.332002 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7097, 8452, 1, 0, 0, 
    TO_TIMESTAMP('10/13/2016 11:07:40.261837 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7098, 8452, 2, 0, 1, 
    TO_TIMESTAMP('10/13/2016 11:07:40.261837 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7099, 8452, 3, 0, 2, 
    TO_TIMESTAMP('10/13/2016 11:07:40.261837 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7103, 8454, 1, 0, 0, 
    TO_TIMESTAMP('10/13/2016 12:20:13.133283 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7104, 8454, 2, 0, 1, 
    TO_TIMESTAMP('10/13/2016 12:20:13.133283 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7105, 8454, 3, 0, 2, 
    TO_TIMESTAMP('10/13/2016 12:20:13.133283 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7309, 8657, 1, 0, 0, 
    TO_TIMESTAMP('11/16/2016 2:50:32.260480 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7310, 8657, 2, 0, 1, 
    TO_TIMESTAMP('11/16/2016 2:50:32.260480 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7311, 8657, 3, 0, 2, 
    TO_TIMESTAMP('11/16/2016 2:50:32.260480 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8006, 9355, 1, 0, 0, 
    TO_TIMESTAMP('2/8/2017 8:38:04.896086 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8007, 9355, 2, 0, 1, 
    TO_TIMESTAMP('2/8/2017 8:38:04.896086 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8008, 9355, 3, 0, 2, 
    TO_TIMESTAMP('2/8/2017 8:38:04.896086 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8321, 9661, 1, 0, 0, 
    TO_TIMESTAMP('3/3/2017 8:39:06.068056 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8322, 9661, 2, 0, 1, 
    TO_TIMESTAMP('3/3/2017 8:39:06.068056 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8323, 9661, 3, 0, 2, 
    TO_TIMESTAMP('3/3/2017 8:39:06.068056 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8354, 9673, 1, 0, 0, 
    TO_TIMESTAMP('3/10/2017 2:19:05.014079 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8355, 9673, 2, 0, 1, 
    TO_TIMESTAMP('3/10/2017 2:19:05.014079 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8356, 9673, 3, 0, 2, 
    TO_TIMESTAMP('3/10/2017 2:19:05.014079 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8912, 10258, 1, 0, 0, 
    TO_TIMESTAMP('7/19/2017 1:23:36.683482 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8913, 10258, 2, 0, 1, 
    TO_TIMESTAMP('7/19/2017 1:23:36.683482 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8914, 10258, 3, 0, 2, 
    TO_TIMESTAMP('7/19/2017 1:23:36.683482 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (19, 207, 1, 0, 0, 
    TO_TIMESTAMP('3/4/2013 1:43:36.715286 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (20, 207, 2, 0, 1, 
    TO_TIMESTAMP('3/4/2013 1:43:36.715286 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (21, 207, 3, 0, 2, 
    TO_TIMESTAMP('3/4/2013 1:43:36.715286 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (104, 106, 1, 0, 0, 
    TO_TIMESTAMP('3/6/2013 2:03:26.808245 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (105, 106, 2, 0, 1, 
    TO_TIMESTAMP('3/6/2013 2:03:26.808245 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (106, 106, 3, 0, 2, 
    TO_TIMESTAMP('3/6/2013 2:03:26.808245 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (25, 210, 1, 0, 0, 
    TO_TIMESTAMP('3/6/2013 2:03:09.444761 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (26, 210, 2, 0, 1, 
    TO_TIMESTAMP('3/6/2013 2:03:09.444761 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (27, 210, 3, 0, 2, 
    TO_TIMESTAMP('3/6/2013 2:03:09.444761 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (119, 111, 1, 0, 0, 
    TO_TIMESTAMP('3/7/2013 12:18:59.653626 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (120, 111, 2, 0, 1, 
    TO_TIMESTAMP('3/7/2013 12:18:59.653626 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (121, 111, 3, 0, 2, 
    TO_TIMESTAMP('3/7/2013 12:18:59.653626 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (131, 224, 1, 0, 0, 
    TO_TIMESTAMP('4/2/2013 11:58:55.506817 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (132, 224, 2, 0, 1, 
    TO_TIMESTAMP('4/2/2013 11:58:55.506817 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (133, 224, 3, 0, 2, 
    TO_TIMESTAMP('4/2/2013 11:58:55.506817 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (825, 1822, 1, 1, 0, 
    TO_TIMESTAMP('7/5/2013 1:27:52.877056 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (826, 1822, 2, 2, 1, 
    TO_TIMESTAMP('7/5/2013 1:27:52.877056 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (827, 1822, 3, 3, 2, 
    TO_TIMESTAMP('7/5/2013 1:27:52.877056 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1125, 2122, 1, 0, 0, 
    TO_TIMESTAMP('7/12/2013 12:08:29.911104 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1126, 2122, 2, 0, 1, 
    TO_TIMESTAMP('7/12/2013 12:08:29.911104 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1127, 2122, 3, 0, 2, 
    TO_TIMESTAMP('7/12/2013 12:08:29.911104 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1858, 2834, 100, 0, 0, 
    TO_TIMESTAMP('8/27/2013 10:38:05.579765 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1859, 2834, 2, 0, 1, 
    TO_TIMESTAMP('8/27/2013 10:38:05.579765 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1860, 2834, 3, 0, 2, 
    TO_TIMESTAMP('8/27/2013 10:38:05.579765 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2237, 3524, 1, 0, 0, 
    TO_TIMESTAMP('1/13/2014 8:28:56.032148 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2238, 3524, 2, 0, 1, 
    TO_TIMESTAMP('1/13/2014 8:28:56.032148 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2239, 3524, 3, 0, 2, 
    TO_TIMESTAMP('1/13/2014 8:28:56.032148 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2640, 3829, 1, 0, 0, 
    TO_TIMESTAMP('3/6/2014 5:00:45.799433 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2641, 3829, 2, 0, 1, 
    TO_TIMESTAMP('3/6/2014 5:00:45.799433 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2642, 3829, 3, 0, 2, 
    TO_TIMESTAMP('3/6/2014 5:00:45.799433 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2643, 3830, 1, 0, 0, 
    TO_TIMESTAMP('3/6/2014 5:12:56.516918 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2644, 3830, 2, 0, 1, 
    TO_TIMESTAMP('3/6/2014 5:12:56.516918 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2645, 3830, 3, 0, 2, 
    TO_TIMESTAMP('3/6/2014 5:12:56.516918 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2658, 3835, 1, 0, 0, 
    TO_TIMESTAMP('3/12/2014 12:25:43.509897 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2659, 3835, 2, 0, 1, 
    TO_TIMESTAMP('3/12/2014 12:25:43.509897 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2660, 3835, 3, 0, 2, 
    TO_TIMESTAMP('3/12/2014 12:25:43.509897 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2661, 3836, 1, 0, 0, 
    TO_TIMESTAMP('3/12/2014 12:27:54.691323 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2662, 3836, 2, 0, 1, 
    TO_TIMESTAMP('3/12/2014 12:27:54.691323 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2663, 3836, 3, 0, 2, 
    TO_TIMESTAMP('3/12/2014 12:27:54.691323 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2664, 3837, 1, 0, 0, 
    TO_TIMESTAMP('4/17/2014 9:30:28.292614 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2665, 3837, 2, 0, 1, 
    TO_TIMESTAMP('4/17/2014 9:30:28.292614 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2666, 3837, 3, 0, 2, 
    TO_TIMESTAMP('4/17/2014 9:30:28.292614 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2946, 4133, 1, 0, 0, 
    TO_TIMESTAMP('6/5/2014 1:06:07.607159 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2947, 4133, 2, 0, 1, 
    TO_TIMESTAMP('6/5/2014 1:06:07.607159 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2948, 4133, 3, 0, 2, 
    TO_TIMESTAMP('6/5/2014 1:06:07.607159 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3252, 4435, 1, 0, 0, 
    TO_TIMESTAMP('8/13/2014 4:23:07.081226 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3253, 4435, 2, 0, 1, 
    TO_TIMESTAMP('8/13/2014 4:23:07.081226 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3254, 4435, 3, 0, 2, 
    TO_TIMESTAMP('8/13/2014 4:23:07.081226 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3361, 4540, 1, 0, 0, 
    TO_TIMESTAMP('9/24/2014 12:47:03.008176 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3362, 4540, 2, 0, 1, 
    TO_TIMESTAMP('9/24/2014 12:47:03.008176 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3363, 4540, 3, 0, 2, 
    TO_TIMESTAMP('9/24/2014 12:47:03.008176 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3364, 4542, 1, 0, 0, 
    TO_TIMESTAMP('10/28/2014 4:19:20.931119 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3365, 4542, 2, 0, 1, 
    TO_TIMESTAMP('10/28/2014 4:19:20.931119 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3366, 4542, 3, 0, 2, 
    TO_TIMESTAMP('10/28/2014 4:19:20.931119 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3367, 4543, 1, 0, 0, 
    TO_TIMESTAMP('10/29/2014 1:41:56.346674 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3368, 4543, 2, 0, 1, 
    TO_TIMESTAMP('10/29/2014 1:41:56.346674 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3369, 4543, 3, 0, 2, 
    TO_TIMESTAMP('10/29/2014 1:41:56.346674 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3655, 4837, 1, 0, 0, 
    TO_TIMESTAMP('11/13/2014 12:51:33.446360 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3656, 4837, 2, 0, 1, 
    TO_TIMESTAMP('11/13/2014 12:51:33.446360 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3657, 4837, 3, 0, 2, 
    TO_TIMESTAMP('11/13/2014 12:51:33.446360 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3858, 5038, 1, 0, 0, 
    TO_TIMESTAMP('11/25/2014 11:13:26.312391 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3859, 5038, 2, 0, 1, 
    TO_TIMESTAMP('11/25/2014 11:13:26.312391 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3860, 5038, 3, 0, 2, 
    TO_TIMESTAMP('11/25/2014 11:13:26.312391 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3864, 5040, 1, 0, 0, 
    TO_TIMESTAMP('11/25/2014 11:21:59.745066 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3865, 5040, 2, 0, 1, 
    TO_TIMESTAMP('11/25/2014 11:21:59.745066 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3866, 5040, 3, 0, 2, 
    TO_TIMESTAMP('11/25/2014 11:21:59.745066 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4064, 5242, 1, 0, 0, 
    TO_TIMESTAMP('12/22/2014 10:57:24.577811 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4065, 5242, 2, 0, 1, 
    TO_TIMESTAMP('12/22/2014 10:57:24.577811 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4066, 5242, 3, 0, 2, 
    TO_TIMESTAMP('12/22/2014 10:57:24.577811 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4367, 5642, 1, 0, 0, 
    TO_TIMESTAMP('2/23/2015 9:24:33.059682 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4368, 5642, 2, 0, 1, 
    TO_TIMESTAMP('2/23/2015 9:24:33.059682 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4369, 5642, 3, 0, 2, 
    TO_TIMESTAMP('2/23/2015 9:24:33.059682 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4385, 5651, 1, 0, 0, 
    TO_TIMESTAMP('3/4/2015 2:44:32.111426 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4386, 5651, 2, 0, 1, 
    TO_TIMESTAMP('3/4/2015 2:44:32.111426 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4387, 5651, 3, 0, 2, 
    TO_TIMESTAMP('3/4/2015 2:44:32.111426 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4388, 5652, 1, 0, 0, 
    TO_TIMESTAMP('3/4/2015 2:47:46.940764 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4389, 5652, 2, 0, 1, 
    TO_TIMESTAMP('3/4/2015 2:47:46.940764 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4390, 5652, 3, 2, 2, 
    TO_TIMESTAMP('3/4/2015 2:47:46.940764 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4406, 5663, 1, 0, 0, 
    TO_TIMESTAMP('3/11/2015 2:55:31.628669 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4407, 5663, 2, 0, 1, 
    TO_TIMESTAMP('3/11/2015 2:55:31.628669 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4408, 5663, 3, 0, 2, 
    TO_TIMESTAMP('3/11/2015 2:55:31.628669 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4655, 5837, 1, 0, 0, 
    TO_TIMESTAMP('3/26/2015 3:44:13.225408 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4656, 5837, 2, 0, 1, 
    TO_TIMESTAMP('3/26/2015 3:44:13.225408 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4657, 5837, 3, 0, 2, 
    TO_TIMESTAMP('3/26/2015 3:44:13.225408 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4855, 6037, 1, 0, 0, 
    TO_TIMESTAMP('4/14/2015 1:05:19.198467 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4856, 6037, 2, 0, 1, 
    TO_TIMESTAMP('4/14/2015 1:05:19.198467 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4857, 6037, 3, 0, 2, 
    TO_TIMESTAMP('4/14/2015 1:05:19.198467 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5855, 7237, 1, 2, 0, 
    TO_TIMESTAMP('8/5/2015 6:48:54.477482 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5856, 7237, 2, 2, 1, 
    TO_TIMESTAMP('8/5/2015 6:48:54.477482 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5857, 7237, 3, 3, 2, 
    TO_TIMESTAMP('8/5/2015 6:48:54.477482 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6264, 7642, 1, 0, 0, 
    TO_TIMESTAMP('12/7/2015 7:03:39.223078 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6265, 7642, 2, 0, 1, 
    TO_TIMESTAMP('12/7/2015 7:03:39.223078 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6266, 7642, 3, 0, 2, 
    TO_TIMESTAMP('12/7/2015 7:03:39.223078 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6900, 8253, 1, 0, 0, 
    TO_TIMESTAMP('9/21/2016 3:27:36.203017 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6901, 8253, 2, 0, 1, 
    TO_TIMESTAMP('9/21/2016 3:27:36.203017 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6902, 8253, 3, 0, 2, 
    TO_TIMESTAMP('9/21/2016 3:27:36.203017 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8363, 9676, 1, 0, 0, 
    TO_TIMESTAMP('4/12/2017 8:01:07.700740 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8364, 9676, 2, 0, 1, 
    TO_TIMESTAMP('4/12/2017 8:01:07.700740 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8365, 9676, 3, 0, 2, 
    TO_TIMESTAMP('4/12/2017 8:01:07.700740 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8387, 9684, 1, 0, 0, 
    TO_TIMESTAMP('4/17/2017 2:57:08.116673 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8388, 9684, 2, 0, 1, 
    TO_TIMESTAMP('4/17/2017 2:57:08.116673 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8389, 9684, 3, 0, 2, 
    TO_TIMESTAMP('4/17/2017 2:57:08.116673 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1, 201, 1, 0, 0, 
    TO_TIMESTAMP('3/4/2013 9:28:51.714601 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2, 201, 2, 0, 1, 
    TO_TIMESTAMP('3/4/2013 9:28:51.714601 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3, 201, 3, 0, 2, 
    TO_TIMESTAMP('3/4/2013 9:28:51.714601 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (31, 213, 1, 0, 0, 
    TO_TIMESTAMP('3/7/2013 6:45:27.430643 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (32, 213, 2, 0, 1, 
    TO_TIMESTAMP('3/7/2013 6:45:27.430643 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (33, 213, 3, 0, 2, 
    TO_TIMESTAMP('3/7/2013 6:45:27.430643 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1025, 2022, 1, 0, 0, 
    TO_TIMESTAMP('7/9/2013 2:49:29.731110 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1026, 2022, 2, 0, 1, 
    TO_TIMESTAMP('7/9/2013 2:49:29.731110 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1027, 2022, 3, 0, 2, 
    TO_TIMESTAMP('7/9/2013 2:49:29.731110 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1225, 2222, 1, 0, 0, 
    TO_TIMESTAMP('7/16/2013 7:30:36.381645 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1226, 2222, 2, 0, 1, 
    TO_TIMESTAMP('7/16/2013 7:30:36.381645 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1227, 2222, 3, 0, 2, 
    TO_TIMESTAMP('7/16/2013 7:30:36.381645 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1628, 2525, 1, 0, 0, 
    TO_TIMESTAMP('8/13/2013 4:19:49.682980 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1629, 2525, 2, 0, 1, 
    TO_TIMESTAMP('8/13/2013 4:19:49.682980 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1630, 2525, 3, 0, 2, 
    TO_TIMESTAMP('8/13/2013 4:19:49.682980 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1825, 2822, 1, 0, 0, 
    TO_TIMESTAMP('8/27/2013 7:57:30.075312 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1826, 2822, 2, 0, 1, 
    TO_TIMESTAMP('8/27/2013 7:57:30.075312 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1827, 2822, 3, 0, 2, 
    TO_TIMESTAMP('8/27/2013 7:57:30.075312 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1855, 2833, 1, 0, 0, 
    TO_TIMESTAMP('8/27/2013 8:54:12.928352 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1856, 2833, 2, 0, 1, 
    TO_TIMESTAMP('8/27/2013 8:54:12.928352 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1857, 2833, 3, 0, 2, 
    TO_TIMESTAMP('8/27/2013 8:54:12.928352 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2437, 3626, 1, 2, 0, 
    TO_TIMESTAMP('1/28/2014 10:48:31.935404 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2438, 3626, 2, 2, 1, 
    TO_TIMESTAMP('1/28/2014 10:48:31.935404 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2439, 3626, 3, 3, 2, 
    TO_TIMESTAMP('1/28/2014 10:48:31.935404 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2840, 4032, 1, 0, 0, 
    TO_TIMESTAMP('4/22/2014 12:25:54.811277 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2841, 4032, 2, 0, 1, 
    TO_TIMESTAMP('4/22/2014 12:25:54.811277 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2842, 4032, 3, 0, 2, 
    TO_TIMESTAMP('4/22/2014 12:25:54.811277 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3049, 4232, 1, 0, 0, 
    TO_TIMESTAMP('6/10/2014 1:24:54.531107 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3050, 4232, 2, 0, 1, 
    TO_TIMESTAMP('6/10/2014 1:24:54.531107 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3051, 4232, 3, 0, 2, 
    TO_TIMESTAMP('6/10/2014 1:24:54.531107 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4055, 5237, 1, 2, 0, 
    TO_TIMESTAMP('12/17/2014 1:29:19.355458 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4056, 5237, 2, 2, 1, 
    TO_TIMESTAMP('12/17/2014 1:29:19.355458 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4057, 5237, 3, 3, 2, 
    TO_TIMESTAMP('12/17/2014 1:29:19.355458 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4467, 5543, 1, 0, 0, 
    TO_TIMESTAMP('2/23/2015 9:34:06.742290 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4468, 5543, 2, 0, 1, 
    TO_TIMESTAMP('2/23/2015 9:34:06.742290 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4469, 5543, 3, 2, 2, 
    TO_TIMESTAMP('2/23/2015 9:34:06.742290 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4391, 5653, 1, 3, 0, 
    TO_TIMESTAMP('3/4/2015 2:52:17.270890 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4392, 5653, 2, 3, 1, 
    TO_TIMESTAMP('3/4/2015 2:52:17.270890 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4393, 5653, 3, 2, 2, 
    TO_TIMESTAMP('3/4/2015 2:52:17.270890 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4397, 5655, 1, 2, 0, 
    TO_TIMESTAMP('3/6/2015 5:58:36.431487 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4398, 5655, 2, 2, 1, 
    TO_TIMESTAMP('3/6/2015 5:58:36.431487 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4399, 5655, 3, 3, 2, 
    TO_TIMESTAMP('3/6/2015 5:58:36.431487 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4409, 5664, 1, 0, 0, 
    TO_TIMESTAMP('3/13/2015 11:18:39.135390 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4410, 5664, 2, 0, 1, 
    TO_TIMESTAMP('3/13/2015 11:18:39.135390 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4411, 5664, 3, 0, 2, 
    TO_TIMESTAMP('3/13/2015 11:18:39.135390 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5058, 6240, 1, 0, 0, 
    TO_TIMESTAMP('4/16/2015 1:52:05.203496 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5059, 6240, 2, 0, 1, 
    TO_TIMESTAMP('4/16/2015 1:52:05.203496 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5060, 6240, 3, 0, 2, 
    TO_TIMESTAMP('4/16/2015 1:52:05.203496 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6273, 7645, 1, 2, 0, 
    TO_TIMESTAMP('1/20/2016 3:03:09.208319 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6274, 7645, 2, 2, 1, 
    TO_TIMESTAMP('1/20/2016 3:03:09.208319 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6275, 7645, 3, 3, 2, 
    TO_TIMESTAMP('1/20/2016 3:03:09.208319 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7109, 8456, 1, 0, 0, 
    TO_TIMESTAMP('10/18/2016 1:12:24.111224 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7110, 8456, 2, 0, 1, 
    TO_TIMESTAMP('10/18/2016 1:12:24.111224 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7111, 8456, 3, 0, 2, 
    TO_TIMESTAMP('10/18/2016 1:12:24.111224 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7312, 8658, 1, 0, 0, 
    TO_TIMESTAMP('11/18/2016 1:47:11.307304 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7313, 8658, 2, 0, 1, 
    TO_TIMESTAMP('11/18/2016 1:47:11.307304 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7314, 8658, 3, 0, 2, 
    TO_TIMESTAMP('11/18/2016 1:47:11.307304 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7997, 9352, 1, 0, 0, 
    TO_TIMESTAMP('2/8/2017 8:06:09.241478 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7998, 9352, 2, 0, 1, 
    TO_TIMESTAMP('2/8/2017 8:06:09.241478 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7999, 9352, 3, 0, 2, 
    TO_TIMESTAMP('2/8/2017 8:06:09.241478 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8324, 9662, 1, 0, 0, 
    TO_TIMESTAMP('3/3/2017 1:02:27.611215 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8325, 9662, 2, 0, 1, 
    TO_TIMESTAMP('3/3/2017 1:02:27.611215 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8326, 9662, 3, 0, 2, 
    TO_TIMESTAMP('3/3/2017 1:02:27.611215 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (40, 218, 1, 0, 0, 
    TO_TIMESTAMP('3/13/2013 3:42:57.132341 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (41, 218, 2, 0, 1, 
    TO_TIMESTAMP('3/13/2013 3:42:57.132341 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (42, 218, 3, 0, 2, 
    TO_TIMESTAMP('3/13/2013 3:42:57.132341 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (46, 220, 1, 0, 0, 
    TO_TIMESTAMP('3/13/2013 3:49:52.575197 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (47, 220, 2, 0, 1, 
    TO_TIMESTAMP('3/13/2013 3:49:52.575197 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (48, 220, 3, 0, 2, 
    TO_TIMESTAMP('3/13/2013 3:49:52.575197 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1864, 2836, 1, 0, 0, 
    TO_TIMESTAMP('8/27/2013 11:26:51.210302 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1865, 2836, 2, 0, 1, 
    TO_TIMESTAMP('8/27/2013 11:26:51.210302 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1866, 2836, 3, 0, 2, 
    TO_TIMESTAMP('8/27/2013 11:26:51.210302 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2231, 3326, 1, 0, 0, 
    TO_TIMESTAMP('12/18/2013 11:17:45.982086 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2232, 3326, 2, 0, 1, 
    TO_TIMESTAMP('12/18/2013 11:17:45.982086 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2233, 3326, 3, 0, 2, 
    TO_TIMESTAMP('12/18/2013 11:17:45.982086 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2331, 3424, 1, 0, 0, 
    TO_TIMESTAMP('12/19/2013 2:08:24.788398 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2332, 3424, 2, 0, 1, 
    TO_TIMESTAMP('12/19/2013 2:08:24.788398 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2333, 3424, 3, 0, 2, 
    TO_TIMESTAMP('12/19/2013 2:08:24.788398 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2761, 3939, 1, 0, 0, 
    TO_TIMESTAMP('3/13/2014 8:51:07.136355 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2762, 3939, 2, 0, 1, 
    TO_TIMESTAMP('3/13/2014 8:51:07.136355 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2763, 3939, 3, 0, 2, 
    TO_TIMESTAMP('3/13/2014 8:51:07.136355 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2943, 4132, 1, 0, 0, 
    TO_TIMESTAMP('6/5/2014 10:47:59.908806 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2944, 4132, 2, 0, 1, 
    TO_TIMESTAMP('6/5/2014 10:47:59.908806 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2945, 4132, 3, 0, 2, 
    TO_TIMESTAMP('6/5/2014 10:47:59.908806 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3346, 4533, 1, 0, 0, 
    TO_TIMESTAMP('8/29/2014 12:32:42.324483 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3347, 4533, 2, 0, 1, 
    TO_TIMESTAMP('8/29/2014 12:32:42.324483 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3348, 4533, 3, 0, 2, 
    TO_TIMESTAMP('8/29/2014 12:32:42.324483 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3561, 4738, 1, 0, 0, 
    TO_TIMESTAMP('11/12/2014 10:21:45.767009 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3562, 4738, 2, 0, 1, 
    TO_TIMESTAMP('11/12/2014 10:21:45.767009 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3563, 4738, 3, 0, 2, 
    TO_TIMESTAMP('11/12/2014 10:21:45.767009 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3649, 4835, 1, 0, 0, 
    TO_TIMESTAMP('11/12/2014 10:48:53.111347 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3650, 4835, 2, 0, 1, 
    TO_TIMESTAMP('11/12/2014 10:48:53.111347 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3651, 4835, 3, 0, 2, 
    TO_TIMESTAMP('11/12/2014 10:48:53.111347 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3855, 5037, 1, 0, 0, 
    TO_TIMESTAMP('11/24/2014 11:17:13.408080 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3856, 5037, 2, 0, 1, 
    TO_TIMESTAMP('11/24/2014 11:17:13.408080 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3857, 5037, 3, 0, 2, 
    TO_TIMESTAMP('11/24/2014 11:17:13.408080 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4161, 5439, 1, 0, 0, 
    TO_TIMESTAMP('1/7/2015 12:44:54.157632 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4162, 5439, 2, 0, 1, 
    TO_TIMESTAMP('1/7/2015 12:44:54.157632 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4163, 5439, 3, 0, 2, 
    TO_TIMESTAMP('1/7/2015 12:44:54.157632 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4164, 5440, 1, 0, 0, 
    TO_TIMESTAMP('1/7/2015 12:51:29.098081 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4165, 5440, 2, 0, 1, 
    TO_TIMESTAMP('1/7/2015 12:51:29.098081 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4166, 5440, 3, 0, 2, 
    TO_TIMESTAMP('1/7/2015 12:51:29.098081 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4170, 5442, 1, 0, 0, 
    TO_TIMESTAMP('1/8/2015 8:02:31.717980 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4171, 5442, 2, 0, 1, 
    TO_TIMESTAMP('1/8/2015 8:02:31.717980 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4172, 5442, 3, 0, 2, 
    TO_TIMESTAMP('1/8/2015 8:02:31.717980 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5055, 6237, 1, 2, 0, 
    TO_TIMESTAMP('4/16/2015 7:14:15.257722 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5056, 6237, 2, 2, 1, 
    TO_TIMESTAMP('4/16/2015 7:14:15.257722 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5057, 6237, 3, 3, 2, 
    TO_TIMESTAMP('4/16/2015 7:14:15.257722 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5255, 6537, 1, 2, 0, 
    TO_TIMESTAMP('6/23/2015 6:49:23.725037 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5256, 6537, 2, 2, 1, 
    TO_TIMESTAMP('6/23/2015 6:49:23.725037 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5257, 6537, 3, 3, 2, 
    TO_TIMESTAMP('6/23/2015 6:49:23.725037 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5358, 6638, 1, 0, 0, 
    TO_TIMESTAMP('6/23/2015 12:04:55.946112 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5359, 6638, 2, 0, 1, 
    TO_TIMESTAMP('6/23/2015 12:04:55.946112 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5360, 6638, 3, 0, 2, 
    TO_TIMESTAMP('6/23/2015 12:04:55.946112 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5870, 7243, 1, 0, 0, 
    TO_TIMESTAMP('8/11/2015 2:03:22.821210 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5871, 7243, 2, 0, 1, 
    TO_TIMESTAMP('8/11/2015 2:03:22.821210 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5872, 7243, 3, 0, 2, 
    TO_TIMESTAMP('8/11/2015 2:03:22.821210 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6276, 7646, 1, 0, 0, 
    TO_TIMESTAMP('1/22/2016 1:22:44.817054 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6277, 7646, 2, 0, 1, 
    TO_TIMESTAMP('1/22/2016 1:22:44.817054 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6278, 7646, 3, 0, 2, 
    TO_TIMESTAMP('1/22/2016 1:22:44.817054 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6279, 7648, 1, 0, 0, 
    TO_TIMESTAMP('1/26/2016 8:38:02.805018 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6280, 7648, 2, 0, 1, 
    TO_TIMESTAMP('1/26/2016 8:38:02.805018 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6281, 7648, 3, 0, 2, 
    TO_TIMESTAMP('1/26/2016 8:38:02.805018 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6764, 8140, 1, 2, 0, 
    TO_TIMESTAMP('8/11/2016 2:41:10.471151 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6765, 8140, 2, 2, 1, 
    TO_TIMESTAMP('8/11/2016 2:41:10.471151 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6766, 8140, 3, 3, 2, 
    TO_TIMESTAMP('8/11/2016 2:41:10.471151 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6776, 8144, 1, 2, 0, 
    TO_TIMESTAMP('8/16/2016 6:56:29.864493 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6777, 8144, 2, 2, 1, 
    TO_TIMESTAMP('8/16/2016 6:56:29.864493 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6778, 8144, 3, 3, 2, 
    TO_TIMESTAMP('8/16/2016 6:56:29.864493 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6779, 8145, 1, 0, 0, 
    TO_TIMESTAMP('8/16/2016 7:54:06.706087 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6780, 8145, 2, 0, 1, 
    TO_TIMESTAMP('8/16/2016 7:54:06.706087 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6781, 8145, 3, 0, 2, 
    TO_TIMESTAMP('8/16/2016 7:54:06.706087 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6782, 8147, 1, 0, 0, 
    TO_TIMESTAMP('8/17/2016 12:25:16.683021 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6783, 8147, 2, 0, 1, 
    TO_TIMESTAMP('8/17/2016 12:25:16.683021 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6784, 8147, 3, 0, 2, 
    TO_TIMESTAMP('8/17/2016 12:25:16.683021 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6785, 8148, 1, 0, 0, 
    TO_TIMESTAMP('8/24/2016 12:24:42.907291 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6786, 8148, 2, 0, 1, 
    TO_TIMESTAMP('8/24/2016 12:24:42.907291 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6787, 8148, 3, 0, 2, 
    TO_TIMESTAMP('8/24/2016 12:24:42.907291 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7497, 8852, 1, 0, 0, 
    TO_TIMESTAMP('11/22/2016 2:22:32.172025 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7498, 8852, 2, 0, 1, 
    TO_TIMESTAMP('11/22/2016 2:22:32.172025 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7499, 8852, 3, 0, 2, 
    TO_TIMESTAMP('11/22/2016 2:22:32.172025 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7697, 9052, 1, 0, 0, 
    TO_TIMESTAMP('12/22/2016 9:20:18.345782 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7698, 9052, 2, 0, 1, 
    TO_TIMESTAMP('12/22/2016 9:20:18.345782 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7699, 9052, 3, 0, 2, 
    TO_TIMESTAMP('12/22/2016 9:20:18.345782 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8327, 9663, 1, 2, 0, 
    TO_TIMESTAMP('3/3/2017 1:24:00.911910 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8328, 9663, 2, 2, 1, 
    TO_TIMESTAMP('3/3/2017 1:24:00.911910 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8329, 9663, 3, 3, 2, 
    TO_TIMESTAMP('3/3/2017 1:24:00.911910 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8381, 9682, 1, 2, 0, 
    TO_TIMESTAMP('4/14/2017 12:27:45.941861 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8382, 9682, 2, 2, 1, 
    TO_TIMESTAMP('4/14/2017 12:27:45.941861 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8383, 9682, 3, 3, 2, 
    TO_TIMESTAMP('4/14/2017 12:27:45.941861 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8818, 10160, 1, 0, 0, 
    TO_TIMESTAMP('5/24/2017 3:17:27.140766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8819, 10160, 2, 0, 1, 
    TO_TIMESTAMP('5/24/2017 3:17:27.140766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8820, 10160, 3, 0, 2, 
    TO_TIMESTAMP('5/24/2017 3:17:27.140766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9218, 10560, 1, 0, 0, 
    TO_TIMESTAMP('8/28/2017 3:27:37.383111 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9219, 10560, 2, 0, 1, 
    TO_TIMESTAMP('8/28/2017 3:27:37.383111 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9220, 10560, 3, 0, 2, 
    TO_TIMESTAMP('8/28/2017 3:27:37.383111 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (28, 211, 1, 0, 0, 
    TO_TIMESTAMP('3/6/2013 2:08:06.929525 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (29, 211, 2, 0, 1, 
    TO_TIMESTAMP('3/6/2013 2:08:06.929525 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (30, 211, 3, 0, 2, 
    TO_TIMESTAMP('3/6/2013 2:08:06.929525 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (37, 217, 1, 1, 0, 
    TO_TIMESTAMP('3/13/2013 1:35:13.787695 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (38, 217, 2, 2, 1, 
    TO_TIMESTAMP('3/13/2013 1:35:13.787695 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (39, 217, 3, 3, 2, 
    TO_TIMESTAMP('3/13/2013 1:35:13.787695 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (225, 922, 1, 0, 0, 
    TO_TIMESTAMP('6/24/2013 9:01:49.504979 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (226, 922, 2, 0, 1, 
    TO_TIMESTAMP('6/24/2013 9:01:49.504979 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (227, 922, 3, 0, 2, 
    TO_TIMESTAMP('6/24/2013 9:01:49.504979 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1625, 2524, 1, 0, 0, 
    TO_TIMESTAMP('8/13/2013 3:04:25.964108 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1626, 2524, 2, 0, 1, 
    TO_TIMESTAMP('8/13/2013 3:04:25.964108 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1627, 2524, 3, 0, 2, 
    TO_TIMESTAMP('8/13/2013 3:04:25.964108 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2537, 3726, 1, 0, 0, 
    TO_TIMESTAMP('2/3/2014 2:36:22.592229 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2538, 3726, 2, 0, 1, 
    TO_TIMESTAMP('2/3/2014 2:36:22.592229 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2539, 3726, 3, 0, 2, 
    TO_TIMESTAMP('2/3/2014 2:36:22.592229 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2637, 3827, 1, 0, 0, 
    TO_TIMESTAMP('2/4/2014 9:07:23.279681 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2638, 3827, 2, 0, 1, 
    TO_TIMESTAMP('2/4/2014 9:07:23.279681 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2639, 3827, 3, 0, 2, 
    TO_TIMESTAMP('2/4/2014 9:07:23.279681 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2740, 3930, 1, 0, 0, 
    TO_TIMESTAMP('3/7/2014 10:01:57.686581 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2741, 3930, 2, 0, 1, 
    TO_TIMESTAMP('3/7/2014 10:01:57.686581 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2742, 3930, 3, 0, 2, 
    TO_TIMESTAMP('3/7/2014 10:01:57.686581 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3446, 4633, 1, 0, 0, 
    TO_TIMESTAMP('9/24/2014 8:43:40.691219 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3447, 4633, 2, 0, 1, 
    TO_TIMESTAMP('9/24/2014 8:43:40.691219 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3448, 4633, 3, 0, 2, 
    TO_TIMESTAMP('9/24/2014 8:43:40.691219 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3355, 4538, 1, 0, 0, 
    TO_TIMESTAMP('9/24/2014 9:06:43.024324 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3356, 4538, 2, 0, 1, 
    TO_TIMESTAMP('9/24/2014 9:06:43.024324 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3357, 4538, 3, 0, 2, 
    TO_TIMESTAMP('9/24/2014 9:06:43.024324 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3358, 4539, 1, 0, 0, 
    TO_TIMESTAMP('9/24/2014 9:28:22.693593 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3359, 4539, 2, 0, 1, 
    TO_TIMESTAMP('9/24/2014 9:28:22.693593 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3360, 4539, 3, 0, 2, 
    TO_TIMESTAMP('9/24/2014 9:28:22.693593 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3549, 4734, 1, 2, 0, 
    TO_TIMESTAMP('11/12/2014 9:21:56.944635 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3550, 4734, 2, 2, 1, 
    TO_TIMESTAMP('11/12/2014 9:21:56.944635 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3551, 4734, 3, 3, 2, 
    TO_TIMESTAMP('11/12/2014 9:21:56.944635 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3558, 4737, 1, 0, 0, 
    TO_TIMESTAMP('11/12/2014 9:50:18.024642 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3559, 4737, 2, 0, 1, 
    TO_TIMESTAMP('11/12/2014 9:50:18.024642 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3560, 4737, 3, 0, 2, 
    TO_TIMESTAMP('11/12/2014 9:50:18.024642 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3564, 4739, 1, 0, 0, 
    TO_TIMESTAMP('11/12/2014 10:41:41.043212 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3565, 4739, 2, 0, 1, 
    TO_TIMESTAMP('11/12/2014 10:41:41.043212 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3566, 4739, 3, 0, 2, 
    TO_TIMESTAMP('11/12/2014 10:41:41.043212 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3755, 4937, 1, 0, 0, 
    TO_TIMESTAMP('11/14/2014 8:17:07.261076 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3756, 4937, 2, 0, 1, 
    TO_TIMESTAMP('11/14/2014 8:17:07.261076 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3757, 4937, 3, 0, 2, 
    TO_TIMESTAMP('11/14/2014 8:17:07.261076 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3867, 5042, 1, 0, 0, 
    TO_TIMESTAMP('11/25/2014 1:26:29.438714 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3868, 5042, 2, 0, 1, 
    TO_TIMESTAMP('11/25/2014 1:26:29.438714 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3869, 5042, 3, 0, 2, 
    TO_TIMESTAMP('11/25/2014 1:26:29.438714 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4073, 5245, 1, 0, 0, 
    TO_TIMESTAMP('1/6/2015 1:11:27.606640 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4074, 5245, 2, 0, 1, 
    TO_TIMESTAMP('1/6/2015 1:11:27.606640 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4075, 5245, 3, 0, 2, 
    TO_TIMESTAMP('1/6/2015 1:11:27.606640 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4085, 5252, 1, 0, 0, 
    TO_TIMESTAMP('1/12/2015 3:18:20.612914 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4086, 5252, 2, 0, 1, 
    TO_TIMESTAMP('1/12/2015 3:18:20.612914 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4087, 5252, 3, 0, 2, 
    TO_TIMESTAMP('1/12/2015 3:18:20.612914 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5155, 6437, 1, 0, 0, 
    TO_TIMESTAMP('5/13/2015 2:14:29.694179 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5156, 6437, 2, 0, 1, 
    TO_TIMESTAMP('5/13/2015 2:14:29.694179 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5157, 6437, 3, 0, 2, 
    TO_TIMESTAMP('5/13/2015 2:14:29.694179 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5555, 6738, 1, 0, 0, 
    TO_TIMESTAMP('6/25/2015 12:28:37.481209 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5556, 6738, 2, 0, 1, 
    TO_TIMESTAMP('6/25/2015 12:28:37.481209 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5557, 6738, 3, 0, 2, 
    TO_TIMESTAMP('6/25/2015 12:28:37.481209 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6288, 7651, 1, 0, 0, 
    TO_TIMESTAMP('2/12/2016 1:34:37.606448 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6289, 7651, 2, 0, 1, 
    TO_TIMESTAMP('2/12/2016 1:34:37.606448 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6290, 7651, 3, 0, 2, 
    TO_TIMESTAMP('2/12/2016 1:34:37.606448 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6291, 7653, 1, 0, 0, 
    TO_TIMESTAMP('2/16/2016 12:35:24.626938 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6292, 7653, 2, 0, 1, 
    TO_TIMESTAMP('2/16/2016 12:35:24.626938 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6293, 7653, 3, 0, 2, 
    TO_TIMESTAMP('2/16/2016 12:35:24.626938 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7100, 8453, 1, 2, 0, 
    TO_TIMESTAMP('10/13/2016 11:39:12.237766 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7101, 8453, 2, 2, 1, 
    TO_TIMESTAMP('10/13/2016 11:39:12.237766 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7102, 8453, 3, 3, 2, 
    TO_TIMESTAMP('10/13/2016 11:39:12.237766 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8003, 9354, 1, 0, 0, 
    TO_TIMESTAMP('2/8/2017 8:30:42.911777 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8004, 9354, 2, 0, 1, 
    TO_TIMESTAMP('2/8/2017 8:30:42.911777 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8005, 9354, 3, 0, 2, 
    TO_TIMESTAMP('2/8/2017 8:30:42.911777 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9221, 10562, 1, 0, 0, 
    TO_TIMESTAMP('8/30/2017 1:40:52.919405 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9222, 10562, 2, 0, 1, 
    TO_TIMESTAMP('8/30/2017 1:40:52.919405 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9223, 10562, 3, 0, 2, 
    TO_TIMESTAMP('8/30/2017 1:40:52.919405 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (128, 223, 1, 0, 0, 
    TO_TIMESTAMP('3/20/2013 7:55:00.488095 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (129, 223, 2, 0, 1, 
    TO_TIMESTAMP('3/20/2013 7:55:00.488095 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (130, 223, 3, 0, 2, 
    TO_TIMESTAMP('3/20/2013 7:55:00.488095 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (831, 1825, 1, 1, 0, 
    TO_TIMESTAMP('7/8/2013 9:14:15.413462 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (832, 1825, 2, 2, 1, 
    TO_TIMESTAMP('7/8/2013 9:14:15.413462 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (833, 1825, 3, 3, 2, 
    TO_TIMESTAMP('7/8/2013 9:14:15.413462 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1831, 2824, 1, 0, 0, 
    TO_TIMESTAMP('8/27/2013 8:01:31.513824 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1832, 2824, 2, 0, 1, 
    TO_TIMESTAMP('8/27/2013 8:01:31.513824 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1833, 2824, 3, 0, 2, 
    TO_TIMESTAMP('8/27/2013 8:01:31.513824 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1834, 2825, 1, 0, 0, 
    TO_TIMESTAMP('8/27/2013 8:07:32.442719 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1835, 2825, 2, 0, 1, 
    TO_TIMESTAMP('8/27/2013 8:07:32.442719 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1836, 2825, 3, 0, 2, 
    TO_TIMESTAMP('8/27/2013 8:07:32.442719 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1837, 2826, 1, 0, 0, 
    TO_TIMESTAMP('8/27/2013 8:09:15.721643 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1838, 2826, 2, 0, 1, 
    TO_TIMESTAMP('8/27/2013 8:09:15.721643 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1839, 2826, 3, 0, 2, 
    TO_TIMESTAMP('8/27/2013 8:09:15.721643 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1849, 2830, 1, 0, 0, 
    TO_TIMESTAMP('8/27/2013 8:17:35.208200 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1850, 2830, 2, 0, 1, 
    TO_TIMESTAMP('8/27/2013 8:17:35.208200 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1851, 2830, 3, 0, 2, 
    TO_TIMESTAMP('8/27/2013 8:17:35.208200 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1852, 2831, 1, 0, 0, 
    TO_TIMESTAMP('8/27/2013 8:21:35.992074 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1853, 2831, 2, 0, 1, 
    TO_TIMESTAMP('8/27/2013 8:21:35.992074 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1854, 2831, 3, 0, 2, 
    TO_TIMESTAMP('8/27/2013 8:21:35.992074 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2025, 3022, 1, 0, 0, 
    TO_TIMESTAMP('10/30/2013 4:23:58.339816 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2026, 3022, 2, 0, 1, 
    TO_TIMESTAMP('10/30/2013 4:23:58.339816 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2027, 3022, 3, 0, 2, 
    TO_TIMESTAMP('10/30/2013 4:23:58.339816 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1931, 2924, 1, 0, 0, 
    TO_TIMESTAMP('10/31/2013 8:04:57.091822 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1932, 2924, 2, 0, 1, 
    TO_TIMESTAMP('10/31/2013 8:04:57.091822 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1933, 2924, 3, 0, 2, 
    TO_TIMESTAMP('10/31/2013 8:04:57.091822 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2431, 3624, 1, 0, 0, 
    TO_TIMESTAMP('1/22/2014 9:19:58.885007 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2432, 3624, 2, 0, 1, 
    TO_TIMESTAMP('1/22/2014 9:19:58.885007 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2433, 3624, 3, 0, 2, 
    TO_TIMESTAMP('1/22/2014 9:19:58.885007 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2243, 3526, 1, 2, 0, 
    TO_TIMESTAMP('1/22/2014 10:27:18.153458 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2244, 3526, 2, 2, 1, 
    TO_TIMESTAMP('1/22/2014 10:27:18.153458 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2245, 3526, 3, 3, 2, 
    TO_TIMESTAMP('1/22/2014 10:27:18.153458 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3343, 4532, 1, 2, 0, 
    TO_TIMESTAMP('8/14/2014 10:52:41.195857 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3344, 4532, 2, 2, 1, 
    TO_TIMESTAMP('8/14/2014 10:52:41.195857 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3345, 4532, 3, 3, 2, 
    TO_TIMESTAMP('8/14/2014 10:52:41.195857 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4067, 5243, 1, 0, 0, 
    TO_TIMESTAMP('12/23/2014 6:04:08.906742 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4068, 5243, 2, 0, 1, 
    TO_TIMESTAMP('12/23/2014 6:04:08.906742 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4069, 5243, 3, 0, 2, 
    TO_TIMESTAMP('12/23/2014 6:04:08.906742 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4070, 5244, 1, 0, 0, 
    TO_TIMESTAMP('1/6/2015 12:06:54.714713 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4071, 5244, 2, 0, 1, 
    TO_TIMESTAMP('1/6/2015 12:06:54.714713 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4072, 5244, 3, 0, 2, 
    TO_TIMESTAMP('1/6/2015 12:06:54.714713 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4491, 5557, 1, 0, 0, 
    TO_TIMESTAMP('3/10/2015 9:44:35.081622 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4492, 5557, 2, 0, 1, 
    TO_TIMESTAMP('3/10/2015 9:44:35.081622 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4493, 5557, 3, 0, 2, 
    TO_TIMESTAMP('3/10/2015 9:44:35.081622 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5958, 7340, 1, 0, 0, 
    TO_TIMESTAMP('8/11/2015 2:07:13.134910 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5959, 7340, 2, 0, 1, 
    TO_TIMESTAMP('8/11/2015 2:07:13.134910 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5960, 7340, 3, 0, 2, 
    TO_TIMESTAMP('8/11/2015 2:07:13.134910 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6070, 7443, 1, 2, 0, 
    TO_TIMESTAMP('9/23/2015 7:15:01.516865 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6071, 7443, 2, 2, 1, 
    TO_TIMESTAMP('9/23/2015 7:15:01.516865 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6072, 7443, 3, 3, 2, 
    TO_TIMESTAMP('9/23/2015 7:15:01.516865 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6255, 7637, 1, 0, 0, 
    TO_TIMESTAMP('11/6/2015 1:43:03.146621 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6256, 7637, 2, 0, 1, 
    TO_TIMESTAMP('11/6/2015 1:43:03.146621 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6257, 7637, 3, 0, 2, 
    TO_TIMESTAMP('11/6/2015 1:43:03.146621 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6767, 8141, 1, 2, 0, 
    TO_TIMESTAMP('8/15/2016 1:43:42.869883 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6768, 8141, 2, 2, 1, 
    TO_TIMESTAMP('8/15/2016 1:43:42.869883 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6769, 8141, 3, 3, 2, 
    TO_TIMESTAMP('8/15/2016 1:43:42.869883 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8315, 9659, 1, 0, 0, 
    TO_TIMESTAMP('3/3/2017 7:36:42.568939 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8316, 9659, 2, 0, 1, 
    TO_TIMESTAMP('3/3/2017 7:36:42.568939 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8317, 9659, 3, 0, 2, 
    TO_TIMESTAMP('3/3/2017 7:36:42.568939 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8318, 9660, 1, 0, 0, 
    TO_TIMESTAMP('3/3/2017 8:23:17.390749 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8319, 9660, 2, 0, 1, 
    TO_TIMESTAMP('3/3/2017 8:23:17.390749 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8320, 9660, 3, 0, 2, 
    TO_TIMESTAMP('3/3/2017 8:23:17.390749 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8369, 9678, 1, 0, 0, 
    TO_TIMESTAMP('4/14/2017 10:50:12.413609 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8370, 9678, 2, 0, 1, 
    TO_TIMESTAMP('4/14/2017 10:50:12.413609 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8371, 9678, 3, 0, 2, 
    TO_TIMESTAMP('4/14/2017 10:50:12.413609 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8812, 10158, 1, 0, 0, 
    TO_TIMESTAMP('5/24/2017 3:12:20.388044 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8813, 10158, 2, 0, 1, 
    TO_TIMESTAMP('5/24/2017 3:12:20.388044 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8814, 10158, 3, 0, 2, 
    TO_TIMESTAMP('5/24/2017 3:12:20.388044 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1925, 2922, 1, 0, 0, 
    TO_TIMESTAMP('10/29/2013 2:02:53.209362 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1926, 2922, 2, 0, 1, 
    TO_TIMESTAMP('10/29/2013 2:02:53.209362 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1927, 2922, 3, 0, 2, 
    TO_TIMESTAMP('10/29/2013 2:02:53.209362 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1928, 2923, 1, 0, 0, 
    TO_TIMESTAMP('10/30/2013 3:09:21.082473 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1929, 2923, 2, 0, 1, 
    TO_TIMESTAMP('10/30/2013 3:09:21.082473 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (1930, 2923, 3, 0, 2, 
    TO_TIMESTAMP('10/30/2013 3:09:21.082473 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2031, 3124, 1, 0, 0, 
    TO_TIMESTAMP('11/7/2013 8:30:34.229355 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2032, 3124, 2, 0, 1, 
    TO_TIMESTAMP('11/7/2013 8:30:34.229355 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2033, 3124, 3, 0, 2, 
    TO_TIMESTAMP('11/7/2013 8:30:34.229355 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2234, 3327, 1, 0, 0, 
    TO_TIMESTAMP('12/19/2013 1:25:06.834812 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2235, 3327, 2, 0, 1, 
    TO_TIMESTAMP('12/19/2013 1:25:06.834812 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2236, 3327, 3, 0, 2, 
    TO_TIMESTAMP('12/19/2013 1:25:06.834812 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2240, 3525, 1, 0, 0, 
    TO_TIMESTAMP('1/22/2014 7:55:04.949621 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2241, 3525, 2, 0, 1, 
    TO_TIMESTAMP('1/22/2014 7:55:04.949621 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2242, 3525, 3, 0, 2, 
    TO_TIMESTAMP('1/22/2014 7:55:04.949621 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2246, 3527, 1, 0, 0, 
    TO_TIMESTAMP('1/22/2014 12:32:14.311474 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2247, 3527, 2, 0, 1, 
    TO_TIMESTAMP('1/22/2014 12:32:14.311474 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2248, 3527, 3, 0, 2, 
    TO_TIMESTAMP('1/22/2014 12:32:14.311474 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2749, 3934, 1, 0, 0, 
    TO_TIMESTAMP('3/10/2014 3:31:46.208517 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2750, 3934, 2, 0, 1, 
    TO_TIMESTAMP('3/10/2014 3:31:46.208517 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (2751, 3934, 3, 0, 2, 
    TO_TIMESTAMP('3/10/2014 3:31:46.208517 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3140, 4330, 1, 0, 0, 
    TO_TIMESTAMP('7/8/2014 2:29:21.509939 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3141, 4330, 2, 0, 1, 
    TO_TIMESTAMP('7/8/2014 2:29:21.509939 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3142, 4330, 3, 0, 2, 
    TO_TIMESTAMP('7/8/2014 2:29:21.509939 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3443, 4631, 1, 0, 0, 
    TO_TIMESTAMP('9/16/2014 11:57:05.890104 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3444, 4631, 2, 0, 1, 
    TO_TIMESTAMP('9/16/2014 11:57:05.890104 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3445, 4631, 3, 0, 2, 
    TO_TIMESTAMP('9/16/2014 11:57:05.890104 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3955, 5137, 1, 0, 0, 
    TO_TIMESTAMP('12/2/2014 1:03:23.103849 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3956, 5137, 2, 0, 1, 
    TO_TIMESTAMP('12/2/2014 1:03:23.103849 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (3957, 5137, 3, 0, 2, 
    TO_TIMESTAMP('12/2/2014 1:03:23.103849 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4076, 5247, 1, 0, 0, 
    TO_TIMESTAMP('1/9/2015 7:49:15.741422 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4077, 5247, 2, 0, 1, 
    TO_TIMESTAMP('1/9/2015 7:49:15.741422 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4078, 5247, 3, 0, 2, 
    TO_TIMESTAMP('1/9/2015 7:49:15.741422 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4355, 5637, 1, 0, 0, 
    TO_TIMESTAMP('2/19/2015 1:31:06.018429 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4356, 5637, 2, 0, 1, 
    TO_TIMESTAMP('2/19/2015 1:31:06.018429 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4357, 5637, 3, 0, 2, 
    TO_TIMESTAMP('2/19/2015 1:31:06.018429 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4455, 5538, 1, 2, 0, 
    TO_TIMESTAMP('2/19/2015 2:32:58.903874 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4456, 5538, 2, 2, 1, 
    TO_TIMESTAMP('2/19/2015 2:32:58.903874 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4457, 5538, 3, 3, 2, 
    TO_TIMESTAMP('2/19/2015 2:32:58.903874 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5258, 6538, 1, 0, 0, 
    TO_TIMESTAMP('6/24/2015 11:32:58.687691 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5259, 6538, 2, 0, 1, 
    TO_TIMESTAMP('6/24/2015 11:32:58.687691 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5260, 6538, 3, 0, 2, 
    TO_TIMESTAMP('6/24/2015 11:32:58.687691 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5858, 7238, 1, 0, 0, 
    TO_TIMESTAMP('8/5/2015 7:42:30.512201 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5859, 7238, 2, 0, 1, 
    TO_TIMESTAMP('8/5/2015 7:42:30.512201 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5860, 7238, 3, 0, 2, 
    TO_TIMESTAMP('8/5/2015 7:42:30.512201 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6067, 7442, 1, 0, 0, 
    TO_TIMESTAMP('9/17/2015 11:51:33.413646 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6068, 7442, 2, 0, 1, 
    TO_TIMESTAMP('9/17/2015 11:51:33.413646 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6069, 7442, 3, 0, 2, 
    TO_TIMESTAMP('9/17/2015 11:51:33.413646 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6270, 7644, 1, 0, 0, 
    TO_TIMESTAMP('12/7/2015 2:54:47.301499 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6271, 7644, 2, 0, 1, 
    TO_TIMESTAMP('12/7/2015 2:54:47.301499 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6272, 7644, 3, 0, 2, 
    TO_TIMESTAMP('12/7/2015 2:54:47.301499 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6464, 7841, 1, 2, 0, 
    TO_TIMESTAMP('2/10/2016 7:26:12.396406 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6465, 7841, 2, 2, 1, 
    TO_TIMESTAMP('2/10/2016 7:26:12.396406 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6466, 7841, 3, 3, 2, 
    TO_TIMESTAMP('2/10/2016 7:26:12.396406 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8000, 9353, 1, 2, 0, 
    TO_TIMESTAMP('2/8/2017 8:27:33.433523 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8001, 9353, 2, 2, 1, 
    TO_TIMESTAMP('2/8/2017 8:27:33.433523 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8002, 9353, 3, 3, 2, 
    TO_TIMESTAMP('2/8/2017 8:27:33.433523 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8918, 10260, 1, 0, 0, 
    TO_TIMESTAMP('7/20/2017 7:18:02.990173 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8919, 10260, 2, 0, 1, 
    TO_TIMESTAMP('7/20/2017 7:18:02.990173 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8920, 10260, 3, 0, 2, 
    TO_TIMESTAMP('7/20/2017 7:18:02.990173 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8927, 10264, 1, 0, 0, 
    TO_TIMESTAMP('8/21/2017 3:23:56.314493 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8928, 10264, 2, 0, 1, 
    TO_TIMESTAMP('8/21/2017 3:23:56.314493 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8929, 10264, 3, 0, 2, 
    TO_TIMESTAMP('8/21/2017 3:23:56.314493 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4158, 5438, 1, 0, 0, 
    TO_TIMESTAMP('1/6/2015 1:11:31.632970 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4159, 5438, 2, 0, 1, 
    TO_TIMESTAMP('1/6/2015 1:11:31.632970 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4160, 5438, 3, 0, 2, 
    TO_TIMESTAMP('1/6/2015 1:11:31.632970 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4458, 5539, 1, 0, 0, 
    TO_TIMESTAMP('2/20/2015 7:31:30.355050 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4459, 5539, 2, 0, 1, 
    TO_TIMESTAMP('2/20/2015 7:31:30.355050 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4460, 5539, 3, 0, 2, 
    TO_TIMESTAMP('2/20/2015 7:31:30.355050 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4488, 5556, 1, 2, 0, 
    TO_TIMESTAMP('3/6/2015 12:33:15.046207 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4489, 5556, 2, 2, 1, 
    TO_TIMESTAMP('3/6/2015 12:33:15.046207 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4490, 5556, 3, 3, 2, 
    TO_TIMESTAMP('3/6/2015 12:33:15.046207 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4494, 5558, 1, 0, 0, 
    TO_TIMESTAMP('3/11/2015 11:55:41.524755 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4495, 5558, 2, 0, 1, 
    TO_TIMESTAMP('3/11/2015 11:55:41.524755 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4496, 5558, 3, 0, 2, 
    TO_TIMESTAMP('3/11/2015 11:55:41.524755 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4412, 5665, 1, 0, 0, 
    TO_TIMESTAMP('3/13/2015 11:23:48.423401 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4413, 5665, 2, 0, 1, 
    TO_TIMESTAMP('3/13/2015 11:23:48.423401 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4414, 5665, 3, 0, 2, 
    TO_TIMESTAMP('3/13/2015 11:23:48.423401 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5655, 7037, 1, 0, 0, 
    TO_TIMESTAMP('7/7/2015 10:11:26.481988 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5656, 7037, 2, 0, 1, 
    TO_TIMESTAMP('7/7/2015 10:11:26.481988 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5657, 7037, 3, 0, 2, 
    TO_TIMESTAMP('7/7/2015 10:11:26.481988 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5755, 7137, 1, 0, 0, 
    TO_TIMESTAMP('7/29/2015 12:04:05.548900 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5756, 7137, 2, 0, 1, 
    TO_TIMESTAMP('7/29/2015 12:04:05.548900 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5757, 7137, 3, 0, 2, 
    TO_TIMESTAMP('7/29/2015 12:04:05.548900 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5758, 7138, 1, 2, 0, 
    TO_TIMESTAMP('7/29/2015 1:25:37.346456 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5759, 7138, 2, 2, 1, 
    TO_TIMESTAMP('7/29/2015 1:25:37.346456 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5760, 7138, 3, 3, 2, 
    TO_TIMESTAMP('7/29/2015 1:25:37.346456 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5761, 7139, 1, 0, 0, 
    TO_TIMESTAMP('7/31/2015 2:57:51.504806 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5762, 7139, 2, 0, 1, 
    TO_TIMESTAMP('7/31/2015 2:57:51.504806 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5763, 7139, 3, 0, 2, 
    TO_TIMESTAMP('7/31/2015 2:57:51.504806 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5867, 7242, 1, 0, 0, 
    TO_TIMESTAMP('8/10/2015 8:49:57.616487 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5868, 7242, 2, 0, 1, 
    TO_TIMESTAMP('8/10/2015 8:49:57.616487 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5869, 7242, 3, 0, 2, 
    TO_TIMESTAMP('8/10/2015 8:49:57.616487 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6076, 7445, 1, 2, 0, 
    TO_TIMESTAMP('9/23/2015 9:07:00.248436 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6077, 7445, 2, 2, 1, 
    TO_TIMESTAMP('9/23/2015 9:07:00.248436 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6078, 7445, 3, 3, 2, 
    TO_TIMESTAMP('9/23/2015 9:07:00.248436 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7106, 8455, 1, 0, 0, 
    TO_TIMESTAMP('10/18/2016 12:10:11.855704 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7107, 8455, 2, 0, 1, 
    TO_TIMESTAMP('10/18/2016 12:10:11.855704 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7108, 8455, 3, 0, 2, 
    TO_TIMESTAMP('10/18/2016 12:10:11.855704 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7303, 8654, 1, 0, 0, 
    TO_TIMESTAMP('11/16/2016 8:44:56.887537 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7304, 8654, 2, 0, 1, 
    TO_TIMESTAMP('11/16/2016 8:44:56.887537 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7305, 8654, 3, 0, 2, 
    TO_TIMESTAMP('11/16/2016 8:44:56.887537 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7306, 8655, 1, 0, 0, 
    TO_TIMESTAMP('11/16/2016 10:12:21.226110 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7307, 8655, 2, 0, 1, 
    TO_TIMESTAMP('11/16/2016 10:12:21.226110 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7308, 8655, 3, 0, 2, 
    TO_TIMESTAMP('11/16/2016 10:12:21.226110 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8366, 9677, 1, 0, 0, 
    TO_TIMESTAMP('4/12/2017 8:45:30.076413 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8367, 9677, 2, 0, 1, 
    TO_TIMESTAMP('4/12/2017 8:45:30.076413 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8368, 9677, 3, 0, 2, 
    TO_TIMESTAMP('4/12/2017 8:45:30.076413 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8412, 9758, 1, 2, 0, 
    TO_TIMESTAMP('5/9/2017 1:34:15.005239 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8413, 9758, 2, 2, 1, 
    TO_TIMESTAMP('5/9/2017 1:34:15.005239 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8414, 9758, 3, 3, 2, 
    TO_TIMESTAMP('5/9/2017 1:34:15.005239 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9212, 10558, 1, 0, 0, 
    TO_TIMESTAMP('8/28/2017 7:47:01.565821 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9213, 10558, 2, 0, 1, 
    TO_TIMESTAMP('8/28/2017 7:47:01.565821 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9214, 10558, 3, 0, 2, 
    TO_TIMESTAMP('8/28/2017 7:47:01.565821 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4255, 5537, 1, 0, 0, 
    TO_TIMESTAMP('1/27/2015 9:10:12.498461 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4256, 5537, 2, 0, 1, 
    TO_TIMESTAMP('1/27/2015 9:10:12.498461 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4257, 5537, 3, 0, 2, 
    TO_TIMESTAMP('1/27/2015 9:10:12.498461 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4361, 5639, 1, 0, 0, 
    TO_TIMESTAMP('2/20/2015 10:26:41.171243 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4362, 5639, 2, 0, 1, 
    TO_TIMESTAMP('2/20/2015 10:26:41.171243 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4363, 5639, 3, 0, 2, 
    TO_TIMESTAMP('2/20/2015 10:26:41.171243 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4403, 5657, 1, 0, 0, 
    TO_TIMESTAMP('3/6/2015 9:28:48.223730 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4404, 5657, 2, 0, 1, 
    TO_TIMESTAMP('3/6/2015 9:28:48.223730 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4405, 5657, 3, 0, 2, 
    TO_TIMESTAMP('3/6/2015 9:28:48.223730 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4958, 6138, 1, 0, 0, 
    TO_TIMESTAMP('4/16/2015 7:30:43.600848 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4959, 6138, 2, 0, 1, 
    TO_TIMESTAMP('4/16/2015 7:30:43.600848 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4960, 6138, 3, 0, 2, 
    TO_TIMESTAMP('4/16/2015 7:30:43.600848 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5458, 6838, 1, 0, 0, 
    TO_TIMESTAMP('6/25/2015 8:49:26.713246 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5459, 6838, 2, 0, 1, 
    TO_TIMESTAMP('6/25/2015 8:49:26.713246 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5460, 6838, 3, 0, 2, 
    TO_TIMESTAMP('6/25/2015 8:49:26.713246 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6058, 7439, 1, 2, 0, 
    TO_TIMESTAMP('9/17/2015 7:02:44.027361 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6059, 7439, 2, 2, 1, 
    TO_TIMESTAMP('9/17/2015 7:02:44.027361 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6060, 7439, 3, 3, 2, 
    TO_TIMESTAMP('9/17/2015 7:02:44.027361 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6555, 7937, 1, 0, 0, 
    TO_TIMESTAMP('4/14/2016 10:18:47.578666 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6556, 7937, 2, 0, 1, 
    TO_TIMESTAMP('4/14/2016 10:18:47.578666 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6557, 7937, 3, 0, 2, 
    TO_TIMESTAMP('4/14/2016 10:18:47.578666 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6770, 8142, 1, 0, 0, 
    TO_TIMESTAMP('8/15/2016 3:51:53.636667 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6771, 8142, 2, 0, 1, 
    TO_TIMESTAMP('8/15/2016 3:51:53.636667 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6772, 8142, 3, 0, 2, 
    TO_TIMESTAMP('8/15/2016 3:51:53.636667 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6773, 8143, 1, 0, 0, 
    TO_TIMESTAMP('8/15/2016 3:56:20.587082 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6774, 8143, 2, 0, 1, 
    TO_TIMESTAMP('8/15/2016 3:56:20.587082 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6775, 8143, 3, 0, 2, 
    TO_TIMESTAMP('8/15/2016 3:56:20.587082 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7297, 8652, 1, 0, 0, 
    TO_TIMESTAMP('11/16/2016 7:28:07.456717 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7298, 8652, 2, 0, 1, 
    TO_TIMESTAMP('11/16/2016 7:28:07.456717 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7299, 8652, 3, 0, 2, 
    TO_TIMESTAMP('11/16/2016 7:28:07.456717 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8339, 9668, 1, 0, 0, 
    TO_TIMESTAMP('3/8/2017 7:48:01.849365 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8340, 9668, 2, 0, 1, 
    TO_TIMESTAMP('3/8/2017 7:48:01.849365 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8341, 9668, 3, 0, 2, 
    TO_TIMESTAMP('3/8/2017 7:48:01.849365 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4079, 5250, 1, 0, 0, 
    TO_TIMESTAMP('1/12/2015 9:29:27.147422 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4080, 5250, 2, 0, 1, 
    TO_TIMESTAMP('1/12/2015 9:29:27.147422 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4081, 5250, 3, 0, 2, 
    TO_TIMESTAMP('1/12/2015 9:29:27.147422 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4082, 5251, 1, 0, 0, 
    TO_TIMESTAMP('1/12/2015 9:39:18.966642 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4083, 5251, 2, 0, 1, 
    TO_TIMESTAMP('1/12/2015 9:39:18.966642 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4084, 5251, 3, 0, 2, 
    TO_TIMESTAMP('1/12/2015 9:39:18.966642 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4376, 5648, 1, 0, 0, 
    TO_TIMESTAMP('3/3/2015 9:23:57.512153 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4377, 5648, 2, 0, 1, 
    TO_TIMESTAMP('3/3/2015 9:23:57.512153 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4378, 5648, 3, 0, 2, 
    TO_TIMESTAMP('3/3/2015 9:23:57.512153 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4473, 5545, 1, 0, 0, 
    TO_TIMESTAMP('3/3/2015 10:38:04.553665 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4474, 5545, 2, 0, 1, 
    TO_TIMESTAMP('3/3/2015 10:38:04.553665 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4475, 5545, 3, 0, 2, 
    TO_TIMESTAMP('3/3/2015 10:38:04.553665 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4758, 5938, 1, 0, 0, 
    TO_TIMESTAMP('3/27/2015 8:11:46.574948 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4759, 5938, 2, 0, 1, 
    TO_TIMESTAMP('3/27/2015 8:11:46.574948 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4760, 5938, 3, 0, 2, 
    TO_TIMESTAMP('3/27/2015 8:11:46.574948 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5355, 6637, 1, 0, 0, 
    TO_TIMESTAMP('6/23/2015 8:14:11.224164 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5356, 6637, 2, 0, 1, 
    TO_TIMESTAMP('6/23/2015 8:14:11.224164 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5357, 6637, 3, 0, 2, 
    TO_TIMESTAMP('6/23/2015 8:14:11.224164 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6158, 7538, 1, 2, 0, 
    TO_TIMESTAMP('11/4/2015 1:27:19.688698 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6159, 7538, 2, 2, 1, 
    TO_TIMESTAMP('11/4/2015 1:27:19.688698 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6160, 7538, 3, 3, 2, 
    TO_TIMESTAMP('11/4/2015 1:27:19.688698 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6355, 7737, 1, 0, 0, 
    TO_TIMESTAMP('12/2/2015 1:27:45.524310 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6356, 7737, 2, 0, 1, 
    TO_TIMESTAMP('12/2/2015 1:27:45.524310 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6357, 7737, 3, 0, 2, 
    TO_TIMESTAMP('12/2/2015 1:27:45.524310 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6455, 7837, 1, 0, 0, 
    TO_TIMESTAMP('1/20/2016 3:08:52.478865 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6456, 7837, 2, 0, 1, 
    TO_TIMESTAMP('1/20/2016 3:08:52.478865 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6457, 7837, 3, 0, 2, 
    TO_TIMESTAMP('1/20/2016 3:08:52.478865 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6282, 7649, 1, 0, 0, 
    TO_TIMESTAMP('2/10/2016 7:16:59.265578 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6283, 7649, 2, 0, 1, 
    TO_TIMESTAMP('2/10/2016 7:16:59.265578 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6284, 7649, 3, 0, 2, 
    TO_TIMESTAMP('2/10/2016 7:16:59.265578 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8915, 10259, 1, 0, 0, 
    TO_TIMESTAMP('7/19/2017 1:30:33.818567 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8916, 10259, 2, 0, 1, 
    TO_TIMESTAMP('7/19/2017 1:30:33.818567 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8917, 10259, 3, 0, 2, 
    TO_TIMESTAMP('7/19/2017 1:30:33.818567 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4379, 5649, 1, 0, 0, 
    TO_TIMESTAMP('3/3/2015 10:42:46.464787 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4380, 5649, 2, 0, 1, 
    TO_TIMESTAMP('3/3/2015 10:42:46.464787 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4381, 5649, 3, 0, 2, 
    TO_TIMESTAMP('3/3/2015 10:42:46.464787 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4400, 5656, 1, 0, 0, 
    TO_TIMESTAMP('3/6/2015 7:57:50.448140 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4401, 5656, 2, 0, 1, 
    TO_TIMESTAMP('3/6/2015 7:57:50.448140 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4402, 5656, 3, 0, 2, 
    TO_TIMESTAMP('3/6/2015 7:57:50.448140 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4482, 5548, 1, 0, 0, 
    TO_TIMESTAMP('3/6/2015 9:38:55.147971 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4483, 5548, 2, 0, 1, 
    TO_TIMESTAMP('3/6/2015 9:38:55.147971 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4484, 5548, 3, 0, 2, 
    TO_TIMESTAMP('3/6/2015 9:38:55.147971 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4555, 5737, 1, 0, 0, 
    TO_TIMESTAMP('3/16/2015 7:41:20.093179 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4556, 5737, 2, 0, 1, 
    TO_TIMESTAMP('3/16/2015 7:41:20.093179 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (4557, 5737, 3, 0, 2, 
    TO_TIMESTAMP('3/16/2015 7:41:20.093179 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5861, 7240, 1, 0, 0, 
    TO_TIMESTAMP('8/6/2015 1:21:39.943869 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5862, 7240, 2, 0, 1, 
    TO_TIMESTAMP('8/6/2015 1:21:39.943869 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (5863, 7240, 3, 0, 2, 
    TO_TIMESTAMP('8/6/2015 1:21:39.943869 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6285, 7650, 1, 0, 0, 
    TO_TIMESTAMP('2/11/2016 2:58:50.572906 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6286, 7650, 2, 0, 1, 
    TO_TIMESTAMP('2/11/2016 2:58:50.572906 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6287, 7650, 3, 0, 2, 
    TO_TIMESTAMP('2/11/2016 2:58:50.572906 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8357, 9674, 1, 2, 0, 
    TO_TIMESTAMP('4/12/2017 7:18:54.232553 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8358, 9674, 2, 2, 1, 
    TO_TIMESTAMP('4/12/2017 7:18:54.232553 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8359, 9674, 3, 3, 2, 
    TO_TIMESTAMP('4/12/2017 7:18:54.232553 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6561, 7939, 1, 2, 0, 
    TO_TIMESTAMP('6/2/2016 7:19:03.615871 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6562, 7939, 2, 2, 1, 
    TO_TIMESTAMP('6/2/2016 7:19:03.615871 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6563, 7939, 3, 3, 2, 
    TO_TIMESTAMP('6/2/2016 7:19:03.615871 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6661, 8039, 1, 0, 0, 
    TO_TIMESTAMP('7/29/2016 1:38:14.635503 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6662, 8039, 2, 0, 1, 
    TO_TIMESTAMP('7/29/2016 1:38:14.635503 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6663, 8039, 3, 0, 2, 
    TO_TIMESTAMP('7/29/2016 1:38:14.635503 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6664, 8040, 1, 2, 0, 
    TO_TIMESTAMP('8/5/2016 6:57:04.187208 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6665, 8040, 2, 2, 1, 
    TO_TIMESTAMP('8/5/2016 6:57:04.187208 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6666, 8040, 3, 3, 2, 
    TO_TIMESTAMP('8/5/2016 6:57:04.187208 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6867, 8241, 1, 0, 0, 
    TO_TIMESTAMP('8/15/2016 2:06:12.333824 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6868, 8241, 2, 0, 1, 
    TO_TIMESTAMP('8/15/2016 2:06:12.333824 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6869, 8241, 3, 0, 2, 
    TO_TIMESTAMP('8/15/2016 2:06:12.333824 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6870, 8242, 1, 0, 0, 
    TO_TIMESTAMP('8/16/2016 7:26:26.848798 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6871, 8242, 2, 0, 1, 
    TO_TIMESTAMP('8/16/2016 7:26:26.848798 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6872, 8242, 3, 0, 2, 
    TO_TIMESTAMP('8/16/2016 7:26:26.848798 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6888, 8249, 1, 0, 0, 
    TO_TIMESTAMP('8/24/2016 12:12:49.229938 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6889, 8249, 2, 0, 1, 
    TO_TIMESTAMP('8/24/2016 12:12:49.229938 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6890, 8249, 3, 0, 2, 
    TO_TIMESTAMP('8/24/2016 12:12:49.229938 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7197, 8552, 1, 2, 0, 
    TO_TIMESTAMP('10/13/2016 1:32:24.552677 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7198, 8552, 2, 2, 1, 
    TO_TIMESTAMP('10/13/2016 1:32:24.552677 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7199, 8552, 3, 3, 2, 
    TO_TIMESTAMP('10/13/2016 1:32:24.552677 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7209, 8556, 1, 0, 0, 
    TO_TIMESTAMP('10/18/2016 1:24:12.050347 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7210, 8556, 2, 0, 1, 
    TO_TIMESTAMP('10/18/2016 1:24:12.050347 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7211, 8556, 3, 0, 2, 
    TO_TIMESTAMP('10/18/2016 1:24:12.050347 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7797, 9152, 1, 0, 0, 
    TO_TIMESTAMP('12/22/2016 9:49:26.091305 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7798, 9152, 2, 0, 1, 
    TO_TIMESTAMP('12/22/2016 9:49:26.091305 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7799, 9152, 3, 0, 2, 
    TO_TIMESTAMP('12/22/2016 9:49:26.091305 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7897, 9252, 1, 0, 0, 
    TO_TIMESTAMP('12/28/2016 1:59:37.683435 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7898, 9252, 2, 0, 1, 
    TO_TIMESTAMP('12/28/2016 1:59:37.683435 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7899, 9252, 3, 0, 2, 
    TO_TIMESTAMP('12/28/2016 1:59:37.683435 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8100, 9453, 1, 0, 0, 
    TO_TIMESTAMP('2/8/2017 9:07:53.344610 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8101, 9453, 2, 0, 1, 
    TO_TIMESTAMP('2/8/2017 9:07:53.344610 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8102, 9453, 3, 0, 2, 
    TO_TIMESTAMP('2/8/2017 9:07:53.344610 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8109, 9457, 1, 0, 0, 
    TO_TIMESTAMP('2/15/2017 1:42:34.913536 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8110, 9457, 2, 0, 1, 
    TO_TIMESTAMP('2/15/2017 1:42:34.913536 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8111, 9457, 3, 0, 2, 
    TO_TIMESTAMP('2/15/2017 1:42:34.913536 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8215, 9559, 1, 0, 0, 
    TO_TIMESTAMP('3/3/2017 1:00:17.851682 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8216, 9559, 2, 0, 1, 
    TO_TIMESTAMP('3/3/2017 1:00:17.851682 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8217, 9559, 3, 0, 2, 
    TO_TIMESTAMP('3/3/2017 1:00:17.851682 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8218, 9560, 1, 0, 0, 
    TO_TIMESTAMP('3/3/2017 1:01:41.898429 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8219, 9560, 2, 0, 1, 
    TO_TIMESTAMP('3/3/2017 1:01:41.898429 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8220, 9560, 3, 0, 2, 
    TO_TIMESTAMP('3/3/2017 1:01:41.898429 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8236, 9566, 1, 0, 0, 
    TO_TIMESTAMP('3/8/2017 3:40:58.575967 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8237, 9566, 2, 0, 1, 
    TO_TIMESTAMP('3/8/2017 3:40:58.575967 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8238, 9566, 3, 0, 2, 
    TO_TIMESTAMP('3/8/2017 3:40:58.575967 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8239, 9567, 1, 0, 0, 
    TO_TIMESTAMP('3/8/2017 4:05:58.824904 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8240, 9567, 2, 0, 1, 
    TO_TIMESTAMP('3/8/2017 4:05:58.824904 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8241, 9567, 3, 0, 2, 
    TO_TIMESTAMP('3/8/2017 4:05:58.824904 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8242, 9568, 1, 2, 0, 
    TO_TIMESTAMP('3/9/2017 9:59:04.390610 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8243, 9568, 2, 2, 1, 
    TO_TIMESTAMP('3/9/2017 9:59:04.390610 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8244, 9568, 3, 3, 2, 
    TO_TIMESTAMP('3/9/2017 9:59:04.390610 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8257, 9574, 1, 0, 0, 
    TO_TIMESTAMP('3/10/2017 2:20:12.251285 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8258, 9574, 2, 0, 1, 
    TO_TIMESTAMP('3/10/2017 2:20:12.251285 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8259, 9574, 3, 0, 2, 
    TO_TIMESTAMP('3/10/2017 2:20:12.251285 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8512, 9858, 1, 0, 0, 
    TO_TIMESTAMP('5/9/2017 1:50:41.955895 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8513, 9858, 2, 0, 1, 
    TO_TIMESTAMP('5/9/2017 1:50:41.955895 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8514, 9858, 3, 0, 2, 
    TO_TIMESTAMP('5/9/2017 1:50:41.955895 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8524, 9862, 1, 2, 0, 
    TO_TIMESTAMP('5/11/2017 8:59:54.124157 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8525, 9862, 2, 2, 1, 
    TO_TIMESTAMP('5/11/2017 8:59:54.124157 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8526, 9862, 3, 3, 2, 
    TO_TIMESTAMP('5/11/2017 8:59:54.124157 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8612, 9958, 1, 0, 0, 
    TO_TIMESTAMP('5/15/2017 2:19:56.730423 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8613, 9958, 2, 0, 1, 
    TO_TIMESTAMP('5/15/2017 2:19:56.730423 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8614, 9958, 3, 0, 2, 
    TO_TIMESTAMP('5/15/2017 2:19:56.730423 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9012, 10358, 1, 2, 0, 
    TO_TIMESTAMP('7/19/2017 1:29:35.397244 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9013, 10358, 2, 2, 1, 
    TO_TIMESTAMP('7/19/2017 1:29:35.397244 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9014, 10358, 3, 3, 2, 
    TO_TIMESTAMP('7/19/2017 1:29:35.397244 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6294, 7656, 1, 2, 0, 
    TO_TIMESTAMP('2/17/2016 12:54:18.735629 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6295, 7656, 2, 2, 1, 
    TO_TIMESTAMP('2/17/2016 12:54:18.735629 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6296, 7656, 3, 3, 2, 
    TO_TIMESTAMP('2/17/2016 12:54:18.735629 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6667, 8041, 1, 0, 0, 
    TO_TIMESTAMP('8/5/2016 7:11:22.863736 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6668, 8041, 2, 0, 1, 
    TO_TIMESTAMP('8/5/2016 7:11:22.863736 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6669, 8041, 3, 0, 2, 
    TO_TIMESTAMP('8/5/2016 7:11:22.863736 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6670, 8043, 1, 0, 0, 
    TO_TIMESTAMP('8/8/2016 8:11:14.327142 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6671, 8043, 2, 0, 1, 
    TO_TIMESTAMP('8/8/2016 8:11:14.327142 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6672, 8043, 3, 0, 2, 
    TO_TIMESTAMP('8/8/2016 8:11:14.327142 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6673, 8044, 1, 0, 0, 
    TO_TIMESTAMP('8/8/2016 12:44:14.983502 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6674, 8044, 2, 0, 1, 
    TO_TIMESTAMP('8/8/2016 12:44:14.983502 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6675, 8044, 3, 0, 2, 
    TO_TIMESTAMP('8/8/2016 12:44:14.983502 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6676, 8045, 1, 0, 0, 
    TO_TIMESTAMP('8/8/2016 1:03:20.003206 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6677, 8045, 2, 0, 1, 
    TO_TIMESTAMP('8/8/2016 1:03:20.003206 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6678, 8045, 3, 0, 2, 
    TO_TIMESTAMP('8/8/2016 1:03:20.003206 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6861, 8239, 1, 0, 0, 
    TO_TIMESTAMP('8/11/2016 2:20:21.175086 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6862, 8239, 2, 0, 1, 
    TO_TIMESTAMP('8/11/2016 2:20:21.175086 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6863, 8239, 3, 0, 2, 
    TO_TIMESTAMP('8/11/2016 2:20:21.175086 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6873, 8243, 1, 2, 0, 
    TO_TIMESTAMP('8/16/2016 7:58:55.034399 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6874, 8243, 2, 2, 1, 
    TO_TIMESTAMP('8/16/2016 7:58:55.034399 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6875, 8243, 3, 3, 2, 
    TO_TIMESTAMP('8/16/2016 7:58:55.034399 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6885, 8248, 1, 0, 0, 
    TO_TIMESTAMP('8/17/2016 2:27:14.337766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6886, 8248, 2, 0, 1, 
    TO_TIMESTAMP('8/17/2016 2:27:14.337766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6887, 8248, 3, 0, 2, 
    TO_TIMESTAMP('8/17/2016 2:27:14.337766 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6997, 8352, 1, 0, 0, 
    TO_TIMESTAMP('9/22/2016 8:52:46.098377 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6998, 8352, 2, 0, 1, 
    TO_TIMESTAMP('9/22/2016 8:52:46.098377 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6999, 8352, 3, 0, 2, 
    TO_TIMESTAMP('9/22/2016 8:52:46.098377 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7203, 8554, 1, 0, 0, 
    TO_TIMESTAMP('10/17/2016 9:20:11.329574 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7204, 8554, 2, 0, 1, 
    TO_TIMESTAMP('10/17/2016 9:20:11.329574 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7205, 8554, 3, 0, 2, 
    TO_TIMESTAMP('10/17/2016 9:20:11.329574 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7206, 8555, 1, 0, 0, 
    TO_TIMESTAMP('10/18/2016 8:10:43.774456 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7207, 8555, 2, 0, 1, 
    TO_TIMESTAMP('10/18/2016 8:10:43.774456 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7208, 8555, 3, 0, 2, 
    TO_TIMESTAMP('10/18/2016 8:10:43.774456 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7212, 8558, 1, 0, 0, 
    TO_TIMESTAMP('10/20/2016 1:28:50.844181 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7213, 8558, 2, 0, 1, 
    TO_TIMESTAMP('10/20/2016 1:28:50.844181 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7214, 8558, 3, 0, 2, 
    TO_TIMESTAMP('10/20/2016 1:28:50.844181 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7900, 9253, 1, 0, 0, 
    TO_TIMESTAMP('12/28/2016 2:17:25.319647 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7901, 9253, 2, 0, 1, 
    TO_TIMESTAMP('12/28/2016 2:17:25.319647 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7902, 9253, 3, 0, 2, 
    TO_TIMESTAMP('12/28/2016 2:17:25.319647 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8248, 9570, 1, 0, 0, 
    TO_TIMESTAMP('3/9/2017 1:55:07.906439 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8249, 9570, 2, 0, 1, 
    TO_TIMESTAMP('3/9/2017 1:55:07.906439 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8250, 9570, 3, 0, 2, 
    TO_TIMESTAMP('3/9/2017 1:55:07.906439 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8251, 9571, 1, 0, 0, 
    TO_TIMESTAMP('3/9/2017 2:00:57.660174 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8252, 9571, 2, 0, 1, 
    TO_TIMESTAMP('3/9/2017 2:00:57.660174 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8253, 9571, 3, 0, 2, 
    TO_TIMESTAMP('3/9/2017 2:00:57.660174 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8260, 9575, 1, 2, 0, 
    TO_TIMESTAMP('4/14/2017 10:46:52.236056 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8261, 9575, 2, 2, 1, 
    TO_TIMESTAMP('4/14/2017 10:46:52.236056 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8262, 9575, 3, 3, 2, 
    TO_TIMESTAMP('4/14/2017 10:46:52.236056 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8263, 9576, 1, 0, 0, 
    TO_TIMESTAMP('4/14/2017 12:46:06.308172 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8264, 9576, 2, 0, 1, 
    TO_TIMESTAMP('4/14/2017 12:46:06.308172 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8265, 9576, 3, 0, 2, 
    TO_TIMESTAMP('4/14/2017 12:46:06.308172 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8518, 9860, 1, 2, 0, 
    TO_TIMESTAMP('5/10/2017 1:05:01.597410 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8519, 9860, 2, 2, 1, 
    TO_TIMESTAMP('5/10/2017 1:05:01.597410 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8520, 9860, 3, 3, 2, 
    TO_TIMESTAMP('5/10/2017 1:05:01.597410 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8527, 9863, 1, 0, 0, 
    TO_TIMESTAMP('5/11/2017 3:17:10.179598 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8528, 9863, 2, 0, 1, 
    TO_TIMESTAMP('5/11/2017 3:17:10.179598 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8529, 9863, 3, 0, 2, 
    TO_TIMESTAMP('5/11/2017 3:17:10.179598 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6864, 8240, 1, 0, 0, 
    TO_TIMESTAMP('8/15/2016 12:51:49.852597 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6865, 8240, 2, 0, 1, 
    TO_TIMESTAMP('8/15/2016 12:51:49.852597 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6866, 8240, 3, 0, 2, 
    TO_TIMESTAMP('8/15/2016 12:51:49.852597 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6876, 8244, 1, 2, 0, 
    TO_TIMESTAMP('8/16/2016 7:59:45.358672 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6877, 8244, 2, 2, 1, 
    TO_TIMESTAMP('8/16/2016 7:59:45.358672 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (6878, 8244, 3, 3, 2, 
    TO_TIMESTAMP('8/16/2016 7:59:45.358672 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7597, 8952, 1, 0, 0, 
    TO_TIMESTAMP('11/22/2016 2:42:16.635198 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7598, 8952, 2, 0, 1, 
    TO_TIMESTAMP('11/22/2016 2:42:16.635198 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (7599, 8952, 3, 0, 2, 
    TO_TIMESTAMP('11/22/2016 2:42:16.635198 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8103, 9454, 1, 0, 0, 
    TO_TIMESTAMP('2/9/2017 9:00:23.536126 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8104, 9454, 2, 0, 1, 
    TO_TIMESTAMP('2/9/2017 9:00:23.536126 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8105, 9454, 3, 0, 2, 
    TO_TIMESTAMP('2/9/2017 9:00:23.536126 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8112, 9458, 1, 0, 0, 
    TO_TIMESTAMP('2/17/2017 11:56:58.797318 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8113, 9458, 2, 0, 1, 
    TO_TIMESTAMP('2/17/2017 11:56:58.797318 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8114, 9458, 3, 0, 2, 
    TO_TIMESTAMP('2/17/2017 11:56:58.797318 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8212, 9558, 1, 2, 0, 
    TO_TIMESTAMP('3/3/2017 6:54:40.341494 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8213, 9558, 2, 2, 1, 
    TO_TIMESTAMP('3/3/2017 6:54:40.341494 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8214, 9558, 3, 3, 2, 
    TO_TIMESTAMP('3/3/2017 6:54:40.341494 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8221, 9561, 1, 0, 0, 
    TO_TIMESTAMP('3/6/2017 2:08:10.060576 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8222, 9561, 2, 0, 1, 
    TO_TIMESTAMP('3/6/2017 2:08:10.060576 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8223, 9561, 3, 0, 2, 
    TO_TIMESTAMP('3/6/2017 2:08:10.060576 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8245, 9569, 1, 0, 0, 
    TO_TIMESTAMP('3/9/2017 12:27:10.134703 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8246, 9569, 2, 0, 1, 
    TO_TIMESTAMP('3/9/2017 12:27:10.134703 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8247, 9569, 3, 0, 2, 
    TO_TIMESTAMP('3/9/2017 12:27:10.134703 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8254, 9572, 1, 0, 0, 
    TO_TIMESTAMP('3/9/2017 2:01:12.366197 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8255, 9572, 2, 0, 1, 
    TO_TIMESTAMP('3/9/2017 2:01:12.366197 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8256, 9572, 3, 0, 2, 
    TO_TIMESTAMP('3/9/2017 2:01:12.366197 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8266, 9577, 1, 0, 0, 
    TO_TIMESTAMP('4/14/2017 2:48:01.374203 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8267, 9577, 2, 0, 1, 
    TO_TIMESTAMP('4/14/2017 2:48:01.374203 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8268, 9577, 3, 0, 2, 
    TO_TIMESTAMP('4/14/2017 2:48:01.374203 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8269, 9578, 1, 0, 0, 
    TO_TIMESTAMP('4/17/2017 9:22:05.004243 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8270, 9578, 2, 0, 1, 
    TO_TIMESTAMP('4/17/2017 9:22:05.004243 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8271, 9578, 3, 0, 2, 
    TO_TIMESTAMP('4/17/2017 9:22:05.004243 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8515, 9859, 1, 0, 0, 
    TO_TIMESTAMP('5/9/2017 2:08:16.902131 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8516, 9859, 2, 0, 1, 
    TO_TIMESTAMP('5/9/2017 2:08:16.902131 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8517, 9859, 3, 0, 2, 
    TO_TIMESTAMP('5/9/2017 2:08:16.902131 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8712, 10058, 1, 0, 0, 
    TO_TIMESTAMP('5/17/2017 1:21:32.916317 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8713, 10058, 2, 0, 1, 
    TO_TIMESTAMP('5/17/2017 1:21:32.916317 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (8714, 10058, 3, 0, 2, 
    TO_TIMESTAMP('5/17/2017 1:21:32.916317 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9015, 10359, 1, 0, 0, 
    TO_TIMESTAMP('7/20/2017 2:20:16.061290 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9016, 10359, 2, 0, 1, 
    TO_TIMESTAMP('7/20/2017 2:20:16.061290 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9017, 10359, 3, 0, 2, 
    TO_TIMESTAMP('7/20/2017 2:20:16.061290 PM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9112, 10458, 1, 2, 0, 
    TO_TIMESTAMP('8/28/2017 6:54:53.865130 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9113, 10458, 2, 2, 1, 
    TO_TIMESTAMP('8/28/2017 6:54:53.865130 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9114, 10458, 3, 3, 2, 
    TO_TIMESTAMP('8/28/2017 6:54:53.865130 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9312, 10658, 1, 0, 0, 
    TO_TIMESTAMP('8/30/2017 10:44:39.562818 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9313, 10658, 2, 0, 1, 
    TO_TIMESTAMP('8/30/2017 10:44:39.562818 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
Insert into DMP_QUESTION_ANSWER
   (DMP_QUESTION_ANSWER_ID, DMP_RESPONSE_ID, QUESTION, ANSWER, LINE_NBR, 
    MESSAGE_INSERTION_TIME)
 Values
   (9314, 10658, 3, 0, 2, 
    TO_TIMESTAMP('8/30/2017 10:44:39.562818 AM','fmMMfm/fmDDfm/YYYY fmHH12fm:MI:SS.FF AM'));
COMMIT;

/******************************************************************************
	Reset Squences
******************************************************************************/


SET SERVEROUTPUT ON

DECLARE

  VC_sql_line_01                       VARCHAR2(80);
  VC_sql_line_02                       VARCHAR2(80);
  VC_sql_line_03                       VARCHAR2(80);
  VC_sql_line_04                       VARCHAR2(80);
  VC_sql_line_05                       VARCHAR2(80);
  VC_sql_line_06                       VARCHAR2(80);
  VC_sql_line_07                       VARCHAR2(80);
  VC_sql_text                          VARCHAR2(4000);

  VN_next_seq_value                    NUMBER;
  VN_next_seq_value_census             NUMBER;

  SEQ_NOT_FOUND                        EXCEPTION;

  PRAGMA EXCEPTION_INIT(SEQ_NOT_FOUND, -02289);

BEGIN

------------------------------------------------------------------------------
-- sequence 1
------------------------------------------------------------------------------

  BEGIN

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION: Processing sequence Care_Coordinator_Seq_Id');
    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Retrieving next ID value');

    SELECT    NVL(MAX(Care_Coordinator_Id),0) + 1
    INTO      VN_next_seq_value
    FROM      Care_Coordinator;

    SELECT    NVL(MAX(Care_Coordinator_Id),0) + 1
    INTO      VN_next_seq_value_census
    FROM      Census_Ccoord;

    IF VN_next_seq_value_census > VN_next_seq_value THEN

      VN_next_seq_value := VN_next_seq_value_census;

    END IF;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Next ID value: ' || TO_CHAR(VN_next_seq_value));
    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Dropping sequence');

    VC_sql_text := 'DROP SEQUENCE Care_Coordinator_Seq_Id';

    BEGIN

      EXECUTE IMMEDIATE VC_sql_text;

        SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence dropped');

    EXCEPTION

      WHEN SEQ_NOT_FOUND THEN

        SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence not found');

      WHEN OTHERS THEN

        SYS.DBMS_OUTPUT.Put_Line(SUBSTR('Error dropping sequence - ' || SQLERRM,1,254));

    END;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Recreating sequence');

    VC_sql_line_01 := 'CREATE SEQUENCE CARE_COORDINATOR_SEQ_ID';
    VC_sql_line_02 := ' START WITH ' || VN_next_seq_value;
    VC_sql_line_03 := ' MAXVALUE 999999999999999999999999999';
    VC_sql_line_04 := ' MINVALUE 1';
    VC_sql_line_05 := ' NOCYCLE';
    VC_sql_line_06 := ' CACHE 20';
    VC_sql_line_07 := ' NOORDER';

    SYS.DBMS_OUTPUT.Put_Line(CHR(10));
    SYS.DBMS_OUTPUT.Put_Line('SQL to execute');
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_01);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_02);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_03);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_04);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_05);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_06);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_07);
    SYS.DBMS_OUTPUT.Put_Line(CHR(10));

    VC_sql_text := VC_sql_line_01 || VC_sql_line_02 || VC_sql_line_03 || VC_sql_line_04 || VC_sql_line_05
                   || VC_sql_line_06 || VC_sql_line_07;

    EXECUTE IMMEDIATE VC_sql_text;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence recreated');
    SYS.DBMS_OUTPUT.Put_Line(CHR(10));

  EXCEPTION

    WHEN OTHERS THEN

      SYS.DBMS_OUTPUT.Put_Line(SUBSTR('Error reseting sequence Care_Coordinator_Seq_Id - ' || SQLERRM,1,254));

  END;

------------------------------------------------------------------------------
-- sequence 2
------------------------------------------------------------------------------

  BEGIN

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION: Processing sequence Survey_Choice_Seq_Id');
    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Retrieving next ID value');

    SELECT    NVL(MAX(Survey_Choice_Id),0) + 1
    INTO      VN_next_seq_value
    FROM      Survey_Choice;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Next ID value: ' || TO_CHAR(VN_next_seq_value));
    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Dropping sequence');

    VC_sql_text := 'DROP SEQUENCE Survey_Choice_Seq_Id';

    BEGIN

      EXECUTE IMMEDIATE VC_sql_text;

        SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence dropped');

    EXCEPTION

      WHEN SEQ_NOT_FOUND THEN

        SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence not found');

      WHEN OTHERS THEN

        SYS.DBMS_OUTPUT.Put_Line(SUBSTR('Error dropping sequence - ' || SQLERRM,1,254));

    END;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Recreating sequence');

    VC_sql_line_01 := 'CREATE SEQUENCE Survey_Choice_Seq_Id';
    VC_sql_line_02 := ' START WITH ' || VN_next_seq_value;
    VC_sql_line_03 := ' MAXVALUE 999999999999999999999999999';
    VC_sql_line_04 := ' MINVALUE 1';
    VC_sql_line_05 := ' NOCYCLE';
    VC_sql_line_06 := ' CACHE 20';
    VC_sql_line_07 := ' NOORDER';

    SYS.DBMS_OUTPUT.Put_Line(CHR(10));
    SYS.DBMS_OUTPUT.Put_Line('SQL to execute');
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_01);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_02);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_03);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_04);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_05);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_06);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_07);
    SYS.DBMS_OUTPUT.Put_Line(CHR(10));

    VC_sql_text := VC_sql_line_01 || VC_sql_line_02 || VC_sql_line_03 || VC_sql_line_04 || VC_sql_line_05
                   || VC_sql_line_06 || VC_sql_line_07;

    EXECUTE IMMEDIATE VC_sql_text;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence recreated');
    SYS.DBMS_OUTPUT.Put_Line(CHR(10));

  EXCEPTION

    WHEN OTHERS THEN

      SYS.DBMS_OUTPUT.Put_Line(SUBSTR('Error reseting sequence Survey_Choice_Seq_Id - ' || SQLERRM,1,254));

  END;

------------------------------------------------------------------------------
-- sequence 3
------------------------------------------------------------------------------

  BEGIN

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION: Processing sequence Survey_Patient_Seq_Id');
    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Retrieving next ID value');

    SELECT    NVL(MAX(Survey_Patient_Id),0) + 1
    INTO      VN_next_seq_value
    FROM      Survey_Patient;

    SELECT    NVL(MAX(Survey_Patient_Id),0) + 1
    INTO      VN_next_seq_value_census
    FROM      Census_Patient;

    IF VN_next_seq_value_census > VN_next_seq_value THEN

      VN_next_seq_value := VN_next_seq_value_census;

    END IF;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Next ID value: ' || TO_CHAR(VN_next_seq_value));
    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Dropping sequence');

    VC_sql_text := 'DROP SEQUENCE Survey_Patient_Seq_Id';

    BEGIN

      EXECUTE IMMEDIATE VC_sql_text;

        SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence dropped');

    EXCEPTION

      WHEN SEQ_NOT_FOUND THEN

        SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence not found');

      WHEN OTHERS THEN

        SYS.DBMS_OUTPUT.Put_Line(SUBSTR('Error dropping sequence - ' || SQLERRM,1,254));

    END;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Recreating sequence');

    VC_sql_line_01 := 'CREATE SEQUENCE Survey_Patient_Seq_Id';
    VC_sql_line_02 := ' START WITH ' || VN_next_seq_value;
    VC_sql_line_03 := ' MAXVALUE 999999999999999999999999999';
    VC_sql_line_04 := ' MINVALUE 1';
    VC_sql_line_05 := ' NOCYCLE';
    VC_sql_line_06 := ' CACHE 20';
    VC_sql_line_07 := ' NOORDER';

    SYS.DBMS_OUTPUT.Put_Line(CHR(10));
    SYS.DBMS_OUTPUT.Put_Line('SQL to execute');
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_01);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_02);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_03);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_04);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_05);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_06);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_07);
    SYS.DBMS_OUTPUT.Put_Line(CHR(10));

    VC_sql_text := VC_sql_line_01 || VC_sql_line_02 || VC_sql_line_03 || VC_sql_line_04 || VC_sql_line_05
                   || VC_sql_line_06 || VC_sql_line_07;

    EXECUTE IMMEDIATE VC_sql_text;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence recreated');
    SYS.DBMS_OUTPUT.Put_Line(CHR(10));

  EXCEPTION

    WHEN OTHERS THEN

      SYS.DBMS_OUTPUT.Put_Line(SUBSTR('Error reseting sequence Survey_Patient_Seq_Id - ' || SQLERRM,1,254));

  END;

------------------------------------------------------------------------------
-- sequence 4
------------------------------------------------------------------------------

  BEGIN

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION: Processing sequence Survey_Question_Answer_Seq_Id');
    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Retrieving next ID value');

    SELECT    NVL(MAX(Survey_Question_Answer_Id),0) + 1
    INTO      VN_next_seq_value
    FROM      Survey_Question_Answer;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Next ID value: ' || TO_CHAR(VN_next_seq_value));
    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Dropping sequence');

    VC_sql_text := 'DROP SEQUENCE Survey_Question_Answer_Seq_Id';

    BEGIN

      EXECUTE IMMEDIATE VC_sql_text;

        SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence dropped');

    EXCEPTION

      WHEN SEQ_NOT_FOUND THEN

        SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence not found');

      WHEN OTHERS THEN

        SYS.DBMS_OUTPUT.Put_Line(SUBSTR('Error dropping sequence - ' || SQLERRM,1,254));

    END;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Recreating sequence');

    VC_sql_line_01 := 'CREATE SEQUENCE Survey_Question_Answer_Seq_Id';
    VC_sql_line_02 := ' START WITH ' || VN_next_seq_value;
    VC_sql_line_03 := ' MAXVALUE 999999999999999999999999999';
    VC_sql_line_04 := ' MINVALUE 1';
    VC_sql_line_05 := ' NOCYCLE';
    VC_sql_line_06 := ' CACHE 20';
    VC_sql_line_07 := ' NOORDER';

    SYS.DBMS_OUTPUT.Put_Line(CHR(10));
    SYS.DBMS_OUTPUT.Put_Line('SQL to execute');
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_01);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_02);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_03);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_04);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_05);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_06);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_07);
    SYS.DBMS_OUTPUT.Put_Line(CHR(10));

    VC_sql_text := VC_sql_line_01 || VC_sql_line_02 || VC_sql_line_03 || VC_sql_line_04 || VC_sql_line_05
                   || VC_sql_line_06 || VC_sql_line_07;

    EXECUTE IMMEDIATE VC_sql_text;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence recreated');
    SYS.DBMS_OUTPUT.Put_Line(CHR(10));

  EXCEPTION

    WHEN OTHERS THEN

      SYS.DBMS_OUTPUT.Put_Line(SUBSTR('Error reseting sequence Survey_Question_Answer_Seq_Id - ' || SQLERRM,1,254));

  END;

------------------------------------------------------------------------------
-- sequence 5
------------------------------------------------------------------------------

  BEGIN

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION: Processing sequence Survey_Question_Seq_Id');
    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Retrieving next ID value');

    SELECT    NVL(MAX(Survey_Question_Id),0) + 1
    INTO      VN_next_seq_value
    FROM      Survey_Question;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Next ID value: ' || TO_CHAR(VN_next_seq_value));
    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Dropping sequence');

    VC_sql_text := 'DROP SEQUENCE Survey_Question_Seq_Id';

    BEGIN

      EXECUTE IMMEDIATE VC_sql_text;

        SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence dropped');

    EXCEPTION

      WHEN SEQ_NOT_FOUND THEN

        SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence not found');

      WHEN OTHERS THEN

        SYS.DBMS_OUTPUT.Put_Line(SUBSTR('Error dropping sequence - ' || SQLERRM,1,254));

    END;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Recreating sequence');

    VC_sql_line_01 := 'CREATE SEQUENCE Survey_Question_Seq_Id';
    VC_sql_line_02 := ' START WITH ' || VN_next_seq_value;
    VC_sql_line_03 := ' MAXVALUE 999999999999999999999999999';
    VC_sql_line_04 := ' MINVALUE 1';
    VC_sql_line_05 := ' NOCYCLE';
    VC_sql_line_06 := ' CACHE 20';
    VC_sql_line_07 := ' NOORDER';

    SYS.DBMS_OUTPUT.Put_Line(CHR(10));
    SYS.DBMS_OUTPUT.Put_Line('SQL to execute');
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_01);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_02);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_03);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_04);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_05);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_06);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_07);
    SYS.DBMS_OUTPUT.Put_Line(CHR(10));

    VC_sql_text := VC_sql_line_01 || VC_sql_line_02 || VC_sql_line_03 || VC_sql_line_04 || VC_sql_line_05
                   || VC_sql_line_06 || VC_sql_line_07;

    EXECUTE IMMEDIATE VC_sql_text;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence recreated');
    SYS.DBMS_OUTPUT.Put_Line(CHR(10));

  EXCEPTION

    WHEN OTHERS THEN

      SYS.DBMS_OUTPUT.Put_Line(SUBSTR('Error reseting sequence Survey_Question_Seq_Id - ' || SQLERRM,1,254));

  END;

------------------------------------------------------------------------------
-- sequence 6
------------------------------------------------------------------------------

  BEGIN

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION: Processing sequence Survey_Response_Seq_Id');
    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Retrieving next ID value');

    SELECT    NVL(MAX(Survey_Response_Id),0) + 1
    INTO      VN_next_seq_value
    FROM      Survey_Response;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Next ID value: ' || TO_CHAR(VN_next_seq_value));
    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Dropping sequence');

    VC_sql_text := 'DROP SEQUENCE Survey_Response_Seq_Id';

    BEGIN

      EXECUTE IMMEDIATE VC_sql_text;

        SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence dropped');

    EXCEPTION

      WHEN SEQ_NOT_FOUND THEN

        SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence not found');

      WHEN OTHERS THEN

        SYS.DBMS_OUTPUT.Put_Line(SUBSTR('Error dropping sequence - ' || SQLERRM,1,254));

    END;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Recreating sequence');

    VC_sql_line_01 := 'CREATE SEQUENCE Survey_Response_Seq_Id';
    VC_sql_line_02 := ' START WITH ' || VN_next_seq_value;
    VC_sql_line_03 := ' MAXVALUE 999999999999999999999999999';
    VC_sql_line_04 := ' MINVALUE 1';
    VC_sql_line_05 := ' NOCYCLE';
    VC_sql_line_06 := ' CACHE 20';
    VC_sql_line_07 := ' NOORDER';

    SYS.DBMS_OUTPUT.Put_Line(CHR(10));
    SYS.DBMS_OUTPUT.Put_Line('SQL to execute');
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_01);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_02);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_03);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_04);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_05);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_06);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_07);
    SYS.DBMS_OUTPUT.Put_Line(CHR(10));

    VC_sql_text := VC_sql_line_01 || VC_sql_line_02 || VC_sql_line_03 || VC_sql_line_04 || VC_sql_line_05
                   || VC_sql_line_06 || VC_sql_line_07;

    EXECUTE IMMEDIATE VC_sql_text;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence recreated');
    SYS.DBMS_OUTPUT.Put_Line(CHR(10));

  EXCEPTION

    WHEN OTHERS THEN

      SYS.DBMS_OUTPUT.Put_Line(SUBSTR('Error reseting sequence Survey_Response_Seq_Id - ' || SQLERRM,1,254));

  END;

------------------------------------------------------------------------------
-- sequence 7
------------------------------------------------------------------------------

  BEGIN

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION: Processing sequence Survey_Seq_Id');
    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Retrieving next ID value');

    SELECT    NVL(MAX(Survey_Id),0) + 1
    INTO      VN_next_seq_value
    FROM      Survey;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Next ID value: ' || TO_CHAR(VN_next_seq_value));
    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Dropping sequence');

    VC_sql_text := 'DROP SEQUENCE Survey_Seq_Id';

    BEGIN

      EXECUTE IMMEDIATE VC_sql_text;

        SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence dropped');

    EXCEPTION

      WHEN SEQ_NOT_FOUND THEN

        SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence not found');

      WHEN OTHERS THEN

        SYS.DBMS_OUTPUT.Put_Line(SUBSTR('Error dropping sequence - ' || SQLERRM,1,254));

    END;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Recreating sequence');

    VC_sql_line_01 := 'CREATE SEQUENCE Survey_Seq_Id';
    VC_sql_line_02 := ' START WITH ' || VN_next_seq_value;
    VC_sql_line_03 := ' MAXVALUE 999999999999999999999999999';
    VC_sql_line_04 := ' MINVALUE 1';
    VC_sql_line_05 := ' NOCYCLE';
    VC_sql_line_06 := ' CACHE 20';
    VC_sql_line_07 := ' NOORDER';

    SYS.DBMS_OUTPUT.Put_Line(CHR(10));
    SYS.DBMS_OUTPUT.Put_Line('SQL to execute');
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_01);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_02);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_03);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_04);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_05);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_06);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_07);
    SYS.DBMS_OUTPUT.Put_Line(CHR(10));

    VC_sql_text := VC_sql_line_01 || VC_sql_line_02 || VC_sql_line_03 || VC_sql_line_04 || VC_sql_line_05
                   || VC_sql_line_06 || VC_sql_line_07;

    EXECUTE IMMEDIATE VC_sql_text;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence recreated');
    SYS.DBMS_OUTPUT.Put_Line(CHR(10));

  EXCEPTION

    WHEN OTHERS THEN

      SYS.DBMS_OUTPUT.Put_Line(SUBSTR('Error reseting sequence Survey_Seq_Id - ' || SQLERRM,1,254));

  END;

------------------------------------------------------------------------------
-- sequence 8
------------------------------------------------------------------------------

  BEGIN

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION: Processing sequence Vendor_Seq_Id');
    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Retrieving next ID value');

    SELECT    NVL(MAX(Vendor_Id),0) + 1
    INTO      VN_next_seq_value
    FROM      Vendor;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Next ID value: ' || TO_CHAR(VN_next_seq_value));
    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Dropping sequence');

    VC_sql_text := 'DROP SEQUENCE Vendor_Seq_Id';

    BEGIN

      EXECUTE IMMEDIATE VC_sql_text;

        SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence dropped');

    EXCEPTION

      WHEN SEQ_NOT_FOUND THEN

        SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence not found');

      WHEN OTHERS THEN

        SYS.DBMS_OUTPUT.Put_Line(SUBSTR('Error dropping sequence - ' || SQLERRM,1,254));

    END;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:   Recreating sequence');

    VC_sql_line_01 := 'CREATE SEQUENCE Vendor_Seq_Id';
    VC_sql_line_02 := ' START WITH ' || VN_next_seq_value;
    VC_sql_line_03 := ' MAXVALUE 999999999999999999999999999';
    VC_sql_line_04 := ' MINVALUE 1';
    VC_sql_line_05 := ' NOCYCLE';
    VC_sql_line_06 := ' CACHE 20';
    VC_sql_line_07 := ' NOORDER';

    SYS.DBMS_OUTPUT.Put_Line(CHR(10));
    SYS.DBMS_OUTPUT.Put_Line('SQL to execute');
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_01);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_02);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_03);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_04);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_05);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_06);
    SYS.DBMS_OUTPUT.Put_Line('- ' || VC_sql_line_07);
    SYS.DBMS_OUTPUT.Put_Line(CHR(10));

    VC_sql_text := VC_sql_line_01 || VC_sql_line_02 || VC_sql_line_03 || VC_sql_line_04 || VC_sql_line_05
                   || VC_sql_line_06 || VC_sql_line_07;

    EXECUTE IMMEDIATE VC_sql_text;

    SYS.DBMS_OUTPUT.Put_Line('INFORMATION:     Sequence recreated');
    SYS.DBMS_OUTPUT.Put_Line(CHR(10));

  EXCEPTION

    WHEN OTHERS THEN

      SYS.DBMS_OUTPUT.Put_Line(SUBSTR('Error reseting sequence Vendor_Seq_Id - ' || SQLERRM,1,254));

  END;

EXCEPTION

  WHEN OTHERS THEN

    SYS.DBMS_OUTPUT.Put_Line(SUBSTR('Error reseting sequence numbers - ' || SQLERRM,1,254));

END;
/

commit;

