

package gov.va.med.cds.logger;


import gov.va.med.cds.ejb.interceptor.CdsLoggerAuditAutowiredInterceptor;
import gov.va.med.cds.log4j.ApplicationLogEvent;
import gov.va.med.cds.log4j.persistence.LoggerPersistenceManagerInterface;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
//import org.apache.log4j.spi.LoggingEvent;
import org.apache.logging.log4j.core.LogEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.interceptor.Interceptors;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;


/**
 * @author vhaislegberb
 * 
 */
@Interceptors( CdsLoggerAuditAutowiredInterceptor.class )
public class LoggerMessageDrivenBean
    implements
        MessageListener
{
    protected final Log logger = LogFactory.getLog( getClass() );

    @Autowired
    @Qualifier( "loggerPersistenceManager2" )
    private LoggerPersistenceManagerInterface loggerPersistenceManager;


    public LoggerMessageDrivenBean( )
    {
    }


    public void onMessage( Message aMessage )
    {
        ApplicationLogEvent appLogEvent = null;
        try
        {
            ObjectMessage objectMessage = ( ( ObjectMessage )aMessage );
            LogEvent logEvent = ( LogEvent )objectMessage.getObject();

            appLogEvent = new ApplicationLogEvent( logEvent );

            if ( appLogEvent.getDomainName().equalsIgnoreCase( "PharmacyCreateOrUpdate40060" ) && appLogEvent.getMessage().contains( "ORA-00001" ) )
            {
                // Ignore unique constraint exceptions throw due to Rx create messages
            }
            else
            {
                loggerPersistenceManager.persistApplicationLogEvent( appLogEvent );
            }
        }
        catch ( Exception e )
        {
            // make sure that any logs coming from the logging sub-system only go to the file or stdout.
            if ( logger.isErrorEnabled() )
            {
                logger.error( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, "APP_UNKNOWN", 
                                  "Error proccessing JMS Appender log event. " ), e );
            }
        }
    }

}
