

package gov.va.med.cds.client.functional.vhim400;


import static gov.va.med.cds.testharness.xml.Assert.assertNoErrors;
import static gov.va.med.cds.testharness.xml.Assert.assertXmlSimilar;
import static org.junit.Assert.assertTrue;
import gov.va.med.cds.client.functional.AbstractDataGeneratorValidatorTest;
import gov.va.med.cds.clinicaldata.vhim400.ConfigurableClinicalDataResponse;
import gov.va.med.cds.junit.runners.BeforeTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;
import gov.va.med.cds.testharness.xml.XmlValidator;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;


/**
 * 
 * This is abstract class that tests creating, reading and deleting records delegating to a 2.1.x clinicalDataService.
 * A child extended test class extends this class so that all 2.1.x functionality is tested using 3.0 
 * client test classes for Soap, Ejb and Rest.
 */
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/client/functional/testDataGeneratorContext.xml" } )
public abstract class AbstractClientDelegatedTest
    extends
        AbstractDataGeneratorValidatorTest
{
    @Autowired
    protected ConfigurableClinicalDataResponse configurableTIUClinicalDataResponse;

    @Autowired
    protected ConfigurableClinicalDataResponse configurableNonVAMedsClinicalDataResponse;

    @Autowired
    protected ConfigurableClinicalDataResponse configurableSkintestProcedureClinicalDataResponse;

    @Autowired
    protected ConfigurableClinicalDataResponse configurableImmunizationEventClinicalDataResponse;

    @Autowired
    protected ConfigurableClinicalDataResponse configurableHealthConcernClinicalDataResponse;

    @Autowired
    protected ConfigurableClinicalDataResponse configurableOutpatientMedicationPromiseClinicalDataResponse;

    @Test
    @BeforeTestsOnce
    @Suite( groups = "appservertest" )
    public void testIsAlive( )
    {
        assertTrue( clinicalDataService.isAlive() );
    }


    //@Test
    @Suite( groups = "checkintest" )
    /**
     * Test to create, read and delete record for Allergy Assessments Domain
     */
    public void testAllergiesAssessments( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String templateId = TemplateIdHelper.ALLERGY_ASSESSMENT_CREATEORUPDATE_TEMPLATE_ID;
        String createRequest = dataGenerator.createAllergyAssessmentXml( requestId, templateId, uniquePatientIdentity );

        String startDate = new SimpleDateFormat( DATE_FORMAT_PATTERN ).format( Calendar.getInstance().getTime() );
        // Create record 
        String createResult = clinicalDataService.createClinicalData( createRequest, templateId, requestId );
        assertNoErrors( createResult );
        String endDate = new SimpleDateFormat( DATE_FORMAT_PATTERN ).format( Calendar.getInstance().getTime() );

        String filterId = TemplateIdHelper.AA_SINGLE_PATIENT_ALL_DATA_FILTER;
        String readTemplateId = TemplateIdHelper.ALLERGY_ASSESSMENT_READ_TEMPLATE_ID;
        String expectedReadResult = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );

        // Make a read request with basic filter
        //String readFilter = dataGenerator.createFilterFromAllergyAssessment( createRequest, filterId, null);
        String readFilter = "<filter:filter xmlns:filter=\"Filter\" vhimVersion=\"Vhim_4_00\"><filterId>AA_SINGLE_PATIENT_ALL_DATA_FILTER</filterId><patients><resolvedIdentifiers><assigningAuthority>USVHA</assigningAuthority><assigningFacility>605</assigningFacility><identity>test_sourceid_10001</identity></resolvedIdentifiers></patients><entryPointFilter queryName=\"id_1\"><domainEntryPoint>AllergyAssessment</domainEntryPoint></entryPointFilter></filter:filter>";
        String readResult = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        // Make a read request with single patient read filter with date range
        Map<String, String> entryPointFilterElements = new HashMap<String, String>();
        entryPointFilterElements.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterElements.put( FilterBuilder.END_DATE_KEY, endDate );
        readFilter = dataGenerator.createFilterFromAllergyAssessment( createRequest, filterId, entryPointFilterElements );
        String readResultForFilterWithDateRange = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        // Delete record
        String deleteTemplateId = TemplateIdHelper.ALLERGY_ASSESSMENT_DELETE_TEMPLATE_ID;
        String deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( deleteTemplateId, createRequest );
        String deleteResult = clinicalDataService.deleteClinicalData( deleteRequest, deleteTemplateId, requestId );

        // Make assertions and validations
        assertNoErrors( deleteResult );

        //Single patient read response
        XmlValidator.validateXml( readResult, TemplateIdHelper.ALLERGY_ASSESSMENT_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResult ), expectedReadResult );

        //Single patient read response with filter using date range 
        XmlValidator.validateXml( readResultForFilterWithDateRange, TemplateIdHelper.ALLERGY_ASSESSMENT_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResultForFilterWithDateRange ), expectedReadResult );
    }


    //@Test
    @Suite( groups = "checkintest" )
    /**
     * Test to create, read and delete record for Intolerance Conditions Domain
     */
    public void testIntoleranceConditions( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String templateId = TemplateIdHelper.INTOLERANCE_CONDITION_CREATEORUPDATE_TEMPLATE_ID;
        String createRequest = dataGenerator.createIntoleranceConditionXml( templateId, requestId, uniquePatientIdentity );

        // Create record
        String startDate = new SimpleDateFormat( DATE_FORMAT_PATTERN ).format( Calendar.getInstance().getTime() );
        String createResult = clinicalDataService.createClinicalData( createRequest, templateId, requestId );
        assertNoErrors( createResult );
        String endDate = new SimpleDateFormat( DATE_FORMAT_PATTERN ).format( Calendar.getInstance().getTime() );

        // Make a read request with single patient read filter    
        String filterId = TemplateIdHelper.IC_SINGLE_PATIENT_ALL_DATA_FILTER;
        String readTemplateId = TemplateIdHelper.INTOLERANCE_CONDITION_READ_TEMPLATE_ID;
        String expectedReadResult1 = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
        String readFilter = dataGenerator.createFilterFromIntoleranceConditions( createRequest, filterId, null );
        String readResult1 = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        // Make a read request with single patient read filter with date range
        filterId = TemplateIdHelper.IC_SINGLE_PATIENT_ALL_DATA_FILTER;
        readTemplateId = TemplateIdHelper.INTOLERANCE_CONDITION_READ_TEMPLATE_ID;
        Map<String, String> entryPointFilterElements = new HashMap<String, String>();
        entryPointFilterElements.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterElements.put( FilterBuilder.END_DATE_KEY, endDate );
        readFilter = dataGenerator.createFilterFromIntoleranceConditions( createRequest, filterId, entryPointFilterElements );
        String readResultWithDateRange = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        // Make a read request with reduced template
        filterId = TemplateIdHelper.IC_SINGLE_PATIENT_ALL_DATA_FILTER;
        readTemplateId = TemplateIdHelper.INTOLERANCE_CONDITION_REDUCED_READ_TEMPLATE_ID;
        String expectedReadResult2 = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
        readFilter = dataGenerator.createFilterFromIntoleranceConditions( createRequest, filterId, null );
        String readResult2 = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        // Make a read request with My Healthy Vet read filter        
        filterId = TemplateIdHelper.IC_SINGLE_PATIENT_ALL_DATA_FILTER;
        readTemplateId = TemplateIdHelper.MHV_INTOLERANCE_CONDITION_READ_TEMPLATE_ID;
        String expectedReadResult3 = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
        readFilter = dataGenerator.createFilterFromIntoleranceConditions( createRequest, filterId, null );
        String readResult3 = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        //Make a read request with VistA Web read filter 
        filterId = TemplateIdHelper.VW_IC_SINGLE_PATIENT_FILTER;
        readTemplateId = TemplateIdHelper.VW_INTOLERANCE_CONDITION_READ_TEMPLATE_ID;
        String expectedReadResult4 = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
        readFilter = dataGenerator.createFilterFromIntoleranceConditions( createRequest, filterId, null );
        String readResult4 = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        // Delete record
        String deleteTemplateId = TemplateIdHelper.INTOLERANCE_CONDITION_DELETE_TEMPLATE_ID;
        String deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( deleteTemplateId, createRequest );
        String deleteResult = clinicalDataService.deleteClinicalData( deleteRequest, deleteTemplateId, requestId );

        // Make assertions and validations        
        assertNoErrors( deleteResult );

        // Single patient read response
        XmlValidator.validateXml( readResult1, TemplateIdHelper.INTOLERANCE_CONDITION_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResult1 ), expectedReadResult1 );

        // Single patient read response with reduced template
        XmlValidator.validateXml( readResult2, TemplateIdHelper.INTOLERANCE_CONDITION_REDUCED_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResult2 ), expectedReadResult2 );

        // My Healthy Vet read response
        XmlValidator.validateXml( readResult3, TemplateIdHelper.MHV_INTOLERANCE_CONDITION_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResult3 ), expectedReadResult3 );

        // VistA Web read response
        XmlValidator.validateXml( readResult4, TemplateIdHelper.VW_INTOLERANCE_CONDITION_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResult4 ), expectedReadResult4 );

        // Single patient read response with date range
        XmlValidator.validateXml( readResultWithDateRange, TemplateIdHelper.INTOLERANCE_CONDITION_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResultWithDateRange ), expectedReadResult1 );

    }


    // @Test
//    @Suite( groups = "brokentest" )
//    /**
//     * Test to create, read and delete record for Intolerance Conditions Domain
//     */
//    public void testChdrIntoleranceConditions_NationalId( )
//        throws Exception
//    {
//        // Create record
//        String requestId = TemplateIdHelper.getUniqueIdentifier();
//        String templateId = TemplateIdHelper.INTOLERANCE_CONDITION_CREATEORUPDATE_TEMPLATE_ID;
//        String createRequest = dataGenerator.createIntoleranceConditionXml( templateId, requestId, uniquePatientIdentity );
//        String createResult = clinicalDataService.createClinicalData( createRequest, templateId, requestId );
//        assertNoErrors( createResult );
//
//        // Make a read request with CHDR Intolerance Condition Filter
//        String filterId = TemplateIdHelper.CHDR_ALLERGY_SINGLE_PATIENT_FILTER;
//        String readTemplateId = TemplateIdHelper.INTOLERANCE_CONDITION_READ_TEMPLATE_ID;
//        String expectedReadResult1 = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
//        String readFilter = dataGenerator.createFilterFromIntoleranceConditions( createRequest, filterId, null );
//        String readResult1 = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );
//
//        // Make a read request with CHDR Intolerance Condition Reduces Filter
//        filterId = TemplateIdHelper.CHDR_ALLERGY_SINGLE_PATIENT_FILTER;
//        readTemplateId = TemplateIdHelper.INTOLERANCE_CONDITION_REDUCED_READ_TEMPLATE_ID;
//        String expectedReadResult2 = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
//        String readResult2 = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );
//
//        // Delete record
//        String deleteTemplateId = TemplateIdHelper.INTOLERANCE_CONDITION_DELETE_TEMPLATE_ID;
//        String deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( deleteTemplateId, createRequest );
//        String deleteResult = clinicalDataService.deleteClinicalData( deleteRequest, deleteTemplateId, requestId );
//
//        // Make assertions and validations     
//        assertNoErrors( deleteResult );
//
//        XmlValidator.validateXml( readResult1, TemplateIdHelper.INTOLERANCE_CONDITION_READ_TEMPLATE_ID );
//        assertXmlSimilar( detachNodesFromReadResult( readResult1 ), expectedReadResult1 );
//
//        XmlValidator.validateXml( readResult2, TemplateIdHelper.INTOLERANCE_CONDITION_REDUCED_READ_TEMPLATE_ID );
//        assertXmlSimilar( detachNodesFromReadResult( readResult2 ), expectedReadResult2 );
//    }


    //@Test
    @Suite( groups = "checkintest" )
    /**
     * Test to create, read and delete record for All Allergies: Intolerance Conditions & Allergy Assessment
     */
    public void testAllAllergies( )
        throws Exception
    {
        // Create records
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String assessmentTemplateId = TemplateIdHelper.ALLERGY_ASSESSMENT_CREATEORUPDATE_TEMPLATE_ID;
        String icTemplateId = TemplateIdHelper.INTOLERANCE_CONDITION_CREATEORUPDATE_TEMPLATE_ID;
        String[] createRequests = dataGenerator.createAllergies( assessmentTemplateId, icTemplateId, requestId, uniquePatientIdentity );
        String assessmentCreateRequest = createRequests[0];
        String intoleranceCoditionCreateRequest = createRequests[1];
        String mergedCreateRequest = dataGenerator.mergeCreateRequests( assessmentCreateRequest, intoleranceCoditionCreateRequest,
                        "intoleranceConditions" );

        // Create an allergy assessment record
        String assesmentCreateResult = clinicalDataService.createClinicalData( assessmentCreateRequest, assessmentTemplateId, requestId );
        // Create an intolerance condition record
        String intoleranceCreateResult = clinicalDataService.createClinicalData( intoleranceCoditionCreateRequest, icTemplateId, requestId );

        // Make a read request with VW Allergy filter
        String filterId = TemplateIdHelper.VW_ALLERGY_SINGLE_PATIENT_FILTER;
        String readTemplateId = TemplateIdHelper.VW_ALLERGIES_READ_TEMPLATE_ID;
        String expectedReadResult = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, mergedCreateRequest );
        String readFilter = dataGenerator.createVwAllergySinglePatientFilter( assessmentCreateRequest, filterId );
        String readResult = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        // Delete records
        String deleteTemplateId = TemplateIdHelper.ALLERGY_ASSESSMENT_DELETE_TEMPLATE_ID;
        String deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( deleteTemplateId, assessmentCreateRequest );
        // Delete allergy assessment record
        String assesmentDeleteResult = clinicalDataService.deleteClinicalData( deleteRequest, deleteTemplateId, requestId );

        deleteTemplateId = TemplateIdHelper.INTOLERANCE_CONDITION_DELETE_TEMPLATE_ID;
        deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( deleteTemplateId, intoleranceCoditionCreateRequest );
        // Delete intolerance condition record
        String intoleranceDeleteResult = clinicalDataService.deleteClinicalData( deleteRequest, deleteTemplateId, requestId );

        // Make assertions and validations
        assertNoErrors( assesmentCreateResult );
        assertNoErrors( intoleranceCreateResult );

        assertNoErrors( assesmentDeleteResult );
        assertNoErrors( intoleranceDeleteResult );

        XmlValidator.validateXml( readResult, TemplateIdHelper.VW_ALLERGIES_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResult ), expectedReadResult );

    }


    //@Test
    @Suite( groups = "checkintest" )
    /**
     * Test to create, read and delete record for All Allergies: Intolerance Conditions & Allergy Assessment
     */
    public void testAllAllergies_NationalId( )
        throws Exception
    {
        // Create records
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String assessmentTemplateId = TemplateIdHelper.ALLERGY_ASSESSMENT_CREATEORUPDATE_TEMPLATE_ID;
        String icTemplateId = TemplateIdHelper.INTOLERANCE_CONDITION_CREATEORUPDATE_TEMPLATE_ID;
        String[] createRequests = dataGenerator.createAllergies( assessmentTemplateId, icTemplateId, requestId, uniquePatientIdentity );
        String assessmentCreateRequest = createRequests[0];
        String intoleranceCoditionCreateRequest = createRequests[1];
        String mergedCreateRequest = dataGenerator.mergeCreateRequests( assessmentCreateRequest, intoleranceCoditionCreateRequest,
                        "intoleranceConditions" );

        // Create allergy assessment record
        String assesmentCreateResult = clinicalDataService.createClinicalData( assessmentCreateRequest, assessmentTemplateId, requestId );
        // Create intolerance condition record
        String intoleranceCreateResult = clinicalDataService.createClinicalData( intoleranceCoditionCreateRequest, icTemplateId, requestId );

        //All Allergies Filter
        String filterId = TemplateIdHelper.ALLERGY_SINGLE_PATIENT_ALL_DATA_FILTER;
        String readTemplateId = TemplateIdHelper.ALLERGIES_READ_TEMPLATE_ID;
        String expectedReadResult1 = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, mergedCreateRequest );
        String readFilter = dataGenerator.createFilterFromAllergies( assessmentCreateRequest, filterId );
        String readResult1 = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        // Make read request with CHDR Allergies Filter
        filterId = TemplateIdHelper.CHDR_ALLERGY_SINGLE_PATIENT_FILTER;
        readTemplateId = TemplateIdHelper.ALLERGIES_READ_TEMPLATE_ID;
        String expectedReadResult2 = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, mergedCreateRequest );
        readFilter = dataGenerator.createFilterFromAllergies( assessmentCreateRequest, filterId );
        String readResult2 = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        // Delete records
        String deleteTemplateId = TemplateIdHelper.ALLERGY_ASSESSMENT_DELETE_TEMPLATE_ID;
        String deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( deleteTemplateId, assessmentCreateRequest );
        // Delete allergy assessment record
        String assesmentDeleteResult = clinicalDataService.deleteClinicalData( deleteRequest, deleteTemplateId, requestId );

        // Delete intolerance condition record
        deleteTemplateId = TemplateIdHelper.INTOLERANCE_CONDITION_DELETE_TEMPLATE_ID;
        deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( deleteTemplateId, intoleranceCoditionCreateRequest );
        String intoleranceDeleteResult = clinicalDataService.deleteClinicalData( deleteRequest, deleteTemplateId, requestId );

        // Make assertions and validations
        assertNoErrors( assesmentCreateResult );
        assertNoErrors( intoleranceCreateResult );
        assertNoErrors( assesmentDeleteResult );
        assertNoErrors( intoleranceDeleteResult );

        XmlValidator.validateXml( readResult1, TemplateIdHelper.ALLERGIES_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResult1 ), expectedReadResult1 );

        XmlValidator.validateXml( readResult2, TemplateIdHelper.ALLERGIES_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResult2 ), expectedReadResult2 );

    }



   /**
    * Test to create, read and delete record for Pharmacy Domain
    */
//    @Test
//    @Suite( groups = "junktest" )
//   public void testPharmacy( )
//       throws Exception
//   {
//       String requestId = TemplateIdHelper.getUniqueIdentifier();
//       String templateId = TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID;
//       String createRequest = dataGenerator.createOutpatientMedicationPromiseXml( templateId, requestId, uniquePatientIdentity );
//       
//       // Remove any requestId added by dataGenerator code
////       Document requestDocument = DocumentHelper.parseText( createRequest );
////       requestDocument.selectSingleNode( "//requestId" ).detach();
////       createRequest = requestDocument.asXML();
//
//       String startDate = new SimpleDateFormat( DATE_FORMAT_PATTERN ).format( Calendar.getInstance().getTime() );
//       // Create record
//       String createResult = clinicalDataService.createClinicalData( createRequest, templateId, requestId );
//       assertNoErrors( createResult );
//       String endDate = new SimpleDateFormat( DATE_FORMAT_PATTERN ).format( Calendar.getInstance().getTime() );
//
//       // Make a read request with Rx Single Patient All Data Filter
//       String filterId = TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER;
//       String readTemplateId = TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID;
//       String expectedReadResult1 = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
//       String readFilter = dataGenerator.createFilterFromOutpatientMedicationPromise( createRequest, filterId, null );
//       String readResult1 = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );
//
////       // Make a read request with VW Rx Single Patient All Data Filter  
//////       filterId = TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER;
//////       readTemplateId = TemplateIdHelper.VW_PHARMACY_READ_TEMPLATE_ID;
//////       String expectedReadResult2 = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
//////       String readResult2 = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );
//////
//////       // Make a read request with VW Rx Single Patient Detailed Read
//////       filterId = TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER;
//////       readTemplateId = TemplateIdHelper.VW_PHARMACY_READ_DETAIL_TEMPLATE_ID;
//////       String expectedReadResult3 = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
//////       String readResult3 = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );
////
//       // Make a read request with Rx Single Patient Single Record Filter
//       filterId = TemplateIdHelper.RX_SINGLE_PATIENT_SINGLE_RECORD_FILTER;
//       readTemplateId = TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID;
//       String expectedReadResult4 = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
//       readFilter = dataGenerator.createFilterFromOutpatientMedicationPromise( createRequest, filterId, null );
//       String readResult4 = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );
//
////       // Make a read request with VW Rx Single Patient Single Record Filter using VW Pharmacy Read
//////       filterId = TemplateIdHelper.RX_SINGLE_PATIENT_SINGLE_RECORD_FILTER;
//////       readTemplateId = TemplateIdHelper.VW_PHARMACY_READ_TEMPLATE_ID;
//////       String expectedReadResult5 = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
//////       String readResult5 = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );
//////
//////       // Make a read request with VW Rx Single Patient Single Record Filter using VW Pharmacy Detailed Read
//////       filterId = TemplateIdHelper.RX_SINGLE_PATIENT_SINGLE_RECORD_FILTER;
//////       readTemplateId = TemplateIdHelper.VW_PHARMACY_READ_DETAIL_TEMPLATE_ID;
//////       String expectedReadResult6 = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
//////       String readResult6 = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );
////
////       // Make a read request with single patient read filter with date range
//       filterId = TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER;
//       readTemplateId = TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID;
//       Map<String, String> entryPointFilterElements = new HashMap<String, String>();
//       entryPointFilterElements.put( FilterBuilder.START_DATE_KEY, startDate );
//       entryPointFilterElements.put( FilterBuilder.END_DATE_KEY, endDate );
//       readFilter = dataGenerator.createFilterFromOutpatientMedicationPromise( createRequest, filterId, entryPointFilterElements );
//       String readResultWithDateRange = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );
//
//       // Delete record
//       String deleteTemplateId = TemplateIdHelper.PHARMACY_DELETE_TEMPLATE_ID;
//       String deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( deleteTemplateId, createRequest );
//       String deleteResult = clinicalDataService.deleteClinicalData( deleteRequest, deleteTemplateId, requestId );
//
//       // Make assertions and validations 
//       assertNoErrors( deleteResult );
//
//       // Single patient read response
//       XmlValidator.validateXml( readResult1, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID );
//       assertXmlSimilar( detachNodesFromReadResult( readResult1, clinicalDataResponse400 ), expectedReadResult1 );
//
////       // Pharmacy VW read response 
////       //XmlValidator.validateXml( readResult2, TemplateIdHelper.VW_PHARMACY_READ_TEMPLATE_ID );
////       //assertXmlSimilar( detachNodesFromReadResult( readResult2, clinicalDataResponse400 ),
////       //                detachNodesFromVWPharmacyReadResult( expectedReadResult2 ) );
////
////       // Pharmacy VW read response
////       //XmlValidator.validateXml( readResult3, TemplateIdHelper.VW_PHARMACY_READ_DETAIL_TEMPLATE_ID );
////       //assertXmlSimilar( detachNodesFromReadResult( readResult3, clinicalDataResponse400 ),
////       //                detachNodesFromVWPharmacyDetailedReadResult( expectedReadResult3 ) );
////
////       // Pharmacy single patient read response
//       XmlValidator.validateXml( readResult4, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID );
//       assertXmlSimilar( detachNodesFromReadResult( readResult4, clinicalDataResponse400 ), expectedReadResult4 );
//
////       // Pharmacy VW read response
//////       XmlValidator.validateXml( readResult5, TemplateIdHelper.VW_PHARMACY_READ_TEMPLATE_ID );
//////       assertXmlSimilar( detachNodesFromReadResult( readResult5, clinicalDataResponse400 ),
//////                       detachNodesFromVWPharmacyReadResult( expectedReadResult5 ) );
////
////       // Pharmacy VW detail read response
//////       XmlValidator.validateXml( readResult6, TemplateIdHelper.VW_PHARMACY_READ_DETAIL_TEMPLATE_ID );
//////       assertXmlSimilar( detachNodesFromReadResult( readResult6, clinicalDataResponse400 ),
//////                       detachNodesFromVWPharmacyDetailedReadResult( expectedReadResult6 ) );
////
////       // Single patient read response with filter using date range
//       XmlValidator.validateXml( readResultWithDateRange, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID );
//       assertXmlSimilar( detachNodesFromReadResult( readResultWithDateRange, clinicalDataResponse400 ), expectedReadResult1 );
//
//   }


   //    @Test
   //    @Suite( groups = "brokentest" )
   //    /*
   //     * needs to be revisited
   //     */
   //    /**
   //     * Test to create, read and delete record for Pharmacy Domain
   //     */
   //    public void testPharmacyWithErrors( )
   //        throws Exception
   //    {
   //        String requestId = TemplateIdHelper.getUniqueIdentifier();
   //        String templateId = TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID;
   //        String createRequest = dataGenerator.createOutpatientMedicationPromiseXml( templateId, requestId, uniquePatientIdentity );
   //
   //        String startDate = new SimpleDateFormat( DATE_FORMAT_PATTERN ).format( Calendar.getInstance().getTime() );
   //        // Create record
   //        String createResult = clinicalDataService.createClinicalData( null, null, null );
   //        assertTrue( createResult.contains( "<errorSection>" ) );
   //        
   //        createResult = clinicalDataService.createClinicalData( "XYZ", null, "XYZ1" );
   //        assertTrue( createResult.contains( "<errorSection>" ) );
   //        
   //        createResult = clinicalDataService.createClinicalData( "XYZ", "INVALID_TEMPLATE_ID", "XYZ1" );
   //        assertTrue( createResult.contains( "<errorSection>" ) );
   //     }

//   @Test
//   @Suite( groups = "brokentest" )
//   /**
//    * Test to create, read and delete record for Pharmacy Domain
//    */
//   public void testChdrPharmacy_NationalId( )
//       throws Exception
//   {
//       String requestId = TemplateIdHelper.getUniqueIdentifier();
//       String templateId = TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID;
//       String createRequest = dataGenerator.createOutpatientMedicationPromiseXml( templateId, requestId, uniquePatientIdentity );
//       String createResult = clinicalDataService.createClinicalData( createRequest, templateId, requestId );
//       assertNoErrors( createResult );
//
//       // CHDR Rx Single Patient Filter
//       String filterId = TemplateIdHelper.CHDR_RX_SINGLE_PATIENT_FILTER;
//       String readTemplateId = TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID;
//       String expectedReadResult = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
//       String readFilter = dataGenerator.createChdrPharmacySinglePatientFilter( createRequest, filterId );
//       String readResult = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );
//
//       String deleteTemplateId = TemplateIdHelper.PHARMACY_DELETE_TEMPLATE_ID;
//       String deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( deleteTemplateId, createRequest );
//       String deleteResult = clinicalDataService.deleteClinicalData( deleteRequest, deleteTemplateId, requestId );
//       assertNoErrors( deleteResult );
//
//       XmlValidator.validateXml( readResult, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID );
//       assertXmlSimilar( detachNodesFromReadResult( readResult, clinicalDataResponse400 ), expectedReadResult );
//
//   }


    @Ignore
    @Test
    @Suite( groups = "brokentest" )
    /**
     * Test to create, read and delete record for Lab Domain, read using Local id
     */
    public void testLabSinglePatientAllDataFilter_LocalId( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String templateId = TemplateIdHelper.LAB_CREATEORUPDATE_TEMPLATE_ID;
        String createRequest = dataGenerator.createLabEventXml( requestId, templateId, uniquePatientIdentity );

        String startDate = new SimpleDateFormat( DATE_FORMAT_PATTERN ).format( Calendar.getInstance().getTime() );
        // Create record 
        String createResult = clinicalDataService.createClinicalData( createRequest, templateId, requestId );
        assertNoErrors( createResult );
        String endDate = new SimpleDateFormat( DATE_FORMAT_PATTERN ).format( Calendar.getInstance().getTime() );

        // Single patient read
        String filterId = TemplateIdHelper.LAB_SINGLE_PATIENT_ALL_DATA_FILTER;
        String readTemplateId = TemplateIdHelper.LAB_READ_TEMPLATE_ID;
        String readFilter = dataGenerator.createFilterFromLabEvent( createRequest, filterId, null );
        String expectedReadResult = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
        String readResult = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        // Single patient read with filter using date range
        // Make a read request with single patient read filter with date range
        filterId = TemplateIdHelper.LAB_SINGLE_PATIENT_ALL_DATA_FILTER;
        readTemplateId = TemplateIdHelper.LAB_READ_TEMPLATE_ID;
        Map<String, String> entryPointFilterElements = new HashMap<String, String>();
        entryPointFilterElements.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterElements.put( FilterBuilder.END_DATE_KEY, endDate );
        readFilter = dataGenerator.createFilterFromLabEvent( createRequest, filterId, entryPointFilterElements );
        String readResultWithDateRange = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        // Delete record
        String deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( TemplateIdHelper.LAB_DELETE_TEMPLATE_ID, createRequest );
        String deleteReply = clinicalDataService.deleteClinicalData( deleteRequest, TemplateIdHelper.LAB_DELETE_TEMPLATE_ID, requestId );

        // Make assertions and validations
        assertNoErrors( deleteReply );

        // Single patient read response
        XmlValidator.validateXml( readResult, TemplateIdHelper.LAB_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResult, clinicalDataResponse400 ), expectedReadResult );

        // Single patient read response with filter using date range
        XmlValidator.validateXml( readResultWithDateRange, TemplateIdHelper.LAB_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResultWithDateRange, clinicalDataResponse400 ), expectedReadResult );
    }


    @Ignore
    @Test
    @Suite( groups = "brokentest" )
    /**
     * Test to create, read and delete record for Lab Domain, read using National id
     * Note: This test only work in development where we are using psim (not idm)for resolving national id.
     * In this test local id - 10 digit long - set as NationalId, the checksum will be added automatically to the value
     * and make it to look like national id.
     */
    public void testLabSinglePatientAllDataFilter_NationalId( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String templateId = TemplateIdHelper.LAB_CREATEORUPDATE_TEMPLATE_ID;
        String createRequest = dataGenerator.createLabEventXml( requestId, templateId, uniquePatientIdentity );
        String createResult = clinicalDataService.createClinicalData( createRequest, templateId, requestId );
        assertNoErrors( createResult );

        String filterId = TemplateIdHelper.LAB_SINGLE_PATIENT_ALL_DATA_FILTER;
        String readTemplateId = TemplateIdHelper.LAB_READ_TEMPLATE_ID;
        String readFilter = dataGenerator.createFilterFromLabEventWithNationalId( createRequest, filterId, null );
        String expectedReadResult = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
        String readResult = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        String deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( TemplateIdHelper.LAB_DELETE_TEMPLATE_ID, createRequest );
        String deleteReply = clinicalDataService.deleteClinicalData( deleteRequest, TemplateIdHelper.LAB_DELETE_TEMPLATE_ID, requestId );
        assertNoErrors( deleteReply );

        XmlValidator.validateXml( readResult, TemplateIdHelper.LAB_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResult, clinicalDataResponse400 ), expectedReadResult );
    }


    @Ignore
    @Test
    @Suite( groups = "brokentest" )
    /**
     * Test to create, read and delete record for Lab Domain, read using National id
     * Note: This test only work in development where we are using psim (not idm)for resolving national id.
     * In this test local id - 10 digit long - set as NationalId, the checksum will be added automatically to the value
     * and make it to look like national id.
     */
    public void testCHDRLabSinglePatientFilter_NationalId( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String templateId = TemplateIdHelper.LAB_CREATEORUPDATE_TEMPLATE_ID;

        String createRequest = dataGenerator.createLabEventXml( requestId, templateId, uniquePatientIdentity );
        String createResult = clinicalDataService.createClinicalData( createRequest, templateId, requestId );
        assertNoErrors( createResult );

        String filterId = TemplateIdHelper.CHDR_LAB_SINGLE_PATIENT_FILTER;
        String readTemplateId = TemplateIdHelper.LAB_READ_TEMPLATE_ID;
        String expectedReadResult = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
        String readFilter = dataGenerator.createFilterFromLabEventWithNationalId( createRequest, filterId, null );
        String readResult = clinicalDataService.readClinicalData( TemplateIdHelper.LAB_READ_TEMPLATE_ID, readFilter, filterId, requestId );

        String deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( TemplateIdHelper.LAB_DELETE_TEMPLATE_ID, createRequest );
        String deleteReply = clinicalDataService.deleteClinicalData( deleteRequest, TemplateIdHelper.LAB_DELETE_TEMPLATE_ID, requestId );
        assertNoErrors( deleteReply );

        XmlValidator.validateXml( readResult, TemplateIdHelper.LAB_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResult, clinicalDataResponse400 ), expectedReadResult );
    }


    //@Test
    @Suite( groups = "checkintest" )
    /**
     * Test to create, read and delete record for RDI client: Intolerance Conditions & Pharmacy
     */
    public void testRDI( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String icTemplateId = TemplateIdHelper.INTOLERANCE_CONDITION_CREATEORUPDATE_TEMPLATE_ID;
        String rxTemplateId = TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID;

        String[] createRequests = dataGenerator.createIntoleranceConditionAndPharmacyForRDI( icTemplateId, rxTemplateId, requestId,
                        uniquePatientIdentity );
        String intoleranceCoditionCreateRequest = createRequests[0];
        String pharmacyCreateRequest = createRequests[1];
        String mergedCreateRequest = dataGenerator.mergeCreateRequests( intoleranceCoditionCreateRequest, pharmacyCreateRequest,
                        "outpatientMedicationPromises" );

        String intoleranceCreateResult = clinicalDataService.createClinicalData( intoleranceCoditionCreateRequest, icTemplateId, requestId );

        String pharmacyCreateResult = clinicalDataService.createClinicalData( pharmacyCreateRequest, rxTemplateId, requestId );

        String filterId = TemplateIdHelper.RDI_IC_RX_CANNED_FILTER_ID;
        String readTemplateId = TemplateIdHelper.RDI_INTOLERANCE_CONDITION_PHARMACY_READ_TEMPLATE_ID;
        String expectedReadResult = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, mergedCreateRequest );
        String readFilter = dataGenerator.createRdiIntoleranceConditionPharmacySinglePatientFilter( intoleranceCoditionCreateRequest, filterId );
        String readResult = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        String deleteTemplateId = TemplateIdHelper.INTOLERANCE_CONDITION_DELETE_TEMPLATE_ID;
        String deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( deleteTemplateId, intoleranceCoditionCreateRequest );
        String intoleranceDeleteResult = clinicalDataService.deleteClinicalData( deleteRequest, deleteTemplateId, requestId );

        deleteTemplateId = TemplateIdHelper.PHARMACY_DELETE_TEMPLATE_ID;
        deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( deleteTemplateId, pharmacyCreateRequest );
        String pharmacyDeleteResult = clinicalDataService.deleteClinicalData( deleteRequest, deleteTemplateId, requestId );

        assertNoErrors( intoleranceCreateResult );
        assertNoErrors( pharmacyCreateResult );

        assertNoErrors( intoleranceDeleteResult );
        assertNoErrors( pharmacyDeleteResult );

        XmlValidator.validateXml( readResult, TemplateIdHelper.RDI_INTOLERANCE_CONDITION_PHARMACY_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResult, clinicalDataResponse400 ), expectedReadResult );
    }


    //@Test
    @Suite( groups = "checkintest" )
    /**
     * Test to create, read and delete record for Vital Observation Events
     */
    public void testVitalObservationEvent( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String templateId = TemplateIdHelper.VITALSIGNS_CREATEORUPDATE_TEMPLATE_ID;
        String createRequest = dataGenerator.createVitalObservationEventXml( requestId, templateId, uniquePatientIdentity );

        String startDate = new SimpleDateFormat( DATE_FORMAT_PATTERN ).format( Calendar.getInstance().getTime() );
        // Create record 
        String createResult = clinicalDataService.createClinicalData( createRequest, templateId, requestId );
        assertNoErrors( createResult );
        String endDate = new SimpleDateFormat( DATE_FORMAT_PATTERN ).format( Calendar.getInstance().getTime() );

        // Make a single patient read request      
        String filterId = TemplateIdHelper.VITAL_SINGLE_PATIENT_ALL_DATA_FILTER;
        String readTemplateId = TemplateIdHelper.VITALSIGNS_READ_TEMPLATE_ID;
        String readFilter = dataGenerator.createFilterFromVitalObservationEvent( createRequest, filterId, null );
        String expectedReadResult = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
        String readResult = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        // Make a read request with single patient read filter with date range
        Map<String, String> entryPointFilterElements = new HashMap<String, String>();
        entryPointFilterElements.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterElements.put( FilterBuilder.END_DATE_KEY, endDate );
        readFilter = dataGenerator.createFilterFromVitalObservationEvent( createRequest, filterId, entryPointFilterElements );
        String readResultWithDateRange = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        // Delete record
        String deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( TemplateIdHelper.VITALSIGNS_DELETE_TEMPLATE_ID, createRequest );
        String deleteReply = clinicalDataService.deleteClinicalData( deleteRequest, TemplateIdHelper.VITALSIGNS_DELETE_TEMPLATE_ID, requestId );

        // Make assertions and validations
        assertNoErrors( deleteReply );

        // Single patient read response
        XmlValidator.validateXml( readResult, TemplateIdHelper.VITALSIGNS_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResult, clinicalDataResponse400 ), expectedReadResult );

        // Single patient read response with filter using date range 
        XmlValidator.validateXml( readResultWithDateRange, TemplateIdHelper.VITALSIGNS_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResultWithDateRange, clinicalDataResponse400 ), expectedReadResult );

    }


    //@Test
    @Suite( groups = "checkintest" )
    /**
     * Test to create, read and delete record for Vital Observation Events
     */
    public void testVitalObservationEvent_NationalId( )
        throws Exception
    {
        // Create record
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String templateId = TemplateIdHelper.VITALSIGNS_CREATEORUPDATE_TEMPLATE_ID;
        String createRequest = dataGenerator.createVitalObservationEventXml( requestId, templateId, uniquePatientIdentity );
        String createResult = clinicalDataService.createClinicalData( createRequest, templateId, requestId );
        assertNoErrors( createResult );

        // Make a read request with single patient with vital signs read template id
        String filterId = TemplateIdHelper.VITAL_SINGLE_PATIENT_ALL_DATA_FILTER;
        String readTemplateId = TemplateIdHelper.VITALSIGNS_READ_TEMPLATE_ID;
        String expectedReadResult = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
        String readFilter = dataGenerator.createFilterFromVitalObservationEvenWithNationalId( createRequest, filterId, null );
        String readResult = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        // Delete record
        String deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( TemplateIdHelper.VITALSIGNS_DELETE_TEMPLATE_ID, createRequest );
        String deleteReply = clinicalDataService.deleteClinicalData( deleteRequest, TemplateIdHelper.VITALSIGNS_DELETE_TEMPLATE_ID, requestId );

        // Make assertions and validations
        assertNoErrors( deleteReply );

        XmlValidator.validateXml( readResult, TemplateIdHelper.VITALSIGNS_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResult, clinicalDataResponse400 ), expectedReadResult );
    }


    //@Test
    @Suite( groups = "checkintest" )
    /**
     * Test to create, read and delete record for VW client:  Vital Observation Events
     */
    public void testVWVitalObservationEvent( )
        throws Exception
    {
        // Create record
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String templateId = TemplateIdHelper.VITALSIGNS_CREATEORUPDATE_TEMPLATE_ID;
        String createRequest = dataGenerator.createVitalObservationEventXml( requestId, templateId, uniquePatientIdentity );
        String createResult = clinicalDataService.createClinicalData( createRequest, templateId, requestId );
        assertNoErrors( createResult );

        // Make a read request with single patient with vista web vital single patient filter
        String filterId = TemplateIdHelper.VW_VITAL_SINGLE_PATIENT_FILTER;
        String readTemplateId = TemplateIdHelper.VW_VITALSIGNS_READ_TEMPLATE_ID;
        String readFilter = dataGenerator.createFilterFromVitalObservationEvent( createRequest, filterId, null );
        String expectedReadResult = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
        String readResult = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        // Delete record
        String deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( TemplateIdHelper.VITALSIGNS_DELETE_TEMPLATE_ID, createRequest );
        String deleteReply = clinicalDataService.deleteClinicalData( deleteRequest, TemplateIdHelper.VITALSIGNS_DELETE_TEMPLATE_ID, requestId );

        // Make assertions and validations
        assertNoErrors( deleteReply );

        XmlValidator.validateXml( readResult, TemplateIdHelper.VW_VITALSIGNS_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResult, clinicalDataResponse400 ), expectedReadResult );
    }


    //@Test
    @Suite( groups = "checkintest" )
    /**
     * Test to create, read and delete record for VW client:  Vital Observation Events
     */
    public void testVWVitalObservationEvent_NationalId( )
        throws Exception
    {
        // Create record
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String templateId = TemplateIdHelper.VITALSIGNS_CREATEORUPDATE_TEMPLATE_ID;
        String createRequest = dataGenerator.createVitalObservationEventXml( requestId, templateId, uniquePatientIdentity );
        String createResult = clinicalDataService.createClinicalData( createRequest, templateId, requestId );
        assertNoErrors( createResult );

        // Make a read request with single patient with
        String filterId = TemplateIdHelper.VW_VITAL_SINGLE_PATIENT_FILTER;
        String readTemplateId = TemplateIdHelper.VITALSIGNS_READ_TEMPLATE_ID;
        String readFilter = dataGenerator.createFilterFromVitalObservationEvenWithNationalId( createRequest, filterId, null );
        String expectedReadResult = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( readTemplateId, createRequest );
        String readResult = clinicalDataService.readClinicalData( readTemplateId, readFilter, filterId, requestId );

        // Delete record
        String deleteRequest = dataGenerator.modifyTemplateMetaDataOfCRUADResultXml( TemplateIdHelper.VITALSIGNS_DELETE_TEMPLATE_ID, createRequest );
        String deleteReply = clinicalDataService.deleteClinicalData( deleteRequest, TemplateIdHelper.VITALSIGNS_DELETE_TEMPLATE_ID, requestId );

        // Make assertions and validations
        assertNoErrors( deleteReply );

        XmlValidator.validateXml( readResult, TemplateIdHelper.VITALSIGNS_READ_TEMPLATE_ID );
        assertXmlSimilar( detachNodesFromReadResult( readResult, clinicalDataResponse400 ), expectedReadResult );
    }


    protected List<Map<String, String>> getExcludeIdentifiers( String... excludeIdentifers )
    {
        List<Map<String, String>> excludeIdentifiers = new ArrayList<Map<String, String>>();

        Map<String, String> excludeIdentifier = new HashMap<String, String>();
        excludeIdentifier.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, excludeIdentifers[0] );
        excludeIdentifier.put( FilterBuilder.ASSIGNING_FACILITY, excludeIdentifers[1] );
        excludeIdentifiers.add( excludeIdentifier );

        return excludeIdentifiers;
    }

}
