/**
 * 
 */


package gov.va.med.cds.client.functional;


import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponse400;
import gov.va.med.cds.testharness.vhim400.builders.ClinicalDataBuilder;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;

import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @author vhaislegberb
 * 
 */
public abstract class AbstractDataGeneratorValidatorTest
    extends
        AbstractFunctionalTest
{

    protected static final String OUTPATIENT_MEDICATION_PROMISE = "Outpatient Medication Promise";
    protected static final String VITAL_OBSERVATION_EVENT = "Vital Observation Event";
    protected static final String INTOLERANCE_CONDITION = "Intolerance Condition";
    protected static final String ALLERGY_ASSESSEMENT = "Allergy Assessement";
    protected static final String LAB_PROMISE = "Lab Promise";

    protected static final String XML_CLINICAL_DATA_OPEN = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\">";
    protected static final String XML_CLINICAL_DATA_CLOSED = "</clinicaldata:ClinicalData>";
    protected static final String TEMPLATE_ID_OPEN = "<templateId>";
    protected static final String TEMPLATE_ID_CLOSED = "</templateId>";
    protected static final String REQUEST_ID_OPEN = "<requestId>";
    protected static final String REQUEST_ID_CLOSED = "</requestId>";
    protected static final String ERRORSECTION_EMPTY = "<errorSection/>";

    @Autowired
    protected DataGenerator dataGenerator;
    @Autowired
    protected ClinicalDataResponse400 clinicalDataResponse400;
    @Autowired
    protected ClinicalDataBuilder clinicalDataBuilder;
    protected final String DATE_FORMAT_PATTERN = "yyyy-MM-dd";


    protected List<Map<String, String>> getResolvedPatients( String[][] patientIdentifiers )
    {
        List<Map<String, String>> resolvedPatients = new ArrayList<Map<String, String>>();

        for ( String[] patientIdentifier : patientIdentifiers )
        {
            Map<String, String> patient = new HashMap<String, String>();
            patient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, patientIdentifier[0] );
            patient.put( FilterBuilder.ASSIGNING_FACILITY, patientIdentifier[1] );
            patient.put( FilterBuilder.IDENTITY, patientIdentifier[2] );

            resolvedPatients.add( patient );
        }

        return resolvedPatients;
    }
}
