

package gov.va.med.cds.rpc.ejb;


import gov.va.med.cds.audit.VhimRequestAuditLoggerInterface;
import gov.va.med.cds.client.ClinicalDataServiceInterface;
import gov.va.med.cds.config.BeanConstantsInterface;
import gov.va.med.cds.ejb.interceptor.CdsAutowiredInterceptor;
import gov.va.med.cds.saml.SamlAssertionThreadLocal;
import gov.va.med.repositories.Pathways;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.jws.WebService;


@WebService( endpointInterface = "gov.va.med.repositories.Pathways", targetNamespace = "http://repositories.URL       /pathways", portName = "PathwaysHttpPort", serviceName = "Pathways" )
@Stateless( name = "ClinicalDataServiceRpcSynchronous", mappedName = "ejb/remote/gov/va/med/cds/ClinicalDataServiceRpcSynchronousSession" )
@Interceptors( CdsAutowiredInterceptor.class )
//@Interceptors( SpringBeanAutowiringInterceptor.class )
public class ClinicalDataServiceRpcSynchronousSession
    implements
        Pathways
{
    protected final Log logger = LogFactory.getLog( getClass() );

    @Autowired
    private ClinicalDataServiceInterface clinicalDataServiceSynchronous;
    @Autowired
    private String pathwaysAppName;

    @Autowired
    @Qualifier( BeanConstantsInterface.VHIM_REQUEST_PATHWAYS_AUDIT_LOGGER )
    private VhimRequestAuditLoggerInterface vhimRequestPathwaysAuditLogger;

    @Autowired
    @Qualifier( BeanConstantsInterface.VHIM_REQUEST_AUDIT_LOGGER )
    private VhimRequestAuditLoggerInterface vhimRequestAuditLogger;


    /**
     *
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#isAlive()
     */
    public boolean isAlive( )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, pathwaysAppName,
                            "About to call the POMO isAlive() method from inside the SLSB" ) );
        }

        boolean result = clinicalDataServiceSynchronous.isAlive();

        if ( logger.isDebugEnabled() )
        {
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, pathwaysAppName,
                            "Finished calling the POMO isAlive() method from inside the SLSB" ) );
        }

        return result;
    }


    /**
     * Synchronous version of a clinical data read
     *
     * @param aTemplateId ID of the template for which the filter request applies
     * @param aFilterRequest Filter request specified in xml format according to the CDS filter schema
     * @param aFilterId ID of the named (canned) filter. The filterId may be null if no canned filter is referenced
     * @param aRequestId Client specified unique request Id
     * @return Results of the read returned in XML according to the CDS read results schema
     */
    public String readData( String aTemplateId, String aFilterRequest, String aFilterId, String aRequestId )
    {
        long startTime = System.currentTimeMillis();

        if ( aFilterRequest != null )
        {
            aFilterRequest = aFilterRequest.trim();
        }

        String response = clinicalDataServiceSynchronous.readClinicalData( aTemplateId, aFilterRequest, aFilterId, aRequestId );

        vhimRequestPathwaysAuditLogger.auditReadRequest( aTemplateId, aFilterRequest, aFilterId, aRequestId, startTime, response,
                        SamlAssertionThreadLocal.get() );

        return response;
    }


    public String createData( String aCreateXml, String aTemplateId, String aRequestId )
    {
        /*
         * JLA Commenting out startTime as it is flagged by Quality Code Review:
         *      Poor Style: Value is never Read
         *
         * long startTime = System.currentTimeMillis();
         */

        if ( aCreateXml != null )
        {
            aCreateXml = aCreateXml.trim();
        }

        vhimRequestAuditLogger.auditWriteRequest( aTemplateId, aCreateXml, aRequestId, SamlAssertionThreadLocal.get() );

        String response = clinicalDataServiceSynchronous.createClinicalData( aCreateXml, aTemplateId, aRequestId, false );

        return response;
    }

}
