

package gov.va.med.cds.ejb;


import gov.va.med.cds.audit.VhimRequestAuditLoggerInterface;
import gov.va.med.cds.client.ClinicalDataServiceInterface;
import gov.va.med.cds.client.webservice.ClinicalDataServiceSynchronousInterface;
import gov.va.med.cds.config.BeanConstantsInterface;
import gov.va.med.cds.ejb.interceptor.CdsAutowiredInterceptor;
import gov.va.med.cds.saml.SamlAssertionThreadLocal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.jws.WebService;


/**
 * XDoclet-based session bean. The class must be declared public according to
 * the EJB specification.
 * 
 * To generate the EJB related files to this EJB: - Add Standard EJB module to
 * XDoclet project properties - Customize XDoclet configuration for your
 * appserver - Run XDoclet
 * 
 * Below are the xdoclet-related tags needed for this EJB.
 * 
 * @ejb.bean name="ClinicalDataServiceSynchronousBean" display-name="Clinical
 *           Data Source Synchronous Session Bean" description="Provides an EJB
 *           stateless session front end to the Clinical Data Source POJOs"
 *           jndi-name="ejb/remote/gov/va/med/cds/ClinicalDataServiceSynchronousSession"
 *           type="Stateless" view-type="remote"
 */
@WebService( serviceName = "ClinicalDataServiceSynchronousInterface", portName = "ClinicalDataServiceSynchronousInterfaceHttpPort", endpointInterface = "gov.va.med.cds.client.webservice.ClinicalDataServiceSynchronousInterface", targetNamespace = "http://client.cds.URL       " )
@Stateless( name = "ClinicalDataServiceSynchronous", mappedName = "ejb/remote/gov/va/med/cds/ClinicalDataServiceSynchronousSession" )
@Interceptors( CdsAutowiredInterceptor.class )
// @Interceptors( SpringBeanAutowiringInterceptor.class )
public class ClinicalDataServiceSynchronousSession
    implements
        ClinicalDataServiceSynchronousInterface
{
    protected final Log logger = LogFactory.getLog( getClass() );

    @Autowired
    private ClinicalDataServiceInterface clinicalDataSourceSynchronous;

    @Autowired
    @Qualifier( BeanConstantsInterface.VHIM_REQUEST_AUDIT_LOGGER )
    private VhimRequestAuditLoggerInterface vhimRequestAuditLogger;

    @Autowired
    private String cdsAppName;


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#appendClinicalData(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public String appendClinicalData( String anAppendRequest, String aTemplateId, String aRequestId )
    {
        if ( anAppendRequest != null )
        {
            anAppendRequest = anAppendRequest.trim();
        }

        vhimRequestAuditLogger.auditWriteRequest( aTemplateId, anAppendRequest, aRequestId, SamlAssertionThreadLocal.get() );

        return clinicalDataSourceSynchronous.appendClinicalData( anAppendRequest, aTemplateId, aRequestId );
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#createClinicalData(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public String createClinicalData( String aCreateRequest, String aTemplateId, String aRequestId )
    {
        if ( aCreateRequest != null )
        {
            aCreateRequest = aCreateRequest.trim();
        }
        vhimRequestAuditLogger.auditWriteRequest( aTemplateId, aCreateRequest, aRequestId, SamlAssertionThreadLocal.get() );

        return clinicalDataSourceSynchronous.createClinicalData( aCreateRequest, aTemplateId, aRequestId );
    }


    public String createClinicalData( String aCreateRequest, String aTemplateId, String aRequestId, boolean anAuditVhimRequest )
    {
        if ( aCreateRequest != null )
        {
            aCreateRequest = aCreateRequest.trim();
        }

        if ( anAuditVhimRequest )
        {
            vhimRequestAuditLogger.auditWriteRequest( aTemplateId, aCreateRequest, aRequestId, SamlAssertionThreadLocal.get() );
        }

        return clinicalDataSourceSynchronous.createClinicalData( aCreateRequest, aTemplateId, aRequestId );
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#deleteClinicalData(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public String deleteClinicalData( String aDeleteRequest, String aTemplateId, String aRequestId )
    {
        if ( aDeleteRequest != null )
        {
            aDeleteRequest = aDeleteRequest.trim();
        }
        vhimRequestAuditLogger.auditWriteRequest( aTemplateId, aDeleteRequest, aRequestId, SamlAssertionThreadLocal.get() );

        return clinicalDataSourceSynchronous.deleteClinicalData( aDeleteRequest, aTemplateId, aRequestId );
    }


    @Override
    public String readClinicalData( String aTemplateId, String aFilterId, String aRequestId )
    {
        throw new UnsupportedOperationException();
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#readClinicalData(java.lang.String,
     *      java.lang.String, java.lang.String, java.lang.String)
     */
    public String readClinicalData( String aTemplateId, String aFilterRequest, String aFilterId, String aRequestId )
    {
        // long startTime = System.currentTimeMillis();

        if ( aFilterRequest != null )
        {
            aFilterRequest = aFilterRequest.trim();
        }

        return this.readClinicalData( aTemplateId, aFilterRequest, aFilterId, aRequestId, true );
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceExtendedInterface#readClinicalData(java.lang.String,
     *      java.lang.String, java.lang.String, java.lang.String, boolean)
     */
    public String readClinicalData( String aTemplateId, String aFilterRequest, String aFilterId, String aRequestId, boolean anAuditRequired )
    {
        long startTime = System.currentTimeMillis();

        if ( aFilterRequest != null )
        {
            aFilterRequest = aFilterRequest.trim();
        }

        String response = clinicalDataSourceSynchronous.readClinicalData( aTemplateId, aFilterRequest, aFilterId, aRequestId );

        // Audit the read request details
        /*
         * JLA Fortify Quality Code Scan update - Dead Code: Expression is Always true
         *   commenting out check on anAuditRequired
         */
//        if ( anAuditRequired )
//        {
            vhimRequestAuditLogger.auditReadRequest( aTemplateId, aFilterRequest, aFilterId, aRequestId, startTime, response,
                            SamlAssertionThreadLocal.get() );
//        }

        return response;
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#updateClinicalData(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public String updateClinicalData( String anUpdateRequest, String aTemplateId, String aRequestId )
    {
        if ( anUpdateRequest != null )
        {
            anUpdateRequest = anUpdateRequest.trim();
        }
        vhimRequestAuditLogger.auditWriteRequest( aTemplateId, anUpdateRequest, aRequestId, SamlAssertionThreadLocal.get() );

        return clinicalDataSourceSynchronous.updateClinicalData( anUpdateRequest, aTemplateId, aRequestId );
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#isAlive()
     */
    public boolean isAlive( )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, cdsAppName,
                            "About to call the POJO isAlive() method from inside the SLSB" ) );
        }

        boolean result = clinicalDataSourceSynchronous.isAlive();

        if ( logger.isDebugEnabled() )
        {
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, cdsAppName,
                            "Finished calling the POJO isAlive() method from inside the SLSB" ) );
        }

        return result;
    }

}
