

package gov.va.med.cds.util;


import static org.junit.Assert.assertEquals;

import gov.va.med.cds.junit.runners.Suite;

import org.junit.Assert;
import org.junit.Test;


public class PerformanceLogTest
{
    @Test
    @Suite( groups = { "checkintest" } )
    public void testLogFinishTimeSuccess( )
    {
        long startTime = 1000;
        long finishTime = 2000;
        String keywords = "TestClass.testMethod()";
        String domainEntryPoint = "testDomainEntryPoint";
        String templateId = "testTemplateId";
        String requestId = "testRequestId";
        String siteId = "testSiteId";
        boolean succeeded = true;
        String tier = "testJdbcTier";

        PerformanceLog performanceLog = new PerformanceLog();
        performanceLog.setEnabled( true );
        String message = performanceLog.logFinishTime( startTime, finishTime, keywords, domainEntryPoint, templateId, requestId, siteId, succeeded,
                        tier );

        String line = message.trim();
        String[] sa = line.split( "," );

        assertEquals( keywords, sa[0] );
        assertEquals( domainEntryPoint, sa[1] );
        assertEquals( templateId, sa[2] );
        assertEquals( requestId, sa[3] );
        assertEquals( siteId, sa[4] );
        assertEquals( startTime, Long.parseLong( sa[5] ) );
        assertEquals( finishTime, Long.parseLong( sa[6] ) );
        double seconds = Double.parseDouble( sa[7] );
        long duration = ( long )( seconds * 1000 );
        long expectedDuration = finishTime - startTime;
        assertEquals( expectedDuration, duration );
        assertEquals( PerformanceLog.STATUS_SUCCESS, sa[8] );
        assertEquals( tier, sa[9] );

    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testLogFinishTimeFail( )
    {
        long startTime = 1000;
        long finishTime = 2000;
        String keywords = "TestClass.testMethod()";
        String domainEntryPoint = "testDomainEntryPoint";
        String templateId = "testTemplateId";
        String requestId = "testRequestId";
        String siteId = "testSiteId";
        boolean succeeded = false;
        String tier = "testJdbcTier";

        PerformanceLog performanceLog = new PerformanceLog();
        performanceLog.setEnabled( true );

        String message = performanceLog.logFinishTime( startTime, finishTime, keywords, domainEntryPoint, templateId, requestId, siteId, succeeded,
                        tier );

        String line = message.trim();
        String[] sa = line.split( "," );

        assertEquals( keywords, sa[0] );
        assertEquals( domainEntryPoint, sa[1] );
        assertEquals( templateId, sa[2] );
        assertEquals( requestId, sa[3] );
        assertEquals( siteId, sa[4] );
        assertEquals( startTime, Long.parseLong( sa[5] ) );
        assertEquals( finishTime, Long.parseLong( sa[6] ) );
        double seconds = Double.parseDouble( sa[7] );
        long duration = ( long )( seconds * 1000 );
        long expectedDuration = finishTime - startTime;
        assertEquals( expectedDuration, duration );
        assertEquals( PerformanceLog.STATUS_FAIL, sa[8] );
        assertEquals( tier, sa[9] );
    }


    @Test( expected = IllegalArgumentException.class )
    @Suite( groups = { "checkintest" } )
    public void testExceptionThrownWhenStartTimeNegative( )
    {
        long startTime = -1000;
        long finishTime = 2000;
        String keywords = "TestClass.testMethod()";
        String domainEntryPoint = "testDomainEntryPoint";
        String templateId = "testTemplateId";
        String requestId = "testRequestId";
        String siteId = "testSiteId";
        boolean succeeded = false;
        String tier = "testJdbcTier";

        PerformanceLog performanceLog = new PerformanceLog();
        performanceLog.setEnabled( true );
        performanceLog.logFinishTime( startTime, finishTime, keywords, domainEntryPoint, templateId, requestId, siteId, succeeded, tier );
    }


    @Test( expected = IllegalArgumentException.class )
    @Suite( groups = { "checkintest" } )
    public void testExceptionThrownWhenFinishTimeNegative( )
    {
        long startTime = 1000;
        long finishTime = -2000;
        String keywords = "TestClass.testMethod()";
        String domainEntryPoint = "testDomainEntryPoint";
        String templateId = "testTemplateId";
        String requestId = "testRequestId";
        String siteId = "testSiteId";
        boolean succeeded = false;
        String tier = "testJdbcTier";

        PerformanceLog performanceLog = new PerformanceLog();
        performanceLog.setEnabled( true );
        performanceLog.logFinishTime( startTime, finishTime, keywords, domainEntryPoint, templateId, requestId, siteId, succeeded, tier );
    }

    
    @Test( expected = IllegalArgumentException.class )
    @Suite( groups = { "checkintest" } )
    public void testFinishTimeCannotBeBeforeStartTime( )
    {
        long startTime = 2000;
        long finishTime = 1000;
        String keywords = "TestClass.testMethod()";
        String domainEntryPoint = "testDomainEntryPoint";
        String templateId = "testTemplateId";
        String requestId = "testRequestId";
        String siteId = "testSiteId";
        boolean succeeded = false;
        String tier = "testJdbcTier";

        PerformanceLog performanceLog = new PerformanceLog();
        performanceLog.setEnabled( true );
        performanceLog.logFinishTime( startTime, finishTime, keywords, domainEntryPoint, templateId, requestId, siteId, succeeded, tier );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testAbleToGetPerformanceLog( )
    {
        Assert.assertNotNull( PerformanceLog.getInstance() );

    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testEnablingMechanism( )
    {
        PerformanceLog performanceLog = PerformanceLog.getInstance();
        performanceLog.setEnabled( true );
        if ( performanceLog.isInfoEnabled() )
        {
            /// the performance log should return a non-null message
            long startTime = 1000;
            long finishTime = 2000;
            String keywords = "TestClass.testMethod()";
            String domainEntryPoint = "testDomainEntryPoint";
            String templateId = "testTemplateId";
            String requestId = "testRequestId";
            String siteId = "testSiteId";
            boolean succeeded = false;
            String tier = "testJdbcTier";

            String message = performanceLog.logFinishTime( startTime, finishTime, keywords, domainEntryPoint, templateId, requestId, siteId,
                            succeeded, tier );
            Assert.assertNotNull( message );
        }
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testDisablingMechanism( )
    {
        PerformanceLog performanceLog = PerformanceLog.getInstance();
        performanceLog.setEnabled( false );
        /// the performance log should return a non-null message
        long startTime = 1000;
        long finishTime = 2000;
        String keywords = "TestClass.testMethod()";
        String domainEntryPoint = "testDomainEntryPoint";
        String templateId = "testTemplateId";
        String requestId = "testRequestId";
        String siteId = "testSiteId";
        boolean succeeded = false;
        String tier = "testJdbcTier";

        String message = performanceLog.logFinishTime( startTime, finishTime, keywords, domainEntryPoint, templateId, requestId, siteId, succeeded,
                        tier );
        Assert.assertNull( message );
    }
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testLoggingWorksWithoutApplicationContext( )
    {
        PerformanceLog performanceLog = PerformanceLog.getInstance();
        performanceLog.setApplicationContext( null );
        performanceLog.setEnabled( true );
        /// the performance log should return a non-null message
        long startTime = 1000;
        long finishTime = 2000;
        String keywords = "TestClass.testMethod()";
        String domainEntryPoint = "testDomainEntryPoint";
        String templateId = "testTemplateId";
        String requestId = "testRequestId";
        String siteId = "testSiteId";
        boolean succeeded = false;
        String tier = "testJdbcTier";

        String message = performanceLog.logFinishTime( startTime, finishTime, keywords, domainEntryPoint, templateId, requestId, siteId, succeeded,
                        tier );
        Assert.assertNotNull( message );
    }
    
    @Test
    @Suite( groups={"checkintest"})
    public void testIsEnabledReturnsCorrectValue()
    {
        PerformanceLog performanceLog = PerformanceLog.getInstance();
        performanceLog.setEnabled( true );
        Assert.assertTrue( performanceLog.isEnabled() );
        performanceLog.setEnabled( false );
        Assert.assertFalse( performanceLog.isEnabled() );
        
    }
    
}
