

package gov.va.med.cds.tfs.util;


import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.EntryFilter;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.util.HashSet;
import java.util.Set;

@RunWith( SuiteAwareRunner.class )
public class FilterMetaDataHelperTest
{
    @Test
    @Suite( groups = "checkintest" )
    public void testBuildVhimVersions( )
    {
        String vhimVersionsStr = "[Vhim_4_00,Vhim_4_01,Vhim_5_00]";

        HashSet<String> expectedVhimVersionsSet = new HashSet<String>();
        expectedVhimVersionsSet.add( "Vhim_4_00" );
        expectedVhimVersionsSet.add( "Vhim_4_01" );
        expectedVhimVersionsSet.add( "Vhim_5_00" );

        Set<String> vhimVerionsSet = FilterMetaDataHelper.buildVhimVersions( vhimVersionsStr );

        Assert.assertTrue( vhimVerionsSet.equals( expectedVhimVersionsSet ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testBuildEntryFilters( )
    {
        Set<EntryFilter> expectedEmptyEntryPoints = new HashSet<EntryFilter>();
        Set<EntryFilter> entryFiltersSet = FilterMetaDataHelper.buildEntryFilters( null );
        Assert.assertTrue( entryFiltersSet.equals( expectedEmptyEntryPoints ) );

        StringBuilder entryPointBuilder = new StringBuilder();
        entryPointBuilder.append( "[" ).append( DomainEntryPoint.AllergyAssessment );
        entryPointBuilder.append( "," ).append( DomainEntryPoint.IntoleranceCondition ).append( "]" );

        HashSet<EntryFilter> expectedEntryfiltersSet = new HashSet<EntryFilter>();
        EntryFilter entryFilter = new EntryFilter();
        entryFilter.setDomainEntryPoint( DomainEntryPoint.AllergyAssessment );
        expectedEntryfiltersSet.add( entryFilter );
        entryFilter = new EntryFilter();
        entryFilter.setDomainEntryPoint( DomainEntryPoint.IntoleranceCondition );
        expectedEntryfiltersSet.add( entryFilter );

        entryFiltersSet = FilterMetaDataHelper.buildEntryFilters( entryPointBuilder.toString() );
        
        Assert.assertTrue( entryFiltersSet.equals( expectedEntryfiltersSet ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetEntryFilter( )
    {
        EntryFilter entryFilter = FilterMetaDataHelper.getEntryFilter( DomainEntryPoint.IntoleranceCondition );

        Assert.assertTrue( entryFilter.getDomainEntryPoint().equals( DomainEntryPoint.IntoleranceCondition ) );
    }
}
