

package gov.va.med.cds.template;


import static org.junit.Assert.assertNotNull;

import gov.va.med.cds.AbstractBaseIntegrationCoreTest;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

import javax.annotation.Resource;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/config/nonWeblogicHdr2DataSourceContext.xml",
                "classpath:gov/va/med/cds/config/templateContextDBTest.xml", "classpath:gov/va/med/cds/config/hibernatePropertiesTestContext.xml"  } )
public class LoadDBBasedTemplateServiceSimulatorWithTemplatesTest
    extends
        AbstractBaseIntegrationCoreTest
{
    private TemplateManager templateManager = null;


    /**
     * Tests that templates in a directory in the project are loaded to an oracle database via the combined
     * functionality of the template service simulator, template manager and oracle template persistence.
     *
     * The configuration is injected and instantiating the template manager causes the behavior to take place.
     */
    @Test
    @Suite( groups = { "prototypetest" } )
    public void testDBBasedTemplateServiceSimulatorLoadedTemplates( )
    {
        assertNotNull( templateManager );
        assertNotNull( templateManager.getSymbolMap( "CdsResponse400" ) );
    }


    @Resource
    public void setTemplateManager( TemplateManager templateManager )
    {
        this.templateManager = templateManager;
    }
}
