

package gov.va.med.cds.response.strategy;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.dom4j.Element;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.ClassPathResource;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;


@RunWith( SuiteAwareRunner.class )
public class ReferenceMappingVistaResponseBlobStrategyMHV
{
    public static final String stream = "<Def>APPOINTMENT IEN^PATIENT IEN^PATIENT NAME^APPOINTMENT DATETIME^CLINIC IEN^CLINIC LOCATION^CLINIC TELEPHONE^EXAM LOCATION STATION NUMBER^EXAM LOCATION OFFICE NAME^EXAM LOCATION OFFICIAL VA NAME^LOCATION FRIENDLY NAME^CLINIC MEETS AT THIS FACILITY^DISPLAY APPOINTMENTS TO PATIENT^SERVICE^DIVISION^TELEPHONE EXTENSION^NAME PREFIX|NAME GIVEN|NAME MIDDLE|NAME FAMILY|NAME SUFFIX|NAME TITLE|DISPLAY NAME|DEFAULT PROVIDER|^COMMENTS^ALLOW DIRECT PATIENT SCHEDULING^APPOINTMENT STATUS CODE^APPOINTMENT STATUS^APPOINTMENT TYPE CODE^APPOINTMENT TYPE^EKG DATETIME^XRAY DATETIME^LAB DATETIME^STATUS CODE^PRINT STATUS^</Def>\n"
                    + "-APPOINTMENT IEN-^-PATIENT IEN-^-PATIENT NAME-^-APPOINTMENT DATETIME-^-CLINIC IEN-^-CLINIC LOCATION-^-CLINIC TELEPHONE-^-EXAM LOCATION STATION NUMBER-^-EXAM LOCATION OFFICE NAME-^-EXAM LOCATION OFFICIAL VA NAME-^-LOCATION FRIENDLY NAME-^-CLINIC MEETS AT THIS FACILITY-^-DISPLAY APPOINTMENTS TO PATIENT-^-SERVICE-^-DIVISION-^-TELEPHONE EXTENSION-^-NAME PREFIX|NAME GIVEN|NAME MIDDLE|NAME FAMILY|NAME SUFFIX|NAME TITLE|DISPLAY NAME|DEFAULT PROVIDER|-^-COMMENTS-^-ALLOW DIRECT PATIENT SCHEDULING-^-APPOINTMENT STATUS CODE-^-APPOINTMENT STATUS-^-APPOINTMENT TYPE CODE-^-APPOINTMENT TYPE-^-EKG DATETIME-^-XRAY DATETIME-^-LAB DATETIME-^-STATUS CODE-^-PRINT STATUS-^";
//                    + "3000521.09^3^EIGHT,PATIENT^200005210900^23^GENERAL MEDICINE^259^500^CAMP MASTER^ALBANY VA MEDICAL CENTER^GENERAL MED PATIENT FRIENDLY^YES^YES^MEDICINE^VEHU DIVISION^X1234^|FORTY-FIVE||NURSE||NURSE|NURSE,FORTY-FIVE|NO|~|NINE||PROVIDER||Scholar Extraordinaire|PROVIDER,NINE|YES|~|TWENTYFIVE||PROGRAMMER||COMPUTER SPECIALIST|PROGRAMMER,TWENTYFIVE|NO|~^^NO^R^SCHEDULED/KEPT^9^REGULAR^^^^3^ACT REQ/CHECKED OUT^";

    ReferenceMappingVistaResponseBlobStrategy responseStrategy = null;

    List<Map<String, Object>> resultList = null;


    @Before
    @Suite( groups = { "checkintest" } )
    public void beforeEachTest( )
    {
        responseStrategy = new ReferenceMappingVistaResponseBlobStrategy();
        Map<String, Object> firstRow = new HashMap<String, Object>();
        firstRow.put( "stream", stream.getBytes() );
        resultList = new ArrayList<Map<String, Object>>();
        resultList.add( firstRow );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testFormatResultList( )
        throws Exception
    {
        List<Map<String, Object>> newResultList = responseStrategy.formatResultList( resultList );
        assertEquals( 1, newResultList.size() );
        assertEquals( 29, newResultList.get( 0 ).size() );
        assertEquals( "-Appointment IEN-", newResultList.get( 0 ).get( "APPOINTMENT IEN" ) );
        assertEquals( "-PATIENT IEN-", newResultList.get( 0 ).get( "PATIENT IEN" ) );
        assertEquals( "-PATIENT NAME-", newResultList.get( 0 ).get( "PATIENT NAME" ) );
        assertEquals( "-APPOINTMENT DATETIME-", newResultList.get( 0 ).get( "APPOINTMENT DATETIME" ) );
        assertEquals( "-CLINIC IEN-", newResultList.get( 0 ).get( "CLINIC IEN" ) );
        assertEquals( "-CLINIC LOCATION-", newResultList.get( 0 ).get( "CLINIC LOCATION" ) );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testFormatResponse( )
        throws Exception
    {
        Map<String, ClassPathResource> refXmlMap = new HashMap<String, ClassPathResource>();

        ClassPathResource classPathResource = new ClassPathResource( "resources/rpcmappings/vrm/AppointmentsRead1.xml" );
        refXmlMap.put( "Appointment-AppointmentsRead1", classPathResource );
        responseStrategy.setRefXmlMap( refXmlMap );
        Element element = responseStrategy.formatResponse( resultList, "Appointment", "AppointmentsRead1" );
        assertNotNull( element );
        assertEquals( "results", element.getName() );
    }
}
