

package gov.va.med.cds.persistence.hibernate.tfs;


import gov.va.med.cds.clinicaldata.DomainEntryPointWrapper;
import gov.va.med.cds.clinicaldata.VhimVersionWrapper;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import java.util.HashSet;
import java.util.Set;

import junit.framework.Assert;

import org.easymock.EasyMock;
import org.hibernate.query.Query;
import org.hibernate.Session;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class AbstractTfsHibernatePersistenceManagerTest
{
    private AbstractTfsHibernatePersistenceManager tfsHibernatePersistenceManager = null;


    @Before
    @Suite( groups = "checkintest" )
    public void beforeAbstractTfsHibernatePersistenceManagerTestSetup( )
    {
        tfsHibernatePersistenceManager = new AbstractTfsHibernatePersistenceManager();
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testPersistifyVhimVersions( )
    {
        Session sessionMock = EasyMock.createMock( Session.class );
        Query queryMock = EasyMock.createMock( Query.class );
        Set<VhimVersionWrapper> vhimVersions = new HashSet<VhimVersionWrapper>();
        VhimVersionWrapper vhimVersionWrapper = new VhimVersionWrapper();
        vhimVersionWrapper.setVersion( "Vim400" );
        vhimVersions.add(vhimVersionWrapper);
        
        VhimVersionWrapper vhimVersionWrapperFromDb = new VhimVersionWrapper();
        vhimVersionWrapperFromDb.setVersion( "tfs_Vim400" );
        
        EasyMock.expect( sessionMock.getNamedQuery( "VhimVersionText" ) ).andReturn( queryMock );
        EasyMock.expect( queryMock.setParameter( "vhimVersionTxt", "Vim400" )).andReturn( queryMock );
        EasyMock.expect( queryMock.uniqueResult()).andReturn( vhimVersionWrapperFromDb);
        
        EasyMock.replay( sessionMock, queryMock);
        tfsHibernatePersistenceManager.persistifyVhimVersions( sessionMock , vhimVersions );
        EasyMock.verify( sessionMock, queryMock );
        
        Assert.assertTrue( vhimVersions.contains(vhimVersionWrapperFromDb) );
        Assert.assertEquals( vhimVersions.size(), 1 );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testPersistifyDomainEntryPoints( )
    {
        Session sessionMock = EasyMock.createMock( Session.class );
        Query queryMock = EasyMock.createMock( Query.class );
        DomainEntryPointWrapper domainEntryPoint = new DomainEntryPointWrapper();
        domainEntryPoint.setDomain( "Allergies" );
        domainEntryPoint.setName( "Allergies123");
                
        EasyMock.expect( sessionMock.getNamedQuery( "DomainEntryPointText" ) ).andReturn( queryMock );
        EasyMock.expect( queryMock.setParameter( "nameTxt", "Allergies123" )).andReturn( queryMock );
        EasyMock.expect( queryMock.setParameter( "domainTxt", "Allergies" )).andReturn( queryMock );
        EasyMock.expect( queryMock.uniqueResult()).andReturn( null);
        EasyMock.expect(sessionMock.save( domainEntryPoint )).andReturn( true );
        EasyMock.replay( sessionMock, queryMock);
        Assert.assertEquals(domainEntryPoint, tfsHibernatePersistenceManager.persistifyDomainEntryPoint( sessionMock , domainEntryPoint ));
        EasyMock.verify( sessionMock, queryMock );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testPersistifyDomainEntryPoint( )
    {

        Session sessionMock = EasyMock.createMock( Session.class );
        Query queryMock = EasyMock.createMock( Query.class );
        Set<DomainEntryPointWrapper> domainEntryPoints = new HashSet<DomainEntryPointWrapper>();
        DomainEntryPointWrapper domainEntryPointWrapper1 = new DomainEntryPointWrapper();
        domainEntryPointWrapper1.setDomain( "Allergies" );
        domainEntryPointWrapper1.setName( "Allergies123");
        domainEntryPoints.add(domainEntryPointWrapper1);
        DomainEntryPointWrapper domainEntryPointWrapper2 = new DomainEntryPointWrapper();
        domainEntryPointWrapper2.setDomain( "Vitals" );
        domainEntryPointWrapper2.setName( "Vitals123");
        domainEntryPoints.add(domainEntryPointWrapper2);
        
        DomainEntryPointWrapper domainEntryPointWrapperFromDb1 = new DomainEntryPointWrapper();
        domainEntryPointWrapperFromDb1.setDomain( "Allergies" );
        domainEntryPointWrapperFromDb1.setName( "tfsAllergies123");

        DomainEntryPointWrapper domainEntryPointWrapperFromDb2 = new DomainEntryPointWrapper();;
        domainEntryPointWrapperFromDb2.setDomain( "Vitals" );
        domainEntryPointWrapperFromDb2.setName( "tfsVitals123");
                
        EasyMock.expect( sessionMock.getNamedQuery( "DomainEntryPointText" ) ).andReturn( queryMock );
        EasyMock.expect( queryMock.setParameter( "nameTxt", "Allergies123" )).andReturn( queryMock );
        EasyMock.expect( queryMock.setParameter( "domainTxt", "Allergies" )).andReturn( queryMock );
        EasyMock.expect( queryMock.uniqueResult()).andReturn( domainEntryPointWrapperFromDb1);
        
        EasyMock.expect( sessionMock.getNamedQuery( "DomainEntryPointText" ) ).andReturn( queryMock );
        EasyMock.expect( queryMock.setParameter( "nameTxt", "Vitals123" )).andReturn( queryMock );
        EasyMock.expect( queryMock.setParameter( "domainTxt", "Vitals" )).andReturn( queryMock );       
        EasyMock.expect( queryMock.uniqueResult()).andReturn(domainEntryPointWrapperFromDb2);
        
        EasyMock.replay( sessionMock, queryMock);
        tfsHibernatePersistenceManager.persistifyDomainEntryPoints( sessionMock , domainEntryPoints );
        EasyMock.verify( sessionMock, queryMock );
        
        Assert.assertFalse( domainEntryPoints.contains(domainEntryPointWrapper1));
        Assert.assertFalse( domainEntryPoints.contains(domainEntryPointWrapper2));
        Assert.assertTrue( domainEntryPoints.contains(domainEntryPointWrapperFromDb1));
        Assert.assertTrue( domainEntryPoints.contains(domainEntryPointWrapperFromDb2));
        Assert.assertEquals( domainEntryPoints.size(), 2 );
        }

}
