

package gov.va.med.cds.persistence.hibernate.common;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.template.generated.basedatatypes.HL72PersonIdentifier;

import org.dom4j.Element;
import org.easymock.EasyMock;
import org.hibernate.EntityMode;
import org.hibernate.engine.spi.SessionImplementor;
import org.junit.Assert;
import org.junit.Test;

import java.sql.ResultSet;


public class VistaPersonIdentifierUserTypeTest
{
    final static String fromDb = "identity^family^given^middle^prefix^suffix^title";
    private static VistaPersonName vistaPersonName = new VistaPersonName( fromDb );
    private VistaPersonIdentifierUserType userType = new VistaPersonIdentifierUserType();


    @Test
    @Suite( groups = "checkintest" )
    public void testNullSafeGet( )
        throws Exception
    {
        ResultSet resultSet = EasyMock.createMock( ResultSet.class );
        String[] names = { "person" };
        EasyMock.expect( resultSet.getString( names[0] ) ).andReturn( "identity^prefix^given^middle^family^suffix^title^stationNumber" ).anyTimes();

        SessionImplementor sessionImplementor = EasyMock.createMock( SessionImplementor.class );
        

        EasyMock.replay( resultSet, sessionImplementor );

        HL72PersonIdentifier personIdentifier = ( HL72PersonIdentifier )userType.nullSafeGet( resultSet, names, sessionImplementor, null );
        Assert.assertEquals( "identity", personIdentifier.getIdentity());
          
    }


    @Test( expected = UnsupportedOperationException.class )
    @Suite( groups = "checkintest" )
    public void testNullSafeSet( )
        throws Exception
    {
        userType.nullSafeSet( null, null, 1, null );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testIsMutable( )
    {
        Assert.assertFalse( userType.isMutable() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testReplace( )
    {
        Assert.assertEquals( vistaPersonName, userType.replace( vistaPersonName, null, null, null ) );
    }


    @Test( expected = UnsupportedOperationException.class )
    @Suite( groups = "checkintest" )
    public void testSetPropertyValue( )
        throws Exception
    {
        userType.setPropertyValue( null, 1, null );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testAssemble( )
    {
        Assert.assertEquals( vistaPersonName, userType.assemble( vistaPersonName, null, null ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testDeepCopy( )
    {
        Assert.assertEquals( vistaPersonName, userType.deepCopy( vistaPersonName ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testDisassemble( )
    {
        Assert.assertEquals( vistaPersonName, userType.disassemble( vistaPersonName, null ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testNotEqualsObjectObject( )
    {
        VistaPersonName vistaPersonName1 = new VistaPersonName( "^^^^^^^" );
        Assert.assertFalse( userType.equals( vistaPersonName, vistaPersonName1 ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testEqualsObjectObject( )
    {
        Assert.assertTrue( userType.equals( vistaPersonName, vistaPersonName ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetPropertyNames( )
    {
        Assert.assertEquals( 1, userType.getPropertyNames().length );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetPropertyTypes( )
    {
        userType.getPropertyTypes();
    }


    @Test( expected = UnsupportedOperationException.class )
    @Suite( groups = "checkintest" )
    public void testGetPropertyValue( )
        throws Exception
    {
        userType.getPropertyValue( null, 1 );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testHashCodeObject( )
    {
        Assert.assertNotSame( 0, userType.hashCode( vistaPersonName ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testHashCodeOfNull( )
    {
        Assert.assertEquals( 0, userType.hashCode( null ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testReturnedClass( )
    {
        Assert.assertEquals( vistaPersonName.getClass().getName(), userType.returnedClass().getName() );
    }

}
