

package gov.va.med.cds.persistence.hibernate.common;


import static org.easymock.EasyMock.expect;
import static org.junit.Assert.assertEquals;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.template.generated.common.TreatmentFactor;
import gov.va.med.cds.template.generated.pharmacy.OutpatientMedicationPromise1.TreatmentFactors;

import org.dom4j.Element;
import org.easymock.EasyMock;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/config/timeZoneOffsetContext.xml" } )
public class VistaOutpatientPharmacyTreatmentFactorTypeTest
{
    private static VistaOutpatientPharmacyTreatmentFactorType vistaOPTreatmentFactorType = null;
    private static final String[] NAMES = { "SERVICE_CONNECTED", "MILITARY_SEXUAL_TRAUMA", "AGENT_ORANGE_EXPOSURE", "IONIZING_RADIATION_EXPOSURE",
                    "SouthwestAsiaConditions", "HEAD_ANDOR_NECK_CANCER", "COMBAT_VETERAN", "Proj112Shad" };
    private static final String TREATMENT_FACTORS_RESULT = "<treatmentFactors><treatmentFactor><factor><code>SERVICE CONNECTED</code></factor><factorValue><code>0</code><displayText>NO</displayText></factorValue></treatmentFactor><treatmentFactor><factor><code>MILITARY SEXUAL TRAUMA</code></factor><factorValue><code>0</code><displayText>NO</displayText></factorValue></treatmentFactor><treatmentFactor><factor><code>AGENT ORANGE EXPOSURE</code></factor><factorValue><code>0</code><displayText>NO</displayText></factorValue></treatmentFactor><treatmentFactor><factor><code>IONIZING RADIATION EXPOSURE</code></factor><factorValue><code>0</code><displayText>NO</displayText></factorValue></treatmentFactor><treatmentFactor><factor><code>SOUTHWEST ASIA CONDITIONS</code></factor><factorValue><code>0</code><displayText>NO</displayText></factorValue></treatmentFactor><treatmentFactor><factor><code>HEAD AND/OR NECK CANCER</code></factor><factorValue><code>0</code><displayText>NO</displayText></factorValue></treatmentFactor><treatmentFactor><factor><code>COMBAT VETERAN</code></factor><factorValue><code>0</code><displayText>NO</displayText></factorValue></treatmentFactor><treatmentFactor><factor><code>PROJ 112/SHAD</code></factor><factorValue><code>0</code><displayText>NO</displayText></factorValue></treatmentFactor></treatmentFactors>";


    @BeforeClass
    @Suite( groups = { "checkintest" } )
    public static void beforeVistaPointInTimeUserTypeQueryTestClassSetUp( )
        throws Exception
    {
        vistaOPTreatmentFactorType = new VistaOutpatientPharmacyTreatmentFactorType();
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testNullSafeGet( )
        throws HibernateException,
            SQLException
    {
        ResultSet rs = EasyMock.createMock( ResultSet.class );
        SessionImplementor sessionImplementor = EasyMock.createMock( SessionImplementor.class );

        for ( String name : NAMES )
        {
            expect( rs.getString( name ) ).andReturn( name );
        }
        
        expect( rs.wasNull() ).andReturn( false ).anyTimes();

        EasyMock.replay( rs, sessionImplementor );
        @SuppressWarnings("unchecked")
		List<TreatmentFactor> result = ( List<TreatmentFactor> )vistaOPTreatmentFactorType.nullSafeGet( rs, NAMES, sessionImplementor, null );

        TreatmentFactor factor = (TreatmentFactor)result.get(0);
        assertEquals( factor.getFactorValue().getCode(), "0" );
        assertEquals( factor.getFactorValue().getDisplayText(), "NO" );
       
        EasyMock.verify( sessionImplementor );
    }


    @Test( expected = UnsupportedOperationException.class )
    @Suite( groups = { "checkintest" } )
    public void testNullSafeSetWithNull( )
        throws HibernateException,
            SQLException
    {
        vistaOPTreatmentFactorType.nullSafeSet( null, null, 1, null );
    }


    @Test( expected = UnsupportedOperationException.class )
    @Suite( groups = { "checkintest" } )
    public void testSetPropertyValue( )
        throws HibernateException,
            SQLException
    {
        //this should throw exception ...
        vistaOPTreatmentFactorType.setPropertyValue( null, 1, null );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testIsMutable( )
    {
        Assert.assertFalse( vistaOPTreatmentFactorType.isMutable() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testReplace( )
    {
        assertEquals( NAMES, vistaOPTreatmentFactorType.replace( NAMES, null, null, null ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testAssemble( )
    {
        assertEquals( NAMES, vistaOPTreatmentFactorType.assemble( NAMES, null, null ) );
        assertEquals( NAMES, vistaOPTreatmentFactorType.assemble( NAMES, null ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testDeepCopy( )
    {
        assertEquals( NAMES, vistaOPTreatmentFactorType.deepCopy( NAMES ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testDisassemble( )
    {
        assertEquals( NAMES, vistaOPTreatmentFactorType.disassemble( NAMES, null ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testNotEqualsObjectObject( )
    {
        VistaPersonName NAMES1 = new VistaPersonName( "^^^^^^^" );
        Assert.assertFalse( vistaOPTreatmentFactorType.equals( NAMES, NAMES1 ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testEqualsObjectObject( )
    {
        Assert.assertTrue( !vistaOPTreatmentFactorType.equals( NAMES, NAMES ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetPropertyNames( )
    {
        assertEquals( NAMES.length, vistaOPTreatmentFactorType.getPropertyNames().length );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetPropertyTypes( )
    {
        vistaOPTreatmentFactorType.getPropertyTypes();
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetPropertyValue( )
        throws Exception
    {
        Assert.assertNull( vistaOPTreatmentFactorType.getPropertyValue( null, 1 ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testHashCodeObject( )
    {
        Assert.assertNotSame( 0, vistaOPTreatmentFactorType.hashCode( NAMES ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testHashCodeOfNull( )
    {
        assertEquals( 0, vistaOPTreatmentFactorType.hashCode( null ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testReturnedClass( )
    {
        assertEquals( PointInTime.class, new VistaOutpatientPharmacyTreatmentFactorType().returnedClass() );
    }
}
