

package gov.va.med.cds.persistence.hibernate.common;


import gov.va.med.cds.junit.runners.Suite;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.easymock.EasyMock;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.junit.Assert;
import org.junit.Test;


public class VistaIntegerToStringUserTypeTest
{
  
    final static String fromDb = "299999998888888833333333.0";
    
    private VistaIntegerToStringUserType userType = new VistaIntegerToStringUserType();


    @Test
    @Suite( groups = "checkintest" )
    public void testNullSafeGet( )
        throws Exception
    {
        ResultSet resultSet = EasyMock.createMock( ResultSet.class );
        String[] identity = { "identity" };
        EasyMock.expect( resultSet.getString( identity[0] ) ).andReturn( fromDb ).anyTimes();
        EasyMock.expect( resultSet.getBigDecimal( identity[0] ) ).andReturn( new BigDecimal(fromDb) ).anyTimes();

        SessionImplementor sessionImplementor = EasyMock.createMock( SessionImplementor.class );
                
        EasyMock.replay( resultSet, sessionImplementor );

        String identityValue = (String)userType.nullSafeGet( resultSet, identity, sessionImplementor, null );
        Assert.assertEquals( "299999998888888833333333", identityValue);
       
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testNullSafeSet( )
        throws Exception
    {
        int index = 1;
        PreparedStatement statement = EasyMock.createMock( PreparedStatement.class );
        SessionImplementor sessionImplementor = EasyMock.createMock( SessionImplementor.class );

        statement.setNull( index, StandardBasicTypes.INTEGER.sqlType() );

        EasyMock.replay( statement );
        userType.nullSafeSet( statement, null, 1, sessionImplementor );
        EasyMock.verify( statement );
    }
    
    @Test
    @Suite( groups = "checkintest" )
    public void testSafeSetInteger( )
        throws Exception
    {
        int index = 1;
        PreparedStatement statement = EasyMock.createMock( PreparedStatement.class );
        SessionImplementor sessionImplementor = EasyMock.createMock( SessionImplementor.class );

        BigDecimal identity = new BigDecimal(fromDb);
        int indent = identity.intValue();
        statement.setInt(index, indent);

        EasyMock.replay( statement );
        userType.nullSafeSet( statement, indent, 1, sessionImplementor );
        EasyMock.verify( statement );
    }

    
    @Test
    @Suite( groups = "checkintest" )
    public void testSafeSetBigDecimal( )
        throws Exception
    {
        int index = 1;
        PreparedStatement statement = EasyMock.createMock( PreparedStatement.class );
        SessionImplementor sessionImplementor = EasyMock.createMock( SessionImplementor.class );

        BigDecimal identity = new BigDecimal(fromDb);
        statement.setBigDecimal(index, identity);

        EasyMock.replay( statement );
        userType.nullSafeSet( statement, identity, 1, sessionImplementor );
        EasyMock.verify( statement );
    }

    @Test
    @Suite( groups = "checkintest" )
    public void testIsMutable( )
    {
        Assert.assertFalse( userType.isMutable() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testReplace( )
    {
        BigDecimal bd = new BigDecimal(fromDb);
        Assert.assertEquals( bd, userType.replace( bd, null, null, null ) );
    }


   
    @Test( expected = UnsupportedOperationException.class )
    @Suite( groups = "checkintest" )
    public void testSetPropertyValue( )
        throws Exception
    {
        userType.setPropertyValue( null, 1, null );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testAssemble( )
    {
        BigDecimal bd = new BigDecimal(fromDb);
        Assert.assertEquals( bd, userType.assemble( bd, null, null ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testDeepCopy( )
    {
    	 BigDecimal bd = new BigDecimal(fromDb);
    	Assert.assertEquals( bd, userType.deepCopy( bd ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testDisassemble( )
    {
    	BigDecimal bd = new BigDecimal(fromDb);
    	Assert.assertEquals( bd, userType.disassemble( bd, null ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testNotEqualsObjectObject( )
    {
        BigDecimal bd = new BigDecimal(fromDb);
        BigDecimal bd2 = new BigDecimal(fromDb);
        Assert.assertFalse( userType.equals( bd, bd2 ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testEqualsObjectObject( )
    {
        BigDecimal bd = new BigDecimal(fromDb);
        Assert.assertTrue( userType.equals( bd, bd ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetPropertyNames( )
    {
        Assert.assertEquals( 1, userType.getPropertyNames().length );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetPropertyTypes( )
    {
        userType.getPropertyTypes();
    }


    @Test( expected = UnsupportedOperationException.class )
    @Suite( groups = "checkintest" )
    public void testGetPropertyValue( )
        throws Exception
    {
        userType.getPropertyValue( null, 1 );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testHashCodeObject( )
    {
        BigDecimal bd = new BigDecimal(fromDb);
        Assert.assertNotSame( 0, userType.hashCode( bd ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testHashCodeOfNull( )
    {
        Assert.assertEquals( 0, userType.hashCode( null) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testReturnedClass( )
    {
    	BigDecimal bd = new BigDecimal(fromDb);
    	Assert.assertEquals( bd.getClass().getName(), userType.returnedClass().getName() );
    }

}
