/**
 *
 */


package gov.va.med.cds.persistence.hibernate;


import gov.va.med.cds.common.person.correlation.PersonIdentifier;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exceptionframework.ExceptionHandler;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.ReadException;

import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;


/**
 * @author barryegbert
 *
 */
public class FailingReadableHibernatePersistenceManager
    extends
        DefaultHibernateReadPersistenceManager
{

    @Autowired
    protected String cdsAppName;


    @Override
    public Document performReadOnClinicalData( EntryFilterInterface entryFilter, List<PersonIdentifierInterface> personIdentifiers,
                    String applicationName )
        throws PersistenceException
    {
        Document resultDocument = null;
        PersonIdentifier[] pids = personIdentifiers.toArray( new PersonIdentifier[personIdentifiers.size()] );
        if ( pids.length > 0 )
        {
            ReadException readException = new ReadException( ErrorCodeEnum.READ_REQUEST_DATA_SOURCE_FAILURE, pids[0].getAssigningFacility(),
                            pids[0].getIdentity(), entryFilter.getDomainEntryPoint(), this.managerIdentifier,
                            "gov.va.med.cds.persistence.hibernate.FailingReadableHibernatePersistenceManager" );

            String templateId = ( entryFilter == null ) ? null : entryFilter.getTemplateId();
            String requestId = ( entryFilter == null ) ? null : entryFilter.getRequestId();
            resultDocument = ExceptionHandler.handleException( readException, templateId, requestId, cdsAppName );
        }

        return resultDocument;
    }
}
