

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import gov.va.med.cds.integration.AbstractEndToEndTest;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.RequestProcessorInterface;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;
import gov.va.med.cds.testharness.xml.Assert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareSpringRunner.class )
public class EndToEndReadVistaPatientRemarksTest
    extends
        AbstractEndToEndTest
{
    private static final String PATIENT_IDENTITY_VISTA = "100600";
    private static final String ASSIGNING_FACILITY_VISTA_580 = "580";
    private static final String ASSIGNING_AUTHORITY_VISTA = "USVHA";

    private static final String PAYLOAD_TYPE_VHIM = "VHIM";

    private static final String XPATH_ERRORSECTION = "//errorSection";
    @SuppressWarnings( "unused" )
    private static final String XPATH_ERRORSECTION_ERROR = "/vp2data:patientRemarksdata/errorSection/errors/error";
    @SuppressWarnings( "unused" )
    private static final String XPATH_ERRORSECTION_WARNING_DISPLAYMSG = "/vp2data:patientRemarksdata/errorSection/warnings/warning/displayMessage";

    @Resource
    private RequestProcessorInterface rpcRequestProcessor = null;
    protected TemplateRequestProcessor templateRequestProcessor;


    @Before
    @Suite( groups = { "checkintest" } )
    public void beforeEndToEndReadVrmTestClassSetUp( )
        throws Exception
    {
        templateRequestProcessor = ( TemplateRequestProcessor )getRpcRequestProcessor();

    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaRemarks( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient521 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA };
        String[][] patientIdentifiers = { vistaPatient521 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "VistaPatient2Remarks" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "VistaPatient2RemarksQuery" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter
        String filterXml = FilterBuilder.buildVistaRemarksFilterElementWithResolvedIdentfiers( TemplateIdHelper.VISTA_PATIENT2_REMARKS_DATA_FILTER,
                        entryPointFilterMaps, resolvedPatients, null, null, clientRequestInitiationTime ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.VISTA_PATIENT2_REMARKS_READ1_TEMPLATE_ID,
                        TemplateIdHelper.VISTA_PATIENT2_REMARKS_DATA_FILTER, requestId, filterXml, resolvedPatients, PAYLOAD_TYPE_VHIM );

        List<Element> elementList = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( elementList.size() == 0 );
    }


    @SuppressWarnings( "unchecked" )
    protected Document readAndAssertDomainData( String templateId, String filterId, String requestId, String filterXml,
                    List<Map<String, String>> resolvedPatients, String payloadType )
        throws Exception
    {
        templateRequestProcessor.setValidateReadResponseXML( false );
        Document dataDocument = templateRequestProcessor.readClinicalData( templateId, filterXml, filterId, requestId );
        assertNotNull( dataDocument );

        // Check for error sections
        List<Element> errorSections = new ArrayList<Element>();
        errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );

        assertTrue( errorSections.size() == 0 );

   
        return dataDocument;
    }


    protected RequestProcessorInterface getRpcRequestProcessor( )
    {
        return rpcRequestProcessor;
    }
}
