

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import gov.va.med.cds.integration.AbstractEndToEndTest;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.RequestProcessorInterface;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;

import javax.annotation.Resource;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith(SuiteAwareSpringRunner.class)
public class EndToEndReadVistaNonEmployeeTest
    extends
        AbstractEndToEndTest
{
    private static final String PATIENT_IDENTITY_VISTA_EMPLOYEE = "20";
    private static final String PATIENT_IDENTITY_VISTA_EMPLOYEE_654 = "17";
    private static final String PATIENT_IDENTITY_VISTA_NONEMPLOYEE_654 = "100600";
    private static final String ASSIGNING_FACILITY_VISTA_578 = "578";
    private static final String ASSIGNING_FACILITY_VISTA_580 = "580";
    private static final String ASSIGNING_FACILITY_VISTA_654 = "654";
    private static final String ASSIGNING_AUTHORITY_VISTA = "USVHA";

    private static final String PAYLOAD_TYPE_VHIM = "VHIM";

    private static final String XPATH_ERRORSECTION = "//errorSection";
    @SuppressWarnings("unused")
    private static final String XPATH_ERRORSECTION_ERROR = "/nonVeteranEmployeedata:nonEmployeeData/errorSection/errors/error";
    @SuppressWarnings("unused")
    private static final String XPATH_ERRORSECTION_WARNING_DISPLAYMSG = "/nonVeteranEmployeedata:nonEmployeeData/errorSection/warnings/warning/displayMessage";

    private static final String XPATH_SINGLE_PATIENT = "//nonVeteranEmployees/nonVeteranEmployee/veteranYN";

    @Resource
    private RequestProcessorInterface rpcRequestProcessor = null;
    protected TemplateRequestProcessor templateRequestProcessor;


    @Before
    @Suite(groups = { "checkintest" })
    public void beforeEndToEndReadVrmTestClassSetUp( ) throws Exception
    {
        templateRequestProcessor = ( TemplateRequestProcessor )getRpcRequestProcessor();

    }


    @SuppressWarnings("unchecked")
    @Test
    @Suite(groups = { "checkintest" })
    public void testNonEmployee( ) throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient654 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_654, PATIENT_IDENTITY_VISTA_NONEMPLOYEE_654 };
        String[][] patientIdentifiers = { vistaPatient654 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "NonVeteranEmployee" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "nonVeteranEmployee" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter
        String filterXml = FilterBuilder
                .buildVistaNonEmployeeFilterElementWithResolvedIdentfiers( TemplateIdHelper.VISTA_NON_EMPLOYEE_FILTER, entryPointFilterMaps,
                        resolvedPatients, null, null, clientRequestInitiationTime )
                .asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.VISTA_NON_EMPLOYEE_TEMPLATE_ID,
                TemplateIdHelper.VISTA_NON_EMPLOYEE_FILTER, requestId, filterXml, resolvedPatients, PAYLOAD_TYPE_VHIM );

        List<Element> elementList = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( elementList.size() == 0 );

        Node NonEmployeeElement = dataDocument.selectSingleNode( XPATH_SINGLE_PATIENT );
        assertTrue( NonEmployeeElement.getText().contains( "YES" ) );

    }


    @SuppressWarnings("unchecked")
    @Test
    @Suite(groups = { "checkintest" })
    public void testEmployee( ) throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient654 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_654, PATIENT_IDENTITY_VISTA_EMPLOYEE_654 };
        String[][] patientIdentifiers = { vistaPatient654 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "NonVeteranEmployee" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "nonVeteranEmployee" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter
        String filterXml = FilterBuilder
                .buildVistaNonEmployeeFilterElementWithResolvedIdentfiers( TemplateIdHelper.VISTA_NON_EMPLOYEE_FILTER, entryPointFilterMaps,
                        resolvedPatients, null, null, clientRequestInitiationTime )
                .asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.VISTA_NON_EMPLOYEE_TEMPLATE_ID,
                TemplateIdHelper.VISTA_NON_EMPLOYEE_FILTER, requestId, filterXml, resolvedPatients, PAYLOAD_TYPE_VHIM );

        List<Element> elementList = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( elementList.size() == 0 );

        Node NonEmployeeElement = dataDocument.selectSingleNode( XPATH_SINGLE_PATIENT );
        assertTrue( NonEmployeeElement.getText().contains( "NO" ) );

    }


    @SuppressWarnings("unchecked")
    @Test
    @Suite(groups = { "checkintest" })
    public void testMultiplePatients( ) throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient654Employee = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_654, PATIENT_IDENTITY_VISTA_EMPLOYEE_654 };
        String[] vistaPatient654NonEmployee = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_654,
                PATIENT_IDENTITY_VISTA_NONEMPLOYEE_654 };
        String[] vistaPatient580Employee = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EMPLOYEE };
        String[] vistaPatient578Employee = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_578, PATIENT_IDENTITY_VISTA_EMPLOYEE };
        String[][] patientIdentifiers = { vistaPatient654Employee, vistaPatient654NonEmployee, vistaPatient580Employee,
                vistaPatient578Employee };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "NonVeteranEmployee" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "nonVeteranEmployee" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter
        String filterXml = FilterBuilder
                .buildVistaNonEmployeeFilterElementWithResolvedIdentfiers( TemplateIdHelper.VISTA_NON_EMPLOYEE_FILTER, entryPointFilterMaps,
                        resolvedPatients, null, null, clientRequestInitiationTime )
                .asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.VISTA_NON_EMPLOYEE_TEMPLATE_ID,
                TemplateIdHelper.VISTA_NON_EMPLOYEE_FILTER, requestId, filterXml, resolvedPatients, PAYLOAD_TYPE_VHIM );

        List<Element> elementList = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( elementList.size() == 0 );

        List<Element> employeeList = dataDocument.selectNodes( XPATH_SINGLE_PATIENT );
        assertTrue( employeeList.size() > 0 );

    }

    
    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testEmployeeWithSingleICN( )
        throws Exception
    {
        String nationalId = "1008523096V381537";
        String readTemplateId = TemplateIdHelper.VISTA_NON_EMPLOYEE_TEMPLATE_ID;
        String filterId = TemplateIdHelper.VISTA_NON_EMPLOYEE_FILTER;

        String requestId = TemplateIdHelper.getUniqueIdentifier();

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "NonVeteranEmployee" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "nonVeteranEmployee" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );

        String filterXml = FilterBuilder.buildFilterWithNationalId( filterId, entryPointFilterMaps, nationalId,
                         DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ) );

        templateRequestProcessor.setValidateReadResponseXML( false );

        Document dataDocument = templateRequestProcessor.readClinicalData( readTemplateId, filterXml, filterId, requestId );
        assertNotNull( dataDocument );

        Node NonEmployeeElement = dataDocument.selectSingleNode( XPATH_SINGLE_PATIENT );
        assertTrue( NonEmployeeElement.getText().contains( "YES" ) );

    }

    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "brokentest" } )
    public void testEmployeeWithUnknownICN( )
        throws Exception
    {
        String nationalId = "3234567890V123456";
        String readTemplateId = TemplateIdHelper.VISTA_NON_EMPLOYEE_TEMPLATE_ID;
        String filterId = TemplateIdHelper.VISTA_NON_EMPLOYEE_FILTER;

        String requestId = TemplateIdHelper.getUniqueIdentifier();

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "NonVeteranEmployee" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "nonVeteranEmployee" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );

        String filterXml = FilterBuilder.buildFilterWithNationalId( filterId, entryPointFilterMaps, nationalId,
                         DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ) );

        templateRequestProcessor.setValidateReadResponseXML( false );

        Document dataDocument = templateRequestProcessor.readClinicalData( readTemplateId, filterXml, filterId, requestId );
        assertNotNull( dataDocument );

        Node NonEmployeeElement = dataDocument.selectSingleNode( XPATH_SINGLE_PATIENT );
        assertTrue( NonEmployeeElement.getText().contains( "YES" ) );

    }

    
    @SuppressWarnings("unchecked")
    protected Document readAndAssertDomainData( String templateId, String filterId, String requestId, String filterXml,
            List<Map<String, String>> resolvedPatients, String payloadType ) throws Exception
    {
        templateRequestProcessor.setValidateReadResponseXML( false );
        Document dataDocument = templateRequestProcessor.readClinicalData( templateId, filterXml, filterId, requestId );
        assertNotNull( dataDocument );

        // Check for error sections
        List<Element> errorSections = new ArrayList<Element>();
        errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );

        assertTrue( errorSections.size() == 0 );

        return dataDocument;
    }


    protected RequestProcessorInterface getRpcRequestProcessor( )
    {
        return rpcRequestProcessor;
    }
}
