

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.integration.AbstractEndToEndReadTiuTest;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;
import gov.va.med.cds.uniqueidentifier.UniqueIdentifier;

import org.dom4j.Document;
import org.dom4j.Element;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@RunWith( SuiteAwareSpringRunner.class )
public class EndToEndReadTiuTest
    extends
        AbstractEndToEndReadTiuTest
{
    private static String PATIENTIDENTITY1 = "1";
    private static String ASSIGNINGFACILITY1 = "580";
    private static String PATIENTIDENTITY2 = "1";
    private static String PATIENTIDENTITY3 = "711";
    private static String ASSIGNINGFACILITY2 = "578";
    private static String DOCUMENT_CLASS_VALUE = "3";
    private static String[] DOCUMENT_TYPE_VALUES = { "4696095", "4696107", "4697146", "4696112", "4696113", "4696119", "4696120", "4696125",
                    "4696444" };
    private static String XPATH_IDENTIFIERS = "//requestedResolvedIdentifier";
    private static String XPATH_DOCUMENTUPDATEEVENTS = "//patient/clinicalDocumentEvents/clinicalDocumentEvent/documentUpdateEvents/documentUpdateEvent";
    private static String XPATH_CLINICALDOCUMENTEVENTS = "//patient/clinicalDocumentEvents/clinicalDocumentEvent";
    private static String XPATH_CLINICALDOCUMENTEVENTS_IMAGE = "//patient/clinicalDocumentEvents/clinicalDocumentEvent/images/image";
    private static String XPATH_ERRORSECTION_ERRORCODE = "/clinicaldata:ClinicalData/errorSection/fatalErrors/fatalError/errorCode";
    private static final String TIMOUT_ERROR_CODE = "READ_REQUEST_ALL_DATASOURCES_FAILED";


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testTiuListReadWithDocumentClass_SingleSite( )
        throws Exception
    {
        Map<String, String> assigningFacilityAndPatientIdentityMap = new HashMap<String, String>();
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY1, PATIENTIDENTITY1 );

        // TIU List read filter with documentClass
        String filterXml = createTiuSinglePatientListDataFilter( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER, DOCUMENT_CLASS_VALUE, null, null, null, null,
                        TIU_LIST_REQUIRED_XQUERY_CRITERIA );

        Document clinicalDataDocument = readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, getTiuListReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER );

        List<Element> resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( XPATH_IDENTIFIERS );
        assertNotNull( resultsResolvedIdentifiersList );
        assertTrue( resultsResolvedIdentifiersList.size() == assigningFacilityAndPatientIdentityMap.size() );

        // TIU List read filter with documentClass with date
        filterXml = createTiuSinglePatientListDataFilter( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER, DOCUMENT_CLASS_VALUE, null, "1994-01-01", "1998-12-31", null,
                        TIU_LIST_REQUIRED_XQUERY_CRITERIA );

        clinicalDataDocument = readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, getTiuListReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER );

        //expecting 5 plus one with a null date
        assertEquals( 5, clinicalDataDocument.selectNodes( XPATH_CLINICALDOCUMENTEVENTS ).size() );

        // TIU List read filter with documentType
        filterXml = createTiuSinglePatientListDataFilter( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER, null, DOCUMENT_TYPE_VALUES, null, null, null,
                        TIU_LIST_REQUIRED_XQUERY_CRITERIA );

        clinicalDataDocument = readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, getTiuListReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER );

        resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( XPATH_IDENTIFIERS );
        assertNotNull( resultsResolvedIdentifiersList );
        assertTrue( resultsResolvedIdentifiersList.size() == assigningFacilityAndPatientIdentityMap.size() );

        // TIU List read filter with documentType and date
        filterXml = createTiuSinglePatientListDataFilter( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER, null, DOCUMENT_TYPE_VALUES, "1996-11-08", "1996-11-08", null,
                        TIU_LIST_REQUIRED_XQUERY_CRITERIA );

        clinicalDataDocument = readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, getTiuListReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER );

        assertEquals( 2, clinicalDataDocument.selectNodes( XPATH_CLINICALDOCUMENTEVENTS ).size() );
        resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( XPATH_IDENTIFIERS );
        assertNotNull( resultsResolvedIdentifiersList );
        assertTrue( resultsResolvedIdentifiersList.size() == assigningFacilityAndPatientIdentityMap.size() );

        // TIU List read filter with documentType and date (no start date)
        filterXml = createTiuSinglePatientListDataFilter( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER, null, DOCUMENT_TYPE_VALUES, null, "1996-11-08", null,
                        TIU_LIST_REQUIRED_XQUERY_CRITERIA );

        clinicalDataDocument = readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, getTiuListReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER );

        assertEquals( 2, clinicalDataDocument.selectNodes( XPATH_CLINICALDOCUMENTEVENTS ).size() );
        resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( XPATH_IDENTIFIERS );
        assertNotNull( resultsResolvedIdentifiersList );
        assertTrue( resultsResolvedIdentifiersList.size() == assigningFacilityAndPatientIdentityMap.size() );

        // TIU List read filter with documentType and date (no end date)
        filterXml = createTiuSinglePatientListDataFilter( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER, null, DOCUMENT_TYPE_VALUES, "1996-11-08", null, null,
                        TIU_LIST_REQUIRED_XQUERY_CRITERIA );

        clinicalDataDocument = readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, getTiuListReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER );

        assertEquals( 2, clinicalDataDocument.selectNodes( XPATH_CLINICALDOCUMENTEVENTS ).size() );
        resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( XPATH_IDENTIFIERS );
        assertNotNull( resultsResolvedIdentifiersList );
        assertTrue( resultsResolvedIdentifiersList.size() == assigningFacilityAndPatientIdentityMap.size() );

        // TIU List read results with documentUpdateEvents
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY1, PATIENTIDENTITY3 );
        filterXml = createTiuSinglePatientListDataFilter( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER, DOCUMENT_CLASS_VALUE, null, null, null, null,
                        TIU_LIST_REQUIRED_XQUERY_CRITERIA );

        clinicalDataDocument = readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, getTiuListReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER );
        assertEquals( 73, clinicalDataDocument.selectNodes( XPATH_CLINICALDOCUMENTEVENTS ).size() );
        assertEquals( 4, clinicalDataDocument.selectNodes( XPATH_DOCUMENTUPDATEEVENTS ).size() );
    }


    //@Test
    //@Suite( groups = { "smoketest" } )
    @SuppressWarnings( "unchecked" )
    /**
     * TIU list read test with Images data
     * Since Dev test VistA accounts do not have Images data, the below test runs against MARTSQA2
     */
    public void testTiuListReadWithDocumentClassAndImagesData_SingleSite( )
        throws Exception
    {
        Map<String, String> assigningFacilityAndPatientIdentityMap = new HashMap<String, String>();
        assigningFacilityAndPatientIdentityMap.put( "613", "38" );

        // TIU List read filter with documentClass
        String filterXml = createTiuSinglePatientListDataFilter( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER, DOCUMENT_CLASS_VALUE, null, null, null, null,
                        TIU_LIST_REQUIRED_XQUERY_CRITERIA );

        Document clinicalDataDocument = readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, getTiuListReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER );

        List<Element> resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( XPATH_IDENTIFIERS );
        assertNotNull( resultsResolvedIdentifiersList );
        assertTrue( resultsResolvedIdentifiersList.size() == assigningFacilityAndPatientIdentityMap.size() );

        assertEquals( 2, clinicalDataDocument.selectNodes( XPATH_CLINICALDOCUMENTEVENTS_IMAGE ).size() );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testTiuDetailReadFromListOfDocumentEvents_SingleSite( )
        throws Exception
    {
        Map<String, String> assigningFacilityAndPatientIdentityMap = new HashMap<String, String>();
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY1, PATIENTIDENTITY1 );

        // TIU List read filter with documentClass
        String filterXml = createTiuSinglePatientListDataFilter( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER, DOCUMENT_CLASS_VALUE, null, null, null, null,
                        TIU_LIST_REQUIRED_XQUERY_CRITERIA );

        Document clinicalDataDocument = readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, getTiuListReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER );

        List<Element> resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( XPATH_IDENTIFIERS );
        assertNotNull( resultsResolvedIdentifiersList );
        assertTrue( resultsResolvedIdentifiersList.size() == assigningFacilityAndPatientIdentityMap.size() );

        // TIU List read filter with documentClass with date
        filterXml = createTiuSinglePatientListDataFilter( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER, null, DOCUMENT_TYPE_VALUES, "1991-01-01", "1998-12-31", null,
                        TIU_LIST_REQUIRED_XQUERY_CRITERIA );

        clinicalDataDocument = readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, getTiuListReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER );
           
        //expecting 5 plus one with a null date
        assertEquals( 2, clinicalDataDocument.selectNodes( XPATH_CLINICALDOCUMENTEVENTS ).size() );

        // TIU List read filter with documentType
        filterXml = createTiuSinglePatientListDataFilter( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER, null, DOCUMENT_TYPE_VALUES, null, null, null,
                        TIU_LIST_REQUIRED_XQUERY_CRITERIA );

        clinicalDataDocument = readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, getTiuListReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER );
        

        List<Element> clinicalDocumentEvent = clinicalDataDocument.selectNodes( XPATH_CLINICALDOCUMENTEVENTS );
        Element identifier = clinicalDocumentEvent.get( 0 ).element( "recordIdentifier" );
        String recordIdentity = identifier.elementText( "identity" );

        Element patientIdentifier = ( Element )clinicalDocumentEvent.get( 0 ).selectSingleNode( "patient/identifier" );
        String identity = patientIdentifier.elementText( "identity" );
        String assigningFacility = patientIdentifier.elementText( "assigningFacility" );
        //NOTE: the development vista sites don't have the same NamespaceId and the User or Datasource (521 = 580) so have to use hardcoded facility
        assigningFacilityAndPatientIdentityMap = new HashMap<String, String>();
        assigningFacilityAndPatientIdentityMap.put( assigningFacility, identity );

        filterXml = createTiuSinglePatientListDataFilterIdentifiers( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_DETAIL_DATA_FILTER, recordIdentity, NAMESPACEID1, null );
        readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, getTiuDetailReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_DETAIL_DATA_FILTER );

    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testTiuDetailRead_SingleSite( )
        throws Exception
    { //34, 500

        Map<String, String> assigningFacilityAndPatientIdentityMap = new HashMap<String, String>();
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY1, "1" );
        String filterXml = createTiuSinglePatientListDataFilterIdentifiers( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_DETAIL_DATA_FILTER, "755", NAMESPACEID1, null );
        readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, getTiuDetailReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_DETAIL_DATA_FILTER );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testTiuDetailRead_SingleSiteWithFloat( )
        throws Exception
    {
        //hardcoded Float identity

        Map<String, String> assigningFacilityAndPatientIdentityMap = new HashMap<String, String>();
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY1, "1.0" );
        String filterXml = createTiuSinglePatientListDataFilterIdentifiers( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_DETAIL_DATA_FILTER, "755.0", NAMESPACEID1, null );
        readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, getTiuDetailReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_DETAIL_DATA_FILTER );
    }


    //this test is comment out because for some unknown reason it doesn't error when ran from command line - surefire
    //@Test
    //@SuppressWarnings( "unchecked" )
    //@Suite( groups = { "checkintest" } )
    public void testTiuDetailRead_SingleSiteWithBadFloat( )
        throws Exception
    {
        //bad float - number format exception in xml.

        Map<String, String> assigningFacilityAndPatientIdentityMap = new HashMap<String, String>();
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY1, "1" );
        String filterXml = createTiuSinglePatientListDataFilterIdentifiers( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_DETAIL_DATA_FILTER, "SiteId", NAMESPACEID1, null );

        requestProcessor.setValidateReadResponseXML( true );

        Document clinicalDataDocument = requestProcessor.readClinicalData( getTiuDetailReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_DETAIL_DATA_FILTER, new UniqueIdentifier().toString() );
        assertNotNull( clinicalDataDocument );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() > 0 );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "timeouttest" } )
    /* this test is failing only on continuous, should be fixed*/
    public void testTiuDetailRead_SingleSiteTimeoutError( )
        throws Exception
    {
        String TIMEOUT_SECONDS = "1";

        Map<String, String> assigningFacilityAndPatientIdentityMap = new HashMap<String, String>();
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY1, "1" );

        String filterXml = createTiuSinglePatientListDataFilterIdentifiers( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_DETAIL_DATA_FILTER, "755", NAMESPACEID1, TIMEOUT_SECONDS );

        requestProcessor.setValidateReadResponseXML( true );

        Document clinicalDataDocument = requestProcessor.readClinicalData( getTiuDetailReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_DETAIL_DATA_FILTER, new UniqueIdentifier().toString() );
        assertNotNull( clinicalDataDocument );

        // Check for error sections
        List<Element> errorCodes = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION_ERRORCODE );

        // The test may/may not timeout due to database and/or network conditions
        if ( errorCodes.size() == 1 )
            assertTrue( errorCodes.get( 0 ).getText().equals( TIMOUT_ERROR_CODE ) );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testTiuListRead_MulitSite( )
        throws Exception
    {
        Map<String, String> assigningFacilityAndPatientIdentityMap = new HashMap<String, String>();
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY1, PATIENTIDENTITY1 );
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY2, PATIENTIDENTITY2 );

        // TIU List read filter with documentClass
        String filterXml = createTiuSinglePatientListDataFilter( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER, DOCUMENT_CLASS_VALUE, null, null, null, null,
                        TIU_LIST_REQUIRED_XQUERY_CRITERIA );

        Document clinicalDataDocument = readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, getTiuListReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER );
        

        List<Element> resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( XPATH_IDENTIFIERS );
        assertNotNull( resultsResolvedIdentifiersList );
        assertTrue( resultsResolvedIdentifiersList.size() == assigningFacilityAndPatientIdentityMap.size() );

        // TIU List read filter with documentType
        filterXml = createTiuSinglePatientListDataFilter( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER, null, DOCUMENT_TYPE_VALUES, null, null, null,
                        TIU_LIST_REQUIRED_XQUERY_CRITERIA );

        clinicalDataDocument = readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, getTiuListReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER );

        resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( XPATH_IDENTIFIERS );
        assertNotNull( resultsResolvedIdentifiersList );
        assertTrue( resultsResolvedIdentifiersList.size() == assigningFacilityAndPatientIdentityMap.size() );

        // TIU List read filter with documentType and date
        filterXml = createTiuSinglePatientListDataFilter( assigningFacilityAndPatientIdentityMap, ASSIGNINGAUTHORITY,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER, null, DOCUMENT_TYPE_VALUES, "1996-11-08", "1996-11-08", null,
                        TIU_LIST_REQUIRED_XQUERY_CRITERIA );

        clinicalDataDocument = readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, getTiuListReadTemplateID(), filterXml,
                        TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER );

        assertEquals( 3, clinicalDataDocument.selectNodes( XPATH_CLINICALDOCUMENTEVENTS ).size() );
        resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( XPATH_IDENTIFIERS );
        assertNotNull( resultsResolvedIdentifiersList );
        assertTrue( resultsResolvedIdentifiersList.size() == assigningFacilityAndPatientIdentityMap.size() );
    }


    @SuppressWarnings( "unused" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testHdrVistaTiuReadWithNationalId( )
        throws Exception
    {
        String templateIds[] = { TemplateIdHelper.TIU_DOCUMENT_LIST_READ };
        for ( int ii = 0; ii < templateIds.length; ii++ )
        {
            String nationalId = "1008523096V381537";

            String readTemplateId = templateIds[ii];
            String requestId = TemplateIdHelper.getUniqueIdentifier();
            String filterId = TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER;

            Map<String, String> entryPointTiuFilterMap = new HashMap<String, String>();
            entryPointTiuFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ClinicalDocumentEvent" );
            entryPointTiuFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "TIUQueryName" );

            List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
            entryPointFilterMaps.add( entryPointTiuFilterMap );

            String filterXml = createTiuSinglePatientListDataFilter( null, ASSIGNINGAUTHORITY, TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER,
                            null, DOCUMENT_TYPE_VALUES, null, null, nationalId, TIU_LIST_REQUIRED_XQUERY_CRITERIA );

            Document clinicalDataDocument = requestProcessor.readClinicalData( readTemplateId, filterXml, filterId, requestId );
            String xml = clinicalDataDocument.asXML();
            assertNotNull( clinicalDataDocument );
            //TODO add more asserts here ...
        }
    }


    @SuppressWarnings( "unchecked" )
    protected Document readAndAssertDomainData( Map<String, String> assigningFacilityAndPatientIdentityMap, String templateId, String filter,
                    String filterId )
        throws Exception
    {
        requestProcessor.setValidateReadResponseXML( true );

        Document clinicalDataDocument = requestProcessor.readClinicalData( templateId, filter, filterId, new UniqueIdentifier().toString() );
        assertNotNull( clinicalDataDocument );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 0 );

        // Check for domain entry point elements
        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() > 0 );
      
        // Assert that the resolved identifier assigning facility values from the filter are in the result document
        List<Element> resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( XPATH_IDENTIFIERS );
        for ( Element resultsResolvedIdentifiers : resultsResolvedIdentifiersList )
        {
            String mapAssigningFacility = resultsResolvedIdentifiers.element( "assigningFacility" ).getText();
            assertTrue( assigningFacilityAndPatientIdentityMap.containsKey( mapAssigningFacility ) );

            String mapIdentity = assigningFacilityAndPatientIdentityMap.get( mapAssigningFacility );
            assertTrue( ( resultsResolvedIdentifiers.element( "identity" ).getText() ).equals( mapIdentity ) );
        }

        return clinicalDataDocument;
    }
}
