

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertEquals;

import gov.va.med.cds.integration.AbstractEndToEndTest;
import gov.va.med.cds.junit.runners.AfterTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


//@RunWith( SuiteAwareSpringRunner.class )
public class EndToEndReadSkinTest
    extends
        AbstractEndToEndTest
{
    private static final Log LOGGER = LogFactory.getLog( EndToEndReadImmunizationsTest.class );

    private static final String SKINTEST_ENTRY_POINT = "SkinTestProcedure";

    private static final String SKINTEST__QUERY_NAME = "ID_SK";

    protected TemplateRequestProcessor templateRequestProcessor;

    private static final String XPATH_SKINTESTPROCEDURE = "//patients/patient/skinTestProcedures/skinTestProcedure";


    @Before
    @Suite( groups = { "checkintest" } )
    public void beforeEndToEndReadHdrVistaTestClassSetUp( )
        throws Exception
    {
        templateRequestProcessor = ( TemplateRequestProcessor )getRequestProcessor();
    }


    @Test
    @Suite( groups = { "broekntest" } )
    public void testSkinTests( )
        throws Exception
    {
        String filterId = TemplateIdHelper.SKINTEST_SINGLE_PATIENT_FILTER;
        String templateId = TemplateIdHelper.SKINTEST_READ3_TEMPLATE_ID;

        String[] vistaPatient580_1 = { "USVHA", "580", "262" };
        String[] vistaPatient580_2 = { "USVHA", "580", "192" };
        String[] vistaPatient580_3 = { "USVHA", "580", "34" };
//        String[] vistaPatient578 = { "USVHA", "578", "730" };
        String[] vistaPatient578 = { "USVHA", "992", "7206744" };

        String[][] patientIdentifiers = { vistaPatient578, vistaPatient580_1, vistaPatient580_2, vistaPatient580_3 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, SKINTEST_ENTRY_POINT );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, SKINTEST__QUERY_NAME );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );
        String filterXml = FilterBuilder.buildFilterWithResolvedIdentfiers( filterId, entryPointFilterMaps, resolvedPatients,
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ) );

        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( filterXml );
        }

        templateRequestProcessor.setValidateReadResponseXML( true );
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        Document clinicalDataDocument = templateRequestProcessor.readClinicalData( templateId, filterXml, filterId, requestId );

        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( clinicalDataDocument.asXML() );
        }

        assertEquals( 5, clinicalDataDocument.selectNodes( XPATH_SKINTESTPROCEDURE ).size() );
    }
    @Override
    @AfterTestsOnce
    @Suite(groups = { "broekntest" })
    public void afterAbstractEndToEndTestsTearDown( ) throws Exception
    {
        
       
        
    }
}
