

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertEquals;
import gov.va.med.cds.integration.AbstractEndToEndTest;
import gov.va.med.cds.junit.runners.AfterTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareSpringRunner.class )
public class EndToEndReadClinicalRemindersTest
    extends
        AbstractEndToEndTest
{
    private static final Log LOGGER = LogFactory.getLog( EndToEndReadClinicalRemindersTest.class );

    private static final String DOMAIN_ENTRY_POINT = "ClinicalReminder";

    private static final String QUERY_NAME = "ID_CLINICAL_REMINDER";

    protected TemplateRequestProcessor templateRequestProcessor;

    private static final String XPATH_CLINICALREMINDERS = "//patients/patient/clinicalReminders/clinicalReminder";


    @Before
    @Suite( groups = { "brokentest" } )
    public void beforeEndToEndReadClinicalRemindersTestClassSetUp( )
        throws Exception
    {
        templateRequestProcessor = ( TemplateRequestProcessor )getRequestProcessor();
    }


    @Test
    @Suite( groups = { "brokentest" } )
    public void testClinicalReminders( )
        throws Exception
    {
        String filterId = TemplateIdHelper.CLINICALREMINDER_SINGLE_PATIENT_FILTER;
        String templateId = TemplateIdHelper.CLINICALREMINDERS_READ_TEMPLATE_ID;
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String[] vistaPatient100848 = { "USVHA", "654", "100848" };
        //String[] vistaPatient580 = { "USVHA", "580", "84" };
        String[][] patientIdentifiers = { vistaPatient100848 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );
        String status = "DUE NOW";
        String token = "1";

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, DOMAIN_ENTRY_POINT );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, QUERY_NAME );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );

        String filterXml = FilterBuilder.buildClinicalRemindersFilterElementWithResolvedIdentfiers( filterId, entryPointFilterMaps, resolvedPatients,
                        null, null, clientRequestInitiationTime, status, token ).asXML();

        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( filterXml );
        }

        templateRequestProcessor.setValidateReadResponseXML( true );
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        Document clinicalDataDocument = templateRequestProcessor.readClinicalData( templateId, filterXml, filterId, requestId );

        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( clinicalDataDocument.asXML() );
        }

        assertEquals( 14, clinicalDataDocument.selectNodes( XPATH_CLINICALREMINDERS ).size() );
    }
    @Override
    @AfterTestsOnce
    @Suite(groups = { "brokentest" })
    public void afterAbstractEndToEndTestsTearDown( ) throws Exception
    {
        
    }
}
