

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.integration.AbstractEndToEndTest;
import gov.va.med.cds.junit.runners.AfterTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.RequestProcessorInterface;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;

import org.dom4j.Document;
import org.dom4j.Element;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;


@RunWith( SuiteAwareSpringRunner.class )
public class EndToEndReadAppointmentLetterTest
    extends
        AbstractEndToEndTest
{
    private static final String XPATH_APPOINTMENTLETTER = "/appointmentLetter:AppointmentLetter/patients/patient/appointmentLetters/appointmentLetter";
    private static final String XPATH_ERRORSECTION = "//errorSection";
    private static final String XPATH_ERRORSECTION_WARNING = "/appointmentLetter:AppointmentLetter/errorSection/warnings/warning";
    private static final String XPATH_ERRORSECTION_WARNING_ERRORCODE = "/appointmentLetter:AppointmentLetter/errorSection/warnings/warning/errorCode";
    @SuppressWarnings( "unused" )
    private static final String XPATH_ERRORSECTION_ERROR = "/appointmentLetter:AppointmentLetter/errorSection/errors/error";
    private static final String XPATH_ERRORSECTION_ERROR_ERRORCODE = "/appointmentLetter:AppointmentLetter/errorSection/errors/error/errorCode";
    private static final String XPATH_ERRORSECTION_FATALERROR = "/appointmentLetter:AppointmentLetter/errorSection/fatalErrors/fatalError";
    private static final String XPATH_ERRORSECTION_FATALERROR_ERRORCODE = "/appointmentLetter:AppointmentLetter/errorSection/fatalErrors/fatalError/errorCode";
    @SuppressWarnings( "unused" )
    private static final String XPATH_ERRORSECTION_WARNING_DISPLAYMSG = "/appointmentLetter:AppointmentLetter/errorSection/warnings/warning/displayMessage";
    private static final String XPATH_ERRORSECTION_FATALERROR_DISPLAYMSG = "/appointmentLetter:AppointmentLetter/errorSection/fatalErrors/fatalError/displayMessage";

    private static final String ASSIGNING_AUTHORITY_VISTA = "USVHA";
    private static final String ASSIGNING_FACILITY_VISTA_578 = "578";
    private static final String PATIENT_IDENTITY_VISTA = "3";
    private static final String ASSIGNING_FACILITY_VISTA_580 = "580";

    @Resource
    private RequestProcessorInterface rpcRequestProcessor = null;
    protected TemplateRequestProcessor templateRequestProcessor;


    @Before
    @Suite( groups = { "checkintest" } )
    public void beforeEndToEndReadVrmTestClassSetUp( )
        throws Exception
    {
        templateRequestProcessor = ( TemplateRequestProcessor )getRpcRequestProcessor();
    }


    protected RequestProcessorInterface getRpcRequestProcessor( )
    {
        return rpcRequestProcessor;
    }


    //@Test
    @Suite( groups = { "checkintest" } )
    public void testAppointmentLetterRead_SingleSite( )
    {
        String clientRequestInitiationTime = "2015-05-05T12:00:00Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient578 = { ASSIGNING_AUTHORITY_VISTA, "654", PATIENT_IDENTITY_VISTA };
        String[][] patientIdentifiers = { vistaPatient578 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "AppointmentLetter" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "AppointmentLetter-Standard" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter
        //TODO - every year we need a new Appointment created one year in the future - it is a limit the scheduler has - "2017-07-07T09:00:00" - we will need one for "2018-07-07T09:00:00" created in July of 2018
        String filterXml = FilterBuilder.buildAppointmentsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.APPOINTMENT_LETTER_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, "2017-07-07T09:00:00",
                        null, clientRequestInitiationTime ).asXML();
        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.APPOINTMENTLETTER1,
                        TemplateIdHelper.APPOINTMENT_LETTER_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );
        List<Element> elementList = dataDocument.selectNodes( XPATH_APPOINTMENTLETTER );
        assertTrue( elementList.size() == 1 );
    }


    //@Test
    //@Suite( groups = { "checkintest" } )
    public void testAppointmentLetterRead_NoDataFound( )
    {
        String clientRequestInitiationTime = "2015-05-05T12:00:00Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient578 = { ASSIGNING_AUTHORITY_VISTA, "654", PATIENT_IDENTITY_VISTA };
        String[][] patientIdentifiers = { vistaPatient578 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "AppointmentLetter" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "AppointmentLetter-Standard" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter with appointment date other than 
        String filterXml = FilterBuilder.buildAppointmentsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.APPOINTMENT_LETTER_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, "2016-07-08T09:00:00",
                        null, clientRequestInitiationTime ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.APPOINTMENTLETTER1,
                        TemplateIdHelper.APPOINTMENT_LETTER_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_ERRORSECTION_FATALERROR );
        assertTrue( elementList.size() == 1 );
    }


    private Document readAndAssertDomainData( String demographicsReadTemplateId, String demographicsSinglePatientFilter, String requestId,
                    String filterXml, List<Map<String, String>> resolvedPatients )
    {
        templateRequestProcessor.setValidateReadResponseXML( true );
        Document dataDocument = templateRequestProcessor.readClinicalData( demographicsReadTemplateId, filterXml, demographicsSinglePatientFilter,
                        requestId );
        assertNotNull( dataDocument );

        return dataDocument;
    }
    @Override
    @AfterTestsOnce
    @Suite(groups = { "brokentest" })
    public void afterAbstractEndToEndTestsTearDown( ) throws Exception
    {
        
    }
}
