//
//
//package gov.va.med.cds.integration.vhim400;
//
//
//import static org.junit.Assert.assertNotNull;
//import static org.junit.Assert.assertTrue;
//import gov.va.med.cds.integration.AbstractEndToEndTest;
//import gov.va.med.cds.junit.runners.Suite;
//import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
//import gov.va.med.cds.request.TemplateRequestProcessor;
//import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
//import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;
//import gov.va.med.cds.testharness.xml.Assert;
//import gov.va.med.cds.util.QueryCacheManager;
//
//import java.util.ArrayList;
//import java.util.Date;
//import java.util.HashMap;
//import java.util.Iterator;
//import java.util.List;
//import java.util.Map;
//import java.util.TreeMap;
//
//import org.apache.commons.lang3.time.DateFormatUtils;
//import org.dom4j.Document;
//import org.dom4j.Element;
//import org.dom4j.Node;
//import org.dom4j.tree.DefaultElement;
//import org.junit.Before;
//import org.junit.Ignore;
//import org.junit.Test;
//import org.junit.runner.RunWith;
//import org.springframework.test.context.ContextConfiguration;
//
//
//@RunWith( SuiteAwareSpringRunner.class )
//@ContextConfiguration( locations = { "classpath:gov/va/med/cds/config/nonWeblogicFailingVistADataSourcesContext.xml" } )
//public class EndToEndQueryCacheTest extends AbstractEndToEndTest
//{
//    private static final String PATIENT_IDENTITY_1 = "1";
//    private static final String PATIENT_IDENTITY_2 = "2";
//    private static final String ASSIGNING_FACILITY_VISTA_578 = "578";
//    private static final String ASSIGNING_FACILITY_VISTA_580 = "580";
//    private static final String ASSIGNING_AUTHORITY_VISTA = "USVHA";
//
//    private static final String ASSIGNING_AUTHORITY_ELEMENT_NAME = "assigningAuthority";
//    private static final String ASSIGNING_FACILITY_ELEMENT_NAME = "assigningFacility";
//    private static final String PATIENT_IDENTITY_ELEMENT_NAME = "identity";
//
//    protected static final String XPATH_PATIENT_40011 = "//clinicaldata:ClinicalData/patient";/// "//patients/patient"; (normal value)     clinicaldata:ClinicalData/patient (true xpath)
//    protected static final String XPATH_RESOLVED_IDENTIFIERS_40011 = "//clinicaldata:ClinicalData/patient/requestedResolvedIdentifiers"; // "//requestedResolvedIdentifiers/requestedResolvedIdentifier"; (normal value)  clinicaldata:ClinicalData/patient/requestedResolvedIdentifiers (true xpath)
//    
//    private TemplateRequestProcessor templateRequestProcessor;
//
//    @Before
//    @Suite( groups = { "checkintest" } )
//    public void beforeEndToEndReadLabTestClassSetUp( )
//        throws Exception
//    {
//        templateRequestProcessor = ( TemplateRequestProcessor )getRequestProcessor();
//    }
//
//    
//    @Test
//    @Ignore
//    @Suite( groups = { "checkintest"})
//    public void testMHVLabRead40011ResultsSame() throws Exception
//    {
//    	testLabResultsSame(TemplateIdHelper.MHV_LAB_READ_TEMPLATE_ID);
//    }
//
//    @Test
//    @Ignore
//    @Suite( groups = { "checkintest"})
//    public void testMHVLabChemHemRead1ResultsSame() throws Exception
//    {
//    	testLabResultsSame(TemplateIdHelper.MHV_LAB_CHEM_HEM_READ_TEMPLATE_ID);
//    }
//
//    @Test
//    @Ignore
//    @Suite( groups = { "brokentest"})
//    public void testLabChemHemRead1ResultsSame() throws Exception
//    {
//    	testLabResultsSame(TemplateIdHelper.LAB_CHEM_HEM_READ_TEMPLATE_ID);
//    }
//    
//    
//    /**
//     * checks the results returned for the given template id to ensure that results are the same whether they
//     * employ no caching, transitional caching, or full caching.  Transitional caching is defined as a run where some 
//     * data is populated via cached results and some data is populated by not-yet-cached data direct from the datasource.
//     * This method also includes a time element to verify that runs with caching are faster than runs with no caching.  
//     * The method's approach to checking XML values is not complete but may be considered a comprehensive spotcheck.  That is, 
//     * for every text node in one document, an equivalent text node should be found in the other document. This approach is 
//     * not perfect, but it does take into account the fact that the results will be assembled asynchronously from different 
//     * datasources and that the order of results cannot be assumed to be the same.  
//     *   
//     * @param templateId
//     * @throws Exception
//     */
//	protected void testLabResultsSame(String templateId) throws Exception 
//	{
//		QueryCacheManager.getInstance().setEnabled(false);
//		long starTimeNoCaching = System.currentTimeMillis();
//    	Document docNoCaching = testLabRead(templateId, true,null,null);
//    	long endTimeNoCaching = System.currentTimeMillis();
//		long timeNoCaching = endTimeNoCaching - starTimeNoCaching;
//		
//    	QueryCacheManager.getInstance().setEnabled(true);
//    	Document docTransitionalCaching = testLabRead(templateId, true,null,null);
//    	
//		/// test time against a fully populated cache
//		long startTimeFullCaching = System.currentTimeMillis();
//		QueryCacheManager.getInstance().setEnabled(true);
//		Document docFullCaching =testLabRead(templateId, true, null, null);
//		long endTimeFullCaching = System.currentTimeMillis();
//		long timeFullCaching = endTimeFullCaching - startTimeFullCaching;
//		assertTrue("The Lab Read should be faster with full caching than without", timeFullCaching < timeNoCaching);
//    	
//    	
//		Map<String, List<String>> pathValuesNoCaching = getDistinctPathValues(docNoCaching);
//    	Map<String, List<String>> pathValuesTransitionalCaching = getDistinctPathValues(docTransitionalCaching);
//    	Map<String, List<String>> pathValuesFullCaching = getDistinctPathValues(docFullCaching);
//    	
//    	/// no cache results should be in the transitional caching results
//    	for ( String path: pathValuesNoCaching.keySet())
//    	{
//    		assertTrue("The path '" + path + "' found in the results with no caching was not found in the path with transitional caching.", pathValuesTransitionalCaching.containsKey(path));    	
//    		for ( String value: pathValuesNoCaching.get(path))
//    		{
//    			boolean result = pathValuesTransitionalCaching.get(path).contains(value); 
//    			assertTrue("The value '"+value+"' in the path '"+path+"' was not found in the path with transitional caching", result);
//    		}
//    	}
//    	
//    	/// transitional cache results should all be found in the no caching results
//    	for ( String path: pathValuesTransitionalCaching.keySet())
//    	{
//    		assertTrue("The path '" + path + "' found in the transitional caching results was not found in the path with no caching.", pathValuesNoCaching.containsKey(path));    	
//    		for ( String value: pathValuesTransitionalCaching.get(path))
//    		{
//    			boolean result = pathValuesNoCaching.get(path).contains(value); 
//    			assertTrue("The value '' in the path '' was not found in the path with no caching", result);
//    		}
//    	}
//
//    	/// no cache results should be in the full caching results
//    	for ( String path: pathValuesNoCaching.keySet())
//    	{
//    		assertTrue("The path '" + path + "' found in the results with no caching was not found in the path with full caching.", pathValuesFullCaching.containsKey(path));    	
//    		for ( String value: pathValuesNoCaching.get(path))
//    		{
//    			boolean result = pathValuesFullCaching.get(path).contains(value); 
//    			assertTrue("The value '"+value+"' in the path '"+path+"' was not found in the path with full caching", result);
//    		}
//    	}
//
//    	/// full cache results should be in the no caching results
//    	for ( String path: pathValuesFullCaching.keySet())
//    	{
//    		assertTrue("The path '" + path + "' found in the results with full caching was not found in the path with no caching.", pathValuesNoCaching.containsKey(path));    	
//    		for ( String value: pathValuesFullCaching.get(path))
//    		{
//    			boolean result = pathValuesNoCaching.get(path).contains(value); 
//    			assertTrue("The value '"+value+"' in the path '"+path+"' was not found in the path with no caching", result);
//    		}
//    	}
//    	
//	}
//	/**
//	 * traverses an xml document and assembled a list of paths that contain text node values. 
//	 * 
//	 * @param doc
//	 * @return
//	 */
//	protected Map<String,List<String>> getDistinctPathValues(Document doc)
//    {
//    	DefaultElement de = (DefaultElement)doc.nodeIterator().next();
//    	
//    	TreeMap<String,List<String>> distinctPathValues = new TreeMap<String, List<String>>();
//    	for ( Object oe: de.elements())
//    	{
//    		Element element = (Element)oe;
//    		getDistinctPathNameValues(distinctPathValues, element);
//    	}
//    	return distinctPathValues;
//    }
//	
//	
//	/** builds up a list of pathname keys with the associated list of values associated with the given path.
//	 *  This method recursively calls itself with the children of the element argument
//	 * 
//	 * @param distinctPathValues
//	 * @param element
//	 */
//	protected void getDistinctPathNameValues(TreeMap<String,List<String>> distinctPathValues, Element element) 
//	{
//		for (Object o : element.elements()) 
//		{
//			if (o instanceof Element) 
//			{
//				Element e = ((Element) o);
//				String path = e.getPath();
//				if (distinctPathValues.containsKey(path)) 
//				{
//					List<String> values = distinctPathValues.get(path);
//					String text = getTextNodeValueForElement(e);
//					if ( text!=null )
//					{
//						if ( !values.contains(text))	values.add(text);						
//					}					
//				}
//				else
//				{
//					List<String> values = new ArrayList<String>();
//					String text = getTextNodeValueForElement(e);
//					if ( text!=null )
//					{
//						values.add(text);	
//						distinctPathValues.put(path, values);	/// only put values in where the text node is not null
//					}									
//				}
//				getDistinctPathNameValues(distinctPathValues, e);  //recursively call this method 
//			}
//		}
//
//	}    
//	
//    /**
//     * returns the Text Node value for the given Element
//     * 
//     * @param e the element to be checked
//     * @return the value of the text node, null if the Element has no text node
//     */
//	@SuppressWarnings("unchecked")
//	protected String getTextNodeValueForElement(Element e) 
//	{
//		if (e == null)	return null;
//		Iterator<Node> nodes = e.nodeIterator();
//		while (nodes.hasNext()) 
//		{
//			Node node = nodes.next();
//			if (node.getNodeType() == org.dom4j.Node.TEXT_NODE) 
//			{
//				return node.getText();
//			}
//		}
//		return null;
//	}
//    
//    
//     
//    protected Document testLabRead( String readTemplateId, boolean includeDates, String startDate, String endDate )
//            throws Exception
//        {
//            String filterId = TemplateIdHelper.LAB_SINGLE_PATIENT_ALL_DATA_FILTER;
//            String requestId = TemplateIdHelper.getUniqueIdentifier();
//
//            String[] vistaPatient578 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_578, PATIENT_IDENTITY_1 };
//            String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_2 };
//
//            String[][] patientIdentifiers = { vistaPatient578, vistaPatient580 };
//
//            List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );
//
//            Map<String, String> entryPointFilterMap = new HashMap<String, String>();
//            entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "LabTestPromise" );
//            entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "testQueryName" );
//            if ( includeDates )
//            {
//                entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, ( startDate != null ) ? startDate : "1998-01-01" );
//                entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, ( endDate != null ) ? endDate : "1998-12-31" );
//            }
//
//            List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
//            entryPointFilterMaps.add( entryPointFilterMap );
//
//            return readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
//        }
//
//    
//    
//
//    @SuppressWarnings( "unchecked" )
//    private Document readAndAssertDomainData( String templateId, String filterId, String requestId, List<Map<String, String>> entryPointFilterMaps,
//                    List<Map<String, String>> resolvedPatients ) 
//        throws Exception
//    {
//        String filterXml = FilterBuilder.buildFilterWithResolvedIdentfiers( filterId, entryPointFilterMaps, resolvedPatients,
//                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ) ); 
//
//        templateRequestProcessor.setValidateReadResponseXML( false );
//        Document clinicalDataDocument = templateRequestProcessor.readClinicalData( templateId, filterXml, filterId, requestId );
//        assertNotNull( clinicalDataDocument );
//
//        String clinicalDataXml = clinicalDataDocument.asXML();
//        Assert.assertXmlValidation( clinicalDataXml, templateId );
//
//        String xpathPatient = XPATH_PATIENT;
//        String xpathResolvedIdentifiers = XPATH_RESOLVED_IDENTIFIERS;
//
//        if ( templateId.equals( TemplateIdHelper.MHV_LAB_READ_TEMPLATE_ID ) )
//        {
//            xpathPatient = XPATH_PATIENT_40011;
//            xpathResolvedIdentifiers = XPATH_RESOLVED_IDENTIFIERS_40011;
//        }
//
//        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
//        assertTrue( errorSections.size() == 0 );
//
//        // Check for domain entry point elements
//        List<Element> domainElements = clinicalDataDocument.selectNodes( xpathPatient );
//        assertTrue( domainElements.size() > 0 );
//
//        // Assert that the resolved identifier assigning facility values from the filter are in the result document
//        List<Element> resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( xpathResolvedIdentifiers );
//        assertTrue( resultsResolvedIdentifiersList.size() == resolvedPatients.size() );
//        for ( Element resultsResolvedIdentifiers : resultsResolvedIdentifiersList )
//        {
//            String resultsAssigningAuthority = resultsResolvedIdentifiers.element( ASSIGNING_AUTHORITY_ELEMENT_NAME ).getText();
//            String resultsAssigningFacility = resultsResolvedIdentifiers.element( ASSIGNING_FACILITY_ELEMENT_NAME ).getText();
//            String resultsPatientIdentity = resultsResolvedIdentifiers.element( PATIENT_IDENTITY_ELEMENT_NAME ).getText();
//
//            Map<String, String> assigningAuthorityFacilityAndPatientIdentityMap = null;
//            for ( Map<String, String> resolvedPatientMap : resolvedPatients )
//            {
//                String mapAssigningAuthority = resolvedPatientMap.get( FilterBuilder.ASSIGNING_AUTHORITY_KEY );
//                String mapAssigningFacility = resolvedPatientMap.get( FilterBuilder.ASSIGNING_FACILITY );
//                String mapIdentity = resolvedPatientMap.get( FilterBuilder.IDENTITY );
//                if ( mapAssigningAuthority != null && mapAssigningAuthority.equalsIgnoreCase( resultsAssigningAuthority )
//                                && mapAssigningFacility != null && mapAssigningFacility.equalsIgnoreCase( resultsAssigningFacility ) 
//                                && mapIdentity != null && mapIdentity.equalsIgnoreCase( resultsPatientIdentity ) )
//                {
//                    assigningAuthorityFacilityAndPatientIdentityMap = resolvedPatientMap;
//                    break;
//                }
//            }
//
//            assertNotNull( assigningAuthorityFacilityAndPatientIdentityMap );
//            String mapPatientIdentity = assigningAuthorityFacilityAndPatientIdentityMap.get( FilterBuilder.IDENTITY );
//            assertNotNull( mapPatientIdentity );
//            assertTrue( mapPatientIdentity.equals( resultsPatientIdentity ) );
//        }
//
//        return clinicalDataDocument;
//    }
//
//
//}
//    @Suite( groups = { "checkintest"})
//    public void testLabChemHemRead1ResultsSame() throws Exception
//    {
//    	testLabResultsSame(TemplateIdHelper.LAB_CHEM_HEM_READ_TEMPLATE_ID);
//    }
//    
//    
//    /**
//     * checks the results returned for the given template id to ensure that results are the same whether they
//     * employ no caching, transitional caching, or full caching.  Transitional caching is defined as a run where some 
//     * data is populated via cached results and some data is populated by not-yet-cached data direct from the datasource.
//     * This method also includes a time element to verify that runs with caching are faster than runs with no caching.  
//     * The method's approach to checking XML values is not complete but may be considered a comprehensive spotcheck.  That is, 
//     * for every text node in one document, an equivalent text node should be found in the other document. This approach is 
//     * not perfect, but it does take into account the fact that the results will be assembled asynchronously from different 
//     * datasources and that the order of results cannot be assumed to be the same.  
//     *   
//     * @param templateId
//     * @throws Exception
//     */
//	protected void testLabResultsSame(String templateId) throws Exception 
//	{
//		QueryCacheManager.getInstance().setEnabled(false);
//		long starTimeNoCaching = System.currentTimeMillis();
//    	Document docNoCaching = testLabRead(templateId, true,null,null);
//    	long endTimeNoCaching = System.currentTimeMillis();
//		long timeNoCaching = endTimeNoCaching - starTimeNoCaching;
//		
//    	QueryCacheManager.getInstance().setEnabled(true);
//    	Document docTransitionalCaching = testLabRead(templateId, true,null,null);
//    	
//		/// test time against a fully populated cache
//		long startTimeFullCaching = System.currentTimeMillis();
//		QueryCacheManager.getInstance().setEnabled(true);
//		Document docFullCaching =testLabRead(templateId, true, null, null);
//		long endTimeFullCaching = System.currentTimeMillis();
//		long timeFullCaching = endTimeFullCaching - startTimeFullCaching;
//		assertTrue("The Lab Read should be faster with full caching than without", timeFullCaching < timeNoCaching);
//    	
//    	
//		Map<String, List<String>> pathValuesNoCaching = getDistinctPathValues(docNoCaching);
//    	Map<String, List<String>> pathValuesTransitionalCaching = getDistinctPathValues(docTransitionalCaching);
//    	Map<String, List<String>> pathValuesFullCaching = getDistinctPathValues(docFullCaching);
//    	
//    	/// no cache results should be in the transitional caching results
//    	for ( String path: pathValuesNoCaching.keySet())
//    	{
//    		assertTrue("The path '" + path + "' found in the results with no caching was not found in the path with transitional caching.", pathValuesTransitionalCaching.containsKey(path));    	
//    		for ( String value: pathValuesNoCaching.get(path))
//    		{
//    			boolean result = pathValuesTransitionalCaching.get(path).contains(value); 
//    			assertTrue("The value '"+value+"' in the path '"+path+"' was not found in the path with transitional caching", result);
//    		}
//    	}
//    	
//    	/// transitional cache results should all be found in the no caching results
//    	for ( String path: pathValuesTransitionalCaching.keySet())
//    	{
//    		assertTrue("The path '" + path + "' found in the transitional caching results was not found in the path with no caching.", pathValuesNoCaching.containsKey(path));    	
//    		for ( String value: pathValuesTransitionalCaching.get(path))
//    		{
//    			if ( path==null || path.trim().equals("") || value==null || value.trim().equals("")) continue;
//    			boolean result = pathValuesNoCaching.get(path).contains(value); 
//    			assertTrue("The value '"+value+"' in the path '"+path+"' was not found in the path with no caching", result);
//    		}
//    	}
//
//    	/// no cache results should be in the full caching results
//    	for ( String path: pathValuesNoCaching.keySet())
//    	{
//    		assertTrue("The path '" + path + "' found in the results with no caching was not found in the path with full caching.", pathValuesFullCaching.containsKey(path));    	
//    		for ( String value: pathValuesNoCaching.get(path))
//    		{
//    			if ( path==null || path.trim().equals("") || value==null || value.trim().equals("")) continue;
//    			boolean result = pathValuesFullCaching.get(path).contains(value); 
//    			assertTrue("The value '"+value+"' in the path '"+path+"' was not found in the path with full caching", result);
//    		}
//    	}
//
//    	/// full cache results should be in the no caching results
//    	for ( String path: pathValuesFullCaching.keySet())
//    	{
//    		assertTrue("The path '" + path + "' found in the results with full caching was not found in the path with no caching.", pathValuesNoCaching.containsKey(path));    	
//    		for ( String value: pathValuesFullCaching.get(path))
//    		{
//    			if ( path==null || path.trim().equals("") || value==null || value.trim().equals("")) continue;
//    			boolean result = pathValuesNoCaching.get(path).contains(value); 
//    			assertTrue("The value '"+value+"' in the path '"+path+"' was not found in the path with no caching", result);
//    		}
//    	}
//    	
//	}
//
///*	@Test
//	public void testLabChemHemRead1Results() throws Exception 
//	{
//		Document docCaching = testLabChemHemRead(TemplateIdHelper.LAB_CHEM_HEM_READ_TEMPLATE_ID, false,null,null);
//    	Map<String, List<String>> pathValues = getDistinctPathValues(docCaching);
//
//    	/// full cache results should be in the no caching results
//    	for ( String path: pathValues.keySet())
//    	{
//    		String shortenedPath = path.substring(path.lastIndexOf("/")+1);
////    		String exValue = pathValues.get(path);
//    		
//    		
//    		
//    		System.out.println(path +","+shortenedPath+ ",\"" + pathValues.get(path) + "\"");    		
//    	}    	
//	}
//	
//	protected Document testLabChemHemRead( String readTemplateId, boolean includeDates, String startDate, String endDate )
//            throws Exception
//        {
//            String filterId = TemplateIdHelper.LAB_SINGLE_PATIENT_ALL_DATA_FILTER;
//            String requestId = TemplateIdHelper.getUniqueIdentifier();
//
//            String[] vistaPatient578 = { ASSIGNING_AUTHORITY_VISTA, "578", "1" };
//            String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, "613", "11" };
//
//            String[][] patientIdentifiers = { vistaPatient578, vistaPatient580 };
//
//            List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );
//
//            Map<String, String> entryPointFilterMap = new HashMap<String, String>();
//            entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "LabTestPromise" );
//            entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "testQueryName" );
//            if ( includeDates )
//            {
//                entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, ( startDate != null ) ? startDate : "1998-01-01" );
//                entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, ( endDate != null ) ? endDate : "1998-12-31" );
//            }
//
//            List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
//            entryPointFilterMaps.add( entryPointFilterMap );
//
//            return readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
//        }
//*/	
//	
//	
//	
//	/**
//	 * traverses an xml document and assembled a list of paths that contain text node values. 
//	 * 
//	 * @param doc
//	 * @return
//	 */
//	protected Map<String,List<String>> getDistinctPathValues(Document doc)
//    {
//    	DefaultElement de = (DefaultElement)doc.nodeIterator().next();
//    	
//    	TreeMap<String,List<String>> distinctPathValues = new TreeMap<String, List<String>>();
//    	for ( Object oe: de.elements())
//    	{
//    		Element element = (Element)oe;
//    		getDistinctPathNameValues(distinctPathValues, element);
//    	}
//    	return distinctPathValues;
//    }
//	
//	
//	/** builds up a list of pathname keys with the associated list of values associated with the given path.
//	 *  This method recursively calls itself with the children of the element argument
//	 * 
//	 * @param distinctPathValues
//	 * @param element
//	 */
//	protected void getDistinctPathNameValues(TreeMap<String,List<String>> distinctPathValues, Element element) 
//	{
//		for (Object o : element.elements()) 
//		{
//			if (o instanceof Element) 
//			{
//				Element e = ((Element) o);
//				String path = e.getPath();
//				if (distinctPathValues.containsKey(path)) 
//				{
//					List<String> values = distinctPathValues.get(path);
//					String text = getTextNodeValueForElement(e);
//					if ( text!=null )
//					{
//						if ( !values.contains(text))	values.add(text);						
//					}					
//				}
//				else
//				{
//					List<String> values = new ArrayList<String>();
//					String text = getTextNodeValueForElement(e);
//					if ( text!=null )
//					{
//						values.add(text);	
//						distinctPathValues.put(path, values);	/// only put values in where the text node is not null
//					}									
//				}
//				getDistinctPathNameValues(distinctPathValues, e);  //recursively call this method 
//			}
//		}
//
//	}    
//	
//    /**
//     * returns the Text Node value for the given Element
//     * 
//     * @param e the element to be checked
//     * @return the value of the text node, null if the Element has no text node
//     */
//	@SuppressWarnings("unchecked")
//	protected String getTextNodeValueForElement(Element e) 
//	{
//		if (e == null)	return null;
//		Iterator<Node> nodes = e.nodeIterator();
//		while (nodes.hasNext()) 
//		{
//			Node node = nodes.next();
//			if (node.getNodeType() == org.dom4j.Node.TEXT_NODE) 
//			{
//				return node.getText();
//			}
//		}
//		return null;
//	}
//    
//    
//     
//    protected Document testLabRead( String readTemplateId, boolean includeDates, String startDate, String endDate )
//            throws Exception
//        {
//            String filterId = TemplateIdHelper.LAB_SINGLE_PATIENT_ALL_DATA_FILTER;
//            String requestId = TemplateIdHelper.getUniqueIdentifier();
//
//            String[] vistaPatient578 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_578, PATIENT_IDENTITY_1 };
//            String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_2 };
//
//            String[][] patientIdentifiers = { vistaPatient578, vistaPatient580 };
//
//            List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );
//
//            Map<String, String> entryPointFilterMap = new HashMap<String, String>();
//            entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "LabTestPromise" );
//            entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "testQueryName" );
//            if ( includeDates )
//            {
//                entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, ( startDate != null ) ? startDate : "1998-01-01" );
//                entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, ( endDate != null ) ? endDate : "1998-12-31" );
//            }
//
//            List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
//            entryPointFilterMaps.add( entryPointFilterMap );
//
//            return readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
//        }
//
//    
//    
//
//    @SuppressWarnings( "unchecked" )
//    private Document readAndAssertDomainData( String templateId, String filterId, String requestId, List<Map<String, String>> entryPointFilterMaps,
//                    List<Map<String, String>> resolvedPatients ) 
//        throws Exception
//    {
//        String filterXml = FilterBuilder.buildFilterWithResolvedIdentfiers( filterId, entryPointFilterMaps, resolvedPatients,
//                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ) ); 
//
//        templateRequestProcessor.setValidateReadResponseXML( false );
//        Document clinicalDataDocument = templateRequestProcessor.readClinicalData( templateId, filterXml, filterId, requestId );
//        assertNotNull( clinicalDataDocument );
//
//        String clinicalDataXml = clinicalDataDocument.asXML();
//        Assert.assertXmlValidation( clinicalDataXml, templateId );
//
//        String xpathPatient = XPATH_PATIENT;
//        String xpathResolvedIdentifiers = XPATH_RESOLVED_IDENTIFIERS;
//
//        if ( templateId.equals( TemplateIdHelper.MHV_LAB_READ_TEMPLATE_ID ) )
//        {
//            xpathPatient = XPATH_PATIENT_40011;
//            xpathResolvedIdentifiers = XPATH_RESOLVED_IDENTIFIERS_40011;
//        }
//
//        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
//        assertTrue( errorSections.size() == 0 );
//
//        // Check for domain entry point elements
//        List<Element> domainElements = clinicalDataDocument.selectNodes( xpathPatient );
//        assertTrue( domainElements.size() > 0 );
//
//        // Assert that the resolved identifier assigning facility values from the filter are in the result document
//        List<Element> resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( xpathResolvedIdentifiers );
//        assertTrue( resultsResolvedIdentifiersList.size() == resolvedPatients.size() );
//        for ( Element resultsResolvedIdentifiers : resultsResolvedIdentifiersList )
//        {
//            String resultsAssigningAuthority = resultsResolvedIdentifiers.element( ASSIGNING_AUTHORITY_ELEMENT_NAME ).getText();
//            String resultsAssigningFacility = resultsResolvedIdentifiers.element( ASSIGNING_FACILITY_ELEMENT_NAME ).getText();
//            String resultsPatientIdentity = resultsResolvedIdentifiers.element( PATIENT_IDENTITY_ELEMENT_NAME ).getText();
//
//            Map<String, String> assigningAuthorityFacilityAndPatientIdentityMap = null;
//            for ( Map<String, String> resolvedPatientMap : resolvedPatients )
//            {
//                String mapAssigningAuthority = resolvedPatientMap.get( FilterBuilder.ASSIGNING_AUTHORITY_KEY );
//                String mapAssigningFacility = resolvedPatientMap.get( FilterBuilder.ASSIGNING_FACILITY );
//                String mapIdentity = resolvedPatientMap.get( FilterBuilder.IDENTITY );
//                if ( mapAssigningAuthority != null && mapAssigningAuthority.equalsIgnoreCase( resultsAssigningAuthority )
//                                && mapAssigningFacility != null && mapAssigningFacility.equalsIgnoreCase( resultsAssigningFacility ) 
//                                && mapIdentity != null && mapIdentity.equalsIgnoreCase( resultsPatientIdentity ) )
//                {
//                    assigningAuthorityFacilityAndPatientIdentityMap = resolvedPatientMap;
//                    break;
//                }
//            }
//
//            assertNotNull( assigningAuthorityFacilityAndPatientIdentityMap );
//            String mapPatientIdentity = assigningAuthorityFacilityAndPatientIdentityMap.get( FilterBuilder.IDENTITY );
//            assertNotNull( mapPatientIdentity );
//            assertTrue( mapPatientIdentity.equals( resultsPatientIdentity ) );
//        }
//
//        return clinicalDataDocument;
//    }
//
//
//}
