

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.integration.AbstractEndToEndReadAllergiesTest;
import gov.va.med.cds.junit.runners.AfterTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.uniqueidentifier.UniqueIdentifier;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.annotation.DirtiesContext.ClassMode;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


@RunWith( SuiteAwareSpringRunner.class )
//@ContextConfiguration( locations = { "classpath:gov/va/med/cds/config/nonWeblogicFailingVistADataSourcesContext.xml" } )
//@DirtiesContext(classMode=ClassMode.BEFORE_CLASS)
//@Transactional(transactionManager = "hdr2TransactionManager")
public class EndToEndPartialReadAllergiesTest
    extends
        AbstractEndToEndReadAllergiesTest
{
    //@Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testAllergyRead40010_SingleSiteFailure( )
        throws Exception
    {
        String[] vistaPatient580 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1, PATIENTIDENTITY1 };
        String[] vistaPatient503 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY_FAILURE_1, PATIENTIDENTITY_FAILURE_1 };
        String[][] patientIdentifiers = { vistaPatient580, vistaPatient503 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointMap = new HashMap<String, String>();
        entryPointMap.put( "ID_1", "AllergyAssessment" );
        entryPointMap.put( "ID_2", "IntoleranceCondition" );

        String filterXml = createAllergiesSinglePatientMulitEntryPointFilter( resolvedPatients, entryPointMap, null, null,
                        TemplateIdHelper.ALLERGY_SINGLE_PATIENT_ALL_DATA_FILTER, null );

        requestProcessor.setValidateReadResponseXML( true );
        Document clinicalDataDocument = requestProcessor.readClinicalData( getAllergiesReadTemplateID(), filterXml,
                        TemplateIdHelper.ALLERGY_SINGLE_PATIENT_ALL_DATA_FILTER, new UniqueIdentifier().toString() );
        assertNotNull( clinicalDataDocument );

        //make sure we were able to read data successfully
        List<Node> clinicalDocumentNodes = clinicalDataDocument.selectNodes( getIntoleranceConditionsEntryPointXpath() );
        Assert.assertTrue( clinicalDocumentNodes.size() > 0 );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

        //make sure we reported one  READ_REQUEST_DATA_SOURCE_FAILURE successfully as a warning
        List<Node> warningNodes = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION_WARNING );
        Assert.assertTrue( warningNodes.size() == 2 );
        Node errorCodeNode = clinicalDataDocument.selectSingleNode( XPATH_ERRORSECTION_WARNINGERRORCODE );
        Assert.assertTrue( errorCodeNode.getText().equals( READ_REQUEST_DATA_SOURCE_FAILURE ) );

        //verify the erroneous siteId and DFN in the error message
        Node dispalyMsgNode = clinicalDataDocument.selectSingleNode( XPATH_ERRORSECTION_DISPLAYMSG );
        Assert.assertTrue( dispalyMsgNode.getText().contains( ASSIGNINGFACILITY_FAILURE_1 ) );
        Assert.assertTrue( dispalyMsgNode.getText().contains( PATIENTIDENTITY_FAILURE_1 ) );
    }


    //@Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testAllergiesRead40010_TwoSiteFailures( )
        throws Exception
    {
        String[] vistaPatient503 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY_FAILURE_1, PATIENTIDENTITY_FAILURE_1 };
        String[] vistaPatient504 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY_FAILURE_2, PATIENTIDENTITY_FAILURE_2 };
        String[][] patientIdentifiers = { vistaPatient503, vistaPatient504 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointMap = new HashMap<String, String>();
        entryPointMap.put( "ID_1", "AllergyAssessment" );
        entryPointMap.put( "ID_2", "IntoleranceCondition" );

        String filterXml = createAllergiesSinglePatientMulitEntryPointFilter( resolvedPatients, entryPointMap, null, null,
                        TemplateIdHelper.ALLERGY_SINGLE_PATIENT_ALL_DATA_FILTER, null );

        requestProcessor.setValidateReadResponseXML( true );
        Document clinicalDataDocument = requestProcessor.readClinicalData( getAllergiesReadTemplateID(), filterXml,
                        TemplateIdHelper.ALLERGY_SINGLE_PATIENT_ALL_DATA_FILTER, new UniqueIdentifier().toString() );
        assertNotNull( clinicalDataDocument );

        //make sure there is no clinical domain data in response
        List<Node> clinicalDocumentNodes = clinicalDataDocument.selectNodes( getIntoleranceConditionsEntryPointXpath() );
        Assert.assertTrue( clinicalDocumentNodes.size() == 0 );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

        //make sure we reported one  READ_REQUEST_DATA_SOURCE_FAILURE successfully as a warning
        List<Node> warningNodes = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION_WARNING );
        Assert.assertTrue( warningNodes.size() == 4 );
        Node errorCodeNode = clinicalDataDocument.selectSingleNode( XPATH_ERRORSECTION_WARNINGERRORCODE );
        Assert.assertTrue( errorCodeNode.getText().equals( READ_REQUEST_DATA_SOURCE_FAILURE ) );

        //verify the erroneous siteId and DFN in the error message
        Node dispalyMsgNode = clinicalDataDocument.selectSingleNode( XPATH_ERRORSECTION_DISPLAYMSG );
        Assert.assertTrue( dispalyMsgNode.getText().contains( ASSIGNINGFACILITY_FAILURE_1 ) );
        Assert.assertTrue( dispalyMsgNode.getText().contains( PATIENTIDENTITY_FAILURE_1 ) );
    }


    //@Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testIntoleranceConditionRead40010_SingleSiteFailure( )
        throws Exception
    {
        String[] vistaPatient503 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY_FAILURE_1, PATIENTIDENTITY_FAILURE_1 };
        String[][] patientIdentifiers = { vistaPatient503 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointMap = new HashMap<String, String>();
        entryPointMap.put( "ID_2", "IntoleranceCondition" );

        String filterXml = createAllergiesSinglePatientMulitEntryPointFilter( resolvedPatients, entryPointMap, null, null,
                        TemplateIdHelper.IC_SINGLE_PATIENT_ALL_DATA_FILTER, null );

        requestProcessor.setValidateReadResponseXML( true );
        Document clinicalDataDocument = requestProcessor.readClinicalData( getVWIntoleranceConditionsReadTemplateID(), filterXml,
                        TemplateIdHelper.IC_SINGLE_PATIENT_ALL_DATA_FILTER, new UniqueIdentifier().toString() );
        assertNotNull( clinicalDataDocument );

        //make sure there is no clinical domain data in response
        List<Node> clinicalDocumentNodes = clinicalDataDocument.selectNodes( getIntoleranceConditionsEntryPointXpath() );
        Assert.assertTrue( clinicalDocumentNodes.size() == 0 );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

        //make sure we reported one  READ_REQUEST_DATA_SOURCE_FAILURE successfully as a warning
        List<Node> warningNodes = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION_WARNING );
        Assert.assertTrue( warningNodes.size() == 1 );
        Node errorCodeNode = clinicalDataDocument.selectSingleNode( XPATH_ERRORSECTION_WARNINGERRORCODE );
        Assert.assertTrue( errorCodeNode.getText().equals( READ_REQUEST_DATA_SOURCE_FAILURE ) );

        //verify the erroneous siteId and DFN in the error message
        Node dispalyMsgNode = clinicalDataDocument.selectSingleNode( XPATH_ERRORSECTION_DISPLAYMSG );
        Assert.assertTrue( dispalyMsgNode.getText().contains( ASSIGNINGFACILITY_FAILURE_1 ) );
        Assert.assertTrue( dispalyMsgNode.getText().contains( PATIENTIDENTITY_FAILURE_1 ) );
    }


    //@Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testIntoleranceConditionRead40010_SingleSiteFailure_MultipleDFNs( )
        throws Exception
    {

        String[] vistaPatient503_1 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY_FAILURE_1, PATIENTIDENTITY_FAILURE_1 };
        String[] vistaPatient503_2 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY_FAILURE_1, PATIENTIDENTITY_FAILURE_2 };
        String[] vistaPatient503_3 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY_FAILURE_1, "3333" };
        String[] vistaPatient580 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1, PATIENTIDENTITY1 };
        String[][] patientIdentifiers = { vistaPatient503_1, vistaPatient503_2, vistaPatient503_3, vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointMap = new HashMap<String, String>();
        entryPointMap.put( "ID_2", "IntoleranceCondition" );

        //since Map does not allow duplicate keys, hard coded filter with two DFNs for site 503 
        //String filterXml = "<filter:filter xmlns:filter=\"Filter\" vhimVersion=\"Vhim_4_00\"><filterId>IC_SINGLE_PATIENT_ALL_DATA_FILTER</filterId><patients><resolvedIdentifiers><assigningAuthority>USVHA</assigningAuthority><assigningFacility>503</assigningFacility><identity>1111</identity></resolvedIdentifiers><resolvedIdentifiers><assigningAuthority>USVHA</assigningAuthority><assigningFacility>503</assigningFacility><identity>2222</identity></resolvedIdentifiers><resolvedIdentifiers><assigningAuthority>USVHA</assigningAuthority><assigningFacility>580</assigningFacility><identity>1</identity></resolvedIdentifiers><resolvedIdentifiers><assigningAuthority>USVHA</assigningAuthority><assigningFacility>503</assigningFacility><identity>3333</identity></resolvedIdentifiers></patients><entryPointFilter queryName=\"ID_2\"><domainEntryPoint>IntoleranceCondition</domainEntryPoint></entryPointFilter></filter:filter>";

        String filterXml = createAllergiesSinglePatientMulitEntryPointFilter( resolvedPatients, entryPointMap, null, null,
                        TemplateIdHelper.IC_SINGLE_PATIENT_ALL_DATA_FILTER, null );

        requestProcessor.setValidateReadResponseXML( true );
        Document clinicalDataDocument = requestProcessor.readClinicalData( getVWIntoleranceConditionsReadTemplateID(), filterXml,
                        TemplateIdHelper.IC_SINGLE_PATIENT_ALL_DATA_FILTER, new UniqueIdentifier().toString() );
        assertNotNull( clinicalDataDocument );

        //make sure there is no clinical domain data in response
        List<Node> clinicalDocumentNodes = clinicalDataDocument.selectNodes( getIntoleranceConditionsEntryPointXpath() );
        Assert.assertTrue( clinicalDocumentNodes.size() > 0 );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

        //make sure we reported one  READ_REQUEST_DATA_SOURCE_FAILURE successfully as a warning
        List<Node> warningNodes = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION_WARNING );
        Assert.assertTrue( warningNodes.size() == 1 );
        Node errorCodeNode = clinicalDataDocument.selectSingleNode( XPATH_ERRORSECTION_WARNINGERRORCODE );
        Assert.assertTrue( errorCodeNode.getText().equals( READ_REQUEST_DATA_SOURCE_FAILURE ) );

        //verify the erroneous siteId and DFN in the error message
        Node dispalyMsgNode = clinicalDataDocument.selectSingleNode( XPATH_ERRORSECTION_DISPLAYMSG );
        Assert.assertTrue( dispalyMsgNode.getText().contains( ASSIGNINGFACILITY_FAILURE_1 ) );
        Assert.assertTrue( dispalyMsgNode.getText().contains( PATIENTIDENTITY_FAILURE_1 ) );
    }
    @Override
    @AfterTestsOnce
    @Suite(groups = { "broekntest" })
    public void afterAbstractEndToEndTestsTearDown( ) throws Exception
    {
        
    }
}