

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.FileSystemResource;

import gov.va.med.cds.integration.AbstractEndToEndTest;
import gov.va.med.cds.junit.runners.AfterTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.RequestProcessorInterface;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;
import gov.va.med.cds.testharness.xml.Assert;
import gov.va.med.cds.util.StreamUtil;


@RunWith( SuiteAwareSpringRunner.class )
public class EndToEndDerivedFieldReadTest
    extends
        AbstractEndToEndTest
{
    private static final String PATIENT_IDENTITY_1 = "1";
    private static final String PATIENT_IDENTITY_2 = "2";
    private static final String ASSIGNING_FACILITY_VISTA_578 = "578";
    private static final String ASSIGNING_FACILITY_VISTA_503 = "503";
    private static final String ASSIGNING_FACILITY_VISTA_504 = "504";
    private static final String ASSIGNING_FACILITY_VISTA_580 = "580";
    private static final String ASSIGNING_AUTHORITY_VISTA = "USVHA";

    private static final String ASSIGNING_AUTHORITY_ELEMENT_NAME = "assigningAuthority";
    private static final String ASSIGNING_FACILITY_ELEMENT_NAME = "assigningFacility";
    private static final String PATIENT_IDENTITY_ELEMENT_NAME = "identity";

    private static final String QUERY_TIMOUT_SECONDS_MIN = "0";

    private static final String XPATH_DOMAINENTRYPOINT = "//labTestPromise";
    private static final String XPATH_DOMAINENTRYPOINT_40011 = "//labTestPromises";

    protected static final String XPATH_PATIENT_40011 = "//clinicaldata:ClinicalData/patient";/// "//patients/patient";
                                                                                              /// (normal
                                                                                              /// value)
                                                                                              /// clinicaldata:ClinicalData/patient
                                                                                              /// (true
                                                                                              /// xpath)
    protected static final String XPATH_RESOLVED_IDENTIFIERS_40011 = "//clinicaldata:ClinicalData/patient/requestedResolvedIdentifiers"; // "//requestedResolvedIdentifiers/requestedResolvedIdentifier";
                                                                                                                                         // (normal
                                                                                                                                         // value)
                                                                                                                                         // clinicaldata:ClinicalData/patient/requestedResolvedIdentifiers
                                                                                                                                         // (true
                                                                                                                                         // xpath)
    private static final String XPATH_REQUESTEDEXCLUDEDINDETIFIERS = "//requestedExcludedIdentifiers/requestedExcludedIdentifier/assigningFacility";
    private static final String XPATH_REQUESTEDEXCLUDEDINDETIFIERS_40011 = "//requestedExcludedIdentifiers/assigningFacility";

    @Resource
    private RequestProcessorInterface requestProcessor = null;


    @Resource
    public void setRequestProcessor( RequestProcessorInterface requestProcessor )
    {
        this.requestProcessor = requestProcessor;
    }


    @Test
    public void testDerivedFieldRead( )
        throws Exception
    {

        String filterXml = StreamUtil.resourceToString(
                        new FileSystemResource( new File( "src/test/java/gov/va/med/cds/integration/vhim400/derived_field_filter.xml" ) ) );

        String filterId = TemplateIdHelper.DERIVED_FIELD_FILTER;
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        Document clinicalDataDocument = requestProcessor.readClinicalData( TemplateIdHelper.DERIVED_FIELD_TEMPLATE_ID, filterXml, filterId,
                        requestId );
        assertNotNull( clinicalDataDocument );
    }


    @Override
    @AfterTestsOnce
    @Suite( groups = { "brokentest" } )
    public void afterAbstractEndToEndTestsTearDown( )
        throws Exception
    {

    }
}
