

package gov.va.med.cds.integration;


import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.xml.datatype.DatatypeConfigurationException;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

import gov.va.med.cds.AbstractBaseIntegrationCoreTest;
import gov.va.med.cds.filter.CdsFilterFactoryInterface;
import gov.va.med.cds.junit.runners.AfterTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.RequestProcessorInterface;
import gov.va.med.cds.request.RequestValidatorInterface;
import gov.va.med.cds.request.ResponseValidatorInterface;
import gov.va.med.cds.template.TemplateMetaDataProviderInterface;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;


@RunWith(SuiteAwareSpringRunner.class)
@ContextConfiguration(locations = { "classpath:gov/va/med/cds/config/nonWeblogicApplicationContext.xml" })
public abstract class AbstractEndToEndTest
    extends
        AbstractBaseIntegrationCoreTest
{

    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    protected static final String COMMENT_8K_SIZE = // lines > 6k can't be read
                                                    // by the P4 Merge tool
            "zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz"
                    + "zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz";

    protected static final String XPATH_ERRORSECTION = "/clinicaldata:ClinicalData/errorSection";
    protected static final String XPATH_ERRORSECTION_WARNING = "/clinicaldata:ClinicalData/errorSection/warnings";
    protected static final String XPATH_ERRORSECTION_WARNINGERRORCODE = "/clinicaldata:ClinicalData/errorSection/warnings/errorCode";
    protected static final String XPATH_ERRORSECTION_ERRORS = "/clinicaldata:ClinicalData/errorSection/errors";
    protected static final String XPATH_ERRORSECTION_ERROR_ERRORCODE = "/clinicaldata:ClinicalData/errorSection/errors/errorCode";
    protected static final String XPATH_ERRORSECTION_DISPLAYMSG = "/clinicaldata:ClinicalData/errorSection/warnings/displayMessage";
    protected static final String XPATH_ERRORSECTION_FATALERROR = "/clinicaldata:ClinicalData/errorSection/fatalErrors/fatalError";
    protected static final String XPATH_IDENTIFIERS = "//requestedResolvedIdentifiers";
    protected static final String XPATH_RESOLVED_IDENTIFIERS = "//requestedResolvedIdentifiers/requestedResolvedIdentifier";
    protected static final String XPATH_PATIENT = "//patients/patient";
    protected static final String XPATH_ASSIGNING_AUTHORITY_ELEMENT_NAME = "//assigningAuthority";
    protected static final String XPATH_ASSIGNING_FACILITY_ELEMENT_NAME = "//assigningFacility";
    protected static final String XPATH_PATIENT_IDENTITY_ELEMENT_NAME = "//identity";
    protected static final String RECORD_IDENTIFIER_IDENTITY_XPATH = "/clinicaldata:ClinicalData/recordIdentifiers/recordIdentifier/identity";

    protected static final String CDS_XPATH_ERRORSECTION = "/clinicaldata:ClinicalData/errorSection";
    protected static final String CDS_XPATH_ERRORSECTION_WARNING = "/clinicaldata:ClinicalData/errorSection/warnings/warning";
    protected static final String CDS_XPATH_ERRORSECTION_WARNING_ERRORCODE = "/clinicaldata:ClinicalData/errorSection/warnings/warning/errorCode";
    protected static final String CDS_XPATH_ERRORSECTION_ERROR = "/clinicaldata:ClinicalData/errorSection/errors/error";
    protected static final String CDS_XPATH_ERRORSECTION_ERROR_ERRORCODE = "/clinicaldata:ClinicalData/errorSection/errors/error/errorCode";
    protected static final String CDS_XPATH_ERRORSECTION_FATALERROR = "/clinicaldata:ClinicalData/errorSection/fatalErrors/fatalError";
    protected static final String CDS_XPATH_ERRORSECTION_FATALERROR_ERRORCODE = "/clinicaldata:ClinicalData/errorSection/fatalErrors/fatalError/errorCode";
    protected static final String CDS_XPATH_IDENTIFIERS = "//requestedResolvedIdentifier";
    protected static final String CDS_XPATH_ERRORSECTION_FATALERROR_DISPLAYMSG = "/clinicaldata:ClinicalData/errorSection/fatalErrors/fatalError/displayMessage";
    protected static final String CDS_XPATH_ERRORSECTION_WARNING_DISPLAYMSG = "/clinicaldata:ClinicalData/errorSection/warnings/warning/displayMessage";
    protected static final String XPATH_ERRORSECTION_WARNINGS_ERRORCODE = "/clinicaldata:ClinicalData/errorSection/warnings/errorCode";
    protected static final String XPATH_ERRORSECTION_FATALERRORS_ERRORCODE = "/clinicaldata:ClinicalData/errorSection/fatalErrors/errorCode";
    protected static final String TIMOUT_ERROR_CODE = "READ_REQUEST_DATA_SOURCE_TIMEOUT";
    protected static final String XPATH_ERRORSECTION_ERROR_ERRORCODE_DISPLAYMSG = "/clinicaldata:ClinicalData/errorSection/errors/displayMessage";
    protected static final String XPATH_ERRORSECTION_FATALERRORS_DISPLAYMSG = "/clinicaldata:ClinicalData/errorSection/fatalErrors/displayMessage";
    protected static final String XPATH_ERRORSECTION_FATALERRORS_FATALERROR_DISPLAYMSG = "/clinicaldata:ClinicalData/errorSection/fatalErrors/fatalError/displayMessage";
    protected static final String XPATH_ERRORSECTION_WARNINGS_DISPLAYMSG = "/clinicaldata:ClinicalData/errorSection/warnings/displayMessage";
    protected static final String XPATH_ERRORSECTION_WARNINGS_WARNING_DISPLAYMSG = "/clinicaldata:ClinicalData/errorSection/warnings/warning/displayMessage";

    protected static final String READ_REQUEST_ALL_DATA_SOURCES_FAILED_MSG = "All datasources failed.  Unable to get data from applicable datasource(s) due to the following reason";
    protected static final String READ_REQUEST_ALL_DATA_SOURCES_FAILED = "READ_REQUEST_ALL_DATASOURCES_FAILED";
    protected static final String NO_PATIENT_IDS_REQUESTED = "NO_PATIENT_IDS_REQUESTED";
    protected static final String READ_REQUEST_DATA_SOURCE_FAILURE = "READ_REQUEST_DATA_SOURCE_FAILURE";
    protected static final String READ_REQUEST_ALL_DATASOURCES_FAILED = "READ_REQUEST_ALL_DATASOURCES_FAILED";
    protected static final String DATASOURCE_NOT_CONFIGURED = "DATASOURCE_NOT_CONFIGURED";
    protected static final String READ_REQUEST_UNKNOWN_DATA_SOURCE_FAILED_MSG = "CDS 3.1 application currently not configured with datasource(s) to support the VistA site(s)";
    protected static final String PATHWAYS_READ_REQUEST_UNKNOWN_DATA_SOURCE_FAILED_MSG = "Pathways 1.0 application currently not configured with datasource(s) to support the VistA site(s)";
    protected static final String READ_REQUEST_TIMEOUT_ERROR_MSG = "A query timeout occured during the read request";

    @Autowired
    protected String cdsAppName;

    @Autowired
    protected String pathwaysAppName;

    @Resource
    private RequestProcessorInterface requestProcessor = null;
    private TemplateMetaDataProviderInterface templateMetaDataProvider = null;
    private CdsFilterFactoryInterface filterFactory;
    private RequestValidatorInterface requestValidator = null;
    private ResponseValidatorInterface responseValidator = null;


    protected static String createEntryFilter( String aQueryName, String aDomainEntryPoint, Calendar aStartDate, Calendar aEndDate,
            String aXpath )
    {
        StringBuffer xmlWorkBuffer = new StringBuffer();

        xmlWorkBuffer.setLength( 0 );
        xmlWorkBuffer.append( "<entryPointFilter queryName=\"" );
        xmlWorkBuffer.append( aQueryName ).append( "\">" );
        xmlWorkBuffer.append( "<domainEntryPoint>" );
        xmlWorkBuffer.append( aDomainEntryPoint );
        xmlWorkBuffer.append( "</domainEntryPoint>" );
        if ( aStartDate != null )
        {
            xmlWorkBuffer.append( "<startDate>" );
            xmlWorkBuffer.append( formatDate( aStartDate ) );
            xmlWorkBuffer.append( "</startDate> " );
        }
        if ( aEndDate != null )
        {
            xmlWorkBuffer.append( "<endDate>" );
            xmlWorkBuffer.append( formatDate( aEndDate ) );
            xmlWorkBuffer.append( "</endDate> " );
        }
        xmlWorkBuffer.append( "<xpathQuery>" );
        xmlWorkBuffer.append( "<xpath>" );
        xmlWorkBuffer.append( aXpath );
        xmlWorkBuffer.append( "</xpath> </xpathQuery> </entryPointFilter>" );
        return xmlWorkBuffer.toString();
    }


    protected static String createFilter( List<Element> resolvedIds, List<String> entryFilters )
    {
        StringBuffer xmlWorkBuffer = new StringBuffer();

        xmlWorkBuffer.setLength( 0 );

        xmlWorkBuffer.append( "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" );
        xmlWorkBuffer.append(
                "<filter:filter vhimVersion=\"Vhim_4_00\" xmlns:filter=\"Filter\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">" );
        xmlWorkBuffer.append( "<filterId>testFilterId</filterId>" );
        xmlWorkBuffer.append( "<patients>" );
        for ( Element patientIdentifier : resolvedIds )
        {
            xmlWorkBuffer.append( "<resolvedIdentifiers>" );
            xmlWorkBuffer.append( "<assigningAuthority>" );
            xmlWorkBuffer.append( patientIdentifier.elementText( "assigningAuthority" ) );
            xmlWorkBuffer.append( "</assigningAuthority>" );
            xmlWorkBuffer.append( "<assigningFacility>" );
            xmlWorkBuffer.append( patientIdentifier.elementText( "assigningFacility" ) );
            xmlWorkBuffer.append( "</assigningFacility>" );
            xmlWorkBuffer.append( "<identity>" );
            xmlWorkBuffer.append( patientIdentifier.elementText( "identity" ) );
            xmlWorkBuffer.append( "</identity>" );
            xmlWorkBuffer.append( "</resolvedIdentifiers> " );
        }

        xmlWorkBuffer.append( "</patients>" );

        for ( String entryFilter : entryFilters )
        {
            xmlWorkBuffer.append( entryFilter );
        }

        xmlWorkBuffer.append( " </filter:filter>" );
        return xmlWorkBuffer.toString();
    }


    public static String formatDate( Calendar aDate )
    {
        String value = null;
        if ( aDate != null )
        {
            value = new SimpleDateFormat( DATE_FORMAT_PATTERN ).format( aDate.getTime() );
        }
        return value;
    }


    /**
     * Convert a Java Gregorian Calendar to its XML date/time equivalent in
     * order to create dates in a filter
     * 
     * @param date
     *            the Java date to convert
     * @return an XML date/time
     * @throws DatatypeConfigurationException
     * @see createXpathFilterFromOutpatientMedicationPromise
     */
    public static Calendar convertDateToCalendar( Date aDate )
    {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime( aDate );
        return cal;
    }


    protected List<Map<String, String>> getResolvedPatients( String[][] patientIdentifiers )
    {
        List<Map<String, String>> resolvedPatients = new ArrayList<Map<String, String>>();

        for ( String[] patientIdentifier : patientIdentifiers )
        {
            Map<String, String> patient = new HashMap<String, String>();
            patient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, patientIdentifier[0] );
            patient.put( FilterBuilder.ASSIGNING_FACILITY, patientIdentifier[1] );
            patient.put( FilterBuilder.IDENTITY, patientIdentifier[2] );

            resolvedPatients.add( patient );
        }

        return resolvedPatients;
    }


    @Resource
    public void setRequestProcessor( RequestProcessorInterface requestProcessor )
    {
        this.requestProcessor = requestProcessor;
    }


    @Resource
    public void setTemplateMetaDataProvider( TemplateMetaDataProviderInterface templateMetaDataProvider )
    {
        this.templateMetaDataProvider = templateMetaDataProvider;
    }


    @Resource
    public void setFilterFactory( CdsFilterFactoryInterface filterFactory )
    {
        this.filterFactory = filterFactory;
    }


    protected RequestProcessorInterface getRequestProcessor( )
    {
        return requestProcessor;
    }


    protected TemplateMetaDataProviderInterface getTemplateMetaDataProvider( )
    {
        return templateMetaDataProvider;
    }


    protected CdsFilterFactoryInterface getFilterFactory( )
    {
        return filterFactory;
    }


    @Resource
    public void setRequestValidator( RequestValidatorInterface requestValidator )
    {
        this.requestValidator = requestValidator;
    }


    @Resource
    public void setResponseValidator( ResponseValidatorInterface responseValidator )
    {
        this.responseValidator = responseValidator;
    }


    protected RequestValidatorInterface getRequestValidator( )
    {
        return requestValidator;
    }


    protected ResponseValidatorInterface getResponseValidator( )
    {
        return responseValidator;
    }


    protected String createHAFilter( String patientIdentifier, String assigningAuthority, String assigningFacility, String entryPoint,
            String filterId, String startDate, String endDate )
    {
        return createHAFilter( patientIdentifier, assigningAuthority, assigningFacility, entryPoint, filterId, startDate, endDate, null );
    }


    protected String createHAFilter( String patientIdentifier, String assigningAuthority, String assigningFacility, String entryPoint,
            String filterId, String startDate, String endDate, String specializedDomainEntryPoint )
    {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add( FilterBuilder.createFilterId( "filterId", filterId ) );
        element.add( FilterBuilder.createClientName( "clientName", "testClientName" ) );
        element.add( FilterBuilder.createClientRequestInitiationTime( "clientRequestInitiationTime",
                DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ) ) );
        element.add( FilterBuilder.createPatientWithEdipi( "patients", patientIdentifier, null, assigningAuthority, assigningFacility ) );
        element.add( FilterBuilder.createMHAEntryFilterWithAdditionalParameters( "entryPointFilter", entryPoint, startDate, endDate, "ID_1",
                specializedDomainEntryPoint ) );
        element.addAttribute( "vhimVersion", "Vhim_4_00" );
        return element.asXML();
    }


    @AfterTestsOnce
    @Suite(groups = { "checkintest" })
    public void afterAbstractEndToEndTestsTearDown( ) throws Exception
    {
        requestProcessor = null;
        templateMetaDataProvider = null;
        filterFactory = null;
        requestValidator = null;
        responseValidator = null;
    }

}
