

package gov.va.med.cds.integration;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;

import java.util.Map;

import org.dom4j.Document;
import org.dom4j.Element;
import org.junit.Before;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareSpringRunner.class )
public abstract class AbstractEndToEndReadTiuTest
    extends
        AbstractEndToEndTest
{
    protected static final String TIU_LIST_REQUIRED_XQUERY_CRITERIA = "/referenceDate/literal descending";
    protected static String ASSIGNINGAUTHORITY = "USVHA";
    protected static String RECORDIDENTIFIER1 = "6";
    protected static String NAMESPACEID1 = "580_8925";
    protected static String XPATH_ERRORSECTION = "/clinicaldata:ClinicalData/errorSection";
    protected static String XPATH_DOMAINENTRYPOINT = "//clinicalDocumentEvents";
    protected TemplateRequestProcessor requestProcessor;


    protected String getTiuListReadTemplateID( )
    {
        return TemplateIdHelper.TIU_DOCUMENT_LIST_READ;
    }


    protected String getTiuDetailReadTemplateID( )
    {
        return TemplateIdHelper.TIU_DOCUMENT_DETAIL_READ;
    }


    protected String getTiuListReadFilterID( )
    {
        return TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER;
    }


    protected String getTiuDetailReadFilterID( )
    {
        return TemplateIdHelper.TIU_SINGLE_PATIENT_DETAIL_DATA_FILTER;
    }


    @Before
    @Suite( groups = { "checkintest" } )
    public void beforeAbstractEndToEndReadTiuTestClassSetUp( )
        throws Exception
    {
        requestProcessor = ( TemplateRequestProcessor )getRequestProcessor();
    }


    protected String createTiuSinglePatientListDataFilter( Map<String, String> assigningFacilityAndPatientIdentityMap, String assigningAuthority,
                    String filterId, String documentClassValue, String[] documentTypeValues, String startDate, String endDate, String nationalId, String xQuery )
    {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add( FilterBuilder.createFilterId( "filterId", filterId ) );
        if ( nationalId != null )
        {
            element.add( FilterBuilder.createPatientWithNationalId( "patients", nationalId, null ) );
        }
        else
        {
            element.add( FilterBuilder.createPatient( "patients", assigningAuthority, assigningFacilityAndPatientIdentityMap ) );
        }

        element.add( FilterBuilder.createEntryFilterWithAdditionalParameters( "entryPointFilter", "ClinicalDocumentEvent", startDate, endDate,
                        documentClassValue, documentTypeValues, "ID_1", xQuery ) );

        element.addAttribute( "vhimVersion", "Vhim_4_00" );
        return element.asXML();
    }


    protected String createTiuSinglePatientListDataFilterIdentifiers( Map<String, String> assigningFacilityAndPatientIdentityMap,
                    String assigningAuthority, String filterId, String recordIdentifier, String namespaceId, String queryTimeoutSeconds )
    {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add( FilterBuilder.createFilterId( "filterId", filterId ) );
        element.add( FilterBuilder.createPatient( "patients", assigningAuthority, assigningFacilityAndPatientIdentityMap ) );

        element.add( FilterBuilder.createEntryFilterWithRecordIdentifiers( "entryPointFilter", "ClinicalDocumentEvent", recordIdentifier,
                        namespaceId, "", "", "ID_1", queryTimeoutSeconds ) );

        element.addAttribute( "vhimVersion", "Vhim_4_00" );
        return element.asXML();
    }
}
