

package gov.va.med.cds.integration;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.junit.Before;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareSpringRunner.class )
public abstract class AbstractEndToEndReadAllergiesTest
    extends
        AbstractEndToEndTest
{
    protected static String PATIENTIDENTITY1 = "1";
    protected static String ASSIGNINGFACILITY1 = "580";
    protected static  String ASSIGNING_FACILITY_HDR = "200CH";
    protected static  String PATIENT_IDENTITY_HDR = "test_sourceid_10000";
    protected static String PATIENTIDENTITY2 = "1";
    protected static String ASSIGNINGFACILITY2 = "578";
    protected static String ASSIGNINGFACILITY3 = "200M";
    protected static String PATIENTIDENTITY3="test_id";
    protected static String ASSIGNINGFACILITY4 = "200ESR";
    protected static String PATIENTIDENTITY4="test_id";
    protected static String PATIENTIDENTITY_FAILURE_1 = "1111";
    protected static String PATIENTIDENTITY_FAILURE_2 = "2222";
    protected static String ASSIGNINGFACILITY_FAILURE_1 = "503";
    protected static String ASSIGNINGFACILITY_FAILURE_2 = "504";
    protected static String DOCUMENT_CLASS_VALUE = "3";
    protected static String[] DOCUMENT_TYPE_VALUES = {};
    protected static String ASSIGNINGAUTHORITY = "USVHA";
    protected static String ASSIGNINGAUTHORITY_DOD = "USDOD";
    protected static String RECORDIDENTIFIER1 = "6";
    protected static String NAMESPACEID1 = "578";
    protected TemplateRequestProcessor requestProcessor;

    @Before
    @Suite( groups = { "checkintest" } )
    public void beforeAbstractEndToEndReadAllergiesTestClassSetUp( )
        throws Exception
    {
        requestProcessor = ( TemplateRequestProcessor )getRequestProcessor();
    }

    protected String getAllergiesReadTemplateID( )
    {
        return TemplateIdHelper.ALLERGIES_READ_TEMPLATE_ID;
    }


    protected String getAlleryAssessmentsReadTemplateID( )
    {
        return TemplateIdHelper.ALLERGY_ASSESSMENT_READ_TEMPLATE_ID;
    }


    protected String getVWAllergiesReadTemplateID( )
    {
        return TemplateIdHelper.VW_ALLERGIES_READ_TEMPLATE_ID;
    }


    protected String getIntoleranceConditionsReadTemplateID( )
    {
        return TemplateIdHelper.INTOLERANCE_CONDITION_READ_TEMPLATE_ID;
    }


    protected String getIntoleranceConditionsReducedReadTemplateID( )
    {
        return TemplateIdHelper.INTOLERANCE_CONDITION_REDUCED_READ_TEMPLATE_ID;
    }


    protected String getVWIntoleranceConditionsReadTemplateID( )
    {
        return TemplateIdHelper.VW_INTOLERANCE_CONDITION_READ_TEMPLATE_ID;
    }


    protected String getMHVIntoleranceConditionsReadTemplateID( )
    {
        return TemplateIdHelper.MHV_INTOLERANCE_CONDITION_READ_TEMPLATE_ID;
    }


    protected String getIntoleranceConditionsEntryPointXpath( )
    {
        return "//intoleranceConditions";
    }


    protected String getAllergyAssessmentsEntryPointXpath( )
    {
        return "//allergyAssessments";
    }


    protected String createAllergiesSinglePatientListDataFilter( Map<String, String> assigningFacilityAndPatientIdentityMap, String entryPoint,
                    String assigningAuthority, String filterId, String documentClassValue, String[] documentTypeValues )
    {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add( FilterBuilder.createFilterId( "filterId", filterId ) );
        element.add( FilterBuilder.createPatient( "patients", assigningAuthority, assigningFacilityAndPatientIdentityMap ) );

        element.add( FilterBuilder.createEntryFilterWithAdditionalParameters( "entryPointFilter", entryPoint, null, null, documentClassValue,
                        documentTypeValues, "ID_1", null ) );

        element.addAttribute( "vhimVersion", "Vhim_4_00" );
        return element.asXML();
    }


    protected String createAllergiesSinglePatientMulitEntryPointFilter( Map<String, String> assigningFacilityAndPatientIdentityMap,
                    Map<String, String> entryPointMap, String recordIdentifier, String namespaceId, String assigningAuthority, String filterId,
                    Map<String, String> xpathMap )
    {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add( FilterBuilder.createFilterId( "filterId", filterId ) );
        element.add( FilterBuilder.createPatient( "patients", assigningAuthority, assigningFacilityAndPatientIdentityMap ) );

        Iterator<String> entryPointIter = entryPointMap.keySet().iterator();
        while ( entryPointIter.hasNext() )
        {
            String queryId = entryPointIter.next();
            Element entryPointElement = DocumentHelper.createElement( "entryPointFilter" );
            entryPointElement.add( FilterBuilder.createDomainEntryPoint( "domainEntryPoint", entryPointMap.get( queryId ) ) );
            entryPointElement.addAttribute( "queryName", queryId );

            if ( xpathMap != null && xpathMap.containsKey( queryId ) )
            {
                String xpath = xpathMap.get( queryId );
                Element xpathElement = FilterBuilder.createXpathQuery( "xpathQuery", xpath );
                entryPointElement.add( xpathElement );
            }
            element.add( entryPointElement.detach() );
        }

        element.addAttribute( "vhimVersion", "Vhim_4_00" );
        return element.asXML();
    }


    protected String createAllergiesSinglePatientMulitEntryPointFilter( List<Map<String, String>> resolvedPatients,
                    Map<String, String> entryPointMap, String recordIdentifier, String namespaceId, String filterId, Map<String, String> xpathMap )
    {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add( FilterBuilder.createFilterId( "filterId", filterId ) );
        element.add( FilterBuilder.createPatientWithResolvedIdentifiers( "patients", resolvedPatients ) );

        Iterator<String> entryPointIter = entryPointMap.keySet().iterator();
        while ( entryPointIter.hasNext() )
        {
            String queryId = entryPointIter.next();
            Element entryPointElement = DocumentHelper.createElement( "entryPointFilter" );
            entryPointElement.add( FilterBuilder.createDomainEntryPoint( "domainEntryPoint", entryPointMap.get( queryId ) ) );
            entryPointElement.addAttribute( "queryName", queryId );

            if ( xpathMap != null && xpathMap.containsKey( queryId ) )
            {
                String xpath = xpathMap.get( queryId );
                Element xpathElement = FilterBuilder.createXpathQuery( "xpathQuery", xpath );
                entryPointElement.add( xpathElement );
            }
            element.add( entryPointElement.detach() );
        }

        element.addAttribute( "vhimVersion", "Vhim_4_00" );
        return element.asXML();
    }

}
