

package gov.va.med.cds.integration;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;

import java.util.Map;

import org.dom4j.Document;
import org.dom4j.Element;
import org.junit.Before;
import org.junit.runner.RunWith;


/**
 * 
 * This initiates all tests through the outermost client pojo (ClinicalDataServiceSynchronous). This has the vhim
 * version agnostic functionality that is common to the vhim version specific subclasses. It will generate a vdm record
 * and save it off to the DB. Next, it will read the same record back and marshal it to XML and compare it with the
 * original vdm record. Also, does some bounds checking for persistence filters. It also tests merging of historical records.
 * 
 */
@RunWith( SuiteAwareSpringRunner.class )
public abstract class AbstractEndToEndOutpatientPharmacyTest
    extends
        AbstractEndToEndTest
{
    protected static final String OUTPATIENT_MEDICATION_PROMISE = "Outpatient Medication Promise";

    protected static String PATIENTIDENTITY1 = "1";
    protected static String PATIENTIDENTITY123 = "123";
    protected static String ASSIGNINGFACILITY1 = "580";
    protected static String PATIENTIDENTITY2 = "1";
    protected static String ASSIGNINGFACILITY2 = "578";
    protected static String ASSIGNINGAUTHORITY = "USVHA";
    protected static String ASSIGNINGAUTHORITY_DOD = "USDOD";
    protected static String RECORDIDENTIFIER1 = "6";
    protected static String NAMESPACEID1 = "578";
    protected static String XPATH_OUTPATIENTMEDICATIONPROMISES = "//patient/outpatientMedicationPromises/outpatientMedicationPromise";
    protected static String XPATH_DOMAINENTRYPOINT = "//outpatientMedicationPromises";
    protected TemplateRequestProcessor requestProcessor;

    @Before
    @Suite( groups = { "checkintest" } )
    public void beforeAbstractEndToEndOutpatientPharmacyTestClassSetUp( )
        throws Exception
    {
        requestProcessor = ( TemplateRequestProcessor )getRequestProcessor();
    }


    protected String createOutpatientPharmacySinglePatientListDataFilter( Map<String, String> assigningFacilityAndPatientIdentityMap,
                    String entryPoint, String assigningAuthority, String filterId, String startDate, String endDate )
    {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add( FilterBuilder.createFilterId( "filterId", filterId ) );
        element.add( FilterBuilder.createPatient( "patients", assigningAuthority, assigningFacilityAndPatientIdentityMap ) );

        element.add( FilterBuilder.createOutpatientMedicationPromiseEntryFilterWithAdditionalParameters( "entryPointFilter", entryPoint, startDate,
                        endDate, "ID_1" ) );

        element.addAttribute( "vhimVersion", "Vhim_4_00" );
        return element.asXML();
    }


    protected String createOutpatientPharmacySinglePatientListDataFilterWithxpath( Map<String, String> assigningFacilityAndPatientIdentityMap,
                    String entryPoint, String assigningAuthority, String filterId, String startDate, String endDate )
    {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add( FilterBuilder.createFilterId( "filterId", filterId ) );
        element.add( FilterBuilder.createPatient( "patients", assigningAuthority, assigningFacilityAndPatientIdentityMap ) );

        element.add( FilterBuilder.createOutpatientMedicationPromiseEntryFilterWithXpath( "entryPointFilter", entryPoint, startDate, endDate, "ID_1" ) );

        element.addAttribute( "vhimVersion", "Vhim_4_00" );
        return element.asXML();
    }


    protected String getOutpatientMedicationPromiseEntryPointXpath( )
    {
        return "//medicationPromises";
    }
}
