

package gov.va.med.cds.filter;


import java.io.IOException;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.util.StreamUtil;


@RunWith(SuiteAwareRunner.class)
public class MultipleIcnFilterHelperTest
{
    private static DefaultResourceLoader resourceLoader;

    MultipleIcnFilterHelper multipleIcnFilterHelper = new MultipleIcnFilterHelper();


    @Test
    @Suite(groups = "checkintest")
    public void convert( ) throws IOException
    {
        resourceLoader = new DefaultResourceLoader();

        Resource resource = resourceLoader.getResource( "classpath:gov/va/med/cds/filter/multipleIcnFilter.xml" );
        String filter = StreamUtil.resourceToString( resource );

        multipleIcnFilterHelper.convertMultipleIcnFilterToSingleIcnFilter( filter );

        Assert.notNull( filter, "Filter is null" );
    }

}
