package gov.va.med.cds.filter;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import java.io.IOException;

import junit.framework.Assert;

import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class FilterPatientResolverExceptionTest
{

    @Test
    @Suite( groups = "checkintest"  )
    public void testFilterPatientResolverException_ErrorCodeEnum( )
    {
        FilterPatientResolverException exception =  new FilterPatientResolverException(ErrorCodeEnum.NO_ENTRYPOINTS_IN_FILTER);
        
        Assert.assertEquals( ErrorCodeEnum.NO_ENTRYPOINTS_IN_FILTER , exception.getErrorCode());
        Assert.assertNull(exception.getCause());
        Assert.assertNull(exception.getCustomMsgValues());
       
    }


    @Test
    @Suite( groups = "checkintest"  )
    public void testFilterPatientResolverException_ErrorCodeEnumAndStringArray( )
    {
        String[] messages = new String[] {"message 1", "message 2"};
        FilterPatientResolverException exception =  new FilterPatientResolverException(ErrorCodeEnum.NO_ENTRYPOINTS_IN_FILTER, messages);
        
        Assert.assertEquals( ErrorCodeEnum.NO_ENTRYPOINTS_IN_FILTER , exception.getErrorCode());
        Assert.assertNull(exception.getCause());
        Assert.assertNotNull(exception.getCustomMsgValues());
        Assert.assertEquals( 2, exception.getCustomMsgValues().length);
    }


    @Test
    @Suite( groups = "checkintest"  )
    public void testFilterPatientResolverException_ErrorCodeEnumAndThrowable( )
    {
        Exception cause = new IOException("Error Message.");
        FilterPatientResolverException exception =  new FilterPatientResolverException(ErrorCodeEnum.NO_ENTRYPOINTS_IN_FILTER, cause);
        
        Assert.assertEquals( ErrorCodeEnum.NO_ENTRYPOINTS_IN_FILTER , exception.getErrorCode());
        Assert.assertNotNull(exception.getCause());
        Assert.assertEquals( cause, exception.getCause() );
        Assert.assertNull(exception.getCustomMsgValues());
    }

    @Test
    @Suite( groups = "checkintest"  )
    public void testFilterPatientResolverException_ErrorCodeEnumAndThrowableAndStringArray( )
    {
        String[] messages = new String[] {"message 1", "message 2"};
        Exception cause = new IOException("Error Message.");
        FilterPatientResolverException exception =  new FilterPatientResolverException(ErrorCodeEnum.NO_ENTRYPOINTS_IN_FILTER, cause, messages);
       
        Assert.assertEquals( ErrorCodeEnum.NO_ENTRYPOINTS_IN_FILTER , exception.getErrorCode());
        Assert.assertNotNull(exception.getCause());
        Assert.assertEquals( cause, exception.getCause() );
        Assert.assertNotNull(exception.getCustomMsgValues());
        Assert.assertEquals( 2, exception.getCustomMsgValues().length);
    }

}
