

package gov.va.med.cds.filter;


import gov.va.med.cds.AbstractBaseIntegrationCoreTest;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;

import java.util.Properties;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareSpringRunner.class )
public class AbstractCdsFilterTest
    extends
        AbstractBaseIntegrationCoreTest
{
    private static final String XML_PROPERTIES_RESOURCE_PATH = "/gov/va/med/cds/filter/filterResource100.properties";
    protected static final String GOOD_FILTER = "goodFilter";
    protected static final String BAD_FILTER = "badFilter";
    protected static final String BAD_REFERENCED_FILTER_ID = "badReferencedFilter";
    protected static Properties filterProperties;

    protected CdsFilterFactoryInterface filterFactory = new DefaultCdsFilterFactory();


    /**
     * Read filterProperties from a filter properties file
     */
    @BeforeClass
    @Suite( groups = { "checkintest" } )
    public static void beforeAbstractCdsFilterTestClassSetUp( )
        throws Exception
    {
        filterProperties = new Properties();
        filterProperties.load( AbstractCdsFilterTest.class.getResourceAsStream( XML_PROPERTIES_RESOURCE_PATH ) );
    }
    
    @Before
    public void setupOnce()
    {
        EntryFilterFactory entryFilterFactory = new EntryFilterFactory();
        ((DefaultCdsFilterFactory)this.filterFactory).setEntryFilterFactory( entryFilterFactory );
    }


    @AfterClass
    @Suite( groups = { "checkintest" } )
    public static void afterAbstractCdsFilterTestClassTearDown( )
    {
        filterProperties = null;
    }


    /**
     * Get a CdsFilter object created from a property name
     * 
     * @param aFilterPropertyName property name to lookup in filterProperties
     * @return associated cdsFilter of the xml found based on aFilterPropertyName
     * @throws Exception if there is an issue while retriving the filter
     */
    protected CdsFilterInterface getCdsFilterByName( String aFilterPropertyName, String templateId, String requestId )
        throws Exception
    {
        String xmlString = filterProperties.getProperty( aFilterPropertyName );
        CdsFilterInterface cdsFilter = getCdsFilterByXml( xmlString, templateId, requestId );

        return cdsFilter;
    }


    /**
     * Get a CdsFilter object created from a property name
     * 
     * @param aFilterPropertyName property name to lookup in filterProperties
     * @return associated cdsFilter of the xml found based on aFilterPropertyName
     * @throws Exception if there is an issue while retriving the filter
     */
    protected CdsFilterInterface getCdsFilterByNameAndFilterId( String aFilterPropertyName, String filterId, String templateId, String requestId )
        throws Exception
    {
        String xmlString = filterProperties.getProperty( aFilterPropertyName );
        CdsFilterInterface cdsFilter = getCdsFilterByXmlAndFilterId( xmlString, filterId, templateId, requestId );

        return cdsFilter;
    }


    /**
     * Get a CdsFilter object created from an xml string
     * 
     * @param aXmlString to create the filter
     * @return filter created based on the xml
     * @throws Exception if there is an issue while creating the filter
     */
    protected CdsFilterInterface getCdsFilterByXml( String aXmlString, String templateId, String requestId )
        throws Exception
    {
        Document filterDocument = DocumentHelper.parseText( aXmlString );
        CdsFilterInterface filter = filterFactory.create( filterDocument, templateId, requestId );

        return filter;
    }


    /**
     * Get a CdsFilter object created from an xml string and filterId
     * 
     * @param aXmlString to create the filter
     * @return filter created based on the xml and filterId
     * @throws Exception if there is an issue while creating the filter
     */
    protected CdsFilterInterface getCdsFilterByXmlAndFilterId( String aXmlString, String filterId, String templateId, String requestId )
        throws Exception
    {
        Document filterDocument = DocumentHelper.parseText( aXmlString );
        CdsFilterInterface filter = filterFactory.create( filterId, filterDocument, templateId, requestId );

        return filter;
    }

}
